/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import grails.util.GrailsUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import groovy.util.Proxy;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.map.CompositeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.web.metaclass.ForwardMethod;
import org.codehaus.groovy.grails.web.plugins.support.WebMetaUtils;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsControllerHelper;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.SynchronizerToken;
import org.codehaus.groovy.grails.web.servlet.mvc.TokenResponseHandler;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.NoViewNameDefinedException;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.UnknownControllerException;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGrailsControllerHelper
implements GrailsControllerHelper {
    private GrailsApplication application;
    private ApplicationContext applicationContext;
    private Map chainModel = Collections.EMPTY_MAP;
    private ServletContext servletContext;
    private GrailsApplicationAttributes grailsAttributes;
    private GrailsWebRequest webRequest;
    private static final Log LOG = LogFactory.getLog(SimpleGrailsControllerHelper.class);
    private static final String PROPERTY_CHAIN_MODEL = "chainModel";
    private String id;
    private String controllerName;
    private String actionName;

    public SimpleGrailsControllerHelper(GrailsApplication application, ApplicationContext context, ServletContext servletContext) {
        this.application = application;
        this.applicationContext = context;
        this.servletContext = servletContext;
        this.grailsAttributes = new DefaultGrailsApplicationAttributes(servletContext);
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public GrailsControllerClass getControllerClassByName(String name) {
        return (GrailsControllerClass)this.application.getArtefact("Controller", name);
    }

    @Override
    public GrailsControllerClass getControllerClassByURI(String uri) {
        return (GrailsControllerClass)this.application.getArtefactForFeature("Controller", (Object)uri);
    }

    @Override
    public GroovyObject getControllerInstance(GrailsControllerClass controllerClass) {
        return (GroovyObject)this.applicationContext.getBean(controllerClass.getFullName());
    }

    private void removeProxiesFromModelObjects(Map<Object, Object> model) {
        for (Map.Entry<Object, Object> entry : model.entrySet()) {
            if (!(entry.getValue() instanceof Proxy)) continue;
            entry.setValue(((Proxy)entry.getValue()).getAdaptee());
        }
    }

    @Override
    public ModelAndView handleURI(String uri, GrailsWebRequest request) {
        return this.handleURI(uri, request, Collections.EMPTY_MAP);
    }

    @Override
    public ModelAndView handleURI(String uri, GrailsWebRequest grailsWebRequest, Map params) {
        GroovyObject controller;
        GrailsControllerClass controllerClass;
        Assert.notNull((Object)uri, (String)("Controller URI [" + uri + "] cannot be null!"));
        HttpServletRequest request = grailsWebRequest.getCurrentRequest();
        HttpServletResponse response = grailsWebRequest.getCurrentResponse();
        this.configureStateForWebRequest(grailsWebRequest, request);
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ((controllerClass = this.getControllerClassByURI(uri)) == null) {
            throw new UnknownControllerException("No controller found for URI [" + uri + "]!");
        }
        this.actionName = controllerClass.getClosurePropertyName(uri);
        grailsWebRequest.setActionName(this.actionName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing request for controller [" + this.controllerName + "], action [" + this.actionName + "], and id [" + this.id + "]"));
        }
        if (!controllerClass.isHttpMethodAllowedForAction(controller = this.getControllerInstance(controllerClass), request.getMethod(), this.actionName)) {
            try {
                response.sendError(405);
                return null;
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error sending 403 error", e);
            }
        }
        request.setAttribute("org.codehaus.groovy.grails.CONTROLLER", (Object)controller);
        request.setAttribute("org.codehaus.groovy.grails.GRAILS_APPLICATION_ATTRIBUTES", (Object)this.grailsAttributes);
        String viewName = controllerClass.getViewByURI(uri);
        boolean executeAction = this.invokeBeforeInterceptor(controller, controllerClass);
        if (!executeAction) {
            return null;
        }
        ModelAndView mv = this.executeAction(controller, controllerClass, viewName, request, response, params);
        boolean returnModelAndView = this.invokeAfterInterceptor(controllerClass, controller, mv) && !response.isCommitted();
        return returnModelAndView ? mv : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected ModelAndView executeAction(GroovyObject controller, GrailsControllerClass controllerClass, String viewName, HttpServletRequest request, HttpServletResponse response, Map params) {
        ModelAndView modelAndView;
        ModelAndView modelAndView2;
        ModelAndView modelAndView3;
        String uri;
        Closure action;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            action = (Closure)controller.getProperty(this.actionName);
            if (WebMetaUtils.isCommandObjectAction(action)) {
                action = WebMetaUtils.createAndPrepareCommandObjectAction(controller, action, this.actionName, this.applicationContext);
            }
        }
        catch (MissingPropertyException mpe) {
            ModelAndView modelAndView4;
            try {
                response.sendError(404);
                modelAndView4 = null;
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error sending 404 error", e);
            }
            Object var15_16 = null;
            try {
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (AccessControlException e) {
                // empty catch block
            }
            return modelAndView4;
        }
        Object returnValue = null;
        try {
            returnValue = this.handleAction(controller, action, request, response, params);
        }
        catch (Throwable t) {
            GrailsUtil.deepSanitize(t);
            String pluginName = GrailsPluginUtils.getPluginName(controller.getClass());
            pluginName = pluginName != null ? "in plugin [" + pluginName + "]" : "";
            throw new ControllerExecutionException("Executing action [" + this.actionName + "] of controller [" + controller.getClass().getName() + "] " + pluginName + " caused exception: " + t.getMessage(), t);
        }
        this.initChainModel(controller);
        if (!response.isCommitted()) break block24;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Response has been redirected, returning null model and view");
        }
        ModelAndView t = null;
        Object var15_17 = null;
        try {
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        {
            block24: {
                return t;
            }
            TokenResponseHandler handler = (TokenResponseHandler)request.getAttribute("org.codehaus.groovy.grails.TOKEN_RESPONSE_HANDLER");
            if (handler == null || handler.wasInvoked() || !handler.wasInvalidToken()) break block25;
            uri = (String)request.getAttribute(SynchronizerToken.URI);
            if (uri == null) {
                uri = WebUtils.getForwardURI(request);
            }
            FlashScope flashScope = this.webRequest.getFlashScope();
            flashScope.put("invalidToken", request.getParameter(SynchronizerToken.KEY));
            response.sendRedirect(uri);
            modelAndView3 = null;
        }
        Object var15_18 = null;
        try {
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        {
            block25: {
                return modelAndView3;
                catch (IOException e) {
                    throw new ControllerExecutionException("I/O error sending redirect to URI: " + uri, e);
                }
            }
            if (request.getAttribute(ForwardMethod.CALLED) != null) break block26;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Action [" + this.actionName + "] executed with result [" + returnValue + "] and view name [" + viewName + "]"));
            }
            ModelAndView mv = this.handleActionResponse(controller, returnValue, this.actionName, viewName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Action [" + this.actionName + "] handled, created Spring model and view [" + mv + "]"));
            }
            modelAndView2 = mv;
        }
        Object var15_19 = null;
        try {
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        {
            block26: {
                return modelAndView2;
            }
            modelAndView = null;
        }
        Object var15_20 = null;
        try {
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        return modelAndView;
        catch (Throwable throwable) {
            Object var15_21 = null;
            try {
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (AccessControlException e) {}
            throw throwable;
        }
    }

    private boolean invokeBeforeInterceptor(GroovyObject controller, GrailsControllerClass controllerClass) {
        Closure beforeInterceptor;
        boolean executeAction = true;
        if (controllerClass.isInterceptedBefore(controller, this.actionName) && (beforeInterceptor = controllerClass.getBeforeInterceptor(controller)) != null) {
            Object interceptorResult;
            if (beforeInterceptor.getDelegate() != controller) {
                beforeInterceptor.setDelegate((Object)controller);
                beforeInterceptor.setResolveStrategy(1);
            }
            if ((interceptorResult = beforeInterceptor.call()) instanceof Boolean) {
                executeAction = (Boolean)interceptorResult;
            }
        }
        return executeAction;
    }

    private void configureStateForWebRequest(GrailsWebRequest grailsWebRequest, HttpServletRequest request) {
        this.webRequest = grailsWebRequest;
        this.actionName = grailsWebRequest.getActionName();
        this.controllerName = grailsWebRequest.getControllerName();
        this.id = grailsWebRequest.getId();
        if (StringUtils.isBlank((String)this.id) && request.getParameter("id") != null) {
            this.id = request.getParameter("id");
        }
    }

    private boolean invokeAfterInterceptor(GrailsControllerClass controllerClass, GroovyObject controller, ModelAndView mv) {
        Object interceptorResult = null;
        if (controllerClass.isInterceptedAfter(controller, this.actionName)) {
            Closure afterInterceptor = controllerClass.getAfterInterceptor(controller);
            if (afterInterceptor.getDelegate() != controller) {
                afterInterceptor.setDelegate((Object)controller);
                afterInterceptor.setResolveStrategy(1);
            }
            Map model = new HashMap();
            if (mv != null) {
                model = mv.getModel() != null ? mv.getModel() : new HashMap();
            }
            switch (afterInterceptor.getMaximumNumberOfParameters()) {
                case 1: {
                    interceptorResult = afterInterceptor.call(new Object[]{model});
                    break;
                }
                case 2: {
                    interceptorResult = afterInterceptor.call(new Object[]{model, mv});
                    break;
                }
                default: {
                    throw new ControllerExecutionException("AfterInterceptor closure must accept one or two parameters");
                }
            }
        }
        return interceptorResult == null || !(interceptorResult instanceof Boolean) || (Boolean)interceptorResult != false;
    }

    @Override
    public GrailsApplicationAttributes getGrailsAttributes() {
        return this.grailsAttributes;
    }

    @Override
    public Object handleAction(GroovyObject controller, Closure action, HttpServletRequest request, HttpServletResponse response) {
        return this.handleAction(controller, action, request, response, Collections.EMPTY_MAP);
    }

    @Override
    public Object handleAction(GroovyObject controller, Closure action, HttpServletRequest request, HttpServletResponse response, Map params) {
        GrailsParameterMap paramsMap = (GrailsParameterMap)controller.getProperty("params");
        if (params != null && !params.isEmpty()) {
            paramsMap.putAll(params);
        }
        Object returnValue = action.call();
        request.setAttribute("org.codehaus.groovy.grails.ERRORS", controller.getProperty("errors"));
        return returnValue;
    }

    @Override
    public ModelAndView handleActionResponse(GroovyObject controller, Object returnValue, String closurePropertyName, String viewName) {
        boolean viewNameBlank = viewName == null || viewName.length() == 0;
        ModelAndView explicitModelAndView = (ModelAndView)controller.getProperty("modelAndView");
        if (!this.webRequest.isRenderView()) {
            return null;
        }
        if (explicitModelAndView != null) {
            return explicitModelAndView;
        }
        if (returnValue == null) {
            if (viewNameBlank) {
                return null;
            }
            Object model = !this.chainModel.isEmpty() ? new CompositeMap(this.chainModel, (Map)new BeanMap((Object)controller)) : new BeanMap((Object)controller);
            return new ModelAndView(viewName, (Map)model);
        }
        if (returnValue instanceof Map) {
            LinkedHashMap<Object, Object> finalModel = new LinkedHashMap<Object, Object>();
            if (!this.chainModel.isEmpty()) {
                finalModel.putAll(this.chainModel);
            }
            Map returnModel = (Map)returnValue;
            finalModel.putAll(returnModel);
            this.removeProxiesFromModelObjects(finalModel);
            return new ModelAndView(viewName, finalModel);
        }
        if (returnValue instanceof ModelAndView) {
            ModelAndView modelAndView = (ModelAndView)returnValue;
            Map modelMap = modelAndView.getModel();
            this.removeProxiesFromModelObjects(modelMap);
            if (!this.chainModel.isEmpty()) {
                modelAndView.addAllObjects(this.chainModel);
            }
            if (modelAndView.getView() == null && modelAndView.getViewName() == null) {
                if (viewNameBlank) {
                    throw new NoViewNameDefinedException("ModelAndView instance returned by and no view name defined by nor for closure on property [" + closurePropertyName + "] in controller [" + controller.getClass() + "]!");
                }
                modelAndView.setViewName(viewName);
            }
            return modelAndView;
        }
        Object model = !this.chainModel.isEmpty() ? new CompositeMap(this.chainModel, (Map)new BeanMap((Object)controller)) : new BeanMap((Object)controller);
        return new ModelAndView(viewName, (Map)model);
    }

    private void initChainModel(GroovyObject controller) {
        FlashScope fs = this.grailsAttributes.getFlashScope((ServletRequest)((HttpServletRequest)controller.getProperty("request")));
        if (fs.containsKey(PROPERTY_CHAIN_MODEL)) {
            this.chainModel = (Map)fs.get(PROPERTY_CHAIN_MODEL);
            if (this.chainModel == null) {
                this.chainModel = Collections.EMPTY_MAP;
            }
        }
    }
}

