/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import groovy.lang.Binding;
import groovy.lang.GroovyObject;
import groovy.lang.Writable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyPageWritable
implements Writable {
    private static final Log LOG = LogFactory.getLog(GroovyPageWritable.class);
    private HttpServletResponse response;
    private HttpServletRequest request;
    private GroovyPageMetaInfo metaInfo;
    private boolean showSource;
    private GrailsWebRequest webRequest;
    private ServletContext context;
    private Map additionalBinding = new HashMap();
    private static final String GROOVY_SOURCE_CONTENT_TYPE = "text/plain";
    private GrailsPluginManager pluginManager;
    private static final GspNoneCodec gspNoneCodeInstance = new GspNoneCodec();
    private static Map<String, Class<?>> cachedDomainsWithoutPackage;

    public GroovyPageWritable(GroovyPageMetaInfo metaInfo) {
        this.webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        ApplicationContext applicationContext = this.webRequest.getApplicationContext();
        if (applicationContext != null && applicationContext.containsBean("pluginManager")) {
            this.pluginManager = (GrailsPluginManager)applicationContext.getBean("pluginManager", GrailsPluginManager.class);
        }
        this.request = this.webRequest.getCurrentRequest();
        HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
        this.response = wrapped != null ? wrapped : this.webRequest.getCurrentResponse();
        this.context = this.webRequest.getServletContext();
        this.metaInfo = metaInfo;
        this.showSource = this.shouldShowGroovySource();
    }

    private boolean shouldShowGroovySource() {
        return this.request.getParameter("showSource") != null && Environment.getCurrent() == Environment.DEVELOPMENT && this.metaInfo.getGroovySource() != null;
    }

    public void setBinding(Map binding) {
        if (binding != null) {
            this.additionalBinding = binding;
        }
    }

    public void setShowSource(boolean showSource) {
        this.showSource = showSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer writeTo(Writer out) throws IOException {
        if (this.showSource) {
            this.response.setContentType(GROOVY_SOURCE_CONTENT_TYPE);
            this.writeGroovySourceToResponse(this.metaInfo, out);
        } else {
            boolean contentTypeAlreadySet;
            if (this.metaInfo.getCompilationException() != null) {
                throw this.metaInfo.getCompilationException();
            }
            boolean bl = contentTypeAlreadySet = this.response.isCommitted() || this.response.getContentType() != null;
            if (LOG.isDebugEnabled() && !contentTypeAlreadySet) {
                LOG.debug((Object)("Writing response to [" + this.response.getClass() + "] with content type: " + this.metaInfo.getContentType()));
            }
            if (!contentTypeAlreadySet) {
                this.response.setContentType(this.metaInfo.getContentType());
            }
            GroovyPageBinding binding = (GroovyPageBinding)((Object)this.request.getAttribute("org.codehaus.groovy.grails.PAGE_SCOPE"));
            GroovyPageBinding oldBinding = null;
            if (binding == null) {
                binding = this.createBinding(this.metaInfo.getPageClass());
                this.formulateBinding(this.request, this.response, binding, out);
            } else {
                oldBinding = binding;
                binding = this.createBinding(this.metaInfo.getPageClass());
                binding.setPluginContextPath(oldBinding.getPluginContextPath());
                this.formulateBinding(this.request, this.response, binding, out);
            }
            if (this.metaInfo.getCodecClass() != null) {
                this.request.setAttribute("org.codehaus.groovy.grails.GSP_CODEC", (Object)this.metaInfo.getCodecName());
                binding.setVariable("Codec", this.metaInfo.getCodecClass());
            } else {
                binding.setVariable("Codec", gspNoneCodeInstance);
            }
            GroovyPage page = (GroovyPage)InvokerHelper.createScript(this.metaInfo.getPageClass(), (Binding)binding);
            page.setJspTags(this.metaInfo.getJspTags());
            page.setJspTagLibraryResolver(this.metaInfo.getJspTagLibraryResolver());
            page.setGspTagLibraryLookup(this.metaInfo.getTagLibraryLookup());
            page.setHtmlParts(this.metaInfo.getHtmlParts());
            page.initRun(out, this.webRequest);
            try {
                page.run();
            }
            finally {
                page.cleanup();
            }
            this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)oldBinding);
        }
        return out;
    }

    protected void copyBinding(Binding binding, Binding oldBinding, Writer out) {
        this.formulateBindingFromWebRequest(binding, this.request, this.response, out, (GroovyObject)this.request.getAttribute("org.codehaus.groovy.grails.CONTROLLER"));
        binding.getVariables().putAll(oldBinding.getVariables());
        for (Object o : this.additionalBinding.keySet()) {
            String key = (String)o;
            if (!GroovyPage.isReservedName(key)) {
                binding.setVariable(key, this.additionalBinding.get(key));
                continue;
            }
            LOG.debug((Object)("Variable [" + key + "] cannot be placed within the GSP model, the name used is a reserved name."));
        }
    }

    private GroovyPageBinding createBinding(Class<?> pageClass) {
        GroovyPageBinding binding = this.pluginManager != null ? new GroovyPageBinding(this.pluginManager.getPluginPathForClass(pageClass)) : new GroovyPageBinding();
        this.request.setAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", (Object)binding);
        binding.setVariable("pageScope", (Object)binding);
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInputStreamToResponse(InputStream in, Writer out) throws IOException {
        try {
            int read;
            in.reset();
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            char[] buf = new char[8192];
            while ((read = reader.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGroovySourceToResponse(GroovyPageMetaInfo info, Writer out) throws IOException {
        InputStream in = info.getGroovySource();
        if (in == null) {
            return;
        }
        try {
            try {
                in.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            int lineNum = 1;
            int maxPaddingSize = 3;
            StringBuffer paddingBuffer = new StringBuffer(maxPaddingSize);
            for (int i = 0; i < maxPaddingSize; ++i) {
                paddingBuffer.append(' ');
            }
            String padding = paddingBuffer.toString();
            String line = reader.readLine();
            while (line != null) {
                String numberText = String.valueOf(lineNum);
                if (padding.length() + numberText.length() > 4) {
                    paddingBuffer.deleteCharAt(padding.length() - 1);
                    padding = paddingBuffer.toString();
                }
                out.write(padding);
                out.write(numberText);
                out.write(": ");
                out.write(line);
                out.write(10);
                line = reader.readLine();
                ++lineNum;
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    protected void formulateBinding(HttpServletRequest req, HttpServletResponse res, Binding binding, Writer out) {
        this.formulateBindingFromWebRequest(binding, req, res, out, (GroovyObject)req.getAttribute("org.codehaus.groovy.grails.CONTROLLER"));
        this.populateViewModel(req, binding);
    }

    protected void populateViewModel(HttpServletRequest req, Binding binding) {
        Map variables = binding.getVariables();
        Enumeration attributeEnum = req.getAttributeNames();
        while (attributeEnum.hasMoreElements()) {
            String key = (String)attributeEnum.nextElement();
            if (!GroovyPage.isReservedName(key)) {
                if (variables.containsKey(key)) continue;
                binding.setVariable(key, req.getAttribute(key));
                continue;
            }
            LOG.debug((Object)("Variable [" + key + "] cannot be placed within the GSP model, the name used is a reserved name."));
        }
        for (Object o : this.additionalBinding.keySet()) {
            String key = (String)o;
            if (!GroovyPage.isReservedName(key)) {
                binding.setVariable(key, this.additionalBinding.get(key));
                continue;
            }
            LOG.debug((Object)("Variable [" + key + "] cannot be placed within the GSP model, the name used is a reserved name."));
        }
    }

    private void formulateBindingFromWebRequest(Binding binding, HttpServletRequest req, HttpServletResponse res, Writer out, GroovyObject controller) {
        GrailsWebRequest grailsWebRequest = GrailsWebRequest.lookup(req);
        binding.setVariable("webRequest", (Object)grailsWebRequest);
        binding.setVariable("request", (Object)req);
        binding.setVariable("response", (Object)res);
        binding.setVariable("flash", (Object)grailsWebRequest.getFlashScope());
        binding.setVariable("application", (Object)this.context);
        ApplicationContext appCtx = grailsWebRequest.getAttributes().getApplicationContext();
        binding.setVariable("applicationContext", (Object)appCtx);
        if (appCtx != null) {
            GrailsApplication app = (GrailsApplication)appCtx.getBean("grailsApplication", GrailsApplication.class);
            binding.setVariable("grailsApplication", (Object)app);
            Map<String, Class<?>> domainClassesWithoutPackage = GroovyPageWritable.getDomainClassMap(app);
            binding.getVariables().putAll(domainClassesWithoutPackage);
        }
        binding.setVariable("session", (Object)grailsWebRequest.getSession());
        binding.setVariable("params", (Object)grailsWebRequest.getParams());
        binding.setVariable("actionName", (Object)grailsWebRequest.getActionName());
        binding.setVariable("controllerName", (Object)grailsWebRequest.getControllerName());
        if (controller != null) {
            binding.setVariable("org.codehaus.groovy.grails.CONTROLLER", (Object)controller);
        }
        binding.setVariable("out", (Object)out);
    }

    private static synchronized Map<String, Class<?>> getDomainClassMap(GrailsApplication application) {
        HashMap domainsWithoutPackage = cachedDomainsWithoutPackage != null ? cachedDomainsWithoutPackage : new HashMap();
        GrailsClass[] domainClasses = application.getArtefacts("Domain");
        if (domainClasses.length != domainsWithoutPackage.size()) {
            domainsWithoutPackage.clear();
            for (GrailsClass domainClass : domainClasses) {
                Class theClass = domainClass.getClazz();
                domainsWithoutPackage.put(theClass.getName(), theClass);
            }
            if (!Environment.isDevelopmentMode()) {
                cachedDomainsWithoutPackage = domainsWithoutPackage;
            }
        }
        return domainsWithoutPackage;
    }

    private static final class GspNoneCodec {
        private GspNoneCodec() {
        }

        public final Object encode(Object object) {
            return object;
        }
    }
}

