/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Closure;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractUrlMappingInfo
implements UrlMappingInfo {
    protected Map params = Collections.EMPTY_MAP;

    public void configure(GrailsWebRequest webRequest) {
        this.populateParamsForMapping(webRequest);
    }

    protected void populateParamsForMapping(GrailsWebRequest webRequest) {
        String id;
        GrailsParameterMap dispatchParams = webRequest.getParams();
        String encoding = webRequest.getRequest().getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        Collection<Object> keys = this.params.keySet();
        keys = DefaultGroovyMethods.toList(keys);
        Collections.sort((List)keys, new Comparator(){

            public int compare(Object leftKey, Object rightKey) {
                Object leftValue = AbstractUrlMappingInfo.this.params.get(leftKey);
                Object rightValue = AbstractUrlMappingInfo.this.params.get(rightKey);
                boolean leftIsClosure = leftValue instanceof Closure;
                boolean rightIsClosure = rightValue instanceof Closure;
                if (leftIsClosure && rightIsClosure) {
                    return 0;
                }
                if (leftIsClosure && !rightIsClosure) {
                    return 1;
                }
                if (rightIsClosure && !leftIsClosure) {
                    return -1;
                }
                return 0;
            }
        });
        for (Object key : keys) {
            String name = (String)key;
            Object param = this.params.get(name);
            if (param instanceof Closure) {
                param = this.evaluateNameForValue(param);
            }
            if (param instanceof String) {
                try {
                    param = URLDecoder.decode((String)param, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    param = this.evaluateNameForValue(param);
                }
            }
            dispatchParams.put(name, param);
        }
        String viewName = this.getViewName();
        if (viewName == null && this.getURI() == null) {
            webRequest.setControllerName(this.getControllerName());
            webRequest.setActionName(this.getActionName());
        }
        if (!StringUtils.isBlank((String)(id = this.getId()))) {
            try {
                dispatchParams.put("id", URLDecoder.decode(id, encoding));
            }
            catch (UnsupportedEncodingException e) {
                dispatchParams.put("id", id);
            }
        }
    }

    protected String evaluateNameForValue(Object value) {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        return this.evaluateNameForValue(value, webRequest);
    }

    protected String evaluateNameForValue(Object value, GrailsWebRequest webRequest) {
        String name;
        if (value == null) {
            return null;
        }
        if (value instanceof Closure) {
            Closure callable = (Closure)value;
            Closure cloned = (Closure)callable.clone();
            cloned.setDelegate((Object)webRequest);
            cloned.setResolveStrategy(1);
            Object result = cloned.call();
            name = result != null ? result.toString() : null;
        } else if (value instanceof Map) {
            Map httpMethods = (Map)value;
            name = (String)httpMethods.get(webRequest.getCurrentRequest().getMethod());
        } else {
            name = value.toString();
        }
        return name != null ? name.trim() : null;
    }
}

