/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsUtil;
import groovy.lang.Writable;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class GroovyPagesServlet
extends FrameworkServlet {
    private static final long serialVersionUID = -1918149859392123495L;
    private static final Log LOG = LogFactory.getLog(GroovyPagesServlet.class);
    private ServletContext context;
    private GrailsApplicationAttributes grailsAttributes;
    private static final String ERRORS_VIEW = "/WEB-INF/grails-app/views/error.gsp";
    public static final String EXCEPTION_MODEL_KEY = "exception";
    public static final String SERVLET_INSTANCE = "org.codehaus.groovy.grails.GSP_SERVLET";
    private Collection<HandlerExceptionResolver> exceptionResolvers;
    private GroovyPagesTemplateEngine templateEngine;

    public GroovyPagesServlet() {
        this.setContextAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        this.context = this.getServletContext();
        this.context.log("GSP servlet initialized");
        this.context.setAttribute(SERVLET_INSTANCE, (Object)this);
        this.exceptionResolvers = this.getWebApplicationContext().getBeansOfType(HandlerExceptionResolver.class).values();
        this.grailsAttributes = new DefaultGrailsApplicationAttributes(this.context);
        this.templateEngine = (GroovyPagesTemplateEngine)((Object)this.getWebApplicationContext().getBean("groovyPagesTemplateEngine", GroovyPagesTemplateEngine.class));
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Template template;
        request.setAttribute("org.codehaus.groovy.grails.GRAILS_APPLICATION_ATTRIBUTES", (Object)this.grailsAttributes);
        request.setAttribute(SERVLET_INSTANCE, (Object)this);
        String pageName = (String)request.getAttribute("org.codehaus.groovy.grails.GSP_TO_RENDER");
        if (StringUtils.isBlank((String)pageName)) {
            pageName = this.templateEngine.getCurrentRequestUri(request);
        }
        if ((template = this.templateEngine.createTemplateForUri(pageName)) == null) {
            this.context.log("GroovyPagesServlet:  \"" + pageName + "\" not found");
            response.sendError(404, "\"" + pageName + "\" not found.");
            return;
        }
        this.renderPageWithEngine(this.templateEngine, request, response, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderPageWithEngine(GroovyPagesTemplateEngine engine, HttpServletRequest request, HttpServletResponse response, Template template) throws IOException, ServletException {
        Writer out = this.createResponseWriter(response);
        try {
            Writable w = template.make();
            w.writeTo(out);
        }
        catch (Exception e) {
            out = this.createResponseWriter(response);
            this.handleException(request, response, e, out, engine);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, Exception exception, Writer out, GroovyPagesTemplateEngine engine) throws ServletException, IOException {
        if (this.exceptionResolvers != null) {
            HandlerExceptionResolver exceptionResolver;
            ModelAndView exMv = null;
            Iterator<HandlerExceptionResolver> i$ = this.exceptionResolvers.iterator();
            while (i$.hasNext() && (exMv = (exceptionResolver = i$.next()).resolveException(request, response, (Object)this, exception)) == null) {
            }
            if (exMv != null) {
                try {
                    exMv.getView().render(exMv.getModel(), request, response);
                }
                catch (Exception e) {
                    this.defaultExceptionHandling(exception, out, engine);
                }
            }
        } else {
            this.defaultExceptionHandling(exception, out, engine);
        }
    }

    private void defaultExceptionHandling(Exception exception, Writer out, GroovyPagesTemplateEngine engine) {
        GrailsUtil.deepSanitize(exception);
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Error processing GSP: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            Template t = engine.createTemplate(ERRORS_VIEW);
            HashMap<String, GrailsWrappedRuntimeException> model = new HashMap<String, GrailsWrappedRuntimeException>();
            model.put(EXCEPTION_MODEL_KEY, new GrailsWrappedRuntimeException(this.context, exception));
            Writable w = t.make(model);
            w.writeTo(out);
        }
        catch (Throwable t) {
            LOG.error((Object)("Error attempting to render errors view : " + t.getMessage()), t);
            LOG.error((Object)("Original exception : " + exception.getMessage()), (Throwable)exception);
        }
    }

    protected Writer createResponseWriter(HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response);
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        webRequest.setOut(out);
        return out;
    }
}

