/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.multipart;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ContentLengthAwareCommonsMultipartResolver
extends CommonsMultipartResolver {
    private static final LinkedMultiValueMap<String, MultipartFile> EMPTY_MULTI_VALUE_MAP = new LinkedMultiValueMap();
    private static final Log LOG = LogFactory.getLog(ContentLengthAwareCommonsMultipartResolver.class);

    protected CommonsFileUploadSupport.MultipartParsingResult parseRequest(HttpServletRequest request) throws MultipartException {
        try {
            return super.parseRequest(request);
        }
        catch (MultipartException e) {
            if (e.getCause() != null && e.getCause().getClass().equals(FileUploadBase.UnknownSizeException.class)) {
                LOG.warn((Object)e.getMessage());
                Map empty = Collections.emptyMap();
                return new CommonsFileUploadSupport.MultipartParsingResult(EMPTY_MULTI_VALUE_MAP, empty);
            }
            throw e;
        }
    }
}

