/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import grails.util.GrailsUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.util.IncludeResponseWrapper;
import org.codehaus.groovy.grails.web.util.IncludedContent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

public class WebUtils
extends org.springframework.web.util.WebUtils {
    public static final char SLASH = '/';
    private static final Log LOG = LogFactory.getLog(WebUtils.class);
    public static final String ENABLE_FILE_EXTENSIONS = "grails.mime.file.extensions";
    public static final String DISPATCH_ACTION_PARAMETER = "_action_";
    private static final String DISPATCH_URI_SUFFIX = ".dispatch";
    private static final String GRAILS_DISPATCH_SERVLET_NAME = "/grails";

    public static ViewResolver lookupViewResolver(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        String[] beanNames = wac.getBeanNamesForType(ViewResolver.class);
        if (beanNames.length > 0) {
            String beanName = beanNames[0];
            return (ViewResolver)wac.getBean(beanName);
        }
        return null;
    }

    public static HandlerInterceptor[] lookupHandlerInterceptors(ServletContext servletContext) {
        WebRequestInterceptor[] webRequestInterceptors;
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        ArrayList<Object> allHandlerInterceptors = new ArrayList<Object>();
        for (WebRequestInterceptor webRequestInterceptor : webRequestInterceptors = WebUtils.lookupWebRequestInterceptors(servletContext)) {
            allHandlerInterceptors.add(new WebRequestHandlerInterceptorAdapter(webRequestInterceptor));
        }
        Collection handlerInterceptors = wac.getBeansOfType(HandlerInterceptor.class).values();
        allHandlerInterceptors.addAll(handlerInterceptors);
        return allHandlerInterceptors.toArray(new HandlerInterceptor[allHandlerInterceptors.size()]);
    }

    public static WebRequestInterceptor[] lookupWebRequestInterceptors(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Collection webRequestInterceptors = wac.getBeansOfType(WebRequestInterceptor.class).values();
        return webRequestInterceptors.toArray(new WebRequestInterceptor[webRequestInterceptors.size()]);
    }

    public static UrlMappingsHolder lookupUrlMappings(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }

    public static String getRequestURIForGrailsDispatchURI(HttpServletRequest request) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        if (request.getRequestURI().endsWith(DISPATCH_URI_SUFFIX)) {
            String path = pathHelper.getPathWithinApplication(request);
            if (path.startsWith(GRAILS_DISPATCH_SERVLET_NAME)) {
                path = path.substring(GRAILS_DISPATCH_SERVLET_NAME.length(), path.length());
            }
            return path.substring(0, path.length() - DISPATCH_URI_SUFFIX.length());
        }
        return pathHelper.getPathWithinApplication(request);
    }

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (GrailsApplication)wac.getBean("grailsApplication");
    }

    public static View resolveView(HttpServletRequest request, UrlMappingInfo info, String viewName, ViewResolver viewResolver) throws Exception {
        String controllerName = info.getControllerName();
        return WebUtils.resolveView(request, viewName, controllerName, viewResolver);
    }

    public static View resolveView(HttpServletRequest request, String viewName, String controllerName, ViewResolver viewResolver) throws Exception {
        View v;
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        if (viewName.startsWith(String.valueOf('/'))) {
            v = viewResolver.resolveViewName(viewName, webRequest.getLocale());
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append('/');
            if (controllerName != null) {
                buf.append(controllerName).append('/');
            }
            buf.append(viewName);
            v = viewResolver.resolveViewName(buf.toString(), webRequest.getLocale());
        }
        return v;
    }

    public static String buildDispatchUrlForMapping(UrlMappingInfo info) {
        return WebUtils.buildDispatchUrlForMapping(info, false);
    }

    private static String buildDispatchUrlForMapping(UrlMappingInfo info, boolean includeParams) {
        if (info.getURI() != null) {
            return info.getURI();
        }
        StringBuilder forwardUrl = new StringBuilder();
        if (info.getViewName() != null) {
            String viewName = info.getViewName();
            forwardUrl.append('/').append(viewName);
        } else {
            forwardUrl.append(GRAILS_DISPATCH_SERVLET_NAME);
            forwardUrl.append('/').append(info.getControllerName());
            if (!StringUtils.isBlank((String)info.getActionName())) {
                forwardUrl.append('/').append(info.getActionName());
            }
            forwardUrl.append(DISPATCH_URI_SUFFIX);
        }
        Map parameters = info.getParameters();
        if (parameters != null && !parameters.isEmpty() && includeParams) {
            try {
                forwardUrl.append(WebUtils.toQueryString(parameters));
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerExecutionException("Unable to include ");
            }
        }
        return forwardUrl.toString();
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info) throws ServletException, IOException {
        return WebUtils.forwardRequestForUrlMappingInfo(request, response, info, Collections.EMPTY_MAP);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) throws ServletException, IOException {
        return WebUtils.forwardRequestForUrlMappingInfo(request, response, info, model, false);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model, boolean includeParams) throws ServletException, IOException {
        String forwardUrl = WebUtils.buildDispatchUrlForMapping(info, includeParams);
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        webRequest.removeAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", 0);
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        WebUtils.exposeRequestAttributes((ServletRequest)request, (Map)model);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        return forwardUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncludedContent includeForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) {
        IncludedContent includedContent;
        block5: {
            String includeUrl = WebUtils.buildDispatchUrlForMapping(info, true);
            GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
            String currentController = null;
            String currentAction = null;
            String currentId = null;
            ModelAndView currentMv = null;
            HashMap currentParams = null;
            if (webRequest != null) {
                currentController = webRequest.getControllerName();
                currentAction = webRequest.getActionName();
                currentId = webRequest.getId();
                currentParams = new HashMap();
                currentParams.putAll(webRequest.getParameterMap());
                currentMv = (ModelAndView)webRequest.getAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", 0);
            }
            try {
                if (webRequest != null) {
                    webRequest.getParameterMap().clear();
                    info.configure(webRequest);
                    webRequest.getParameterMap().putAll(info.getParameters());
                    webRequest.removeAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", 0);
                }
                includedContent = WebUtils.includeForUrl(includeUrl, request, response, model);
                Object var13_12 = null;
                if (webRequest == null) break block5;
                webRequest.getParameterMap().clear();
                webRequest.getParameterMap().putAll(currentParams);
                webRequest.setId(currentId);
                webRequest.setControllerName(currentController);
                webRequest.setActionName(currentAction);
                if (currentMv == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var13_13 = null;
                    if (webRequest == null) break block6;
                    webRequest.getParameterMap().clear();
                    webRequest.getParameterMap().putAll(currentParams);
                    webRequest.setId(currentId);
                    webRequest.setControllerName(currentController);
                    webRequest.setActionName(currentAction);
                    if (currentMv != null) {
                        webRequest.setAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", currentMv, 0);
                    }
                }
                throw throwable;
            }
            webRequest.setAttribute("org.codehaus.groovy.grails.MODEL_AND_VIEW", currentMv, 0);
        }
        return includedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IncludedContent includeForUrl(String includeUrl, HttpServletRequest request, HttpServletResponse response, Map model) {
        RequestDispatcher dispatcher = request.getRequestDispatcher(includeUrl);
        HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
        response = wrapped != null ? wrapped : response;
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        WebUtils.exposeRequestAttributes((ServletRequest)request, (Map)model);
        try {
            IncludedContent includedContent;
            block6: {
                IncludedContent includedContent2;
                block5: {
                    IncludeResponseWrapper responseWrapper = new IncludeResponseWrapper(response);
                    try {
                        WrappedResponseHolder.setWrappedResponse((HttpServletResponse)responseWrapper);
                        dispatcher.include((ServletRequest)request, (ServletResponse)responseWrapper);
                        if (responseWrapper.getRedirectURL() != null) {
                            includedContent2 = new IncludedContent(responseWrapper.getRedirectURL());
                            Object var9_10 = null;
                            break block5;
                        }
                        includedContent = new IncludedContent(responseWrapper.getContentType(), responseWrapper.getContent());
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        WrappedResponseHolder.setWrappedResponse(wrapped);
                        throw throwable;
                    }
                }
                WrappedResponseHolder.setWrappedResponse(wrapped);
                return includedContent2;
            }
            Object var9_11 = null;
            WrappedResponseHolder.setWrappedResponse(wrapped);
            return includedContent;
        }
        catch (Exception e) {
            GrailsUtil.deepSanitize(e);
            throw new ControllerExecutionException("Unable to execute include: " + e.getMessage(), e);
        }
    }

    public static String toQueryString(Map params, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringBuilder queryString = new StringBuilder("?");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            boolean hasMore = i.hasNext();
            boolean wasAppended = WebUtils.appendEntry(entry, queryString, encoding, "");
            if (!hasMore || !wasAppended) continue;
            queryString.append('&');
        }
        return queryString.toString();
    }

    public static String toQueryString(Map parameters) throws UnsupportedEncodingException {
        return WebUtils.toQueryString(parameters, "UTF-8");
    }

    private static boolean appendEntry(Map.Entry entry, StringBuilder queryString, String encoding, String path) throws UnsupportedEncodingException {
        String name = entry.getKey().toString();
        if (name.indexOf(".") > -1) {
            return false;
        }
        Object value = entry.getValue();
        if (value == null) {
            value = "";
        } else if (value instanceof GrailsParameterMap) {
            GrailsParameterMap child = (GrailsParameterMap)value;
            Set nestedEntrySet = child.entrySet();
            for (Object aNestedEntrySet : nestedEntrySet) {
                Map.Entry childEntry = (Map.Entry)aNestedEntrySet;
                WebUtils.appendEntry(childEntry, queryString, encoding, entry.getKey().toString() + '.');
            }
        } else {
            queryString.append(URLEncoder.encode(path + name, encoding)).append('=').append(URLEncoder.encode(value.toString(), encoding));
        }
        return true;
    }

    public static String getFormatFromURI(String uri) {
        String lastToken;
        if (uri.endsWith("/")) {
            return null;
        }
        int idx = uri.lastIndexOf(47);
        if (idx > -1 && (idx = (lastToken = uri.substring(idx + 1, uri.length())).lastIndexOf(46)) > -1 && idx != lastToken.length() - 1) {
            MimeType[] mimeTypes;
            String extension = lastToken.substring(idx + 1, lastToken.length());
            for (MimeType mimeType : mimeTypes = MimeType.getConfiguredMimeTypes()) {
                if (!mimeType.getExtension().equals(extension)) continue;
                return extension;
            }
        }
        return null;
    }

    public static boolean areFileExtensionsEnabled() {
        Map config = ConfigurationHolder.getFlatConfig();
        Object o = config.get(ENABLE_FILE_EXTENSIONS);
        return o == null || !(o instanceof Boolean) || (Boolean)o != false;
    }

    public static GrailsWebRequest retrieveGrailsWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    public static void storeGrailsWebRequest(GrailsWebRequest webRequest) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        webRequest.getRequest().setAttribute("org.codehaus.groovy.grails.WEB_REQUEST", (Object)webRequest);
    }

    public static void clearGrailsWebRequest() {
        RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
        if (reqAttrs != null) {
            GrailsWebRequest webRequest = (GrailsWebRequest)reqAttrs;
            webRequest.getRequest().removeAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
            RequestContextHolder.setRequestAttributes(null);
        }
    }

    public static String getForwardURI(HttpServletRequest request) {
        String result = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (StringUtils.isBlank((String)result)) {
            result = request.getRequestURI();
        }
        return result;
    }
}

