/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public class GroovyElseIfTag
extends GroovySyntaxTag {
    public static final String TAG_NAME = "elseif";
    private static final String ATTRIBUTE_TEST = "test";
    private static final String ATTRIBUTE_ENV = "env";

    public void doStartTag() {
        String env = (String)this.attributes.get(ATTRIBUTE_ENV);
        String test = (String)this.attributes.get(ATTRIBUTE_TEST);
        env = StringUtils.isBlank((String)env) ? null : env;
        String string = test = StringUtils.isBlank((String)test) ? null : test;
        if (env == null && test == null) {
            throw new GrailsTagException("Tag [elseif] must have one or both of the attributes [test] or [env]");
        }
        if (env != null) {
            env = this.calculateExpression(env);
        }
        if (env != null && test != null) {
            this.out.print("else if((GrailsUtil.environment == '" + env + "') && (");
            this.out.print(test);
            this.out.println(")) {");
        } else if (env != null) {
            this.out.print("else if(GrailsUtil.environment == '" + env + "') {");
        } else {
            this.out.print("else if(");
            this.out.print(test);
            this.out.println(") {");
        }
    }

    public void doEndTag() {
        this.out.println("}");
    }

    public String getName() {
        return TAG_NAME;
    }

    public boolean isKeepPrecedingWhiteSpace() {
        return false;
    }

    public boolean isAllowPrecedingContent() {
        return false;
    }
}

