/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import grails.util.Environment;
import grails.util.Metadata;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.PluginInfo;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsLayoutDecoratorMapper
extends AbstractDecoratorMapper
implements DecoratorMapper {
    private static final String DEFAULT_DECORATOR_PATH = "/WEB-INF/grails-app/views/layouts";
    private static final String DEFAULT_VIEW_TYPE = ".gsp";
    private static final Log LOG = LogFactory.getLog(GrailsLayoutDecoratorMapper.class);
    private Map<String, Decorator> decoratorMap = new ConcurrentHashMap<String, Decorator>();
    private ServletContext servletContext;
    private WebApplicationContext applicationContext;
    private GrailsPluginManager pluginManager;

    public void init(Config config, Properties properties, DecoratorMapper parent) throws InstantiationException {
        super.init(config, properties, parent);
        this.servletContext = config.getServletContext();
        this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
        if (this.applicationContext.containsBean("pluginManager")) {
            this.pluginManager = (GrailsPluginManager)this.applicationContext.getBean("pluginManager", GrailsPluginManager.class);
        }
    }

    public Decorator getDecorator(HttpServletRequest request, Page page) {
        Decorator d;
        String layoutName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluating layout for request: " + request.getRequestURI()));
        }
        if (StringUtils.isBlank((String)(layoutName = page.getProperty("meta.layout")))) {
            GroovyObject controller = (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
            if (controller != null) {
                String controllerName = (String)controller.getProperty("controllerName");
                String actionUri = (String)controller.getProperty("actionUri");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found controller in request, location layout for controller [" + controllerName + "] and action [" + actionUri + "]"));
                }
                Decorator d2 = null;
                Object layoutProperty = GrailsClassUtils.getStaticPropertyValue(controller.getClass(), (String)"layout");
                if (layoutProperty instanceof String) {
                    LOG.debug((Object)("layout property found in controller, looking for template named " + layoutProperty));
                    d2 = this.getNamedDecorator(request, (String)layoutProperty);
                }
                if (d2 == null) {
                    d2 = this.getNamedDecorator(request, actionUri.substring(1));
                }
                if (d2 != null) {
                    return d2;
                }
                if (!StringUtils.isBlank((String)controllerName)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Action layout not found, trying controller");
                    }
                    if ((d2 = this.getNamedDecorator(request, controllerName)) != null) {
                        return d2;
                    }
                    return this.parent != null ? super.getDecorator(request, page) : null;
                }
            } else {
                return this.parent != null ? super.getDecorator(request, page) : null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluated layout for page: " + layoutName));
        }
        if ((d = this.getNamedDecorator(request, layoutName)) != null) {
            return d;
        }
        return this.parent != null ? super.getDecorator(request, page) : null;
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        if (Environment.getCurrent() != Environment.DEVELOPMENT && this.decoratorMap.containsKey(name)) {
            return this.decoratorMap.get(name);
        }
        String decoratorName = name;
        if (!name.matches("(.+)(\\.)(\\w{2}|\\w{3})")) {
            name = name + DEFAULT_VIEW_TYPE;
        }
        String decoratorPage = "/WEB-INF/grails-app/views/layouts/" + name;
        ResourceLoader resourceLoader = this.establishResourceLoader();
        Resource res = resourceLoader.getResource(decoratorPage);
        Decorator d = null;
        if (!res.exists()) {
            String pathToView = this.lookupPathToControllerView(request, name);
            Resource resource = res = pathToView != null ? resourceLoader.getResource(pathToView) : null;
            if (res != null && res.exists()) {
                decoratorPage = pathToView;
                d = this.useExistingDecorator(request, decoratorName, decoratorPage);
            } else {
                String pluginViewLocation = this.searchPluginViews(name, resourceLoader);
                if (pluginViewLocation != null) {
                    decoratorPage = pluginViewLocation;
                    d = this.useExistingDecorator(request, decoratorName, decoratorPage);
                }
            }
        } else {
            d = this.useExistingDecorator(request, decoratorName, decoratorPage);
        }
        return d;
    }

    public String searchPluginViews(String name, ResourceLoader resourceLoader) {
        String pluginViewLocation = null;
        pluginViewLocation = Metadata.getCurrent().isWarDeployed() ? this.searchPluginViewsForWarDeployed(name, resourceLoader) : this.searchPluginViewsInDevelopmentMode(name);
        return pluginViewLocation;
    }

    private String searchPluginViewsInDevelopmentMode(String name) {
        Resource[] pluginDirs;
        String pluginViewLocation = null;
        for (Resource resource : pluginDirs = GrailsPluginUtils.getPluginDirectories()) {
            try {
                Resource layoutPath;
                String pathToLayoutInPlugin = "grails-app/views/layouts/" + name;
                String absolutePathToResource = resource.getFile().getAbsolutePath();
                if (!absolutePathToResource.endsWith("/")) {
                    resource = new FileSystemResource(absolutePathToResource + '/');
                }
                if (!(layoutPath = resource.createRelative(pathToLayoutInPlugin)).exists()) continue;
                PluginInfo info = GrailsPluginUtils.getPluginBuildSettings().getPluginInfo(absolutePathToResource);
                pluginViewLocation = "/WEB-INF/plugins/" + info.getFullName() + '/' + pathToLayoutInPlugin;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return pluginViewLocation;
    }

    private String searchPluginViewsForWarDeployed(String name, ResourceLoader resourceLoader) {
        String pluginViewLocation = null;
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(resourceLoader);
        try {
            Resource[] resources = resourceResolver.getResources("/WEB-INF/plugins/*/grails-app/views/layouts/" + name);
            if (resources.length > 0 && resources[0].exists()) {
                Resource r = resources[0];
                String url = r.getURL().toString();
                pluginViewLocation = "/WEB-INF" + url.substring(url.indexOf("/plugins"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return pluginViewLocation;
    }

    private String lookupPathToControllerView(HttpServletRequest request, String viewName) {
        GroovyObject controller;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        if (webRequest != null && (controller = webRequest.getAttributes().getController((ServletRequest)request)) != null && this.pluginManager != null) {
            String pathToView = this.pluginManager.getPluginViewsPathForInstance((Object)controller);
            return "/WEB-INF" + (pathToView != null ? pathToView : "") + "/layouts/" + viewName;
        }
        return null;
    }

    private Decorator useExistingDecorator(HttpServletRequest request, String decoratorName, String decoratorPage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using decorator " + decoratorPage));
        }
        DefaultDecorator d = new DefaultDecorator(decoratorName, decoratorPage, request.getRequestURI(), Collections.EMPTY_MAP);
        this.decoratorMap.put(decoratorName, (Decorator)d);
        return d;
    }

    private ResourceLoader establishResourceLoader() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
        GrailsApplication application = null;
        if (ctx.containsBean("grailsApplication")) {
            application = (GrailsApplication)ctx.getBean("grailsApplication");
        }
        Object resourceLoader = application == null ? ctx : (ctx.containsBean("groovyPageResourceLoader") && !application.isWarDeployed() ? (ResourceLoader)ctx.getBean("groovyPageResourceLoader") : ctx);
        return resourceLoader;
    }
}

