/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.errors;

import grails.util.GrailsUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.grails.exceptions.GrailsRuntimeException;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.GrailsMVCException;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class GrailsExceptionResolver
extends SimpleMappingExceptionResolver
implements ServletContextAware {
    private ServletContext servletContext;
    private static final Log LOG = LogFactory.getLog(GrailsExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Throwable t;
        if ((ex instanceof InvokerInvocationException || ex instanceof GrailsMVCException) && (t = GrailsExceptionResolver.getRootCause(ex)) instanceof Exception) {
            ex = (Exception)t;
        }
        ModelAndView mv = super.resolveException(request, response, handler, ex);
        response.setStatus(500);
        request.setAttribute("javax.servlet.error.status_code", (Object)500);
        GrailsUtil.deepSanitize(ex);
        LOG.error((Object)ex.getMessage(), (Throwable)ex);
        GrailsWrappedRuntimeException gwrex = new GrailsWrappedRuntimeException(this.servletContext, ex);
        mv.addObject("exception", (Object)gwrex);
        UrlMappingsHolder urlMappings = null;
        try {
            urlMappings = WebUtils.lookupUrlMappings(this.servletContext);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (urlMappings != null) {
            UrlMappingInfo info = urlMappings.matchStatusCode(500, ex);
            if (info == null) {
                info = urlMappings.matchStatusCode(500, GrailsExceptionResolver.getRootCause(ex));
            }
            if (info == null) {
                info = urlMappings.matchStatusCode(500);
            }
            try {
                if (info != null && info.getViewName() != null) {
                    ViewResolver viewResolver = WebUtils.lookupViewResolver(this.servletContext);
                    View v = WebUtils.resolveView(request, info, info.getViewName(), viewResolver);
                    if (v != null) {
                        mv.setView(v);
                    }
                } else if (info != null && info.getControllerName() != null) {
                    String uri = request.getAttribute("javax.servlet.forward.request_uri") != null ? (String)request.getAttribute("javax.servlet.forward.request_uri") : request.getRequestURI();
                    if (!response.isCommitted()) {
                        info.configure(WebUtils.retrieveGrailsWebRequest());
                        String forwardUrl = WebUtils.forwardRequestForUrlMappingInfo(request, response, info, mv.getModel());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Matched URI [" + uri + "] to URL mapping [" + info + "], forwarding to [" + forwardUrl + "] with response [" + response.getClass() + "]"));
                        }
                        return null;
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to render errors view: " + e.getMessage()), (Throwable)e);
                throw new GrailsRuntimeException((Throwable)e);
            }
        }
        return mv;
    }

    public static Throwable getRootCause(Throwable ex) {
        while (ex.getCause() != null && !ex.equals(ex.getCause())) {
            ex = ex.getCause();
        }
        return ex;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static int extractLineNumber(CompilationFailedException e) {
        MultipleCompilationErrorsException mcee;
        Object message;
        int lineNumber = -1;
        if (e instanceof MultipleCompilationErrorsException && (message = (mcee = (MultipleCompilationErrorsException)e).getErrorCollector().getErrors().iterator().next()) instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage sem = (SyntaxErrorMessage)message;
            lineNumber = sem.getCause().getLine();
        }
        return lineNumber;
    }

    public static RuntimeException getFirstRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        Throwable ex = e;
        while (ex.getCause() != null && !ex.equals(ex.getCause())) {
            if (!((ex = ex.getCause()) instanceof RuntimeException)) continue;
            return (RuntimeException)ex;
        }
        return null;
    }
}

