/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.metaclass;

import grails.converters.JSON;
import grails.util.GrailsWebUtil;
import grails.util.JSonBuilder;
import grails.util.OpenRicoBuilder;
import grails.web.JSONBuilder;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.xml.StreamingMarkupBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.ModelAndView;

public class RenderDynamicMethod
extends AbstractDynamicMethodInvocation {
    public static final String METHOD_SIGNATURE = "render";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^render$");
    public static final String ARGUMENT_TEXT = "text";
    public static final String ARGUMENT_STATUS = "status";
    public static final String ARGUMENT_CONTENT_TYPE = "contentType";
    public static final String ARGUMENT_ENCODING = "encoding";
    public static final String ARGUMENT_VIEW = "view";
    public static final String ARGUMENT_MODEL = "model";
    public static final String ARGUMENT_TEMPLATE = "template";
    public static final String ARGUMENT_CONTEXTPATH = "contextPath";
    public static final String ARGUMENT_BEAN = "bean";
    public static final String ARGUMENT_COLLECTION = "collection";
    public static final String ARGUMENT_BUILDER = "builder";
    public static final String ARGUMENT_VAR = "var";
    private static final String DEFAULT_ARGUMENT = "it";
    private static final String BUILDER_TYPE_RICO = "rico";
    private static final String BUILDER_TYPE_JSON = "json";
    private static final String TEXT_HTML = "text/html";
    private String gspEncoding;
    private boolean useLegacyJSONBuilder = true;
    private static final String DEFAULT_ENCODING = "utf-8";
    private Object ARGUMENT_PLUGIN = "plugin";

    public RenderDynamicMethod() {
        super(METHOD_PATTERN);
        Map config = ConfigurationHolder.getFlatConfig();
        Object gspEnc = config.get("grails.views.gsp.encoding");
        this.gspEncoding = gspEnc != null && gspEnc.toString().trim().length() > 0 ? gspEnc.toString() : DEFAULT_ENCODING;
        Object o = config.get("grails.json.legacy.builder");
        if (o instanceof Boolean) {
            this.useLegacyJSONBuilder = (Boolean)o;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object target, String methodName, Object[] arguments) {
        if (arguments.length == 0) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        GrailsApplication application = webRequest.getAttributes().getGrailsApplication();
        HttpServletRequest request = webRequest.getCurrentRequest();
        HttpServletResponse response = webRequest.getCurrentResponse();
        boolean renderView = true;
        GroovyObject controller = (GroovyObject)target;
        if (arguments[0] instanceof String || arguments[0] instanceof GString) {
            this.setContentType(response, TEXT_HTML, DEFAULT_ENCODING, true);
            String text = arguments[0].toString();
            renderView = this.renderText(text, response);
        } else if (arguments[0] instanceof Closure) {
            this.setContentType(response, TEXT_HTML, this.gspEncoding, true);
            Closure closure = (Closure)arguments[arguments.length - 1];
            renderView = this.renderMarkup(closure, response);
        } else {
            String text;
            Object statusObj;
            GSPResponseWriter out;
            if (!(arguments[0] instanceof Map)) throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
            Map argMap = (Map)arguments[0];
            if (argMap.containsKey(ARGUMENT_CONTENT_TYPE) && argMap.containsKey(ARGUMENT_ENCODING)) {
                String contentType = argMap.get(ARGUMENT_CONTENT_TYPE).toString();
                String encoding = argMap.get(ARGUMENT_ENCODING).toString();
                this.setContentType(response, contentType, encoding);
                out = GSPResponseWriter.getInstance((ServletResponse)response);
            } else if (argMap.containsKey(ARGUMENT_CONTENT_TYPE)) {
                this.setContentType(response, argMap.get(ARGUMENT_CONTENT_TYPE).toString(), DEFAULT_ENCODING);
                out = GSPResponseWriter.getInstance((ServletResponse)response);
            } else {
                this.setContentType(response, TEXT_HTML, DEFAULT_ENCODING, true);
                out = GSPResponseWriter.getInstance((ServletResponse)response);
            }
            if (argMap.containsKey(ARGUMENT_STATUS) && (statusObj = argMap.get(ARGUMENT_STATUS)) != null) {
                try {
                    response.setStatus(Integer.parseInt(statusObj.toString()));
                }
                catch (NumberFormatException e) {
                    throw new ControllerExecutionException("Argument [status] of method [render] must be a valid integer.");
                }
            }
            webRequest.setOut(out);
            if (arguments[arguments.length - 1] instanceof Closure) {
                Closure callable = (Closure)arguments[arguments.length - 1];
                renderView = BUILDER_TYPE_RICO.equals(argMap.get(ARGUMENT_BUILDER)) ? this.renderRico(callable, response) : (BUILDER_TYPE_JSON.equals(argMap.get(ARGUMENT_BUILDER)) || this.isJSONResponse(response) ? this.renderJSON(callable, response) : this.renderMarkup(callable, response));
            } else if (arguments[arguments.length - 1] instanceof String) {
                text = (String)arguments[arguments.length - 1];
                renderView = this.renderText(text, out);
            } else if (argMap.containsKey(ARGUMENT_TEXT)) {
                text = argMap.get(ARGUMENT_TEXT).toString();
                renderView = this.renderText(text, out);
            } else if (argMap.containsKey(ARGUMENT_VIEW)) {
                this.renderView(webRequest, argMap, target, controller);
            } else if (argMap.containsKey(ARGUMENT_TEMPLATE)) {
                renderView = this.renderTemplate(target, controller, webRequest, argMap, out);
            } else {
                Object object = arguments[0];
                renderView = this.renderObject(object, out);
            }
            try {
                if (!renderView) {
                    ((Writer)out).flush();
                }
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error executing render method for arguments [" + argMap + "]: " + e.getMessage(), e);
            }
        }
        webRequest.setRenderView(renderView);
        return null;
    }

    private boolean renderTemplate(Object target, GroovyObject controller, GrailsWebRequest webRequest, Map argMap, Writer out) {
        boolean renderView;
        String templateName = argMap.get(ARGUMENT_TEMPLATE).toString();
        String contextPath = this.getContextPath(webRequest, argMap);
        String var = (String)argMap.get(ARGUMENT_VAR);
        String templateUri = webRequest.getAttributes().getTemplateURI(controller, templateName);
        GroovyPagesTemplateEngine engine = webRequest.getAttributes().getPagesTemplateEngine();
        try {
            Template t = engine.createTemplateForUri(new String[]{contextPath + templateUri, contextPath + "/grails-app/views/" + templateUri});
            if (t == null) {
                throw new ControllerExecutionException("Unable to load template for uri [" + templateUri + "]. Template not found.");
            }
            HashMap binding = new HashMap();
            if (argMap.containsKey(ARGUMENT_BEAN)) {
                Object modelObject;
                Object bean = argMap.get(ARGUMENT_BEAN);
                if (argMap.containsKey(ARGUMENT_MODEL) && (modelObject = argMap.get(ARGUMENT_MODEL)) instanceof Map) {
                    binding.putAll((Map)modelObject);
                }
                this.renderTemplateForBean(t, binding, bean, var, out);
            } else if (argMap.containsKey(ARGUMENT_COLLECTION)) {
                Object modelObject;
                Object colObject = argMap.get(ARGUMENT_COLLECTION);
                if (argMap.containsKey(ARGUMENT_MODEL) && (modelObject = argMap.get(ARGUMENT_MODEL)) instanceof Map) {
                    binding.putAll((Map)modelObject);
                }
                this.renderTemplateForCollection(t, binding, colObject, var, out);
            } else if (argMap.containsKey(ARGUMENT_MODEL)) {
                Object modelObject = argMap.get(ARGUMENT_MODEL);
                this.renderTemplateForModel(t, modelObject, target, out);
            } else {
                Writable w = t.make((Map)new BeanMap(target));
                w.writeTo(out);
            }
            renderView = false;
        }
        catch (GroovyRuntimeException gre) {
            throw new ControllerExecutionException("Error rendering template [" + templateName + "]: " + gre.getMessage(), gre);
        }
        catch (IOException ioex) {
            throw new ControllerExecutionException("I/O error executing render method for arguments [" + argMap + "]: " + ioex.getMessage(), ioex);
        }
        return renderView;
    }

    private String getContextPath(GrailsWebRequest webRequest, Map argMap) {
        ApplicationContext applicationContext;
        GrailsPluginManager pluginManager;
        GrailsPlugin plugin;
        Object cp = argMap.get(ARGUMENT_CONTEXTPATH);
        String contextPath = cp != null ? cp.toString() : "";
        Object pluginName = argMap.get(this.ARGUMENT_PLUGIN);
        if (pluginName != null && (plugin = (pluginManager = (GrailsPluginManager)(applicationContext = webRequest.getApplicationContext()).getBean("pluginManager")).getGrailsPlugin(pluginName.toString())) != null && !plugin.isBasePlugin()) {
            contextPath = plugin.getPluginPath();
        }
        return contextPath;
    }

    private void setContentType(HttpServletResponse response, String contentType, String encoding) {
        this.setContentType(response, contentType, encoding, false);
    }

    private void setContentType(HttpServletResponse response, String contentType, String encoding, boolean contentTypeIsDefault) {
        if (response.getContentType() == null || !contentTypeIsDefault) {
            response.setContentType(GrailsWebUtil.getContentType(contentType, encoding));
        }
    }

    private boolean renderObject(Object object, Writer out) {
        boolean renderView;
        try {
            out.write(DefaultGroovyMethods.inspect((Object)object));
            renderView = false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error obtaining response writer: " + e.getMessage(), e);
        }
        return renderView;
    }

    private void renderTemplateForModel(Template template, Object modelObject, Object target, Writer out) throws IOException {
        if (modelObject instanceof Map) {
            Writable w = template.make((Map)modelObject);
            w.writeTo(out);
        } else {
            Writable w = template.make((Map)new BeanMap(target));
            w.writeTo(out);
        }
    }

    private void renderTemplateForCollection(Template template, Map binding, Object colObject, String var, Writer out) throws IOException {
        if (colObject instanceof Collection) {
            Collection c = (Collection)colObject;
            for (Object o : c) {
                if (StringUtils.isBlank((String)var)) {
                    binding.put(DEFAULT_ARGUMENT, o);
                } else {
                    binding.put(var, o);
                }
                Writable w = template.make(binding);
                w.writeTo(out);
            }
        } else {
            if (StringUtils.isBlank((String)var)) {
                binding.put(DEFAULT_ARGUMENT, colObject);
            } else {
                binding.put(var, colObject);
            }
            Writable w = template.make(binding);
            w.writeTo(out);
        }
    }

    private void renderTemplateForBean(Template template, Map binding, Object bean, String varName, Writer out) throws IOException {
        if (StringUtils.isBlank((String)varName)) {
            binding.put(DEFAULT_ARGUMENT, bean);
        } else {
            binding.put(varName, bean);
        }
        Writable w = template.make(binding);
        w.writeTo(out);
    }

    private void renderView(GrailsWebRequest webRequest, Map argMap, Object target, GroovyObject controller) {
        String viewName = argMap.get(ARGUMENT_VIEW).toString();
        Object modelObject = argMap.get(ARGUMENT_MODEL);
        String viewUri = webRequest.getAttributes().getNoSuffixViewURI((GroovyObject)target, viewName);
        BeanMap model = modelObject instanceof Map ? (BeanMap)modelObject : (target instanceof GroovyObject ? new BeanMap(target) : new HashMap());
        controller.setProperty("modelAndView", (Object)new ModelAndView(viewUri, (Map)model));
    }

    private boolean renderJSON(Closure callable, HttpServletResponse response) {
        boolean renderView = true;
        if (!this.useLegacyJSONBuilder) {
            JSONBuilder builder = new JSONBuilder();
            JSON json = builder.build(callable);
            json.render(response);
            renderView = false;
        } else {
            JSonBuilder jsonBuilder;
            try {
                jsonBuilder = new JSonBuilder(response);
                renderView = false;
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error executing render method for arguments [" + callable + "]: " + e.getMessage(), e);
            }
            jsonBuilder.invokeMethod(BUILDER_TYPE_JSON, new Object[]{callable});
        }
        return renderView;
    }

    private boolean renderRico(Closure callable, HttpServletResponse response) {
        boolean renderView;
        OpenRicoBuilder orb;
        try {
            orb = new OpenRicoBuilder(response);
            renderView = false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error executing render method for arguments [" + callable + "]: " + e.getMessage(), e);
        }
        orb.invokeMethod("ajax", new Object[]{callable});
        return renderView;
    }

    private boolean renderMarkup(Closure closure, HttpServletResponse response) {
        StreamingMarkupBuilder b = new StreamingMarkupBuilder();
        Writable markup = (Writable)b.bind((Object)closure);
        try {
            markup.writeTo((Writer)response.getWriter());
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error executing render method for arguments [" + closure + "]: " + e.getMessage(), e);
        }
        boolean renderView = false;
        return renderView;
    }

    private boolean renderText(String text, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            return this.renderText(text, writer);
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), e);
        }
    }

    private boolean renderText(String text, Writer writer) {
        try {
            writer.write(text);
            return false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), e);
        }
    }

    private boolean isJSONResponse(HttpServletResponse response) {
        String contentType = response.getContentType();
        return contentType != null && (contentType.indexOf("application/json") > -1 || contentType.indexOf("text/json") > -1);
    }
}

