/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.pages.GroovyPageOutputStack;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolver;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsPageFilter;
import org.codehaus.groovy.grails.web.taglib.GroovyPageTagBody;
import org.codehaus.groovy.grails.web.taglib.GroovyPageTagWriter;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.springframework.context.ApplicationContext;

public abstract class GroovyPage
extends Script {
    private static final Log LOG = LogFactory.getLog(GroovyPage.class);
    public static final String REQUEST = "request";
    public static final String SERVLET_CONTEXT = "application";
    public static final String RESPONSE = "response";
    public static final String OUT = "out";
    public static final String ATTRIBUTES = "attributes";
    public static final String APPLICATION_CONTEXT = "applicationContext";
    public static final String SESSION = "session";
    public static final String PARAMS = "params";
    public static final String FLASH = "flash";
    public static final String PLUGIN_CONTEXT_PATH = "pluginContextPath";
    public static final String EXTENSION = ".gsp";
    public static final String WEB_REQUEST = "webRequest";
    public static final String DEFAULT_NAMESPACE = "g";
    public static final String LINK_NAMESPACE = "link";
    public static final String TEMPLATE_NAMESPACE = "tmpl";
    public static final String PAGE_SCOPE = "pageScope";
    public static final String CONTROLLER_NAME = "controllerName";
    public static final String SUFFIX = ".gsp";
    public static final String ACTION_NAME = "actionName";
    public static final Collection<String> RESERVED_NAMES = new ArrayList<String>(){
        {
            this.add(GroovyPage.REQUEST);
            this.add(GroovyPage.SERVLET_CONTEXT);
            this.add(GroovyPage.RESPONSE);
            this.add(GroovyPage.OUT);
            this.add(GroovyPage.ATTRIBUTES);
            this.add(GroovyPage.APPLICATION_CONTEXT);
            this.add(GroovyPage.SESSION);
            this.add(GroovyPage.PARAMS);
            this.add(GroovyPage.FLASH);
            this.add(GroovyPage.PLUGIN_CONTEXT_PATH);
            this.add(GroovyPage.PAGE_SCOPE);
        }
    };
    private static final String BINDING = "binding";
    private static final String BLANK_STRING = "";
    private Map jspTags = Collections.EMPTY_MAP;
    private TagLibraryResolver jspTagLibraryResolver;
    private TagLibraryLookup gspTagLibraryLookup;
    private String[] htmlParts;
    private GrailsPrintWriter out;
    private GroovyPageOutputStack outputStack;
    private GrailsWebRequest webRequest;
    private String pluginContextPath;
    protected static final Closure EMPTY_BODY_CLOSURE = new ConstantClosure("");
    private static final String REQUEST_TAGLIB_CACHE = GroovyPage.class.getName() + ".TAGLIBCACHE";

    public GroovyPage() {
        this.init();
    }

    protected void init() {
    }

    public Writer getOut() {
        return this.out;
    }

    public void setOut(Writer newWriter) {
        throw new IllegalStateException("Setting out in page isn't allowed.");
    }

    public void initRun(Writer target, GrailsWebRequest webRequest) {
        ApplicationContext applicationContext;
        this.outputStack = GroovyPageOutputStack.currentStack(true, target, false, true);
        this.out = this.outputStack.getProxyWriter();
        this.webRequest = webRequest;
        Map map = this.getBinding().getVariables();
        if (map.containsKey(APPLICATION_CONTEXT) && (applicationContext = (ApplicationContext)map.get(APPLICATION_CONTEXT)) != null && applicationContext.containsBean("pluginManager")) {
            GrailsPluginManager pluginManager = (GrailsPluginManager)applicationContext.getBean("pluginManager", GrailsPluginManager.class);
            this.pluginContextPath = pluginManager.getPluginPathForInstance((Object)this);
        }
        if (webRequest != null) {
            this.webRequest.setOut(this.out);
        }
        this.getBinding().setVariable(OUT, (Object)this.out);
    }

    public String getPluginContextPath() {
        return this.pluginContextPath != null ? this.pluginContextPath : BLANK_STRING;
    }

    public void cleanup() {
        this.outputStack.pop(true);
    }

    protected Closure createClosureForHtmlPart(int partNumber) {
        String htmlPart = this.htmlParts[partNumber];
        return new ConstantClosure(htmlPart);
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setGspTagLibraryLookup(TagLibraryLookup gspTagLibraryLookup) {
        this.gspTagLibraryLookup = gspTagLibraryLookup;
    }

    TagLibraryResolver getTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public Object evaluate(String exprText, int lineNumber, Object outerIt, Closure evaluator) {
        try {
            return evaluator.call(outerIt);
        }
        catch (Exception e) {
            throw new GroovyPagesException("Error evaluating expression [" + exprText + "] on line [" + lineNumber + "]: " + e.getMessage(), e, lineNumber, this.getGroovyPageFileName());
        }
    }

    public abstract String getGroovyPageFileName();

    public Object getProperty(String property) {
        MetaProperty mp;
        if (OUT.equals(property)) {
            return this.out;
        }
        if (BINDING.equals(property)) {
            return this.getBinding();
        }
        Object value = this.getBinding().getVariables().get(property);
        if (value != null) {
            return value;
        }
        if (value == null && (mp = this.getMetaClass().getMetaProperty(property)) != null) {
            return mp.getProperty((Object)this);
        }
        if (value == null) {
            Object object = value = this.gspTagLibraryLookup != null ? this.gspTagLibraryLookup.lookupNamespaceDispatcher(property) : null;
            if (value == null && this.jspTags.containsKey(property)) {
                TagLibraryResolver tagResolver = this.getTagLibraryResolver();
                String uri = (String)this.jspTags.get(property);
                if (uri != null) {
                    value = tagResolver.resolveTagLibrary(uri);
                }
            }
            if (value != null) {
                this.getBinding().setVariable(property, value);
            }
        }
        return value;
    }

    public void invokeTag(String tagName, Map attrs, Closure body) {
        this.invokeTag(tagName, DEFAULT_NAMESPACE, attrs, body);
    }

    public void invokeTag(String tagName, String tagNamespace, Map attrs, Closure body) {
        this.invokeTag(tagName, tagNamespace, -1, attrs, body);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invokeTag(String tagName, String tagNamespace, int lineNumber, Map attrs, Closure body) {
        Map tmpAttrs;
        String tmpTagName;
        if (tagNamespace.equals(TEMPLATE_NAMESPACE)) {
            tmpTagName = tagName;
            tmpAttrs = attrs;
            tagName = "render";
            tagNamespace = DEFAULT_NAMESPACE;
            attrs = new HashMap(){
                {
                    this.put("model", tmpAttrs);
                    this.put("template", tmpTagName);
                }
            };
        } else if (tagNamespace.equals(LINK_NAMESPACE)) {
            tmpTagName = tagName;
            tmpAttrs = attrs;
            tagName = LINK_NAMESPACE;
            tagNamespace = DEFAULT_NAMESPACE;
            attrs = new HashMap(){
                {
                    if (tmpAttrs.size() > 0) {
                        this.put(GroovyPage.PARAMS, tmpAttrs);
                    }
                    this.put("mapping", tmpTagName);
                }
            };
        }
        try {
            GroovyObject tagLib = this.getTagLib(tagNamespace, tagName);
            if (tagLib != null || this.gspTagLibraryLookup.hasNamespace(tagNamespace)) {
                if (tagLib == null) throw new GrailsTagException("Tag [" + tagName + "] does not exist. No tag library found for namespace: " + tagNamespace, this.getGroovyPageFileName(), lineNumber);
                boolean returnsObject = this.gspTagLibraryLookup.doesTagReturnObject(tagNamespace, tagName);
                Object tagLibProp = tagLib.getProperty(tagName);
                if (!(tagLibProp instanceof Closure)) throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]", this.getGroovyPageFileName(), lineNumber);
                Closure tag = (Closure)((Closure)tagLibProp).clone();
                Object tagresult = null;
                boolean preferSubChunkWhenWritingToOtherBuffer = GroovyPage.resolvePreferSubChunk(tagNamespace, tagName);
                if (body instanceof GroovyPageTagBody && preferSubChunkWhenWritingToOtherBuffer) {
                    ((GroovyPageTagBody)body).setPreferSubChunkWhenWritingToOtherBuffer(true);
                }
                switch (tag.getParameterTypes().length) {
                    case 1: {
                        tagresult = tag.call(new Object[]{attrs});
                        if (returnsObject && tagresult != null && !(tagresult instanceof Writer)) {
                            this.out.print(tagresult);
                        }
                        if (body == null || body == EMPTY_BODY_CLOSURE) return;
                        body.call();
                        return;
                    }
                    case 2: {
                        if (tag.getParameterTypes().length != 2) return;
                        tagresult = tag.call(new Object[]{attrs, body != null ? body : EMPTY_BODY_CLOSURE});
                        if (!returnsObject || tagresult == null || tagresult instanceof Writer) return;
                        this.out.print(tagresult);
                    }
                }
                return;
            } else {
                Object bodyOutput;
                this.out.append('<').append(tagNamespace).append(':').append(tagName);
                Iterator i$ = attrs.entrySet().iterator();
                while (i$.hasNext()) {
                    boolean containsSingleQuote;
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    this.out.append(' ');
                    this.out.append(entry.getKey()).append('=');
                    String value = String.valueOf(entry.getValue());
                    boolean containsQuotes = value.indexOf(34) > -1;
                    boolean bl = containsSingleQuote = value.indexOf(39) > -1;
                    if (containsQuotes && !containsSingleQuote) {
                        this.out.append('\'').append(value).append('\'');
                        continue;
                    }
                    if (containsQuotes & containsSingleQuote) {
                        this.out.append('\"').append(value.replaceAll("\"", "&quot;")).append('\"');
                        continue;
                    }
                    this.out.append('\"').append(value).append('\"');
                }
                this.out.append('>');
                if (body != null && (bodyOutput = body.call()) != null) {
                    this.out.print(bodyOutput);
                }
                this.out.append("</").append(tagNamespace).append(':').append(tagName).append('>');
            }
            return;
        }
        catch (Throwable e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Full exception for problem at " + this.getGroovyPageFileName() + ":" + lineNumber), e);
            }
            if (tagName.matches("capture(Body|Head|Meta|Title|Component)")) {
                RuntimeException rte = GrailsExceptionResolver.getFirstRuntimeException(e);
                if (rte != null) throw rte;
                this.throwRootCause(tagName, tagNamespace, lineNumber, e);
                return;
            }
            this.throwRootCause(tagName, tagNamespace, lineNumber, e);
        }
    }

    private void throwRootCause(String tagName, String tagNamespace, int lineNumber, Throwable e) {
        Throwable cause = GrailsExceptionResolver.getRootCause(e);
        if (cause instanceof GrailsTagException) {
            throw new GrailsTagException(cause.getMessage(), this.getGroovyPageFileName(), lineNumber);
        }
        throw new GrailsTagException("Error executing tag <" + tagNamespace + ":" + tagName + ">: " + e.getMessage(), e, this.getGroovyPageFileName(), lineNumber);
    }

    private static boolean resolvePreferSubChunk(String tagNamespace, String tagName) {
        boolean preferSubChunkWhenWritingToOtherBuffer = false;
        if (DEFAULT_NAMESPACE.equals(tagNamespace) && tagName.startsWith("capture")) {
            preferSubChunkWhenWritingToOtherBuffer = true;
        }
        return preferSubChunkWhenWritingToOtherBuffer;
    }

    private GroovyObject getTagLibForDefaultNamespace(String tagName) {
        return this.getTagLib(DEFAULT_NAMESPACE, tagName);
    }

    private GroovyObject getTagLib(String namespace, String tagName) {
        return GroovyPage.lookupCachedTagLib(this.webRequest, this.gspTagLibraryLookup, namespace, tagName);
    }

    public Object invokeMethod(String methodName, Object args) {
        if (methodName.equals("invokeTag")) {
            return super.invokeMethod(methodName, args);
        }
        Map attrs = null;
        Object body = null;
        GroovyObject tagLib = this.getTagLibForDefaultNamespace(methodName);
        if (tagLib != null) {
            if (args instanceof Object[]) {
                Object[] argArray = (Object[])args;
                if (argArray.length > 0 && argArray[0] instanceof Map) {
                    attrs = (Map)argArray[0];
                }
                if (argArray.length > 1) {
                    body = argArray[1];
                }
            } else if (args instanceof Map) {
                attrs = (HashMap)args;
            }
            if (attrs == null) {
                attrs = new HashMap();
            }
            return GroovyPage.captureTagOutput(this.gspTagLibraryLookup, DEFAULT_NAMESPACE, methodName, attrs, body, this.webRequest);
        }
        return super.invokeMethod(methodName, args);
    }

    public static Object captureTagOutput(TagLibraryLookup gspTagLibraryLookup, String namespace, String tagName, Map attrs, Object body, GrailsWebRequest webRequest) {
        GroovyObject tagLib = GroovyPage.lookupCachedTagLib(webRequest, gspTagLibraryLookup, namespace, tagName);
        boolean preferSubChunkWhenWritingToOtherBuffer = GroovyPage.resolvePreferSubChunk(namespace, tagName);
        Closure actualBody = GroovyPage.createOutputCapturingClosure(tagLib, body, webRequest, preferSubChunkWhenWritingToOtherBuffer);
        GroovyPageTagWriter out = new GroovyPageTagWriter(preferSubChunkWhenWritingToOtherBuffer);
        try {
            GroovyPageOutputStack.currentStack().push(out);
            Object tagLibProp = tagLib.getProperty(tagName);
            if (tagLibProp instanceof Closure) {
                boolean returnsObject;
                Closure tag = (Closure)((Closure)tagLibProp).clone();
                Object bodyResult = null;
                if (tag.getParameterTypes().length == 1) {
                    Object bodyResult2;
                    bodyResult = tag.call(new Object[]{attrs});
                    if (actualBody != null && actualBody != EMPTY_BODY_CLOSURE && (bodyResult2 = actualBody.call()) != null) {
                        out.print(bodyResult2);
                    }
                } else if (tag.getParameterTypes().length == 2) {
                    bodyResult = tag.call(new Object[]{attrs, actualBody});
                } else {
                    throw new GrailsTagException("Tag [" + tagName + "] does not specify expected number of params in tag library [" + tagLib.getClass().getName() + "]");
                }
                if ((returnsObject = gspTagLibraryLookup.doesTagReturnObject(namespace, tagName)) && bodyResult != null && !(bodyResult instanceof Writer)) {
                    Object object = bodyResult;
                    return object;
                }
                StreamCharBuffer streamCharBuffer = out.getBuffer();
                return streamCharBuffer;
            }
            throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]");
        }
        finally {
            GroovyPageOutputStack.currentStack().pop();
        }
    }

    private static GroovyObject lookupCachedTagLib(GrailsWebRequest webRequest, TagLibraryLookup gspTagLibraryLookup, String namespace, String tagName) {
        if (webRequest != null) {
            String tagKey = namespace + ":" + tagName;
            HashMap<String, GroovyObject> tagLibCache = (HashMap<String, GroovyObject>)webRequest.getCurrentRequest().getAttribute(REQUEST_TAGLIB_CACHE);
            GroovyObject tagLib = null;
            if (tagLibCache == null) {
                tagLibCache = new HashMap<String, GroovyObject>();
                webRequest.getCurrentRequest().setAttribute(REQUEST_TAGLIB_CACHE, tagLibCache);
            } else {
                tagLib = (GroovyObject)tagLibCache.get(tagKey);
            }
            if (tagLib == null && (tagLib = gspTagLibraryLookup.lookupTagLibrary(namespace, tagName)) != null) {
                tagLibCache.put(tagKey, tagLib);
            }
            return tagLib;
        }
        return gspTagLibraryLookup != null ? gspTagLibraryLookup.lookupTagLibrary(namespace, tagName) : null;
    }

    public static Closure createOutputCapturingClosure(Object wrappedInstance, Object body1, GrailsWebRequest webRequest, boolean preferSubChunkWhenWritingToOtherBuffer) {
        if (body1 == null) {
            return EMPTY_BODY_CLOSURE;
        }
        if (body1 instanceof GroovyPageTagBody) {
            GroovyPageTagBody gptb = (GroovyPageTagBody)((Object)body1);
            gptb.setPreferSubChunkWhenWritingToOtherBuffer(preferSubChunkWhenWritingToOtherBuffer);
            return gptb;
        }
        if (body1 instanceof ConstantClosure) {
            return (Closure)body1;
        }
        if (body1 instanceof Closure) {
            return new GroovyPageTagBody(wrappedInstance, webRequest, (Closure)body1, preferSubChunkWhenWritingToOtherBuffer);
        }
        return new ConstantClosure(body1);
    }

    public static boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    public final void printHtmlPart(int partNumber) {
        this.out.write(this.htmlParts[partNumber]);
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags;
    }

    public String[] getHtmlParts() {
        return this.htmlParts;
    }

    public void setHtmlParts(String[] htmlParts) {
        this.htmlParts = htmlParts;
    }

    public GroovyPageOutputStack getOutputStack() {
        return this.outputStack;
    }

    public void registerSitemeshPreprocessMode(HttpServletRequest request) {
        GSPSitemeshPage page = (GSPSitemeshPage)((Object)request.getAttribute(GrailsPageFilter.GSP_SITEMESH_PAGE));
        if (page != null) {
            page.setUsed(true);
        }
    }

    public static final class ConstantClosure
    extends Closure {
        private static final long serialVersionUID = 1L;
        final Object retval;

        public ConstantClosure(Object retval) {
            super(null);
            this.retval = retval;
        }

        public Object doCall(Object obj) {
            return this.retval;
        }

        public Object doCall() {
            return this.retval;
        }

        public Object doCall(Object[] args) {
            return this.retval;
        }

        public Object call(Object[] args) {
            return this.retval;
        }
    }
}

