/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.marshaller.ClosureOjectMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverterConfiguration<C extends Converter>
implements ConverterConfiguration<C> {
    public static final int DEFAULT_PRIORITY = 0;
    private static final AtomicInteger MARSHALLER_SEQUENCE = new AtomicInteger(0);
    private ConverterConfiguration<C> delegate;
    private String encoding;
    private boolean prettyPrint = false;
    private final SortedSet<Entry> objectMarshallers = new TreeSet<Entry>();
    private Converter.CircularReferenceBehaviour circularReferenceBehaviour;

    @Override
    public String getEncoding() {
        return this.encoding != null ? this.encoding : (this.delegate != null ? this.delegate.getEncoding() : null);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Converter.CircularReferenceBehaviour getCircularReferenceBehaviour() {
        return this.circularReferenceBehaviour != null ? this.circularReferenceBehaviour : (this.delegate != null ? this.delegate.getCircularReferenceBehaviour() : null);
    }

    @Override
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public List<ObjectMarshaller<C>> getOrderedObjectMarshallers() {
        ArrayList<ObjectMarshaller<C>> list = new ArrayList<ObjectMarshaller<C>>();
        for (Entry entry : this.objectMarshallers) {
            list.add(entry.marshaller);
        }
        if (this.delegate != null) {
            for (ObjectMarshaller objectMarshaller : this.delegate.getOrderedObjectMarshallers()) {
                list.add(objectMarshaller);
            }
        }
        return list;
    }

    public void setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour circularReferenceBehaviour) {
        this.circularReferenceBehaviour = circularReferenceBehaviour;
    }

    public DefaultConverterConfiguration() {
    }

    public DefaultConverterConfiguration(ConverterConfiguration<C> delegate) {
        this.delegate = delegate;
        this.prettyPrint = delegate.isPrettyPrint();
        this.circularReferenceBehaviour = delegate.getCircularReferenceBehaviour();
        this.encoding = delegate.getEncoding();
    }

    public DefaultConverterConfiguration(List<ObjectMarshaller<C>> oms) {
        int initPriority = -1;
        for (ObjectMarshaller<C> om : oms) {
            this.registerObjectMarshaller(om, initPriority--);
        }
    }

    public void registerObjectMarshaller(ObjectMarshaller<C> marshaller) {
        this.registerObjectMarshaller(marshaller, 0);
    }

    public void registerObjectMarshaller(ObjectMarshaller<C> marshaller, int priority) {
        this.objectMarshallers.add(new Entry(marshaller, priority));
    }

    public void registerObjectMarshaller(Class c, int priority, Closure callable) {
        this.registerObjectMarshaller(new ClosureOjectMarshaller(c, callable), priority);
    }

    public void registerObjectMarshaller(Class c, Closure callable) {
        this.registerObjectMarshaller(new ClosureOjectMarshaller(c, callable));
    }

    @Override
    public ObjectMarshaller<C> getMarshaller(Object o) {
        for (Entry entry : this.objectMarshallers) {
            if (!entry.marshaller.supports(o)) continue;
            return entry.marshaller;
        }
        return this.delegate != null ? this.delegate.getMarshaller(o) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry
    implements Comparable<Entry> {
        protected final ObjectMarshaller<C> marshaller;
        private final int priority;
        private final int seq;

        private Entry(ObjectMarshaller<C> marshaller, int priority) {
            this.marshaller = marshaller;
            this.priority = priority;
            this.seq = MARSHALLER_SEQUENCE.incrementAndGet();
        }

        @Override
        public int compareTo(Entry entry) {
            return this.priority == entry.priority ? entry.seq - this.seq : entry.priority - this.priority;
        }
    }
}

