/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.request.RequestContextHolder;

public class GrailsFlashScope
implements FlashScope {
    private HashMap current = new HashMap();
    private HashMap next = new HashMap();
    public static final String ERRORS_PREFIX = "org.codehaus.groovy.grails.ERRORS_";
    private static final String ERRORS_PROPERTY = "errors";

    public void next() {
        this.current.clear();
        this.current = (HashMap)this.next.clone();
        this.next.clear();
        this.reassociateObjectsWithErrors(this.current);
    }

    private void reassociateObjectsWithErrors(Map scope) {
        for (Object key : scope.keySet()) {
            Object value = scope.get(key);
            if (value instanceof Map) {
                this.reassociateObjectsWithErrors((Map)value);
            }
            this.reassociateObjectWithErrors(scope, value);
        }
    }

    private void reassociateObjectWithErrors(Map scope, Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object current : values) {
                this.reassociateObjectWithErrors(scope, current);
            }
        } else {
            MetaClass mc;
            String errorsKey = ERRORS_PREFIX + System.identityHashCode(value);
            Object errors = scope.get(errorsKey);
            if (value != null && errors != null && (mc = GroovySystem.getMetaClassRegistry().getMetaClass(value.getClass())).hasProperty(value, ERRORS_PROPERTY) != null) {
                mc.setProperty(value, ERRORS_PROPERTY, errors);
            }
        }
    }

    public int size() {
        return this.current.size() + this.next.size();
    }

    public void clear() {
        this.current.clear();
        this.next.clear();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.current.containsKey(key) || this.next.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.current.containsValue(value) || this.next.containsValue(value);
    }

    public Collection values() {
        ArrayList c = new ArrayList();
        c.addAll(this.current.values());
        c.addAll(this.next.values());
        return c;
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        HashSet keySet = new HashSet();
        keySet.addAll(this.current.entrySet());
        keySet.addAll(this.next.entrySet());
        return keySet;
    }

    public Set keySet() {
        HashSet keySet = new HashSet();
        keySet.addAll(this.current.keySet());
        keySet.addAll(this.next.keySet());
        return keySet;
    }

    public Object get(Object key) {
        if (this.next.containsKey(key)) {
            return this.next.get(key);
        }
        return this.current.get(key);
    }

    public Object remove(Object key) {
        if (this.current.containsKey(key)) {
            return this.current.remove(key);
        }
        return this.next.remove(key);
    }

    public Object put(Object key, Object value) {
        this.registerWithSessionIfNecessary();
        if (this.current.containsKey(key)) {
            this.current.remove(key);
        }
        this.storeErrorsIfPossible(this.next, value);
        return this.next.put(key, value);
    }

    private void storeErrorsIfPossible(Map scope, Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                for (Object current : values) {
                    this.storeErrorsIfPossible(scope, current);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                LinkedList keys = new LinkedList(map.keySet());
                for (Object key : keys) {
                    Object val = map.get(key);
                    this.storeErrorsIfPossible(map, val);
                }
            } else {
                Object errors;
                MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(value.getClass());
                if (mc.hasProperty(value, ERRORS_PROPERTY) != null && (errors = mc.getProperty(value, ERRORS_PROPERTY)) != null) {
                    scope.put(ERRORS_PREFIX + System.identityHashCode(value), errors);
                }
            }
        }
    }

    private void registerWithSessionIfNecessary() {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        HttpSession session = webRequest.getCurrentRequest().getSession(true);
        if (session.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE") == null) {
            session.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)this);
        }
    }
}

