/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SitemeshPreprocessor {
    Pattern metaPattern = Pattern.compile("<meta(\\s[^>]+)>", 34);
    Pattern titlePattern = Pattern.compile("<title(\\s[^>]*)?>(.*?)</title>", 34);
    Pattern headPattern = Pattern.compile("<head(\\s[^>]*)?>(.*?)</head>", 34);
    Pattern bodyPattern = Pattern.compile("<body(\\s[^>]*)?>(.*?)</body>", 34);
    Pattern contentPattern = Pattern.compile("<content(\\s+tag[^>]+)>(.*?)</content>", 34);

    public String addGspSitemeshCapturing(String gspSource) {
        StringBuffer sb = this.addHeadCapturing(gspSource);
        sb = this.addBodyCapturing(sb);
        sb = this.addContentCapturing(sb);
        return sb.toString();
    }

    StringBuffer addHeadCapturing(String gspSource) {
        StringBuffer sb = new StringBuffer((int)((double)gspSource.length() * 1.2));
        Matcher m = this.headPattern.matcher(gspSource);
        if (m.find()) {
            m.appendReplacement(sb, "");
            sb.append("<g:captureHead");
            if (m.group(1) != null) {
                sb.append(m.group(1));
            }
            sb.append(">");
            sb.append(this.addMetaCapturing(this.addTitleCapturing(m.group(2))));
            sb.append("</g:captureHead>");
        }
        m.appendTail(sb);
        return sb;
    }

    String addMetaCapturing(String headContent) {
        StringBuffer sb = new StringBuffer((int)((double)headContent.length() * 1.2));
        Matcher m = this.metaPattern.matcher(headContent);
        while (m.find()) {
            m.appendReplacement(sb, "");
            sb.append("<g:captureMeta");
            String tagContent = m.group(1);
            sb.append(tagContent);
            if (!tagContent.endsWith("/")) {
                sb.append("/");
            }
            sb.append(">");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    String addTitleCapturing(String headContent) {
        StringBuffer sb = new StringBuffer((int)((double)headContent.length() * 1.2));
        Matcher m = this.titlePattern.matcher(headContent);
        if (m.find()) {
            m.appendReplacement(sb, "");
            sb.append("<g:captureTitle");
            if (m.group(1) != null) {
                sb.append(m.group(1));
            }
            sb.append(">");
            sb.append(m.group(2));
            sb.append("</g:captureTitle>");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    StringBuffer addBodyCapturing(StringBuffer sb) {
        StringBuffer sb2 = new StringBuffer((int)((double)sb.length() * 1.2));
        Matcher m = this.bodyPattern.matcher(sb);
        if (m.find()) {
            m.appendReplacement(sb2, "");
            sb2.append("<g:captureBody");
            if (m.group(1) != null) {
                sb2.append(m.group(1));
            }
            sb2.append(">");
            sb2.append(m.group(2));
            sb2.append("</g:captureBody>");
        }
        m.appendTail(sb2);
        return sb2;
    }

    StringBuffer addContentCapturing(StringBuffer sb) {
        StringBuffer sb2 = new StringBuffer((int)((double)sb.length() * 1.2));
        Matcher m = this.contentPattern.matcher(sb);
        while (m.find()) {
            m.appendReplacement(sb2, "");
            sb2.append("<g:captureContent").append(m.group(1)).append(">");
            sb2.append(m.group(2));
            sb2.append("</g:captureContent>");
        }
        m.appendTail(sb2);
        return sb2;
    }
}

