/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.module.sitemesh.filter.HttpContentType;
import com.opensymphony.module.sitemesh.filter.RoutableServletOutputStream;
import com.opensymphony.module.sitemesh.filter.TextEncoder;
import com.opensymphony.module.sitemesh.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GrailsRoutablePrintWriter;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.codehaus.groovy.grails.web.util.WebUtils;

public class GrailsPageResponseWrapper
extends HttpServletResponseWrapper {
    private final GrailsRoutablePrintWriter routablePrintWriter;
    private final RoutableServletOutputStream routableServletOutputStream;
    private final PageParserSelector parserSelector;
    private GrailsBuffer buffer;
    private boolean aborted = false;
    private boolean parseablePage = false;

    public GrailsPageResponseWrapper(final HttpServletResponse response, PageParserSelector parserSelector) {
        super(response);
        this.parserSelector = parserSelector;
        this.routablePrintWriter = new GrailsRoutablePrintWriter(new GrailsRoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() throws IOException {
                return response.getWriter();
            }
        });
        this.routableServletOutputStream = new RoutableServletOutputStream(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() throws IOException {
                return response.getOutputStream();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int sc) throws IOException {
        this.aborted = true;
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        try {
            super.sendError(sc);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            WebUtils.storeGrailsWebRequest(webRequest);
            throw throwable;
        }
        WebUtils.storeGrailsWebRequest(webRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int sc, String msg) throws IOException {
        this.aborted = true;
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        try {
            super.sendError(sc, msg);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            WebUtils.storeGrailsWebRequest(webRequest);
            throw throwable;
        }
        WebUtils.storeGrailsWebRequest(webRequest);
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (type != null) {
            HttpContentType httpContentType = new HttpContentType(type);
            if (this.parserSelector.shouldParsePage(httpContentType.getType())) {
                this.activateSiteMesh(httpContentType.getType(), httpContentType.getEncoding());
            } else {
                this.deactivateSiteMesh();
            }
        }
    }

    public void activateSiteMesh(String contentType, String encoding) {
        if (this.parseablePage) {
            return;
        }
        this.buffer = new GrailsBuffer(this.parserSelector.getPageParser(contentType), encoding);
        this.routablePrintWriter.updateDestination(new GrailsRoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() {
                return GrailsPageResponseWrapper.this.buffer.getWriter();
            }
        });
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() {
                return GrailsPageResponseWrapper.this.buffer.getOutputStream();
            }
        });
        this.parseablePage = true;
    }

    private void deactivateSiteMesh() {
        this.parseablePage = false;
        this.buffer = null;
        this.routablePrintWriter.updateDestination(new GrailsRoutablePrintWriter.DestinationFactory(){

            public PrintWriter activateDestination() throws IOException {
                return GrailsPageResponseWrapper.this.getResponse().getWriter();
            }
        });
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            public ServletOutputStream create() throws IOException {
                return GrailsPageResponseWrapper.this.getResponse().getOutputStream();
            }
        });
    }

    public void setContentLength(int contentLength) {
        if (!this.parseablePage) {
            super.setContentLength(contentLength);
        }
    }

    public void flushBuffer() throws IOException {
        if (!this.parseablePage) {
            super.flushBuffer();
        }
    }

    public void setHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.parseablePage || !name.toLowerCase().equals("content-length")) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (!this.parseablePage || !name.toLowerCase().equals("content-length")) {
            super.addHeader(name, value);
        }
    }

    public void setStatus(int sc) {
        if (sc == 304) {
            this.aborted = true;
            this.deactivateSiteMesh();
        }
        super.setStatus(sc);
    }

    public ServletOutputStream getOutputStream() {
        return this.routableServletOutputStream;
    }

    public PrintWriter getWriter() {
        return this.routablePrintWriter;
    }

    public Page getPage() throws IOException {
        if (this.isSitemeshNotActive()) {
            return null;
        }
        return this.buffer.parse();
    }

    public void sendRedirect(String location) throws IOException {
        this.aborted = true;
        super.sendRedirect(location);
    }

    public boolean isUsingStream() {
        return this.buffer != null && this.buffer.isUsingStream();
    }

    public char[] getContents() throws IOException {
        if (this.isSitemeshNotActive()) {
            return null;
        }
        return this.buffer.getContents();
    }

    public boolean isSitemeshActive() {
        return !this.isSitemeshNotActive();
    }

    private boolean isSitemeshNotActive() {
        return this.aborted || !this.parseablePage;
    }

    private static class GrailsBuffer {
        private final PageParser pageParser;
        private final String encoding;
        private static final TextEncoder TEXT_ENCODER = new TextEncoder();
        private StreamCharBuffer streamBuffer = new StreamCharBuffer(512, 100);
        private Writer bufferedWriter = null;
        private FastByteArrayOutputStream bufferedStream;
        private GrailsPrintWriter exposedWriter;
        private ServletOutputStream exposedStream;

        public GrailsBuffer(PageParser pageParser, String encoding) {
            this.pageParser = pageParser;
            this.encoding = encoding;
        }

        public char[] getContents() throws IOException {
            if (this.bufferedWriter != null) {
                return this.streamBuffer.toCharArray();
            }
            if (this.bufferedStream != null) {
                return TEXT_ENCODER.encode(this.bufferedStream.toByteArray(), this.encoding);
            }
            return new char[0];
        }

        public Page parse() throws IOException {
            return this.pageParser.parse(this.getContents());
        }

        public PrintWriter getWriter() {
            if (this.bufferedWriter == null) {
                if (this.bufferedStream != null) {
                    throw new IllegalStateException("response.getWriter() called after response.getOutputStream()");
                }
                this.bufferedWriter = this.streamBuffer.getWriter();
                this.exposedWriter = new GrailsPrintWriter(this.bufferedWriter);
                this.exposedWriter.setFinalTargetHere(true);
            }
            return this.exposedWriter;
        }

        public ServletOutputStream getOutputStream() {
            if (this.bufferedStream == null) {
                if (this.bufferedWriter != null) {
                    throw new IllegalStateException("response.getOutputStream() called after response.getWriter()");
                }
                this.bufferedStream = new FastByteArrayOutputStream();
                this.exposedStream = new ServletOutputStream(){

                    public void write(int b) {
                        GrailsBuffer.this.bufferedStream.write(b);
                    }
                };
            }
            return this.exposedStream;
        }

        public boolean isUsingStream() {
            return this.bufferedStream != null;
        }
    }
}

