/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import groovy.lang.GString;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class GrailsParameterMap
implements Map {
    private Map parameterMap;
    private HttpServletRequest request;

    public GrailsParameterMap(HttpServletRequest request) {
        this.request = request;
        this.parameterMap = new HashMap();
        LinkedHashMap requestMap = new LinkedHashMap(request.getParameterMap());
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            for (Object fileName : fileMap.keySet()) {
                requestMap.put(fileName, multipartRequest.getFile((String)fileName));
            }
        }
        for (Object o : requestMap.keySet()) {
            String key = (String)o;
            Object paramValue = this.getParameterValue(requestMap, key);
            this.parameterMap.put(key, paramValue);
            this.processNestedKeys(request, requestMap, key, key, this.parameterMap);
        }
    }

    private Object getParameterValue(Map requestMap, String key) {
        String[] multiParams;
        Object paramValue = requestMap.get(key);
        if (paramValue instanceof String[] && (multiParams = (String[])paramValue).length == 1) {
            paramValue = multiParams[0];
        }
        return paramValue;
    }

    private void processNestedKeys(HttpServletRequest request, Map requestMap, String key, String nestedKey, Map nestedLevel) {
        int nestedIndex = nestedKey.indexOf(46);
        if (nestedIndex > -1) {
            String nestedPrefix = nestedKey.substring(0, nestedIndex);
            Object prefixValue = nestedLevel.get(nestedPrefix);
            if (prefixValue == null) {
                prefixValue = new GrailsParameterMap(new HashMap(), request);
                nestedLevel.put(nestedPrefix, prefixValue);
            }
            if (prefixValue instanceof Map) {
                Map nestedMap = (Map)prefixValue;
                if (nestedIndex < nestedKey.length() - 1) {
                    String remainderOfKey = nestedKey.substring(nestedIndex + 1, nestedKey.length());
                    nestedMap.put(remainderOfKey, this.getParameterValue(requestMap, key));
                    if (remainderOfKey.indexOf(46) > -1) {
                        this.processNestedKeys(request, requestMap, key, remainderOfKey, nestedMap);
                    }
                }
            }
        }
    }

    public GrailsParameterMap(Map values, HttpServletRequest request) {
        this.request = request;
        this.parameterMap = values;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public int size() {
        return this.parameterMap.size();
    }

    public boolean isEmpty() {
        return this.parameterMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.parameterMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.parameterMap.containsValue(value);
    }

    public Object get(Object key) {
        if (this.parameterMap.get(key) instanceof String[]) {
            String[] valueArray = (String[])this.parameterMap.get(key);
            if (valueArray == null) {
                return null;
            }
            if (valueArray.length == 1) {
                return valueArray[0];
            }
        }
        return this.parameterMap.get(key);
    }

    public Object put(Object key, Object value) {
        if (value instanceof GString) {
            value = value.toString();
        }
        return this.parameterMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.parameterMap.remove(key);
    }

    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public void clear() {
        this.parameterMap.clear();
    }

    public Set keySet() {
        return this.parameterMap.keySet();
    }

    public Collection values() {
        return this.parameterMap.values();
    }

    public Set entrySet() {
        return this.parameterMap.entrySet();
    }

    public String toQueryString() {
        String encoding = this.request.getCharacterEncoding();
        try {
            return WebUtils.toQueryString(this, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ControllerExecutionException("Unable to convert parameter map [" + this + "] to a query string: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return DefaultGroovyMethods.inspect((Object)this.parameterMap);
    }
}

