/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import groovy.lang.GroovyObject;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.plugins.PluginMetaManager;
import org.codehaus.groovy.grails.web.pages.GroovyPageUtils;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.GrailsFlashScope;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Errors;
import org.springframework.web.util.UrlPathHelper;

public class DefaultGrailsApplicationAttributes
implements GrailsApplicationAttributes {
    private static Log LOG = LogFactory.getLog(DefaultGrailsApplicationAttributes.class);
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private ServletContext context;

    public DefaultGrailsApplicationAttributes(ServletContext context) {
        this.context = context;
    }

    public ApplicationContext getApplicationContext() {
        return (ApplicationContext)this.context.getAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT");
    }

    public String getPluginContextPath(HttpServletRequest request) {
        GroovyObject controller = this.getController((ServletRequest)request);
        GrailsApplication application = this.getGrailsApplication();
        if (controller != null && application != null) {
            Class<?> controllerClass = controller.getClass();
            PluginMetaManager metaManager = (PluginMetaManager)this.getApplicationContext().getBean("pluginMetaManager");
            String path = metaManager.getPluginPathForResource(controllerClass.getName());
            return path == null ? "" : path;
        }
        return "";
    }

    public GroovyObject getController(ServletRequest request) {
        return (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
    }

    public String getControllerUri(ServletRequest request) {
        return "/" + this.getControllerName(request);
    }

    private String getControllerName(ServletRequest request) {
        GroovyObject controller = this.getController(request);
        String controllerName = controller != null ? (String)controller.getProperty("controllerName") : (String)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE");
        return controllerName != null ? controllerName : "";
    }

    public String getApplicationUri(ServletRequest request) {
        return this.urlHelper.getContextPath((HttpServletRequest)request);
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public FlashScope getFlashScope(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            HttpSession session = servletRequest.getSession(false);
            FlashScope fs = session != null ? (FlashScope)session.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE") : (FlashScope)request.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE");
            if (fs == null) {
                fs = new GrailsFlashScope();
                if (session != null) {
                    session.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)fs);
                } else {
                    request.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)fs);
                }
            }
            return fs;
        }
        return null;
    }

    public String getTemplateUri(String templateName, ServletRequest request) {
        return GroovyPageUtils.getTemplateURI(this.getControllerName(request), templateName);
    }

    public String getControllerActionUri(ServletRequest request) {
        GroovyObject controller = this.getController(request);
        return (String)controller.getProperty("actionUri");
    }

    public Errors getErrors(ServletRequest request) {
        return (Errors)request.getAttribute("org.codehaus.groovy.grails.ERRORS");
    }

    public GroovyPagesTemplateEngine getPagesTemplateEngine() {
        ApplicationContext appCtx = this.getApplicationContext();
        if (appCtx.containsBean("groovyPagesTemplateEngine")) {
            return (GroovyPagesTemplateEngine)((Object)appCtx.getBean("groovyPagesTemplateEngine"));
        }
        throw new GroovyPagesException("No bean named [groovyPagesTemplateEngine] defined in Spring application context!");
    }

    public GrailsApplication getGrailsApplication() {
        return (GrailsApplication)this.getApplicationContext().getBean("grailsApplication");
    }

    public GroovyObject getTagLibraryForTag(HttpServletRequest request, HttpServletResponse response, String tagName) {
        return this.getTagLibraryForTag(request, response, tagName, "g");
    }

    public GroovyObject getTagLibraryForTag(HttpServletRequest request, HttpServletResponse response, String tagName, String namespace) {
        String nonNullNamesapce = namespace == null ? "g" : namespace;
        String fullTagName = nonNullNamesapce + ":" + tagName;
        GrailsTagLibClass tagLibClass = (GrailsTagLibClass)this.getGrailsApplication().getArtefactForFeature("TagLib", (Object)fullTagName);
        if (tagLibClass == null) {
            return null;
        }
        return (GroovyObject)this.getApplicationContext().getBean(tagLibClass.getFullName());
    }

    public String getViewUri(String viewName, HttpServletRequest request) {
        return GroovyPageUtils.getDeployedViewURI(this.getControllerName((ServletRequest)request), viewName);
    }

    public Writer getOut(HttpServletRequest request) {
        return (Writer)request.getAttribute("org.codehaus.groovy.grails.RESPONSE_OUT");
    }

    public void setOut(HttpServletRequest request, Writer out2) {
        request.setAttribute("org.codehaus.groovy.grails.RESPONSE_OUT", (Object)out2);
    }
}

