/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.json;

import java.io.Writer;
import java.util.Stack;
import org.codehaus.groovy.grails.web.json.JSONWriter;

public class PathCapturingJSONWriterWrapper
extends JSONWriter {
    private JSONWriter delegate;
    private Stack<PathElement> pathStack = new Stack();

    public PathCapturingJSONWriterWrapper(Writer w, JSONWriter delegate) {
        super(w);
        this.delegate = delegate;
    }

    public JSONWriter append(String s) {
        return this.delegate.append(s);
    }

    public void comma() {
        this.delegate.comma();
    }

    public JSONWriter array() {
        return this.delegate.array();
    }

    public JSONWriter end(JSONWriter.Mode m, char c) {
        return this.delegate.end(m, c);
    }

    public JSONWriter endArray() {
        return this.delegate.endArray();
    }

    public JSONWriter endObject() {
        return this.delegate.endObject();
    }

    public JSONWriter key(String s) {
        this.pathStack.push(new PropertyElement(s));
        return this.delegate.key(s);
    }

    public JSONWriter object() {
        return this.delegate.object();
    }

    public void pop(JSONWriter.Mode c) {
        this.delegate.pop(c);
    }

    public void push(JSONWriter.Mode c) {
        this.delegate.push(c);
    }

    public JSONWriter value(boolean b) {
        this.pathStack.pop();
        if (this.mode == JSONWriter.Mode.ARRAY) {
            this.pathStack.push(new IndexElement(((IndexElement)this.pathStack.peek()).index));
        }
        return this.delegate.value(b);
    }

    public JSONWriter value(double d) {
        this.pathStack.pop();
        return this.delegate.value(d);
    }

    public JSONWriter value(long l) {
        this.pathStack.pop();
        return this.delegate.value(l);
    }

    public JSONWriter value(Object o) {
        this.pathStack.pop();
        return this.delegate.value(o);
    }

    private class IndexElement
    extends PathElement {
        private int index;

        private IndexElement(int index) {
            this.index = index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }
    }

    private class PropertyElement
    extends PathElement {
        private String property;

        private PropertyElement(String property) {
            this.property = property;
        }

        public String toString() {
            return "." + this.property;
        }
    }

    private class PathElement {
        private PathElement() {
        }
    }
}

