/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.hibernate.Hibernate;
import org.hibernate.collection.AbstractPersistentCollection;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassMarshaller
implements ObjectMarshaller<XML> {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public boolean supports(Object object) {
        return ConverterUtil.isDomainClass(object.getClass());
    }

    @Override
    public void marshalObject(Object value, XML xml) throws ConverterException {
        GrailsDomainClassProperty[] properties;
        Class<?> clazz = value.getClass();
        GrailsDomainClass domainClass = ConverterUtil.getDomainClass(clazz.getName());
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        GrailsDomainClassProperty id = domainClass.getIdentifier();
        Object idValue = this.extractIdValue(value, id);
        if (idValue != null) {
            xml.attribute("id", String.valueOf(idValue));
        }
        for (GrailsDomainClassProperty property : properties = domainClass.getPersistentProperties()) {
            xml.startNode(property.getName());
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                xml.convertAnother(val);
            } else {
                Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
                if (this.isRenderDomainClassRelations()) {
                    if (referenceObject != null) {
                        if (referenceObject instanceof AbstractPersistentCollection) {
                            AbstractPersistentCollection acol = (AbstractPersistentCollection)referenceObject;
                            acol.forceInitialization();
                            referenceObject = referenceObject instanceof SortedMap ? new TreeMap(referenceObject) : (referenceObject instanceof SortedSet ? new TreeSet((SortedSet)((Object)referenceObject)) : (referenceObject instanceof Set ? new HashSet((Set)((Object)referenceObject)) : (referenceObject instanceof Map ? new HashMap(referenceObject) : new ArrayList((Collection)((Object)referenceObject)))));
                        } else if (!Hibernate.isInitialized((Object)referenceObject)) {
                            Hibernate.initialize((Object)referenceObject);
                        }
                        xml.convertAnother(referenceObject);
                    }
                } else if (referenceObject != null) {
                    GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
                    if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                        if (GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                            xml.convertAnother(referenceObject);
                        } else {
                            this.asShortObject(referenceObject, xml, referencedDomainClass.getIdentifier(), referencedDomainClass);
                        }
                    } else {
                        GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
                        String refPropertyName = referencedDomainClass.getPropertyName();
                        if (referenceObject instanceof Collection) {
                            Collection o = (Collection)((Object)referenceObject);
                            for (Object e : o) {
                                xml.startNode(xml.getElementName(e));
                                this.asShortObject(e, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        } else if (referenceObject instanceof Map) {
                            Map map = referenceObject;
                            for (Map.Entry entry : map.entrySet()) {
                                String key = String.valueOf(entry.getKey());
                                Object o = entry.getValue();
                                xml.startNode("entry").attribute("key", key);
                                this.asShortObject(o, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        }
                    }
                }
            }
            xml.end();
        }
    }

    protected void asShortObject(Object refObj, XML xml, GrailsDomainClassProperty idProperty, GrailsDomainClass referencedDomainClass) throws ConverterException {
        xml.attribute("id", String.valueOf(this.extractIdValue(refObj, idProperty)));
    }

    protected Object extractIdValue(Object domainObject, GrailsDomainClassProperty idProperty) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(domainObject);
        return beanWrapper.getPropertyValue(idProperty.getName());
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

