/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.codehaus.groovy.grails.web.json.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaBeanMarshaller
implements ObjectMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return true;
    }

    @Override
    public void marshalObject(Object o, JSON json) throws ConverterException {
        JSONWriter writer = json.getWriter();
        try {
            Field[] fields;
            PropertyDescriptor[] properties;
            writer.object();
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                String name = property.getName();
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                writer.key(name);
                json.convertAnother(value);
            }
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!field.isAccessible() || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                writer.key(field.getName());
                json.convertAnother(field.get(o));
            }
            writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }
}

