/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlCreator;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeUrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlCreator;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.springframework.core.style.ToStringCreator;

public class DefaultUrlMappingsHolder
implements UrlMappingsHolder {
    private static final transient Log LOG = LogFactory.getLog(DefaultUrlMappingsHolder.class);
    private List urlMappings = new ArrayList();
    private UrlMapping[] mappings;
    private List excludePatterns;
    private Map mappingsLookup = new HashMap();
    private UrlMappingsList mappingsListLookup = new UrlMappingsList();
    private Set DEFAULT_CONTROLLER_PARAMS = new HashSet(){
        {
            this.add("controller");
            this.add("action");
        }
    };
    private Set DEFAULT_ACTION_PARAMS = new HashSet(){
        {
            this.add("action");
        }
    };

    public DefaultUrlMappingsHolder(List mappings) {
        this.urlMappings = mappings;
        this.initialize();
    }

    public DefaultUrlMappingsHolder(List mappings, List excludePatterns) {
        this.urlMappings = mappings;
        this.excludePatterns = excludePatterns;
        this.initialize();
    }

    private void initialize() {
        Collections.sort(this.urlMappings);
        Collections.reverse(this.urlMappings);
        this.mappings = this.urlMappings.toArray(new UrlMapping[this.urlMappings.size()]);
        for (int i = 0; i < this.mappings.length; ++i) {
            UrlMapping mapping = this.mappings[i];
            String controllerName = mapping.getControllerName() instanceof String ? mapping.getControllerName().toString() : null;
            String actionName = mapping.getActionName() instanceof String ? mapping.getActionName().toString() : null;
            ConstrainedProperty[] params = mapping.getConstraints();
            HashSet<String> requiredParams = new HashSet<String>();
            int optionalIndex = -1;
            for (int j = 0; j < params.length; ++j) {
                ConstrainedProperty param = params[j];
                if (param.isNullable()) {
                    optionalIndex = j;
                    break;
                }
                requiredParams.add(param.getPropertyName());
            }
            UrlMappingKey key = new UrlMappingKey(controllerName, actionName, requiredParams);
            this.mappingsLookup.put(key, mapping);
            UrlMappingsListKey listKey = new UrlMappingsListKey(controllerName, actionName);
            this.mappingsListLookup.put(listKey, key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reverse mapping: " + key + " -> " + mapping));
            }
            HashSet<String> requiredParamsAndOptionals = new HashSet<String>(requiredParams);
            if (optionalIndex <= -1) continue;
            for (int j = optionalIndex; j < params.length; ++j) {
                ConstrainedProperty param = params[j];
                requiredParamsAndOptionals.add(param.getPropertyName());
                key = new UrlMappingKey(controllerName, actionName, new HashSet(requiredParamsAndOptionals));
                this.mappingsLookup.put(key, mapping);
                listKey = new UrlMappingsListKey(controllerName, actionName);
                this.mappingsListLookup.put(listKey, key);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Reverse mapping: " + key + " -> " + mapping));
            }
        }
    }

    public UrlMapping[] getUrlMappings() {
        return this.mappings;
    }

    public List getExcludePatterns() {
        return this.excludePatterns;
    }

    public UrlCreator getReverseMapping(String controller, String action, Map params) {
        Set paramKeys;
        HashSet lookupParams;
        UrlMapping mapping;
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        if ((mapping = this.lookupMapping(controller, action, params)) == null || mapping instanceof ResponseCodeUrlMapping) {
            mapping = (UrlMapping)this.mappingsLookup.get(new UrlMappingKey(controller, action, Collections.EMPTY_SET));
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet(this.DEFAULT_ACTION_PARAMS);
            paramKeys = params.keySet();
            lookupParams.addAll(paramKeys);
            mapping = (UrlMapping)this.mappingsLookup.get(new UrlMappingKey(controller, null, lookupParams));
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                mapping = (UrlMapping)this.mappingsLookup.get(new UrlMappingKey(controller, null, lookupParams));
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet(this.DEFAULT_CONTROLLER_PARAMS);
            paramKeys = params.keySet();
            lookupParams.addAll(paramKeys);
            mapping = (UrlMapping)this.mappingsLookup.get(new UrlMappingKey(null, null, lookupParams));
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                mapping = (UrlMapping)this.mappingsLookup.get(new UrlMappingKey(null, null, lookupParams));
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            return new DefaultUrlCreator(controller, action);
        }
        return mapping;
    }

    private UrlMapping lookupMapping(String controller, String action, Map params) {
        SortedSet mappingKeysSet = this.mappingsListLookup.get(new UrlMappingsListKey(controller, action));
        if (null == mappingKeysSet) {
            return null;
        }
        UrlMappingKey[] mappingKeys = mappingKeysSet.toArray(new UrlMappingKey[mappingKeysSet.size()]);
        HashSet mappingConstraintNames = new HashSet();
        for (int i = mappingKeys.length; i > 0; --i) {
            UrlMappingKey mappingKey = mappingKeys[i - 1];
            if (!params.keySet().containsAll(mappingKey.paramNames)) continue;
            return (UrlMapping)this.mappingsLookup.get(mappingKey);
        }
        return null;
    }

    public UrlMappingInfo match(String uri) {
        UrlMappingInfo info = null;
        for (int i = 0; i < this.mappings.length; ++i) {
            UrlMapping mapping = this.mappings[i];
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
            }
            if ((info = mapping.match(uri)) != null) break;
        }
        return info;
    }

    public UrlMappingInfo[] matchAll(String uri) {
        ArrayList<UrlMappingInfo> matchingUrls = new ArrayList<UrlMappingInfo>();
        for (int i = 0; i < this.mappings.length; ++i) {
            UrlMappingInfo current;
            UrlMapping mapping = this.mappings[i];
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
            }
            if ((current = mapping.match(uri)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Matched URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "], adding to posibilities"));
            }
            matchingUrls.add(current);
        }
        return matchingUrls.toArray(new UrlMappingInfo[matchingUrls.size()]);
    }

    public UrlMappingInfo[] matchAll(String uri, String httpMethod) {
        return new UrlMappingInfo[0];
    }

    public UrlMappingInfo matchStatusCode(int responseCode) {
        for (int i = 0; i < this.mappings.length; ++i) {
            ResponseCodeUrlMapping responseCodeUrlMapping;
            UrlMappingInfo current;
            UrlMapping mapping = this.mappings[i];
            if (!(mapping instanceof ResponseCodeUrlMapping) || (current = (responseCodeUrlMapping = (ResponseCodeUrlMapping)mapping).match(responseCode)) == null) continue;
            return current;
        }
        return null;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("URL Mappings");
        pw.println("------------");
        for (int i = 0; i < this.mappings.length; ++i) {
            UrlMapping mapping = this.mappings[i];
            pw.println(mapping);
        }
        pw.flush();
        return sw.toString();
    }

    class UrlMappingsList {
        private Map mappingsListLookup = new HashMap();

        UrlMappingsList() {
        }

        public void put(UrlMappingsListKey key, UrlMappingKey mapping) {
            TreeSet<UrlMappingKey> mappingsList = (TreeSet<UrlMappingKey>)this.mappingsListLookup.get(key);
            if (null == mappingsList) {
                mappingsList = new TreeSet<UrlMappingKey>();
                this.mappingsListLookup.put(key, mappingsList);
            }
            mappingsList.add(mapping);
        }

        public SortedSet get(UrlMappingsListKey key) {
            return (SortedSet)this.mappingsListLookup.get(key);
        }
    }

    class UrlMappingsListKey {
        String controller;
        String action;

        public UrlMappingsListKey(String controller, String action) {
            this.controller = controller;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlMappingsListKey that = (UrlMappingsListKey)o;
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            return this.controller == null || this.controller.equals(that.controller);
        }

        public int hashCode() {
            int result = this.controller != null ? this.controller.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("controller", (Object)this.controller).append("action", (Object)this.action).toString();
        }
    }

    class UrlMappingKey
    implements Comparable {
        String controller;
        String action;
        Set paramNames = Collections.EMPTY_SET;

        public UrlMappingKey(String controller, String action, Set paramNames) {
            this.controller = controller;
            this.action = action;
            this.paramNames = paramNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlMappingKey that = (UrlMappingKey)o;
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            if (this.controller != null && !this.controller.equals(that.controller)) {
                return false;
            }
            return ((Object)this.paramNames).equals(that.paramNames);
        }

        public int hashCode() {
            int result = this.controller != null ? this.controller.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + ((Object)this.paramNames).hashCode();
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("controller", (Object)this.controller).append("action", (Object)this.action).append("params", (Object)this.paramNames).toString();
        }

        public int compareTo(Object o) {
            int comparison;
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this == o) {
                return 0;
            }
            UrlMappingKey other = (UrlMappingKey)o;
            if (this.paramNames.size() < other.paramNames.size()) {
                return -1;
            }
            if (this.paramNames.size() > other.paramNames.size()) {
                return 1;
            }
            int n = comparison = this.controller != null ? this.controller.compareTo(other.controller) : 0;
            if (comparison != 0) {
                return comparison;
            }
            int n2 = comparison = this.action != null ? this.action.compareTo(other.action) : 0;
            if (comparison != 0) {
                return comparison;
            }
            return 0;
        }
    }
}

