/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters;

import com.thoughtworks.xstream.XStream;
import grails.converters.XML;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.web.converters.AbstractConverter;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.validation.Errors;

public class ConverterUtil {
    private static final Log log = LogFactory.getLog(ConverterUtil.class);
    private static ConverterUtil INSTANCE;
    private static Map XSTREAM_MAP;
    private static Map ALIAS_MAP;
    private GrailsApplication grailsApplication;

    public static Object createConverter(Class converterClass, Object target) throws ConverterException {
        return ConverterUtil.createConverter(converterClass, target, null);
    }

    public static Object createConverter(Class converterClass, Object target, ApplicationContext applicationContext) throws ConverterException {
        try {
            AbstractConverter converter = (AbstractConverter)converterClass.newInstance();
            if (converter instanceof ApplicationContextAware && applicationContext != null) {
                ((ApplicationContextAware)converter).setApplicationContext(applicationContext);
            }
            converter.setTarget(target);
            return converter;
        }
        catch (Exception e) {
            throw new ConverterException("Initialization of Converter Object " + converterClass.getName() + " failed for target " + target.getClass().getName(), e);
        }
    }

    public static XStream getXStream(Class clazz) {
        XStream xs = (XStream)XSTREAM_MAP.get(clazz);
        if (xs == null) {
            xs = ConverterUtil.setupXStream(clazz);
        }
        return xs;
    }

    protected static XStream setupXStream(Class converter) {
        XStream xs = new XStream();
        xs.setMode(1004);
        for (Class cls : ALIAS_MAP.keySet()) {
            String alias = (String)ALIAS_MAP.get(cls);
            xs.alias(alias, cls);
        }
        xs.aliasType("errors", Errors.class);
        try {
            XML instance = (XML)converter.newInstance();
            instance.configureXStream(xs);
            XSTREAM_MAP.put(converter, xs);
        }
        catch (Exception e) {
            log.error((Object)("Error configuring XStream for Converter " + converter.getName()), (Throwable)e);
        }
        return xs;
    }

    public static void addAlias(String alias, Class clazz) {
        ALIAS_MAP.put(clazz, alias);
        XSTREAM_MAP.clear();
    }

    public static String getAlias(Class cls) {
        return (String)ALIAS_MAP.get(cls);
    }

    public static String resolveAlias(Class cls) {
        String alias = (String)ALIAS_MAP.get(cls);
        if (alias == null) {
            return cls.getName();
        }
        return alias;
    }

    public static GrailsDomainClass getDomainClass(String name) {
        name = ConverterUtil.trimProxySuffix(name);
        return (GrailsDomainClass)ConverterUtil.getGrailsApplication().getArtefact("Domain", name);
    }

    private static String trimProxySuffix(String name) {
        int i = name.indexOf("$$");
        if (i > -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static GrailsApplication getGrailsApplication() {
        return ConverterUtil.getInstance().grailsApplication;
    }

    protected static ConverterUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterUtil();
        }
        return INSTANCE;
    }

    public static boolean isConverterClass(Class clazz) {
        return Converter.class.isAssignableFrom(clazz);
    }

    public static boolean isDomainClass(Class clazz) {
        String name = ConverterUtil.trimProxySuffix(clazz.getName());
        return ConverterUtil.getGrailsApplication().isArtefactOfType("Domain", name);
    }

    public static Set getDomainClassNames() {
        return ConverterUtil.getGrailsApplication().getArtefactInfo("Domain").getClassesByName().keySet();
    }

    public static void setGrailsApplication(GrailsApplication grailsApp) {
        ConverterUtil.getInstance().grailsApplication = grailsApp;
    }

    protected ConverterUtil() {
    }

    public static Object invokeOriginalAsTypeMethod(Object delegate, Class clazz) {
        if (delegate instanceof Collection) {
            return DefaultGroovyMethods.asType((Collection)((Collection)delegate), (Class)clazz);
        }
        if (delegate instanceof Closure) {
            return DefaultGroovyMethods.asType((Closure)((Closure)delegate), (Class)clazz);
        }
        if (delegate instanceof Map) {
            return DefaultGroovyMethods.asType((Map)((Map)delegate), (Class)clazz);
        }
        if (delegate instanceof Number) {
            return DefaultGroovyMethods.asType((Number)((Number)delegate), (Class)clazz);
        }
        if (delegate instanceof File) {
            return DefaultGroovyMethods.asType((File)((File)delegate), (Class)clazz);
        }
        if (delegate instanceof String) {
            return DefaultGroovyMethods.asType((String)((String)delegate), (Class)clazz);
        }
        return DefaultGroovyMethods.asType((Object)delegate, (Class)clazz);
    }

    static {
        XSTREAM_MAP = new HashMap();
        ALIAS_MAP = new HashMap();
    }
}

