/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsLayoutDecoratorMapper
extends AbstractDecoratorMapper
implements DecoratorMapper {
    private static final String DEFAULT_DECORATOR_PATH = "/WEB-INF/grails-app/views/layouts";
    private static final String DEFAULT_VIEW_TYPE = ".gsp";
    private static final Log LOG = LogFactory.getLog(GrailsLayoutDecoratorMapper.class);
    private Map decoratorMap = new HashMap();
    private ServletContext servletContext;

    public void init(Config config, Properties properties, DecoratorMapper parent) throws InstantiationException {
        super.init(config, properties, parent);
        this.servletContext = config.getServletContext();
    }

    public Decorator getDecorator(HttpServletRequest request, Page page) {
        Decorator d;
        String layoutName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluating layout for request: " + request.getRequestURI()));
        }
        if (StringUtils.isBlank((String)(layoutName = page.getProperty("meta.layout")))) {
            GroovyObject controller = (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
            if (controller != null) {
                Decorator d2;
                String controllerName = (String)controller.getProperty("controllerName");
                String actionUri = (String)controller.getProperty("actionUri");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found controller in request, location layout for controller [" + controllerName + "] and action [" + actionUri + "]"));
                }
                if ((d2 = this.getNamedDecorator(request, actionUri.substring(1))) != null) {
                    return d2;
                }
                if (!StringUtils.isBlank((String)controllerName)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Action layout not found, trying controller");
                    }
                    if ((d2 = this.getNamedDecorator(request, controllerName)) != null) {
                        return d2;
                    }
                    return this.parent != null ? super.getDecorator(request, page) : null;
                }
            } else {
                return this.parent != null ? super.getDecorator(request, page) : null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluated layout for page: " + layoutName));
        }
        if ((d = this.getNamedDecorator(request, layoutName)) != null) {
            return d;
        }
        return this.parent != null ? super.getDecorator(request, page) : null;
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        if (this.decoratorMap.containsKey(name)) {
            return (Decorator)this.decoratorMap.get(name);
        }
        String decoratorName = name;
        if (!name.matches("(.+)(\\.)(\\w{2}|\\w{3})")) {
            name = name + DEFAULT_VIEW_TYPE;
        }
        String decoratorPage = "/WEB-INF/grails-app/views/layouts/" + name;
        ResourceLoader resourceLoader = this.establishResourceLoader();
        Resource res = resourceLoader.getResource(decoratorPage);
        if (!res.exists()) {
            PathMatchingResourcePatternResolver matcher = new PathMatchingResourcePatternResolver(resourceLoader);
            String pattern = "/WEB-INF/plugins/*/grails-app/views/layouts/" + name;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No decorator found at " + decoratorPage + ". Trying plug-ins with pattern: " + pattern));
            }
            try {
                Resource[] layouts = matcher.getResources(pattern);
                if (layouts.length > 0) {
                    if (layouts.length > 1) {
                        LOG.warn((Object)("Multiple matching layouts found in plug-ins for name [" + name + "] using first from [" + ArrayUtils.toString((Object)layouts) + "]"));
                    }
                    String url = layouts[0].getURL().toString();
                    url = "/WEB-INF" + url.substring(url.indexOf("/plugins"), url.length());
                    DefaultDecorator d = new DefaultDecorator(name, request.getRequestURI(), url, Collections.EMPTY_MAP);
                    this.decoratorMap.put(decoratorName, d);
                    return d;
                }
            }
            catch (IOException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using decorator " + decoratorPage));
        }
        DefaultDecorator d = new DefaultDecorator(decoratorName, request.getRequestURI(), decoratorPage, Collections.EMPTY_MAP);
        this.decoratorMap.put(decoratorName, d);
        return d;
    }

    private ResourceLoader establishResourceLoader() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
        GrailsApplication application = null;
        if (ctx.containsBean("grailsApplication")) {
            application = (GrailsApplication)ctx.getBean("grailsApplication");
        }
        Object resourceLoader = application == null ? ctx : (ctx.containsBean("groovyPageResourceLoader") && !application.isWarDeployed() ? (ResourceLoader)ctx.getBean("groovyPageResourceLoader") : ctx);
        return resourceLoader;
    }
}

