/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsUtil;
import groovy.lang.GroovyClassLoader;
import groovy.text.Template;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.grails.support.ResourceAwareTemplateEngine;
import org.codehaus.groovy.grails.web.pages.GroovyPageMetaInfo;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.pages.Parse;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.metaclass.ConcurrentReaderHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class GroovyPagesTemplateEngine
extends ResourceAwareTemplateEngine
implements ApplicationContextAware,
ServletContextAware {
    private static final Log LOG = LogFactory.getLog(GroovyPagesTemplateEngine.class);
    private static Map pageCache = new ConcurrentReaderHashMap();
    private GroovyClassLoader classLoader = new GroovyClassLoader();
    private int scriptNameCount;
    private ResourceLoader resourceLoader;
    public static final String BEAN_ID = "groovyPagesTemplateEngine";
    public static final String RESOURCE_LOADER_BEAN_ID = "groovyPagesResourceLoader";
    private boolean reloadEnabled;
    private ServletContext servletContext;
    private ServletContextResourceLoader servletContextLoader;

    public GroovyPagesTemplateEngine() {
    }

    public GroovyPagesTemplateEngine(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException("Argument [servletContext] cannot be null");
        }
        this.resourceLoader = new ServletContextResourceLoader(servletContext);
        this.servletContext = servletContext;
        this.servletContextLoader = new ServletContextResourceLoader(servletContext);
    }

    public void setClassLoader(GroovyClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] calculateLineNumbersForPage(ServletContext context, String url) {
        try {
            Resource r = this.getResourceForUri(url);
            if (r == null) return new int[0];
            InputStream inputStream = r.getInputStream();
            try {
                GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, r, null);
                if (metaInfo == null) return new int[0];
                int[] nArray = metaInfo.getLineNumbers();
                return nArray;
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception retrieving line numbers from GSP: " + url + ", message: " + e.getMessage()));
            LOG.debug((Object)"Full stack trace of error", (Throwable)e);
        }
        return new int[0];
    }

    public Template createTemplate(Resource resource) {
        if (resource == null) {
            GrailsWebRequest webRequest = this.getWebRequest();
            throw new GroovyPagesException("No Groovy page found for URI: " + this.getCurrentRequestUri(webRequest.getCurrentRequest()));
        }
        String name = this.establishPageName(resource, null);
        if (pageCache.containsKey(name)) {
            GroovyPageMetaInfo meta = (GroovyPageMetaInfo)pageCache.get(name);
            if (this.isGroovyPageReloadable(resource, meta)) {
                try {
                    return this.createTemplateWithResource(resource);
                }
                catch (IOException e) {
                    throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
                }
            }
            return new GroovyPageTemplate(meta);
        }
        try {
            return this.createTemplateWithResource(resource);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O error reading stream for resource [" + resource + "]: " + e.getMessage(), e);
        }
    }

    public Template createTemplate(String uri) {
        return this.createTemplate(this.getResourceForUri(uri));
    }

    public Template createTemplate(String txt, String pageName) throws IOException {
        if (StringUtils.isBlank((String)txt)) {
            throw new IllegalArgumentException("Argument [txt] cannot be null or blank");
        }
        if (StringUtils.isBlank((String)pageName)) {
            throw new IllegalArgumentException("Argument [pageName] cannot be null or blank");
        }
        return this.createTemplate((Resource)new ByteArrayResource(txt.getBytes(), pageName), pageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplate(Resource resource, String pageName) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            Template template = this.createTemplate(in, resource, pageName);
            return template;
        }
        finally {
            in.close();
        }
    }

    public Template createTemplate() throws IOException, ClassNotFoundException {
        GrailsWebRequest webRequest = this.getWebRequest();
        String uri = this.getCurrentRequestUri(webRequest.getCurrentRequest());
        return this.createTemplate(uri);
    }

    public Template createTemplate(File file) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new FileSystemResource(file));
    }

    public Template createTemplate(URL url) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new UrlResource(url));
    }

    public Template createTemplate(InputStream inputStream) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, null, null);
        return new GroovyPageTemplate(metaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createTemplateWithResource(Resource resource) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            Template template = this.createTemplate(in, resource, null);
            return template;
        }
        finally {
            in.close();
        }
    }

    protected Template createTemplate(InputStream inputStream, Resource resource, String pageName) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, resource, pageName);
        return new GroovyPageTemplate(metaInfo);
    }

    private boolean isGroovyPageReloadable(Resource resource, GroovyPageMetaInfo meta) {
        return this.isReloadEnabled() && this.establishLastModified(resource) > meta.getLastModified();
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean b) {
        this.reloadEnabled = true;
    }

    public Resource getResourceForUri(String uri) {
        String pluginUri;
        Resource r = this.getResourceWithinContext(uri);
        if (!(r != null && r.exists() || (r = this.getResourceWithinContext(pluginUri = "/WEB-INF" + uri)) != null && r.exists())) {
            uri = this.getUriWithinGrailsViews(uri);
            return this.getResourceWithinContext(uri);
        }
        return r;
    }

    private Resource getResourceWithinContext(String uri) {
        if (this.resourceLoader == null) {
            throw new IllegalStateException("TemplateEngine not initialised correctly, no [resourceLoader] specified!");
        }
        Resource r = this.servletContextLoader.getResource(uri);
        if (r.exists()) {
            return r;
        }
        return this.resourceLoader.getResource(uri);
    }

    private long establishLastModified(Resource resource) {
        long lastModified;
        if (resource == null) {
            return -1L;
        }
        try {
            URLConnection urlc = resource.getURL().openConnection();
            urlc.setDoInput(false);
            urlc.setDoOutput(false);
            lastModified = urlc.getLastModified();
        }
        catch (FileNotFoundException fnfe) {
            lastModified = -1L;
        }
        catch (IOException e) {
            lastModified = -1L;
        }
        return lastModified;
    }

    protected GroovyPageMetaInfo buildPageMetaInfo(InputStream inputStream, Resource res, String pageName) {
        Parse parse;
        String name = this.establishPageName(res, pageName);
        long lastModified = this.establishLastModified(res);
        try {
            parse = new Parse(name, res.getDescription(), inputStream);
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O parsing Groovy page [" + (res != null ? res.getDescription() : name) + "]: " + e.getMessage(), e);
        }
        InputStream in = parse.parse();
        GroovyPageMetaInfo metaInfo = this.createPageMetaInfo(parse, lastModified, in);
        metaInfo.setPageClass(this.compileGroovyPage(in, name));
        pageCache.put(name, metaInfo);
        return metaInfo;
    }

    private Class compileGroovyPage(InputStream in, String name) {
        Class scriptClass;
        try {
            scriptClass = this.classLoader.parseClass(in, name);
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)("Compilation error compiling GSP [" + name + "]:" + e.getMessage()), (Throwable)e);
            throw new GroovyPagesException("Could not parse script [" + name + "]: " + e.getMessage(), (Exception)((Object)e));
        }
        return scriptClass;
    }

    private GroovyPageMetaInfo createPageMetaInfo(Parse parse, long lastModified, InputStream in) {
        GroovyPageMetaInfo pageMeta = new GroovyPageMetaInfo();
        pageMeta.setContentType(parse.getContentType());
        pageMeta.setLineNumbers(parse.getLineNumberMatrix());
        pageMeta.setLastModified(lastModified);
        pageMeta.setJspTags(parse.getJspTags());
        if (this.isReloadEnabled() || GrailsUtil.isDevelopmentEnv()) {
            pageMeta.setGroovySource(in);
        }
        return pageMeta;
    }

    private GrailsWebRequest getWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    protected String establishPageName(Resource res, String pageName) {
        String name;
        if (res == null) {
            return this.generateTemplateName();
        }
        try {
            String string = name = pageName != null ? pageName : res.getURL().getPath();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            name = name.replaceAll("[^\\w\\d]", "_");
        }
        catch (IllegalStateException e) {
            name = this.generateTemplateName();
        }
        catch (IOException ioex) {
            name = this.generateTemplateName();
        }
        return name;
    }

    private String generateTemplateName() {
        return "gsp_script_" + ++this.scriptNameCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.resourceLoader == null) {
            this.resourceLoader = applicationContext;
        }
    }

    protected String getCurrentRequestUri(HttpServletRequest request) {
        Object includePath = request.getAttribute("javax.servlet.include.servlet_path");
        if (includePath != null) {
            return ((String)includePath).intern();
        }
        return request.getServletPath().intern();
    }

    protected String getUriWithinGrailsViews(String relativeUri) {
        StringBuffer buf = new StringBuffer();
        if (relativeUri.startsWith("/")) {
            relativeUri = relativeUri.substring(1);
        }
        String[] tokens = relativeUri.indexOf(47) > -1 ? relativeUri.split("/") : new String[]{relativeUri};
        buf.append("/WEB-INF/grails-app/views");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            buf.append('/').append(token);
        }
        if (!relativeUri.endsWith(".gsp")) {
            buf.append(".gsp");
        }
        return buf.toString();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.servletContextLoader = new ServletContextResourceLoader(servletContext);
        if (this.resourceLoader == null) {
            this.resourceLoader = new ServletContextResourceLoader(servletContext);
        }
    }

    public void clearPageCache() {
        pageCache.clear();
    }
}

