/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsUtil;
import groovy.lang.Writable;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.core.io.Resource;
import org.springframework.web.context.request.RequestContextHolder;

public class GroovyPagesServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(GroovyPagesServlet.class);
    private ServletContext context;
    private GrailsApplicationAttributes grailsAttributes;
    private static final int BUFFER_SIZE = 8192;
    private static final String ERRORS_VIEW = "/WEB-INF/grails-app/views/error.gsp";
    public static final String EXCEPTION_MODEL_KEY = "exception";
    public static final String SERVLET_INSTANCE = "org.codehaus.groovy.grails.GSP_SERVLET";

    public void init(ServletConfig config) {
        this.context = config.getServletContext();
        this.context.log("GSP servlet initialized");
        this.context.setAttribute(SERVLET_INSTANCE, (Object)this);
        this.grailsAttributes = new DefaultGrailsApplicationAttributes(this.context);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPage(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPage(request, response);
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public void doPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Resource page;
        request.setAttribute("org.codehaus.groovy.grails.GRAILS_APPLICATION_ATTRIBUTES", (Object)this.grailsAttributes);
        request.setAttribute(SERVLET_INSTANCE, (Object)this);
        GroovyPagesTemplateEngine engine = this.grailsAttributes.getPagesTemplateEngine();
        String pageName = (String)request.getAttribute("org.codehaus.groovy.grails.GSP_TO_RENDER");
        if (StringUtils.isBlank((String)pageName)) {
            pageName = engine.getCurrentRequestUri(request);
        }
        if ((page = engine.getResourceForUri(pageName)) == null) {
            this.context.log("GroovyPagesServlet:  \"" + pageName + "\" not found");
            response.sendError(404, "\"" + pageName + "\" not found.");
            return;
        }
        this.renderPageWithEngine(engine, request, response, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderPageWithEngine(GroovyPagesTemplateEngine engine, HttpServletRequest request, HttpServletResponse response, Resource pageResource) throws IOException, ServletException {
        Writer out = this.createResponseWriter(response);
        try {
            Template t = engine.createTemplate(pageResource);
            if (t == null) {
                this.context.log("GroovyPagesServlet:  \"" + pageResource.getDescription() + "\" not found");
                response.sendError(404, "\"" + pageResource.getDescription() + "\" not found.");
                return;
            }
            Writable w = t.make();
            w.writeTo(out);
        }
        catch (Exception e) {
            out = this.createResponseWriter(response);
            this.handleException(e, out, engine);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void handleException(Exception exception, Writer out, GroovyPagesTemplateEngine engine) throws ServletException, IOException {
        GrailsUtil.deepSanitize(exception);
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Error processing GSP: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            Template t = engine.createTemplate(ERRORS_VIEW);
            HashMap<String, GrailsWrappedRuntimeException> model = new HashMap<String, GrailsWrappedRuntimeException>();
            model.put(EXCEPTION_MODEL_KEY, new GrailsWrappedRuntimeException(this.context, exception));
            Writable w = t.make(model);
            w.writeTo(out);
        }
        catch (Throwable t) {
            LOG.error((Object)("Error attempting to render errors view : " + t.getMessage()), t);
            LOG.error((Object)("Original exception : " + exception.getMessage()), (Throwable)exception);
        }
    }

    protected Writer createResponseWriter(HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response, 8192);
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        webRequest.setOut(out);
        return out;
    }
}

