/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Metadata;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    DEVELOPMENT,
    PRODUCTION,
    TEST,
    APPLICATION,
    CUSTOM;

    public static String KEY;
    public static final String DEFAULT = "grails.env.default";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static HashMap<String, String> envNameMappings;
    private String name;

    public static Environment getCurrent() {
        Metadata metadata = Metadata.getCurrent();
        String envName = null;
        if (metadata != null) {
            envName = metadata.getEnvironment();
        }
        if (Environment.isBlank(envName)) {
            envName = System.getProperty(KEY);
        }
        if (Environment.isBlank(envName)) {
            return DEVELOPMENT;
        }
        Environment env = Environment.getEnvironment(envName);
        if (env == null) {
            try {
                env = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (env == null) {
            env = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = envNameMappings.get(shortName);
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        return null;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        if (this.name == null) {
            return this.toString().toLowerCase(Locale.getDefault());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        KEY = "grails.env";
        envNameMappings = new HashMap<String, String>(){
            {
                this.put(Environment.DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName());
                this.put(Environment.PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName());
                this.put(Environment.TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
            }
        };
    }
}

