/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import com.opensymphony.module.sitemesh.util.FastByteArrayOutputStream;
import grails.util.GrailsUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class WebUtils
extends org.springframework.web.util.WebUtils {
    public static final char SLASH = '/';
    private static final Log LOG = LogFactory.getLog(WebUtils.class);
    public static final String ENABLE_FILE_EXTENSIONS = "grails.mime.file.extensions";
    public static final String DISPATCH_ACTION_PARAMETER = "_action_";
    private static final String DISPATCH_URI_SUFFIX = ".dispatch";
    private static final String GRAILS_DISPATCH_SERVLET_NAME = "/grails";

    public static ViewResolver lookupViewResolver(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        String[] beanNames = wac.getBeanNamesForType(ViewResolver.class);
        if (beanNames.length > 0) {
            String beanName = beanNames[0];
            return (ViewResolver)wac.getBean(beanName);
        }
        return null;
    }

    public static HandlerInterceptor[] lookupHandlerInterceptors(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Collection handlerInterceptors = wac.getBeansOfType(HandlerInterceptor.class).values();
        return handlerInterceptors.toArray(new HandlerInterceptor[handlerInterceptors.size()]);
    }

    public static UrlMappingsHolder lookupUrlMappings(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }

    public static String getRequestURIForGrailsDispatchURI(HttpServletRequest request) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        if (request.getRequestURI().endsWith(DISPATCH_URI_SUFFIX)) {
            String path = pathHelper.getPathWithinApplication(request);
            if (path.startsWith(GRAILS_DISPATCH_SERVLET_NAME)) {
                path = path.substring(GRAILS_DISPATCH_SERVLET_NAME.length(), path.length());
            }
            return path.substring(0, path.length() - DISPATCH_URI_SUFFIX.length());
        }
        return pathHelper.getPathWithinApplication(request);
    }

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (GrailsApplication)wac.getBean("grailsApplication");
    }

    public static View resolveView(HttpServletRequest request, UrlMappingInfo info, String viewName, ViewResolver viewResolver) throws Exception {
        String controllerName = info.getControllerName();
        return WebUtils.resolveView(request, viewName, controllerName, viewResolver);
    }

    public static View resolveView(HttpServletRequest request, String viewName, String controllerName, ViewResolver viewResolver) throws Exception {
        View v;
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        if (viewName.startsWith(String.valueOf('/'))) {
            v = viewResolver.resolveViewName(viewName, webRequest.getLocale());
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append('/');
            if (controllerName != null) {
                buf.append(controllerName).append('/');
            }
            buf.append(viewName);
            v = viewResolver.resolveViewName(buf.toString(), webRequest.getLocale());
        }
        return v;
    }

    public static String buildDispatchUrlForMapping(UrlMappingInfo info) {
        StringBuilder forwardUrl = new StringBuilder();
        if (info.getViewName() != null) {
            String viewName = info.getViewName();
            forwardUrl.append('/').append(viewName);
        } else {
            forwardUrl.append(GRAILS_DISPATCH_SERVLET_NAME);
            forwardUrl.append('/').append(info.getControllerName());
            if (!StringUtils.isBlank((String)info.getActionName())) {
                forwardUrl.append('/').append(info.getActionName());
            }
            forwardUrl.append(DISPATCH_URI_SUFFIX);
        }
        return forwardUrl.toString();
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info) throws ServletException, IOException {
        return WebUtils.forwardRequestForUrlMappingInfo(request, response, info, Collections.EMPTY_MAP);
    }

    public static String forwardRequestForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) throws ServletException, IOException {
        String forwardUrl = WebUtils.buildDispatchUrlForMapping(info);
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        WebUtils.exposeRequestAttributes((ServletRequest)request, (Map)model);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        return forwardUrl;
    }

    public static String includeForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, Map model) {
        String includeUrl = WebUtils.buildDispatchUrlForMapping(info);
        return WebUtils.includeForUrl(includeUrl, request, response, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String includeForUrl(String includeUrl, HttpServletRequest request, HttpServletResponse response, Map model) {
        String string;
        RequestDispatcher dispatcher = request.getRequestDispatcher(includeUrl);
        HttpServletResponse wrapped = WrappedResponseHolder.getWrappedResponse();
        response = wrapped != null ? wrapped : response;
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        WebUtils.exposeRequestAttributes((ServletRequest)request, (Map)model);
        IncludeResponseWrapper responseWrapper = new IncludeResponseWrapper(response);
        try {
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)responseWrapper);
            dispatcher.include((ServletRequest)request, (ServletResponse)responseWrapper);
            string = responseWrapper.getContent();
        }
        catch (Throwable throwable) {
            try {
                WrappedResponseHolder.setWrappedResponse(wrapped);
                throw throwable;
            }
            catch (Exception e) {
                GrailsUtil.deepSanitize(e);
                throw new ControllerExecutionException("Unable to execute include: " + e.getMessage(), e);
            }
        }
        WrappedResponseHolder.setWrappedResponse(wrapped);
        return string;
    }

    public static String getFormatFromURI(String uri) {
        String lastToken;
        if (uri.endsWith("/")) {
            return null;
        }
        int idx = uri.lastIndexOf(47);
        if (idx > -1 && (idx = (lastToken = uri.substring(idx + 1, uri.length())).lastIndexOf(46)) > -1 && idx != lastToken.length() - 1) {
            return lastToken.substring(idx + 1);
        }
        return null;
    }

    public static boolean areFileExtensionsEnabled() {
        Map config = ConfigurationHolder.getFlatConfig();
        Object o = config.get(ENABLE_FILE_EXTENSIONS);
        return o == null || !(o instanceof Boolean) || (Boolean)o != false;
    }

    public static GrailsWebRequest retrieveGrailsWebRequest() {
        return (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
    }

    public static void storeGrailsWebRequest(GrailsWebRequest webRequest) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        webRequest.getRequest().setAttribute("org.codehaus.groovy.grails.WEB_REQUEST", (Object)webRequest);
    }

    public static void clearGrailsWebRequest() {
        RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
        if (reqAttrs != null) {
            GrailsWebRequest webRequest = (GrailsWebRequest)reqAttrs;
            webRequest.getRequest().removeAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
            RequestContextHolder.setRequestAttributes(null);
        }
    }

    public static String getForwardURI(HttpServletRequest request) {
        String result = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (StringUtils.isBlank((String)result)) {
            result = request.getRequestURI();
        }
        return result;
    }

    static class IncludeResponseWrapper
    extends HttpServletResponseWrapper {
        private FastStringWriter sw = new FastStringWriter();
        private PrintWriter pw = new PrintWriter(this.sw);
        private FastByteArrayOutputStream os = new FastByteArrayOutputStream();
        private ServletOutputStream sos = new ServletOutputStream(){

            public void write(int i) throws IOException {
                IncludeResponseWrapper.this.os.write(i);
            }
        };
        private boolean usingStream;
        private boolean usingWriter;
        private int status;

        public IncludeResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public void setStatus(int i) {
            this.status = i;
        }

        public int getStatus() {
            return this.status;
        }

        public void setContentType(String s) {
        }

        public void setLocale(Locale locale) {
        }

        public void sendError(int i, String s) throws IOException {
            this.setStatus(i);
        }

        public void sendError(int i) throws IOException {
            this.setStatus(i);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.usingWriter) {
                throw new IllegalStateException("Method getWriter() already called");
            }
            this.usingStream = true;
            return this.sos;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.usingStream) {
                throw new IllegalStateException("Method getOutputStream() already called");
            }
            this.usingWriter = true;
            return this.pw;
        }

        public String getContent() throws UnsupportedEncodingException {
            return this.getContent("UTF-8");
        }

        public String getContent(String encoding) throws UnsupportedEncodingException {
            if (this.usingWriter) {
                return this.sw.toString();
            }
            if (this.usingStream) {
                return this.os.toString(encoding);
            }
            return "".intern();
        }
    }
}

