/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.web.pages.GSPWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageScanner;
import org.codehaus.groovy.grails.web.pages.Tokens;
import org.codehaus.groovy.grails.web.taglib.GrailsTagRegistry;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public class GroovyPageParser
implements Tokens {
    public static final Log LOG = LogFactory.getLog(GroovyPageParser.class);
    private static final Pattern PARA_BREAK = Pattern.compile("/p>\\s*<p[^>]*>", 2);
    private static final Pattern ROW_BREAK = Pattern.compile("((/td>\\s*</tr>\\s*<)?tr[^>]*>\\s*<)?td[^>]*>", 2);
    private static final Pattern PARSE_TAG_FIRST_PASS = Pattern.compile("(\\s*(\\S+)\\s*=\\s*[\"]([^\"]*)[\"][\\s|>]{1}){1}");
    private static final Pattern PARSE_TAG_SECOND_PASS = Pattern.compile("(\\s*(\\S+)\\s*=\\s*[']([^']*)['][\\s|>]{1}){1}");
    private static final Pattern PAGE_DIRECTIVE_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*\"([^\"]*)\"");
    private GroovyPageScanner scan;
    private GSPWriter out;
    private String className;
    private boolean finalPass = false;
    private int tagIndex;
    private Map tagContext;
    private List tagMetaStack = new ArrayList();
    private GrailsTagRegistry tagRegistry = GrailsTagRegistry.getInstance();
    private Environment environment;
    private boolean currentlyBufferingWhitespace;
    private boolean previousContentWasNonWhitespace;
    private StringBuffer whitespaceBuffer = new StringBuffer();
    private int currentOutputLine = 1;
    private String contentType = "text/html;charset=UTF-8";
    private boolean doNextScan = true;
    private int state;
    private static final String START_MULTILINE_STRING = "'''";
    private static final String END_MULTILINE_STRING = "'''";
    private static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private Map constants = new TreeMap();
    private int constantCount = 0;
    private Map constantsToNames = new HashMap();
    private final String pageName;
    private static final String EMPTY_MULTILINE_STRING = "''''''";
    public static final String[] DEFAULT_IMPORTS = new String[]{"org.codehaus.groovy.grails.web.pages.GroovyPage", "org.codehaus.groovy.grails.web.taglib.*", "org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException", "org.springframework.web.util.*", "grails.util.GrailsUtil"};
    private static final String CONFIG_PROPERTY_DEFAULT_CODEC = "grails.views.default.codec";
    private static final String CONFIG_PROPERTY_GSP_ENCODING = "grails.views.gsp.encoding";
    private String codecClassName;
    private String codecName;
    private static final String IMPORT_DIRECTIVE = "import";
    private static final String CONTENT_TYPE_DIRECTIVE = "contentType";
    private static final String DEFAULT_CODEC_DIRECTIVE = "defaultCodec";
    private static final String PAGE_DIRECTIVE = "page";
    private static final String TAGLIB_DIRECTIVE = "taglib";
    private String gspEncoding;
    public static final String GROOVY_SOURCE_CHAR_ENCODING = "UTF-8";
    private Map jspTags = new HashMap();

    public String getContentType() {
        return this.contentType;
    }

    public int getCurrentOutputLineNumber() {
        return this.currentOutputLine;
    }

    public Map getJspTags() {
        return this.jspTags;
    }

    public GroovyPageParser(String name, String filename, InputStream in) throws IOException {
        Map config = ConfigurationHolder.getFlatConfig();
        Object gspEnc = config.get(CONFIG_PROPERTY_GSP_ENCODING);
        this.gspEncoding = gspEnc != null && gspEnc.toString().trim().length() > 0 ? gspEnc.toString() : System.getProperty("file.encoding", "us-ascii");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GSP file encoding set to: " + this.gspEncoding));
        }
        this.scan = new GroovyPageScanner(this.readStream(in));
        this.pageName = filename;
        this.environment = Environment.getCurrent();
        this.makeName(name);
        Object o = config.get(CONFIG_PROPERTY_DEFAULT_CODEC);
        this.lookupCodec(o);
    }

    private void lookupCodec(Object o) {
        if (o != null) {
            this.codecName = o.toString();
            GrailsApplication app = ApplicationHolder.getApplication();
            if (app != null) {
                GrailsClass codecClass = app.getArtefactByLogicalPropertyName("Codec", this.codecName);
                if (codecClass == null) {
                    codecClass = app.getArtefactByLogicalPropertyName("Codec", this.codecName.toUpperCase());
                }
                if (codecClass != null) {
                    this.codecClassName = codecClass.getFullName();
                }
            }
        }
    }

    public int[] getLineNumberMatrix() {
        return this.out.getLineNumbers();
    }

    public InputStream parse() {
        StringWriter sw = new StringWriter();
        this.out = new GSPWriter((Writer)sw, this);
        this.page();
        this.finalPass = true;
        this.scan.reset();
        this.previousContentWasNonWhitespace = false;
        this.currentlyBufferingWhitespace = false;
        this.page();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(sw.toString().getBytes(GROOVY_SOURCE_CHAR_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Grails cannot run unless your environment supports UTF-8!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compiled GSP into Groovy code: " + sw.toString()));
        }
        this.scan = null;
        return in;
    }

    private void declare(boolean gsp) {
        if (this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: declare");
        }
        this.out.println();
        this.write(this.scan.getToken().trim(), gsp);
        this.out.println();
        this.out.println();
    }

    private void direct() {
        if (this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: direct");
        }
        String text = this.scan.getToken();
        if ((text = text.trim()).startsWith(PAGE_DIRECTIVE)) {
            this.directPage(text);
        } else if (text.startsWith(TAGLIB_DIRECTIVE)) {
            this.directJspTagLib(text);
        }
    }

    private void directPage(String text) {
        text = text.trim();
        Matcher mat = PAGE_DIRECTIVE_PATTERN.matcher(text);
        int ix = 0;
        while (mat.find(ix)) {
            String name = mat.group(1);
            String value = mat.group(2);
            if (name.equals(IMPORT_DIRECTIVE)) {
                this.pageImport(value);
            }
            if (name.equals(CONTENT_TYPE_DIRECTIVE)) {
                this.contentType(value);
            }
            if (name.equals(DEFAULT_CODEC_DIRECTIVE)) {
                this.lookupCodec(value);
            }
            ix = mat.end();
        }
        return;
    }

    private void directJspTagLib(String text) {
        text = text.substring(TAGLIB_DIRECTIVE.length() + 1, text.length());
        HashMap attrs = new HashMap();
        this.populateMapWithAttributes(attrs, text + '>');
        String prefix = (String)attrs.get("\"prefix\"");
        String uri = (String)attrs.get("\"uri\"");
        if (uri != null && prefix != null) {
            String namespace = prefix.substring(1, prefix.length() - 1);
            if (!"g".equals(namespace)) {
                this.jspTags.put(namespace, uri.substring(1, uri.length() - 1));
            } else {
                LOG.error((Object)"You cannot override the default 'g' namespace with the directive <%@ taglib prefix=\"g\" %>. Please select another namespace.");
            }
        }
    }

    private void contentType(String value) {
        this.contentType = value;
    }

    private void scriptletExpr() {
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: expr");
        }
        String text = this.scan.getToken().trim();
        this.out.printlnToResponse(text);
    }

    private void expr() {
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: expr");
        }
        String text = this.scan.getToken().trim();
        text = this.getExpressionText(text);
        if (this.environment == Environment.DEVELOPMENT) {
            // empty if block
        }
        if (this.codecClassName != null) {
            this.out.printlnToResponse("Codec.encode(" + text + ")");
        } else {
            this.out.printlnToResponse(text);
        }
    }

    public String getExpressionText(String text) {
        if (this.environment == Environment.DEVELOPMENT) {
            boolean safeDereference = false;
            if (text.endsWith("?")) {
                text = text.substring(0, text.length() - 1);
                safeDereference = true;
            }
            text = "evaluate('" + text.replaceAll("'", "\\\\'") + "', " + this.getCurrentOutputLineNumber() + ", it) { return " + text + " }" + (safeDereference ? "?" : "");
        }
        return text;
    }

    private String[] splitLinesKeepingBlanks(String text) {
        ArrayList<String> results = new ArrayList<String>();
        int len = text.length();
        int pos = 0;
        while (pos < len) {
            int EOLpos = text.indexOf(10, pos);
            if (EOLpos >= 0) {
                results.add(text.substring(pos, EOLpos));
                pos = EOLpos + 1;
                continue;
            }
            results.add(text.substring(pos, len));
            pos = len;
        }
        return results.toArray(new String[results.size()]);
    }

    private void bufferedPrintlnToResponse(String s) {
        if (this.currentlyBufferingWhitespace) {
            this.whitespaceBuffer.append(s);
        } else {
            this.out.printlnToResponse(s);
        }
    }

    private void html() {
        boolean contentIsWhitespace;
        String text;
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: html");
        }
        if ((text = this.scan.getToken()).length() == 0) {
            return;
        }
        boolean bl = contentIsWhitespace = !Pattern.compile("\\S").matcher(text).find();
        if (!contentIsWhitespace && this.currentlyBufferingWhitespace) {
            this.flushBufferedWhiteSpace();
        } else {
            this.currentlyBufferingWhitespace = contentIsWhitespace;
        }
        this.previousContentWasNonWhitespace = !contentIsWhitespace;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String[] lines = this.splitLinesKeepingBlanks(text);
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            if (lines[0].length() == 0) {
                lines[0] = "\n";
            }
            this.bufferedPrintlnToResponse('\'' + this.escapeGroovy(lines[0]) + '\'');
        } else {
            pw.print("'''");
            String prevcontent = null;
            boolean firstLine = true;
            for (String line : lines) {
                if (line.length() == 0) {
                    line = "\n";
                }
                String content = this.escapeGroovy(line);
                if (firstLine) {
                    pw.print(content);
                    firstLine = false;
                } else {
                    if (!"\\n".equals(prevcontent)) {
                        this.incrementLineNumber();
                        pw.println();
                    }
                    pw.print(content);
                }
                prevcontent = content;
            }
            pw.print("'''");
            pw.println();
            String constantValue = sw.toString();
            String constantName = (String)this.constantsToNames.get(constantValue);
            if (constantName == null) {
                constantName = "STATIC_HTML_CONTENT_" + this.constantCount++;
                this.constants.put(constantName, constantValue);
                this.constantsToNames.put(constantValue, constantName);
            }
            this.bufferedPrintlnToResponse(constantName);
        }
    }

    private void makeName(String uri) {
        String name;
        int slash = uri.lastIndexOf(47);
        if (slash > -1) {
            name = uri.substring(slash + 1);
            uri = uri.substring(0, uri.length() - 1 - name.length());
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            slash = uri.lastIndexOf(47);
            if (slash > -1) {
                name = uri.substring(slash + 1) + '_' + name;
            }
        } else {
            name = uri;
        }
        StringBuffer buf = new StringBuffer(name.length());
        int ixz = name.length();
        for (int ix = 0; ix < ixz; ++ix) {
            int c = name.charAt(ix);
            if (c < 48 || c > 57 && c < 64 || c > 90 && c < 95 || c > 95 && c < 97 || c > 122) {
                c = 95;
            } else if (ix == 0 && c >= 48 && c <= 57) {
                c = 95;
            }
            buf.append((char)c);
        }
        this.className = buf.toString();
    }

    private static boolean match(CharSequence pat, CharSequence text, int start) {
        int ixy;
        int ix = start;
        int ixz = text.length();
        if (ixz > (ixy = start + pat.length())) {
            ixz = ixy;
        }
        if (pat.length() > ixz - start) {
            return false;
        }
        while (ix < ixz) {
            if (Character.toLowerCase(text.charAt(ix)) != Character.toLowerCase(pat.charAt(ix - start))) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    private static int match(Pattern pat, CharSequence text, int start) {
        Matcher mat = pat.matcher(text);
        if (mat.find(start) && mat.start() == start) {
            return mat.end();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void page() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: page");
        }
        if (this.finalPass) {
            this.out.println();
            this.out.print("class ");
            this.out.print(this.className);
            this.out.println(" extends GroovyPage {");
            this.out.println("public String getGroovyPageFileName() { \"" + this.pageName.replaceAll("\\\\", "/") + "\" }");
            this.out.println("public Object run() {");
            this.out.println("def params = binding.params");
            this.out.println("def request = binding.request");
            this.out.println("def flash = binding.flash");
            this.out.println("def response = binding.response");
            if (this.codecClassName != null) {
                this.out.println("request.setAttribute('org.codehaus.groovy.grails.GSP_CODEC', '" + this.codecName + "')");
            }
        }
        block14: while (true) {
            if (this.doNextScan) {
                this.state = this.scan.nextToken();
            } else {
                this.doNextScan = true;
            }
            if (this.state != 15 && this.state != 0) {
                this.flushBufferedWhiteSpace();
                this.previousContentWasNonWhitespace = false;
            }
            switch (this.state) {
                case -1: {
                    break block14;
                }
                case 0: {
                    this.html();
                    break;
                }
                case 1: {
                    this.scriptletExpr();
                    break;
                }
                case 2: {
                    this.script(false);
                    break;
                }
                case 3: {
                    this.direct();
                    break;
                }
                case 4: {
                    this.declare(false);
                    break;
                }
                case 11: {
                    this.expr();
                    break;
                }
                case 12: {
                    this.script(true);
                    break;
                }
                case 13: {
                    this.direct();
                    break;
                }
                case 14: {
                    this.declare(true);
                    break;
                }
                case 15: {
                    this.startTag();
                    break;
                }
                case 16: {
                    this.endTag();
                }
            }
        }
        if (this.finalPass) {
            if (!this.tagMetaStack.isEmpty()) {
                TagMeta tag = (TagMeta)this.tagMetaStack.iterator().next();
                throw new GrailsTagException("Grails tags were not closed! [" + this.tagMetaStack + "] in GSP " + this.pageName + "", this.pageName, this.out.getCurrentLineNumber());
            }
            this.out.println("}");
            Iterator i = this.constants.keySet().iterator();
            while (true) {
                if (!i.hasNext()) {
                    this.out.println("}");
                    return;
                }
                String name = (String)i.next();
                this.out.println("static final " + name + " = " + this.constants.get(name));
            }
        }
        int i = 0;
        while (true) {
            if (i >= DEFAULT_IMPORTS.length) {
                if (this.codecClassName == null) return;
                this.out.print("import ");
                this.out.print(this.codecClassName);
                this.out.println(" as Codec");
                return;
            }
            this.out.print("import ");
            this.out.println(DEFAULT_IMPORTS[i]);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void endTag() {
        if (!this.finalPass) {
            return;
        }
        String tagName = this.scan.getToken().trim();
        String ns = this.scan.getNamespace();
        if (this.tagMetaStack.isEmpty()) {
            throw new GrailsTagException("Found closing Grails tag with no opening [" + tagName + "]");
        }
        TagMeta tm = (TagMeta)this.tagMetaStack.remove(this.tagMetaStack.size() - 1);
        String lastInStack = tm.name;
        String lastNamespaceInStack = tm.namespace;
        if (StringUtils.isBlank((String)tagName)) {
            tagName = lastInStack;
        }
        if (!lastInStack.equals(tagName) || !lastNamespaceInStack.equals(ns)) {
            throw new GrailsTagException("Grails tag [" + lastNamespaceInStack + ":" + lastInStack + "] was not closed");
        }
        if ("g".equals(ns) && this.tagRegistry.isSyntaxTag(tagName)) {
            if (!(tm.instance instanceof GroovySyntaxTag)) throw new GrailsTagException("Grails tag [" + tagName + "] was not closed");
            GroovySyntaxTag tag = (GroovySyntaxTag)tm.instance;
            tag.doEndTag();
        } else {
            this.out.println("}");
            if (this.jspTags.containsKey(ns)) {
                String uri = (String)this.jspTags.get(ns);
                this.out.println("jspTag = tagLibraryResolver?.resolveTagLibrary('" + uri + "')?.getTag('" + tagName + "')");
                this.out.println("if(!jspTag) throw new GrailsTagException('Unknown JSP tag " + ns + ":" + tagName + "')");
                this.out.println("jspTag.doTag(out,attrs" + this.tagIndex + ", body" + this.tagIndex + ")");
            } else if (tm.hasAttributes) {
                this.out.println("invokeTag('" + tagName + "','" + ns + "'," + this.getCurrentOutputLineNumber() + ",attrs" + this.tagIndex + ",body" + this.tagIndex + ")");
            } else {
                this.out.println("invokeTag('" + tagName + "','" + ns + "'," + this.getCurrentOutputLineNumber() + ",[:],body" + this.tagIndex + ")");
            }
        }
        --this.tagIndex;
    }

    private void startTag() {
        String tagName;
        if (!this.finalPass) {
            return;
        }
        ++this.tagIndex;
        StringBuffer buf = new StringBuffer(this.scan.getToken().trim());
        String ns = this.scan.getNamespace();
        this.state = this.scan.nextToken();
        while (this.state != 0 && this.state != 16 && this.state != -1) {
            if (this.state == 17) {
                buf.append("${");
                buf.append(this.scan.getToken().trim());
                buf.append("}");
            } else {
                buf.append(this.scan.getToken().trim());
            }
            this.state = this.scan.nextToken();
        }
        this.doNextScan = false;
        String text = buf.toString();
        TreeMap attrs = new TreeMap();
        if ((text = text.replaceAll("[\r\n\t]", " ")).indexOf(32) > -1) {
            int i = text.indexOf(32);
            tagName = text.substring(0, i);
            String attrTokens = text.substring(i, text.length());
            attrTokens = attrTokens + '>';
            this.populateMapWithAttributes(attrs, attrTokens);
        } else {
            tagName = text;
        }
        if (this.state == -1) {
            throw new GrailsTagException("Unexpected end of file encountered parsing Tag [" + tagName + "] for " + this.className + ". Are you missing a closing brace '}'?");
        }
        TagMeta tm = new TagMeta();
        tm.name = tagName;
        tm.namespace = ns;
        tm.hasAttributes = !attrs.isEmpty();
        tm.lineNumber = this.getCurrentOutputLineNumber();
        this.tagMetaStack.add(tm);
        if ("g".equals(ns) && this.tagRegistry.isSyntaxTag(tagName)) {
            if (this.tagContext == null) {
                this.tagContext = new HashMap();
                this.tagContext.put("out", this.out);
                this.tagContext.put(GroovyPageParser.class, this);
            }
            GroovySyntaxTag tag = (GroovySyntaxTag)this.tagRegistry.newTag(tagName);
            tag.init(this.tagContext);
            tag.setAttributes(attrs);
            if (tag.isKeepPrecedingWhiteSpace() && this.currentlyBufferingWhitespace) {
                this.flushBufferedWhiteSpace();
            } else {
                if (!tag.isAllowPrecedingContent() && this.previousContentWasNonWhitespace) {
                    throw new GrailsTagException("Tag [" + tag.getName() + "] cannot have non-whitespace characters directly preceding it.");
                }
                this.clearBufferedWhiteSpace();
            }
            tag.doStartTag();
            tm.instance = tag;
        } else {
            this.flushBufferedWhiteSpace();
            if (attrs.size() > 0) {
                this.out.print("attrs" + this.tagIndex + " = [");
                Iterator i = attrs.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    this.out.print(name);
                    this.out.print(':');
                    this.out.print(this.getExpressionText(attrs.get(name).toString()));
                    if (i.hasNext()) {
                        this.out.print(',');
                        continue;
                    }
                    this.out.println(']');
                }
            }
            this.out.println("body" + this.tagIndex + " = new GroovyPageTagBody(this,binding.webRequest) {");
        }
    }

    private void clearBufferedWhiteSpace() {
        this.whitespaceBuffer.delete(0, this.whitespaceBuffer.length());
        this.currentlyBufferingWhitespace = false;
    }

    private void flushBufferedWhiteSpace() {
        if (this.currentlyBufferingWhitespace) {
            this.out.printlnToResponse(this.whitespaceBuffer.toString());
            this.clearBufferedWhiteSpace();
        }
        this.currentlyBufferingWhitespace = false;
    }

    private void populateMapWithAttributes(Map attrs, String attrTokens) {
        Matcher m = PARSE_TAG_FIRST_PASS.matcher(attrTokens);
        this.populateAttributesFromMatcher(m, attrs);
        m = PARSE_TAG_SECOND_PASS.matcher(attrTokens);
        this.populateAttributesFromMatcher(m, attrs);
    }

    private void populateAttributesFromMatcher(Matcher m, Map attrs) {
        while (m.find()) {
            String name = m.group(2);
            String val = m.group(3);
            name = '\"' + name + '\"';
            if (val.startsWith("${") && val.endsWith("}")) {
                val = val.substring(2, val.length() - 1);
            } else if (!val.startsWith("[") || !val.endsWith("]")) {
                val = '\"' + val + '\"';
            }
            attrs.put(name, val);
        }
    }

    private void pageImport(String value) {
        String[] imports = Pattern.compile(";").split(value.subSequence(0, value.length()));
        for (int ix = 0; ix < imports.length; ++ix) {
            this.out.print("import ");
            this.out.print(imports[ix]);
            this.out.println();
        }
    }

    private String escapeGroovy(CharSequence text) {
        StringBuffer buf = new StringBuffer();
        int ixz = text.length();
        for (int ix = 0; ix < ixz; ++ix) {
            char c = text.charAt(ix);
            String rep = null;
            if (c == '\n') {
                this.incrementLineNumber();
                rep = "\\n";
            } else if (c == '\r') {
                rep = "\\r";
            } else if (c == '\t') {
                rep = "\\t";
            } else if (c == '\'') {
                rep = "\\'";
            } else if (c == '\\') {
                rep = "\\\\";
            }
            if (rep != null) {
                buf.append(rep);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int read;
            byte[] buf = new byte[8192];
            while ((read = in.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
            String string = out.toString(this.gspEncoding);
            return string;
        }
        finally {
            out.close();
            in.close();
        }
    }

    private void script(boolean gsp) {
        if (!this.finalPass) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"parse: script");
        }
        this.out.println();
        this.write(this.scan.getToken().trim(), gsp);
        this.out.println();
        this.out.println();
    }

    private void write(CharSequence text, boolean gsp) {
        if (!gsp) {
            this.out.print(text);
            return;
        }
        int ixz = text.length();
        for (int ix = 0; ix < ixz; ++ix) {
            char c = text.charAt(ix);
            String rep = null;
            if (Character.isWhitespace(c)) {
                ++ix;
                while (ix < ixz) {
                    if (!Character.isWhitespace(text.charAt(ix))) {
                        --ix;
                        rep = " ";
                        break;
                    }
                    ++ix;
                }
            } else if (c == '&') {
                if (GroovyPageParser.match("&semi;", text, ix)) {
                    rep = ";";
                    ix += 5;
                } else if (GroovyPageParser.match("&amp;", text, ix)) {
                    rep = "&";
                    ix += 4;
                } else if (GroovyPageParser.match("&lt;", text, ix)) {
                    rep = "<";
                    ix += 3;
                } else if (GroovyPageParser.match("&gt;", text, ix)) {
                    rep = ">";
                    ix += 3;
                }
            } else if (c == '<') {
                if (GroovyPageParser.match("<br>", text, ix) || GroovyPageParser.match("<hr>", text, ix)) {
                    rep = "\n";
                    this.incrementLineNumber();
                    ix += 3;
                } else {
                    int end = GroovyPageParser.match(PARA_BREAK, text, ix);
                    if (end <= 0) {
                        end = GroovyPageParser.match(ROW_BREAK, text, ix);
                    }
                    if (end > 0) {
                        rep = "\n";
                        this.incrementLineNumber();
                        ix = end;
                    }
                }
            }
            if (rep != null) {
                this.out.print(rep);
                continue;
            }
            this.out.print(c);
        }
    }

    private void incrementLineNumber() {
        ++this.currentOutputLine;
    }

    class TagMeta {
        String name;
        String namespace;
        Object instance;
        boolean isDynamic;
        boolean hasAttributes;
        int lineNumber;

        TagMeta() {
        }

        public String toString() {
            return "<" + this.namespace + ":" + this.name + ">";
        }
    }
}

