/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import org.codehaus.groovy.grails.web.pages.GroovyPageParser;

public class GSPWriter
extends PrintWriter {
    private int lineNumber = 1;
    private int[] lineNumbers = new int[1000];
    private GroovyPageParser parse;

    public GSPWriter(Writer out, GroovyPageParser parse) {
        super(out);
        this.parse = parse;
    }

    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
    }

    public void printlnToResponse(String s) {
        if (s == null) {
            s = "''";
        }
        super.print("out.print(");
        super.print(s);
        super.print(")");
        this.println();
    }

    public void printlnToBuffer(String s, int index) {
        if (s == null) {
            s = "''";
        }
        super.print("buf" + index + " << ");
        super.print(s);
        this.println();
    }

    public void println() {
        if (this.lineNumber >= this.lineNumbers.length) {
            this.lineNumbers = (int[])this.resizeArray(this.lineNumbers, this.lineNumbers.length * 2);
        } else {
            this.lineNumbers[this.lineNumber - 1] = this.parse.getCurrentOutputLineNumber();
            ++this.lineNumber;
        }
        super.println();
    }

    private Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public int getCurrentLineNumber() {
        return this.lineNumber;
    }

    public int[] getLineNumbers() {
        return this.lineNumbers;
    }
}

