/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GSPResponseWriter
extends PrintWriter {
    private static final Log LOG = LogFactory.getLog(GSPResponseWriter.class);
    private ServletResponse response;
    private CharArrayWriter out0 = new CharArrayWriter();
    private Writer out1;
    private int max;
    private boolean trouble = false;
    private int totalLength;
    private static final String BLANK_STRING = "";

    private GSPResponseWriter(ServletResponse response, CharArrayWriter out, int max) {
        super(out);
        this.response = response;
        this.out0 = out;
        this.max = max;
    }

    private GSPResponseWriter(Writer writer, CharArrayWriter out, int max) {
        super(out);
        this.out0 = out;
        this.out1 = writer;
        this.max = max;
    }

    public boolean checkError() {
        if (super.checkError()) {
            return true;
        }
        return this.trouble;
    }

    public void close() {
        if (!this.response.isCommitted()) {
            try {
                this.response.setContentLength(this.totalLength += this.getContentLength(this.out0.toString()));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("Encoding error setting content length: " + e.getMessage()), (Throwable)e);
            }
        }
        this.flush();
        super.close();
    }

    public synchronized void flush() {
        if (this.trouble) {
            return;
        }
        super.flush();
        if (this.out1 == null) {
            try {
                this.out1 = this.response.getWriter();
            }
            catch (IOException e) {
                LOG.debug((Object)("I/O excepton flushing output in GSP response writer: " + e.getMessage()), (Throwable)e);
                this.trouble = true;
                return;
            }
        }
        try {
            String contents = this.out0.toString();
            this.out1.write(contents.toCharArray());
            try {
                this.totalLength += this.getContentLength(contents);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("Encoding error getting content length: " + e.getMessage()), (Throwable)e);
            }
            this.out0.reset();
        }
        catch (IOException e) {
            LOG.debug((Object)("I/O excepton flushing output in GSP response writer: " + e.getMessage()), (Throwable)e);
            this.trouble = true;
        }
    }

    private int getContentLength(String contents) throws UnsupportedEncodingException {
        return contents.getBytes(this.response.getCharacterEncoding()).length;
    }

    public static GSPResponseWriter getInstance(ServletResponse response, int max) {
        return new GSPResponseWriter(response, new CharArrayWriter(max), max);
    }

    public static GSPResponseWriter getInstance(Writer target, int max) {
        return new GSPResponseWriter(target, new CharArrayWriter(max), max);
    }

    public void print(Object obj) {
        String out;
        if (obj == null) {
            obj = BLANK_STRING;
        }
        if ((out = String.valueOf(obj)) == null) {
            out = BLANK_STRING;
        }
        this.write(out);
    }

    public void print(String s) {
        if (s == null) {
            s = BLANK_STRING;
        }
        this.write(s);
    }

    public void write(String s) {
        if (s == null) {
            s = BLANK_STRING;
        }
        super.write(s);
    }

    public void write(int c) {
        if (this.trouble) {
            return;
        }
        super.write(c);
        if (this.out0.size() >= this.max) {
            this.flush();
        }
    }

    public void write(char[] buf, int off, int len) {
        if (this.trouble || buf == null || len == 0) {
            return;
        }
        super.write(buf, off, len);
        if (this.out0.size() >= this.max) {
            this.flush();
        }
    }

    public void write(String s, int off, int len) {
        if (this.trouble || s == null || s.length() == 0) {
            return;
        }
        super.write(s, off, len);
        if (this.out0.size() >= this.max) {
            this.flush();
        }
    }

    public GSPResponseWriter leftShift(Object value) throws IOException {
        if (value == null) {
            value = BLANK_STRING;
        }
        InvokerHelper.write((Writer)this, (Object)value);
        return this;
    }
}

