/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsMetaClassUtils;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerHolder;
import org.codehaus.groovy.grails.plugins.support.aware.ClassLoaderAware;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.ConstrainedPropertyBuilder;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingParser;
import org.codehaus.groovy.grails.web.mapping.RegexUrlMapping;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeMappingData;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeUrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.codehaus.groovy.grails.web.mapping.UrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.UrlMappingParser;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.plugins.support.WebMetaUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.Resource;

public class DefaultUrlMappingEvaluator
implements UrlMappingEvaluator,
ClassLoaderAware {
    private static final Log LOG = LogFactory.getLog(UrlMappingBuilder.class);
    private GroovyClassLoader classLoader = new GroovyClassLoader();
    private UrlMappingParser urlParser = new DefaultUrlMappingParser();
    private ServletContext servletContext;
    private static final String EXCEPTION = "exception";
    private static final String PARSE_REQUEST = "parseRequest";
    private static final String RESOURCE = "resource";
    private static final Map<String, String> DEFAULT_REST_MAPPING = new HashMap<String, String>(){
        {
            this.put("GET", "show");
            this.put("POST", "save");
            this.put("PUT", "update");
            this.put("DELETE", "delete");
        }
    };

    public DefaultUrlMappingEvaluator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public List evaluateMappings(Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            List list = this.evaluateMappings(this.classLoader.parseClass(inputStream));
            return list;
        }
        catch (IOException e) {
            throw new UrlMappingException("Unable to read mapping file [" + resource.getFilename() + "]: " + e.getMessage(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public List evaluateMappings(Class theClass) {
        GroovyObject obj = (GroovyObject)BeanUtils.instantiateClass((Class)theClass);
        if (obj instanceof Script) {
            Script script = (Script)obj;
            Binding b = new Binding();
            MappingCapturingClosure closure = new MappingCapturingClosure(script);
            b.setVariable("mappings", (Object)closure);
            script.setBinding(b);
            script.run();
            Closure mappings = closure.getMappings();
            UrlMappingBuilder builder = new UrlMappingBuilder(script.getBinding(), this.servletContext);
            mappings.setDelegate((Object)builder);
            mappings.call();
            builder.urlDefiningMode = false;
            this.configureUrlMappingDynamicObjects(script);
            return builder.getUrlMappings();
        }
        throw new UrlMappingException("Unable to configure URL mappings for class [" + theClass + "]. A URL mapping must be an instance of groovy.lang.Script.");
    }

    public List evaluateMappings(Closure closure) {
        UrlMappingBuilder builder = new UrlMappingBuilder(null, this.servletContext);
        closure.setDelegate((Object)builder);
        closure.setResolveStrategy(1);
        closure.call();
        builder.urlDefiningMode = false;
        List mappings = builder.getUrlMappings();
        this.configureUrlMappingDynamicObjects(closure);
        return mappings;
    }

    private void configureUrlMappingDynamicObjects(Script script) {
        GrailsPluginManager manager = PluginManagerHolder.getPluginManager();
        if (manager != null) {
            GrailsPlugin controllerPlugin = manager.getGrailsPlugin("controllers");
            GroovyObject pluginInstance = controllerPlugin.getInstance();
            WebMetaUtils.registerCommonWebProperties((MetaClass)GrailsMetaClassUtils.getExpandoMetaClass(script.getClass()), null);
        }
    }

    private void configureUrlMappingDynamicObjects(Object object) {
        GrailsPluginManager manager = PluginManagerHolder.getPluginManager();
        if (manager != null) {
            GrailsPlugin controllerPlugin = manager.getGrailsPlugin("controllers");
            GroovyObject pluginInstance = controllerPlugin.getInstance();
            WebMetaUtils.registerCommonWebProperties((MetaClass)GrailsMetaClassUtils.getExpandoMetaClass(object.getClass()), null);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (!(classLoader instanceof GroovyClassLoader)) {
            throw new IllegalArgumentException("Property [classLoader] must be an instance of GroovyClassLoader");
        }
        this.classLoader = (GroovyClassLoader)classLoader;
    }

    class UrlMappingBuilder
    extends GroovyObjectSupport {
        private static final String CAPTURING_WILD_CARD = "(*)";
        private static final String SLASH = "/";
        private static final String CONSTRAINTS = "constraints";
        private boolean urlDefiningMode = true;
        private List<ConstrainedProperty> previousConstraints = new ArrayList<ConstrainedProperty>();
        private List urlMappings = new ArrayList();
        private Map parameterValues = new HashMap();
        private Binding binding;
        private Object actionName = null;
        private Object controllerName = null;
        private Object viewName = null;
        private ServletContext servletContext;
        private Object exception;
        private Object parseRequest;

        public UrlMappingBuilder(Binding binding, ServletContext servletContext) {
            this.binding = binding;
            this.servletContext = servletContext;
        }

        public List getUrlMappings() {
            return this.urlMappings;
        }

        public Object getProperty(String name) {
            if (this.urlDefiningMode) {
                this.previousConstraints.add(new ConstrainedProperty(UrlMapping.class, name, String.class));
                return CAPTURING_WILD_CARD;
            }
            return super.getProperty(name);
        }

        public Object getException() {
            return this.exception;
        }

        public void setException(Object exception) {
            this.exception = exception;
        }

        public void setAction(Object action) {
            this.actionName = action;
        }

        public Object getAction() {
            return this.actionName;
        }

        public void setController(Object controller) {
            this.controllerName = controller;
        }

        public Object getController() {
            return this.controllerName;
        }

        public Object getView() {
            return this.viewName;
        }

        public void setView(String viewName) {
            this.viewName = viewName;
        }

        public Object invokeMethod(String methodName, Object arg) {
            if (this.binding == null) {
                return this.invokeMethodClosure(methodName, arg);
            }
            return this.invokeMethodScript(methodName, arg);
        }

        private Object invokeMethodScript(String methodName, Object arg) {
            return this._invoke(methodName, arg, null);
        }

        private Object invokeMethodClosure(String methodName, Object arg) {
            return this._invoke(methodName, arg, (Object)this);
        }

        void propertyMissing(String name, Object value) {
            this.parameterValues.put(name, value);
        }

        Object propertyMissing(String name) {
            return this.parameterValues.get(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object _invoke(String methodName, Object arg, Object delegate) {
            Object[] args = (Object[])arg;
            boolean isResponseCode = this.isResponseCode(methodName);
            if (methodName.startsWith(SLASH) || isResponseCode) {
                this.parameterValues = new HashMap();
                try {
                    Object[] objectArray;
                    this.urlDefiningMode = false;
                    if (args != null && args.length > 0) {
                        objectArray = args;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = Collections.EMPTY_MAP;
                    }
                    args = objectArray;
                    if (args[0] instanceof Closure) {
                        Object viewName;
                        Object actionName;
                        Object controllerName;
                        UrlMappingData urlData = this.createUrlMappingData(methodName, isResponseCode);
                        Closure callable = (Closure)args[0];
                        if (delegate != null) {
                            callable.setDelegate(delegate);
                        }
                        callable.call();
                        if (this.binding != null) {
                            controllerName = this.binding.getVariables().get("controller");
                            actionName = this.binding.getVariables().get("action");
                            viewName = this.binding.getVariables().get("view");
                        } else {
                            controllerName = this.controllerName;
                            actionName = this.actionName;
                            viewName = this.viewName;
                        }
                        ConstrainedProperty[] constraints = this.previousConstraints.toArray(new ConstrainedProperty[this.previousConstraints.size()]);
                        UrlMapping urlMapping = this.createURLMapping(urlData, isResponseCode, controllerName, actionName, viewName, constraints);
                        this.configureUrlMapping(urlMapping);
                        UrlMapping urlMapping2 = urlMapping;
                        return urlMapping2;
                    }
                    if (args[0] instanceof Map) {
                        Map namedArguments = (Map)args[0];
                        UrlMappingData urlData = this.createUrlMappingData(methodName, isResponseCode);
                        if (args.length > 1 && args[1] instanceof Closure) {
                            Closure callable = (Closure)args[1];
                            callable.call();
                        }
                        UrlMapping urlMapping = this.getURLMappingForNamedArgs(namedArguments, urlData, methodName, isResponseCode);
                        this.configureUrlMapping(urlMapping);
                        UrlMapping actionName = urlMapping;
                        return actionName;
                    }
                    Object namedArguments = null;
                    return namedArguments;
                }
                finally {
                    if (this.binding != null) {
                        this.binding.getVariables().clear();
                    } else {
                        this.controllerName = null;
                        this.actionName = null;
                        this.viewName = null;
                    }
                    this.previousConstraints.clear();
                    this.urlDefiningMode = true;
                }
            }
            if (!this.urlDefiningMode && CONSTRAINTS.equals(methodName)) {
                ConstrainedPropertyBuilder builder = new ConstrainedPropertyBuilder((Object)this);
                if (args.length > 0 && args[0] instanceof Closure) {
                    Closure callable = (Closure)args[0];
                    callable.setDelegate((Object)builder);
                    for (ConstrainedProperty constrainedProperty : this.previousConstraints) {
                        builder.getConstrainedProperties().put(constrainedProperty.getPropertyName(), constrainedProperty);
                    }
                    callable.call();
                }
                return builder.getConstrainedProperties();
            }
            return super.invokeMethod(methodName, arg);
        }

        private void configureUrlMapping(UrlMapping urlMapping) {
            if (this.binding != null) {
                Map vars = this.binding.getVariables();
                for (Object key : vars.keySet()) {
                    if (!this.isNotCoreMappingKey(key)) continue;
                    this.parameterValues.put(key, vars.get(key));
                }
                this.binding.getVariables().clear();
            }
            if (urlMapping.getControllerName() != null) {
                this.parameterValues.put("controller", urlMapping.getControllerName());
            }
            if (urlMapping.getActionName() != null) {
                this.parameterValues.put("action", urlMapping.getActionName());
            }
            urlMapping.setParameterValues(this.parameterValues);
            this.urlMappings.add(urlMapping);
        }

        private boolean isNotCoreMappingKey(Object key) {
            return !"action".equals(key) && !"controller".equals(key) && !"view".equals(key);
        }

        private UrlMappingData createUrlMappingData(String methodName, boolean responseCode) {
            UrlMappingData urlData = !responseCode ? DefaultUrlMappingEvaluator.this.urlParser.parse(methodName) : new ResponseCodeMappingData(methodName);
            return urlData;
        }

        private boolean isResponseCode(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private UrlMapping getURLMappingForNamedArgs(Map namedArguments, UrlMappingData urlData, String mapping, boolean isResponseCode) {
            Object actionName;
            Object controllerName;
            Map bindingVariables = this.binding != null ? this.binding.getVariables() : null;
            boolean restRequest = false;
            if (namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCE)) {
                controllerName = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCE);
                actionName = DEFAULT_REST_MAPPING;
                restRequest = true;
            } else {
                controllerName = this.getControllerName(namedArguments, bindingVariables);
                actionName = this.getActionName(namedArguments, bindingVariables);
            }
            Object viewName = this.getViewName(namedArguments, bindingVariables);
            if (actionName != null && viewName != null) {
                viewName = null;
                LOG.warn((Object)("Both [action] and [view] specified in URL mapping [" + mapping + "]. The action takes precendence!"));
            }
            ConstrainedProperty[] constraints = this.previousConstraints.toArray(new ConstrainedProperty[this.previousConstraints.size()]);
            UrlMapping urlMapping = this.createURLMapping(urlData, isResponseCode, controllerName, actionName, viewName, constraints);
            Object exceptionArg = this.getException(namedArguments, bindingVariables);
            if (isResponseCode && exceptionArg != null) {
                if (exceptionArg instanceof Class) {
                    Class exClass = (Class)exceptionArg;
                    if (Throwable.class.isAssignableFrom(exClass)) {
                        ((ResponseCodeUrlMapping)urlMapping).setExceptionType(exClass);
                    } else {
                        LOG.error((Object)("URL mapping argument [exception] with value [" + exceptionArg + "] must be a subclass of java.lang.Throwable"));
                    }
                } else {
                    LOG.error((Object)("URL mapping argument [exception] with value [" + exceptionArg + "] must be a valid class"));
                }
            }
            if (restRequest) {
                urlMapping.setParseRequest(true);
            } else {
                Object parseRequest = this.getParseRequest(namedArguments, bindingVariables);
                if (parseRequest instanceof Boolean) {
                    urlMapping.setParseRequest((Boolean)parseRequest);
                }
            }
            return urlMapping;
        }

        private Object getVariableFromNamedArgsOrBinding(Map namedArguments, Map bindingVariables, String variableName, Object defaultValue) {
            Object returnValue = namedArguments.get(variableName);
            if (returnValue == null) {
                returnValue = this.binding != null ? bindingVariables.get(variableName) : defaultValue;
            }
            return returnValue;
        }

        private Object getActionName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "action", this.actionName);
        }

        private Object getParseRequest(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.PARSE_REQUEST, this.parseRequest);
        }

        private Object getControllerName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "controller", this.controllerName);
        }

        private Object getViewName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "view", this.viewName);
        }

        private Object getException(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.EXCEPTION, this.exception);
        }

        private UrlMapping createURLMapping(UrlMappingData urlData, boolean isResponseCode, Object controllerName, Object actionName, Object viewName, ConstrainedProperty[] constraints) {
            if (!isResponseCode) {
                return new RegexUrlMapping(urlData, controllerName, actionName, viewName, constraints, this.servletContext);
            }
            return new ResponseCodeUrlMapping(urlData, controllerName, actionName, viewName, null, this.servletContext);
        }
    }

    class MappingCapturingClosure
    extends Closure {
        private Closure mappings;

        public Closure getMappings() {
            return this.mappings;
        }

        public MappingCapturingClosure(Object o) {
            super(o);
        }

        public Object call(Object[] args) {
            if (args.length > 0 && args[0] instanceof Closure) {
                this.mappings = (Closure)args[0];
            }
            return null;
        }
    }
}

