/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.core.GrailsApplication;
import grails.core.support.ClassLoaderAware;
import grails.gorm.validation.ConstrainedProperty;
import grails.gorm.validation.DefaultConstrainedProperty;
import grails.io.IOUtils;
import grails.plugins.GrailsPluginManager;
import grails.plugins.PluginManagerAware;
import grails.util.GrailsUtil;
import grails.web.mapping.UrlMapping;
import grails.web.mapping.UrlMappingData;
import grails.web.mapping.UrlMappingEvaluator;
import grails.web.mapping.UrlMappingParser;
import grails.web.mapping.exceptions.UrlMappingException;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.grails.datastore.gorm.validation.constraints.builder.ConstrainedPropertyBuilder;
import org.grails.datastore.gorm.validation.constraints.eval.ConstraintsEvaluator;
import org.grails.datastore.gorm.validation.constraints.eval.DefaultConstraintEvaluator;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.gorm.validation.constraints.registry.DefaultConstraintRegistry;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValueMappingContext;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.web.mapping.DefaultUrlMappingParser;
import org.grails.web.mapping.MetaMappingInfo;
import org.grails.web.mapping.RegexUrlMapping;
import org.grails.web.mapping.ResponseCodeMappingData;
import org.grails.web.mapping.ResponseCodeUrlMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class DefaultUrlMappingEvaluator
implements UrlMappingEvaluator,
ClassLoaderAware,
PluginManagerAware {
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_INDEX = "index";
    public static final String ACTION_SHOW = "show";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_PATCH = "patch";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_SAVE = "save";
    public static final List<String> DEFAULT_RESOURCES_INCLUDES = Arrays.asList("index", "create", "save", "show", "edit", "update", "patch", "delete");
    public static final List<String> DEFAULT_RESOURCE_INCLUDES = Arrays.asList("create", "save", "show", "edit", "update", "patch", "delete");
    private static final Logger LOG = LoggerFactory.getLogger(UrlMappingBuilder.class);
    private GroovyClassLoader classLoader = new GroovyClassLoader();
    private UrlMappingParser urlParser = new DefaultUrlMappingParser();
    private static final String EXCEPTION = "exception";
    private static final String PARSE_REQUEST = "parseRequest";
    private static final String SINGLE = "single";
    private static final String RESOURCE = "resource";
    private static final String RESOURCES = "resources";
    private GrailsPluginManager pluginManager;
    private ApplicationContext applicationContext;
    private GrailsApplication grailsApplication;
    private final ConstraintRegistry constraintRegistry;
    private final ConstraintsEvaluator constraintsEvaluator;

    public DefaultUrlMappingEvaluator(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext != null) {
            ConstraintsEvaluator constraintEvaluator;
            ConstraintRegistry constraintRegistry;
            this.grailsApplication = (GrailsApplication)applicationContext.getBean(GrailsApplication.class);
            try {
                constraintRegistry = (ConstraintRegistry)applicationContext.getBean(ConstraintRegistry.class);
            }
            catch (BeansException e) {
                constraintRegistry = new DefaultConstraintRegistry((MessageSource)applicationContext);
            }
            this.constraintRegistry = constraintRegistry;
            try {
                constraintEvaluator = (ConstraintsEvaluator)applicationContext.getBean(ConstraintsEvaluator.class);
            }
            catch (BeansException e) {
                constraintEvaluator = new DefaultConstraintEvaluator(constraintRegistry, (MappingContext)new KeyValueMappingContext("test"), Collections.emptyMap());
            }
            this.constraintsEvaluator = constraintEvaluator;
        } else {
            StaticMessageSource messageSource = new StaticMessageSource();
            this.constraintRegistry = new DefaultConstraintRegistry((MessageSource)messageSource);
            this.constraintsEvaluator = new DefaultConstraintEvaluator((MessageSource)messageSource);
        }
    }

    public List evaluateMappings(Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            List<UrlMapping> list = this.evaluateMappings(this.classLoader.parseClass(IOGroovyMethods.getText((InputStream)inputStream, (String)"UTF-8")));
            return list;
        }
        catch (IOException e) {
            throw new UrlMappingException("Unable to read mapping file [" + resource.getFilename() + "]: " + e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    public List<UrlMapping> evaluateMappings(Class theClass) {
        GroovyObject obj = (GroovyObject)BeanUtils.instantiateClass((Class)theClass);
        if (obj instanceof Script) {
            Script script = (Script)obj;
            Binding b = new Binding();
            MappingCapturingClosure closure = new MappingCapturingClosure(script);
            b.setVariable("mappings", (Object)closure);
            script.setBinding(b);
            script.run();
            Closure<?> mappings = closure.getMappings();
            Binding binding = script.getBinding();
            return this.evaluateMappings((GroovyObject)script, mappings, binding);
        }
        throw new UrlMappingException("Unable to configure URL mappings for class [" + theClass + "]. A URL mapping must be an instance of groovy.lang.Script.");
    }

    private List<UrlMapping> evaluateMappings(GroovyObject go, Closure<?> mappings, Binding binding) {
        UrlMappingBuilder builder = new UrlMappingBuilder(binding);
        mappings.setDelegate((Object)builder);
        mappings.call();
        builder.urlDefiningMode = false;
        return builder.getUrlMappings();
    }

    @Override
    public List<UrlMapping> evaluateMappings(Closure closure) {
        UrlMappingBuilder builder = new UrlMappingBuilder((Binding)null);
        closure.setDelegate((Object)builder);
        closure.setResolveStrategy(1);
        if (closure.getParameterTypes().length == 0) {
            closure.call();
        } else {
            closure.call((Object)this.applicationContext);
        }
        builder.urlDefiningMode = false;
        return builder.getUrlMappings();
    }

    public void setClassLoader(ClassLoader classLoader) {
        Assert.isInstanceOf(GroovyClassLoader.class, (Object)classLoader, (String)"Property [classLoader] must be an instance of GroovyClassLoader");
        this.classLoader = (GroovyClassLoader)classLoader;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    class UrlGroupMappingRecursionBuilder
    extends UrlMappingBuilder {
        private UrlMappingBuilder.ParentResource parentResource;

        public UrlGroupMappingRecursionBuilder(UrlMappingBuilder parent, UrlMappingBuilder.ParentResource parentResource) {
            super(parent);
            this.parentResource = parentResource;
        }

        @Override
        public void group(String uri, Closure mappings) {
            if (this.parentResource != null) {
                uri = this.parentResource.uri.concat(uri);
            }
            super.group(uri, mappings);
        }
    }

    class UrlMappingBuilder
    extends GroovyObjectSupport {
        private static final String CAPTURING_WILD_CARD = "(*)";
        private static final String SLASH = "/";
        private static final String CONSTRAINTS = "constraints";
        private boolean urlDefiningMode = true;
        private boolean inGroupConstraints = false;
        private List<ConstrainedProperty> previousConstraints = new ArrayList<ConstrainedProperty>();
        private List<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
        private Map<String, Object> parameterValues = new HashMap<String, Object>();
        private Binding binding;
        private Object exception;
        private Object parseRequest;
        private Deque<ParentResource> parentResources = new ArrayDeque<ParentResource>();
        private Deque<MetaMappingInfo> mappingInfoDeque = new ArrayDeque<MetaMappingInfo>();
        private boolean isInCollection;

        public UrlMappingBuilder(Binding binding) {
            this.binding = binding;
        }

        protected UrlMappingBuilder(UrlMappingBuilder parent) {
            this(parent.binding);
            this.urlDefiningMode = parent.urlDefiningMode;
            this.previousConstraints = parent.previousConstraints;
            this.inGroupConstraints = parent.inGroupConstraints;
            this.urlMappings = parent.urlMappings;
            this.parameterValues = parent.parameterValues;
            this.exception = parent.exception;
            this.parseRequest = parent.parseRequest;
            this.parentResources = parent.parentResources;
            this.mappingInfoDeque = parent.mappingInfoDeque;
        }

        public List<UrlMapping> getUrlMappings() {
            return this.urlMappings;
        }

        public ServletContext getServletContext() {
            ApplicationContext ctx = this.getApplicationContext();
            if (ctx instanceof WebApplicationContext) {
                return ((WebApplicationContext)ctx).getServletContext();
            }
            return null;
        }

        public ApplicationContext getApplicationContext() {
            return DefaultUrlMappingEvaluator.this.applicationContext;
        }

        public GrailsApplication getGrailsApplication() {
            return DefaultUrlMappingEvaluator.this.grailsApplication;
        }

        public Object getProperty(String name) {
            if (this.urlDefiningMode) {
                DefaultConstrainedProperty newConstrained = new DefaultConstrainedProperty(UrlMapping.class, name, String.class, DefaultUrlMappingEvaluator.this.constraintRegistry);
                this.previousConstraints.add((ConstrainedProperty)newConstrained);
                return CAPTURING_WILD_CARD;
            }
            return super.getProperty(name);
        }

        public Object getException() {
            return this.exception;
        }

        public void setException(Object exception) {
            this.exception = exception;
        }

        public Object getUri() {
            return this.getMetaMappingInfo().getUri();
        }

        public void setUri(Object uri) {
            this.getMetaMappingInfo().setUri(uri);
        }

        public void setAction(Object action) {
            this.getMetaMappingInfo().setAction(action);
        }

        public Object getAction() {
            return this.getMetaMappingInfo().getAction();
        }

        public void setController(Object controller) {
            this.getMetaMappingInfo().setController(controller);
        }

        public Object getController() {
            return this.getMetaMappingInfo().getController();
        }

        public void setRedirectInfo(Object redirectInfo) {
            this.getMetaMappingInfo().setRedirectInfo(redirectInfo);
        }

        public Object getRedirectInfo() {
            return this.getMetaMappingInfo().getRedirectInfo();
        }

        public void setPlugin(Object plugin) {
            this.getMetaMappingInfo().setPlugin(plugin);
        }

        public Object getPlugin() {
            return this.getMetaMappingInfo().getPlugin();
        }

        public void setNamespace(Object namespace) {
            this.getMetaMappingInfo().setNamespace(namespace);
        }

        public Object getNamespace() {
            return this.getMetaMappingInfo().getNamespace();
        }

        public Object getView() {
            return this.getMetaMappingInfo().getView();
        }

        public void setView(String viewName) {
            this.getMetaMappingInfo().setView(viewName);
        }

        public void setMethod(Object method) {
            this.getMetaMappingInfo().setHttpMethod(method.toString());
        }

        public Object getMethod() {
            return this.getMetaMappingInfo().getHttpMethod();
        }

        public void name(Map<String, UrlMapping> m) {
            for (Map.Entry<String, UrlMapping> entry : m.entrySet()) {
                entry.getValue().setMappingName(entry.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void group(String uri, Closure mappings) {
            try {
                ParentResource parentResource = new ParentResource(null, uri, true, true);
                this.parentResources.push(parentResource);
                this.pushNewMetaMappingInfo();
                UrlGroupMappingRecursionBuilder builder = new UrlGroupMappingRecursionBuilder(this, parentResource);
                mappings.setDelegate((Object)builder);
                mappings.setResolveStrategy(1);
                mappings.call();
                this.inGroupConstraints = false;
            }
            finally {
                this.mappingInfoDeque.pop();
                this.parentResources.pop();
            }
        }

        public Object invokeMethod(String methodName, Object arg) {
            if (this.binding == null) {
                return this.invokeMethodClosure(methodName, arg);
            }
            return this.invokeMethodScript(methodName, arg);
        }

        private Object invokeMethodScript(String methodName, Object arg) {
            return this._invoke(methodName, arg, null);
        }

        private Object invokeMethodClosure(String methodName, Object arg) {
            return this._invoke(methodName, arg, (Object)this);
        }

        void propertyMissing(String name, Object value) {
            this.parameterValues.put(name, value);
        }

        Object propertyMissing(String name) {
            return this.parameterValues.get(name);
        }

        public UrlMapping get(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.GET.toString());
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping get(Map arguments, String uri) {
            return this.get(arguments, uri, null);
        }

        public UrlMapping get(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.GET.toString();
            return regexUrlMapping;
        }

        public UrlMapping post(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.POST);
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping post(Map arguments, String uri) {
            return this.post(arguments, uri, null);
        }

        public UrlMapping post(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.POST.toString();
            return regexUrlMapping;
        }

        public UrlMapping put(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.PUT);
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping put(Map arguments, String uri) {
            return this.put(arguments, uri, null);
        }

        public UrlMapping put(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.PUT.toString();
            return regexUrlMapping;
        }

        public UrlMapping patch(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.PATCH);
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping patch(Map arguments, String uri) {
            return this.patch(arguments, uri, null);
        }

        public UrlMapping patch(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.PATCH.toString();
            return regexUrlMapping;
        }

        public UrlMapping delete(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.DELETE);
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping delete(Map arguments, String uri) {
            return this.delete(arguments, uri, null);
        }

        public UrlMapping delete(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.DELETE.toString();
            return regexUrlMapping;
        }

        public UrlMapping head(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.HEAD);
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping head(Map arguments, String uri) {
            return this.head(arguments, uri, null);
        }

        public UrlMapping head(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.HEAD.toString();
            return regexUrlMapping;
        }

        public UrlMapping options(Map arguments, String uri, Closure callable) {
            arguments.put("method", HttpMethod.OPTIONS);
            return (UrlMapping)this._invoke(uri, new Object[]{arguments, callable}, (Object)this);
        }

        public UrlMapping options(Map arguments, String uri) {
            return this.options(arguments, uri, null);
        }

        public UrlMapping options(RegexUrlMapping regexUrlMapping) {
            regexUrlMapping.httpMethod = HttpMethod.OPTIONS.toString();
            return regexUrlMapping;
        }

        public void collection(Closure callable) {
            boolean previousState = this.isInCollection;
            this.isInCollection = true;
            try {
                callable.setDelegate((Object)this);
                callable.call();
            }
            finally {
                this.isInCollection = previousState;
            }
        }

        public void members(Closure callable) {
            boolean previousState = this.isInCollection;
            this.isInCollection = false;
            try {
                callable.setDelegate((Object)this);
                callable.call();
            }
            finally {
                this.isInCollection = previousState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object _invoke(String methodName, Object arg, Object delegate) {
            try {
                MetaMappingInfo mappingInfo = this.pushNewMetaMappingInfo();
                List<ConstrainedProperty> currentConstraints = mappingInfo.getConstraints();
                Object[] args = (Object[])arg;
                String mappedURI = this.establishFullURI(methodName, currentConstraints);
                boolean isResponseCode = this.isResponseCode(mappedURI);
                if (mappedURI.startsWith(SLASH) || isResponseCode) {
                    this.parameterValues = new HashMap<String, Object>();
                    Map variables = this.binding != null ? this.binding.getVariables() : null;
                    boolean hasParent = !this.parentResources.isEmpty();
                    try {
                        Object[] objectArray;
                        if (!hasParent) {
                            this.urlDefiningMode = false;
                        }
                        if (args != null && args.length > 0) {
                            objectArray = args;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = Collections.emptyMap();
                        }
                        args = objectArray;
                        if (args[0] instanceof Closure) {
                            Object bindingVariables;
                            UrlMapping urlMapping;
                            UrlMappingData urlData = this.createUrlMappingData(mappedURI, isResponseCode);
                            Closure callable = (Closure)args[0];
                            if (delegate != null) {
                                callable.setDelegate(delegate);
                            }
                            callable.call();
                            if (this.binding != null) {
                                mappingInfo.setController(variables.get("controller"));
                                mappingInfo.setAction(variables.get("action"));
                                mappingInfo.setView(variables.get("view"));
                                mappingInfo.setUri(variables.get("uri"));
                                mappingInfo.setPlugin(variables.get("plugin"));
                                mappingInfo.setNamespace(variables.get("namespace"));
                                if (variables.containsKey("method")) {
                                    mappingInfo.setHttpMethod(variables.get("method").toString());
                                }
                            }
                            ConstrainedProperty[] constraints = currentConstraints.toArray(new ConstrainedProperty[currentConstraints.size()]);
                            if (mappingInfo.getUri() != null) {
                                try {
                                    urlMapping = new RegexUrlMapping(urlData, new URI(mappingInfo.getUri().toString()), constraints, DefaultUrlMappingEvaluator.this.grailsApplication);
                                }
                                catch (URISyntaxException e) {
                                    throw new UrlMappingException("Cannot map to invalid URI: " + e.getMessage(), e);
                                }
                            } else {
                                urlMapping = this.createURLMapping(urlData, isResponseCode, mappingInfo.getRedirectInfo(), mappingInfo.getController(), mappingInfo.getAction(), mappingInfo.getNamespace(), mappingInfo.getPlugin(), mappingInfo.getView(), mappingInfo.getHttpMethod(), null, constraints);
                            }
                            if (this.binding != null) {
                                bindingVariables = variables;
                                Object parse = this.getParseRequest(Collections.emptyMap(), (Map)bindingVariables);
                                if (parse instanceof Boolean) {
                                    urlMapping.setParseRequest((Boolean)parse);
                                }
                            }
                            this.configureUrlMapping(urlMapping);
                            bindingVariables = urlMapping;
                            return bindingVariables;
                        }
                        if (args[0] instanceof Map) {
                            Map namedArguments = (Map)args[0];
                            String uri = mappedURI;
                            String version = null;
                            if (namedArguments.containsKey("version")) {
                                version = namedArguments.get("version").toString();
                            }
                            if (namedArguments.containsKey("namespace")) {
                                mappingInfo.setNamespace(namedArguments.get("namespace").toString());
                            }
                            if (namedArguments.containsKey("plugin")) {
                                mappingInfo.setPlugin(namedArguments.get("plugin").toString());
                            }
                            UrlMappingData urlData = this.createUrlMappingData(uri, isResponseCode);
                            if (namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCE) || namedArguments.containsKey(DefaultUrlMappingEvaluator.SINGLE)) {
                                Object controller;
                                if (namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCE)) {
                                    GrailsUtil.deprecated((String)"The resource syntax is deprecated and will be removed in a future release. Use single instead.");
                                    controller = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCE);
                                } else {
                                    controller = namedArguments.get(DefaultUrlMappingEvaluator.SINGLE);
                                }
                                String controllerName = controller.toString();
                                mappingInfo.setController(controllerName);
                                this.parentResources.push(new ParentResource(controllerName, uri, true));
                                try {
                                    this.invokeLastArgumentIfClosure(args);
                                }
                                finally {
                                    this.parentResources.pop();
                                }
                                if (controller != null) {
                                    this.createSingleResourceRestfulMappings(controllerName, mappingInfo.getPlugin(), mappingInfo.getNamespace(), version, urlData, currentConstraints, this.calculateIncludes(namedArguments, DEFAULT_RESOURCE_INCLUDES));
                                }
                            } else {
                                if (!namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCES)) {
                                    this.invokeLastArgumentIfClosure(args);
                                    UrlMapping urlMapping = this.getURLMappingForNamedArgs(namedArguments, urlData, mappedURI, isResponseCode, currentConstraints);
                                    this.configureUrlMapping(urlMapping);
                                    UrlMapping urlMapping2 = urlMapping;
                                    return urlMapping2;
                                }
                                Object controller = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCES);
                                String controllerName = controller.toString();
                                mappingInfo.setController(controllerName);
                                this.parentResources.push(new ParentResource(controllerName, uri, false));
                                try {
                                    this.urlDefiningMode = true;
                                    this.invokeLastArgumentIfClosure(args);
                                    this.parentResources.pop();
                                }
                                catch (Throwable throwable) {
                                    this.parentResources.pop();
                                    hasParent = !this.parentResources.isEmpty();
                                    if (hasParent) throw throwable;
                                    this.urlDefiningMode = false;
                                    throw throwable;
                                }
                                boolean bl = hasParent = !this.parentResources.isEmpty();
                                if (!hasParent) {
                                    this.urlDefiningMode = false;
                                }
                                if (controller != null) {
                                    this.createResourceRestfulMappings(controllerName, mappingInfo.getPlugin(), mappingInfo.getNamespace(), version, urlData, currentConstraints, this.calculateIncludes(namedArguments, DEFAULT_RESOURCES_INCLUDES));
                                }
                            }
                        }
                        Object var11_16 = null;
                        return var11_16;
                    }
                    finally {
                        if (this.binding != null) {
                            variables.clear();
                        }
                        if (!hasParent) {
                            this.urlDefiningMode = true;
                        }
                    }
                }
                if ((!this.urlDefiningMode || this.parentResources.size() > 0 && this.parentResources.peek().isGroup) && CONSTRAINTS.equals(mappedURI)) {
                    if (args.length > 0 && args[0] instanceof Closure) {
                        Closure callable = (Closure)args[0];
                        ConstrainedPropertyBuilder builder = DefaultUrlMappingEvaluator.this.constraintsEvaluator.newConstrainedPropertyBuilder(UrlMapping.class);
                        Object object = currentConstraints.iterator();
                        while (true) {
                            if (!object.hasNext()) {
                                callable.setResolveStrategy(1);
                                callable.setDelegate((Object)builder);
                                callable.call();
                                object = builder.getConstrainedProperties();
                                return object;
                            }
                            ConstrainedProperty constrainedProperty = object.next();
                            builder.getConstrainedProperties().put(constrainedProperty.getPropertyName(), constrainedProperty);
                        }
                    }
                    Map map = Collections.emptyMap();
                    return map;
                }
                LOG.error("Mapping: '" + mappedURI + "' does not start with / or is response code.");
                Object object = super.invokeMethod(mappedURI, arg);
                return object;
            }
            finally {
                this.mappingInfoDeque.pop();
            }
        }

        private List<String> calculateIncludes(Map namedArguments, List<String> defaultResourcesIncludes) {
            Object includesObject;
            ArrayList<String> includes = new ArrayList<String>(defaultResourcesIncludes);
            Object excludesObject = namedArguments.get("excludes");
            if (excludesObject != null) {
                if (excludesObject instanceof List) {
                    List excludeList = (List)excludesObject;
                    for (Object exc : excludeList) {
                        if (exc == null) continue;
                        String excStr = exc.toString().toLowerCase();
                        includes.remove(excStr);
                    }
                } else {
                    includes.remove(excludesObject.toString());
                }
            }
            if ((includesObject = namedArguments.get("includes")) != null) {
                if (includesObject instanceof List) {
                    List includeList = (List)includesObject;
                    includes.clear();
                    for (Object inc : includeList) {
                        if (inc == null) continue;
                        String incStr = inc.toString().toLowerCase();
                        includes.add(incStr);
                    }
                } else {
                    includes.clear();
                    includes.add(includesObject.toString());
                }
            }
            return includes;
        }

        private String establishFullURI(String uri, List<ConstrainedProperty> constrainedList) {
            if (this.parentResources.isEmpty() || this.inGroupConstraints) {
                return uri;
            }
            ParentResource parentResource = this.parentResources.peek();
            if (CONSTRAINTS.equals(uri) && parentResource.isGroup) {
                return uri;
            }
            this.inGroupConstraints = false;
            StringBuilder uriBuilder = new StringBuilder();
            if (parentResource.isSingle) {
                uriBuilder.append(parentResource.uri);
            } else if (parentResource.controllerName != null) {
                uriBuilder.append(parentResource.uri);
                if (!this.isInCollection) {
                    uriBuilder.append(SLASH).append(CAPTURING_WILD_CARD);
                }
            }
            if (!SLASH.equals(uri)) {
                uriBuilder.append(uri);
            }
            return uriBuilder.toString();
        }

        private void invokeLastArgumentIfClosure(Object[] args) {
            if (args.length > 1 && args[1] instanceof Closure) {
                ((Closure)args[1]).call();
            }
        }

        protected void createResourceRestfulMappings(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList, List<String> includes) {
            ConstrainedProperty[] constraintArray = constrainedList.toArray(new ConstrainedProperty[constrainedList.size()]);
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_INDEX)) {
                UrlMapping listUrlMapping = this.createIndexActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(listUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_CREATE)) {
                UrlMapping createUrlMapping = this.createCreateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(createUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SAVE)) {
                UrlMapping saveUrlMapping = this.createSaveActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(saveUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SHOW)) {
                UrlMapping showUrlMapping = this.createShowActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(showUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_EDIT)) {
                UrlMapping editUrlMapping = this.createEditActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(editUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_UPDATE)) {
                UrlMapping updateUrlMapping = this.createUpdateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(updateUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_PATCH)) {
                UrlMapping patchUrlMapping = this.createPatchActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(patchUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_DELETE)) {
                UrlMapping deleteUrlMapping = this.createDeleteActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(deleteUrlMapping);
            }
        }

        protected UrlMapping createDeleteActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData deleteUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> deleteUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(deleteUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_DELETE, namespace, pluginName, null, HttpMethod.DELETE.toString(), version, deleteUrlMappingConstraints.toArray(new ConstrainedProperty[deleteUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createUpdateActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData updateUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> updateUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(updateUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_UPDATE, namespace, pluginName, null, HttpMethod.PUT.toString(), version, updateUrlMappingConstraints.toArray(new ConstrainedProperty[updateUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createPatchActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData patchUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> patchUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(patchUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_PATCH, namespace, pluginName, null, HttpMethod.PATCH.toString(), version, patchUrlMappingConstraints.toArray(new ConstrainedProperty[patchUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createEditActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData editUrlMappingData = urlData.createRelative("/(*)/edit");
            ArrayList<ConstrainedProperty> editUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constrainedList);
            editUrlMappingConstraints.add((ConstrainedProperty)new DefaultConstrainedProperty(UrlMapping.class, "id", String.class, DefaultUrlMappingEvaluator.this.constraintRegistry));
            return new RegexUrlMapping(editUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_EDIT, namespace, pluginName, null, HttpMethod.GET.toString(), version, editUrlMappingConstraints.toArray(new ConstrainedProperty[editUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createShowActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData showUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> showUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(showUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SHOW, namespace, pluginName, null, HttpMethod.GET.toString(), version, showUrlMappingConstraints.toArray(new ConstrainedProperty[showUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        private List<ConstrainedProperty> createConstraintsWithIdAndFormat(List<ConstrainedProperty> constrainedList) {
            ArrayList<ConstrainedProperty> showUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constrainedList);
            showUrlMappingConstraints.add((ConstrainedProperty)new DefaultConstrainedProperty(UrlMapping.class, "id", String.class, DefaultUrlMappingEvaluator.this.constraintRegistry));
            DefaultConstrainedProperty cp = new DefaultConstrainedProperty(UrlMapping.class, "format", String.class, DefaultUrlMappingEvaluator.this.constraintRegistry);
            cp.applyConstraint("nullable", (Object)true);
            showUrlMappingConstraints.add((ConstrainedProperty)cp);
            return showUrlMappingConstraints;
        }

        private UrlMappingData createRelativeUrlDataWithIdAndFormat(UrlMappingData urlData) {
            return urlData.createRelative("/(*)(.(*))?");
        }

        private UrlMappingData createFormatOnlyUrlMappingData(UrlMappingData urlData) {
            return urlData.createRelative("(.(*))?");
        }

        protected UrlMapping createSaveActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData saveActionUrlMappingData = urlData.createRelative("(.(*))?");
            List<ConstrainedProperty> saveUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(saveActionUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SAVE, namespace, pluginName, null, HttpMethod.POST.toString(), version, saveUrlMappingConstraints.toArray(new ConstrainedProperty[saveUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createCreateActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, ConstrainedProperty[] constraintArray) {
            UrlMappingData createMappingData = urlData.createRelative("/create");
            return new RegexUrlMapping(createMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_CREATE, namespace, pluginName, null, HttpMethod.GET.toString(), version, constraintArray, DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createIndexActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData indexActionUrlMappingData = urlData.createRelative("(.(*))?");
            List<ConstrainedProperty> indexUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(indexActionUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_INDEX, namespace, pluginName, null, HttpMethod.GET.toString(), version, indexUrlMappingConstraints.toArray(new ConstrainedProperty[indexUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        private List<ConstrainedProperty> createFormatOnlyConstraints(List<ConstrainedProperty> constrainedList) {
            ArrayList<ConstrainedProperty> indexUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constrainedList);
            DefaultConstrainedProperty cp = new DefaultConstrainedProperty(UrlMapping.class, "format", String.class, DefaultUrlMappingEvaluator.this.constraintRegistry);
            cp.applyConstraint("nullable", (Object)true);
            indexUrlMappingConstraints.add((ConstrainedProperty)cp);
            return indexUrlMappingConstraints;
        }

        protected void createSingleResourceRestfulMappings(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList, List<String> includes) {
            ConstrainedProperty[] constraintArray = constrainedList.toArray(new ConstrainedProperty[constrainedList.size()]);
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_CREATE)) {
                UrlMapping createUrlMapping = this.createCreateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(createUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SAVE)) {
                UrlMapping saveUrlMapping = this.createSaveActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(saveUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SHOW)) {
                UrlMapping showUrlMapping = this.createShowActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(showUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_EDIT)) {
                UrlMapping editUrlMapping = this.createEditActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(editUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_UPDATE)) {
                UrlMapping updateUrlMapping = this.createUpdateActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(updateUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_PATCH)) {
                UrlMapping patchUrlMapping = this.createPatchActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(patchUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_DELETE)) {
                UrlMapping deleteUrlMapping = this.createDeleteActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(deleteUrlMapping);
            }
        }

        protected UrlMapping createDeleteActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData deleteUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> deleteUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(deleteUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_DELETE, namespace, pluginName, null, HttpMethod.DELETE.toString(), version, deleteUrlMappingConstraints.toArray(new ConstrainedProperty[deleteUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createUpdateActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData updateUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> updateUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(updateUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_UPDATE, namespace, pluginName, null, HttpMethod.PUT.toString(), version, updateUrlMappingConstraints.toArray(new ConstrainedProperty[updateUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createPatchActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData patchUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> patchUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(patchUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_PATCH, namespace, pluginName, null, HttpMethod.PATCH.toString(), version, patchUrlMappingConstraints.toArray(new ConstrainedProperty[patchUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createEditActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, ConstrainedProperty[] constraintArray) {
            UrlMappingData editMappingData = urlData.createRelative("/edit");
            return new RegexUrlMapping(editMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_EDIT, namespace, pluginName, null, HttpMethod.GET.toString(), version, constraintArray, DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected UrlMapping createShowActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData showUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> showUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(showUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SHOW, namespace, pluginName, null, HttpMethod.GET.toString(), version, showUrlMappingConstraints.toArray(new ConstrainedProperty[showUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        private void configureUrlMapping(UrlMapping urlMapping) {
            if (this.binding != null) {
                Map vars = this.binding.getVariables();
                for (String key : vars.keySet()) {
                    if (!this.isNotCoreMappingKey(key)) continue;
                    this.parameterValues.put(key, vars.get(key));
                }
                this.binding.getVariables().clear();
            }
            if (urlMapping.getControllerName() != null) {
                this.parameterValues.put("controller", urlMapping.getControllerName());
            }
            if (urlMapping.getActionName() != null) {
                this.parameterValues.put("action", urlMapping.getActionName());
            }
            urlMapping.setParameterValues(new LinkedHashMap<String, Object>(this.parameterValues));
            this.urlMappings.add(urlMapping);
        }

        private boolean isNotCoreMappingKey(Object key) {
            return !"action".equals(key) && !"controller".equals(key) && !"view".equals(key);
        }

        private UrlMappingData createUrlMappingData(String methodName, boolean responseCode) {
            if (!responseCode) {
                return DefaultUrlMappingEvaluator.this.urlParser.parse(methodName);
            }
            return new ResponseCodeMappingData(methodName);
        }

        private boolean isResponseCode(String s) {
            int count = s.length();
            for (int i = 0; i < count; ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private UrlMapping getURLMappingForNamedArgs(Map namedArguments, UrlMappingData urlData, String mapping, boolean isResponseCode, List<ConstrainedProperty> constrainedList) {
            Object parseRequest;
            UrlMapping urlMapping;
            Map bindingVariables = this.binding != null ? this.binding.getVariables() : null;
            Object controllerName = this.getControllerName(namedArguments, bindingVariables);
            Object actionName = this.getActionName(namedArguments, bindingVariables);
            Object pluginName = this.getPluginName(namedArguments, bindingVariables);
            Object httpMethod = this.getHttpMethod(namedArguments, bindingVariables);
            Object version = this.getVersion(namedArguments, bindingVariables);
            Object namespace = this.getNamespace(namedArguments, bindingVariables);
            Object redirectInfo = this.getRedirectInfo(namedArguments, bindingVariables);
            Object viewName = this.getViewName(namedArguments, bindingVariables);
            if (actionName != null && viewName != null) {
                viewName = null;
                LOG.warn("Both [action] and [view] specified in URL mapping [" + mapping + "]. The action takes precendence!");
            }
            Object uri = this.getURI(namedArguments, bindingVariables);
            ConstrainedProperty[] constraints = constrainedList.toArray(new ConstrainedProperty[constrainedList.size()]);
            if (uri != null) {
                try {
                    urlMapping = isResponseCode ? new ResponseCodeUrlMapping(urlData, new URI(uri.toString()), constraints, DefaultUrlMappingEvaluator.this.grailsApplication) : new RegexUrlMapping(urlData, new URI(uri.toString()), constraints, DefaultUrlMappingEvaluator.this.grailsApplication);
                }
                catch (URISyntaxException e) {
                    throw new UrlMappingException("Cannot map to invalid URI: " + e.getMessage(), e);
                }
            } else {
                urlMapping = this.createURLMapping(urlData, isResponseCode, redirectInfo, controllerName, actionName, namespace, pluginName, viewName, httpMethod != null ? httpMethod.toString() : null, version != null ? version.toString() : null, constraints);
            }
            Object exceptionArg = this.getException(namedArguments, bindingVariables);
            if (isResponseCode && exceptionArg != null) {
                if (exceptionArg instanceof Class) {
                    Class exClass = (Class)exceptionArg;
                    if (Throwable.class.isAssignableFrom(exClass)) {
                        ((ResponseCodeUrlMapping)urlMapping).setExceptionType(exClass);
                    } else {
                        LOG.error("URL mapping argument [exception] with value [" + exceptionArg + "] must be a subclass of java.lang.Throwable");
                    }
                } else {
                    LOG.error("URL mapping argument [exception] with value [" + exceptionArg + "] must be a valid class");
                }
            }
            if ((parseRequest = this.getParseRequest(namedArguments, bindingVariables)) instanceof Boolean) {
                urlMapping.setParseRequest((Boolean)parseRequest);
            }
            return urlMapping;
        }

        private Object getVariableFromNamedArgsOrBinding(Map namedArguments, Map bindingVariables, String variableName, Object defaultValue) {
            Object returnValue = namedArguments.get(variableName);
            if (returnValue == null) {
                returnValue = this.binding != null ? bindingVariables.get(variableName) : defaultValue;
            }
            return returnValue;
        }

        private Object getActionName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "action", this.getMetaMappingInfo().getAction());
        }

        private Object getParseRequest(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.PARSE_REQUEST, this.parseRequest);
        }

        private Object getControllerName(Map namedArguments, Map bindingVariables) {
            Object fromBinding = this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "controller", this.getMetaMappingInfo().getController());
            if (fromBinding == null && !this.parentResources.isEmpty()) {
                return this.parentResources.peekLast().controllerName;
            }
            return fromBinding;
        }

        private Object getPluginName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "plugin", this.getMetaMappingInfo().getPlugin());
        }

        private Object getHttpMethod(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "method", this.getMetaMappingInfo().getHttpMethod());
        }

        private Object getRedirectInfo(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "redirect", this.getMetaMappingInfo().getRedirectInfo());
        }

        private Object getVersion(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "version", this.getMetaMappingInfo().getView());
        }

        private Object getNamespace(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "namespace", this.getMetaMappingInfo().getNamespace());
        }

        private Object getViewName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "view", this.getMetaMappingInfo().getView());
        }

        private Object getURI(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "uri", this.getMetaMappingInfo().getUri());
        }

        private Object getException(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.EXCEPTION, this.exception);
        }

        private UrlMapping createURLMapping(UrlMappingData urlData, boolean isResponseCode, Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints) {
            if (!isResponseCode) {
                return new RegexUrlMapping(redirectInfo, urlData, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints, DefaultUrlMappingEvaluator.this.grailsApplication);
            }
            return new ResponseCodeUrlMapping(urlData, controllerName, actionName, namespace, pluginName, viewName, null, DefaultUrlMappingEvaluator.this.grailsApplication);
        }

        protected MetaMappingInfo pushNewMetaMappingInfo() {
            MetaMappingInfo mappingInfo = new MetaMappingInfo();
            MetaMappingInfo parentMappingInfo = this.mappingInfoDeque.peek();
            if (parentMappingInfo != null) {
                ParentResource parentResource;
                List<ConstrainedProperty> parentMappingConstraints = parentMappingInfo.getConstraints();
                if (parentMappingConstraints != null) {
                    mappingInfo.getConstraints().addAll(parentMappingConstraints);
                }
                if ((parentResource = this.parentResources.peek()) != null && !parentResource.isSingle && !this.isInCollection) {
                    mappingInfo.getConstraints().add((ConstrainedProperty)new DefaultConstrainedProperty(UrlMapping.class, parentResource.controllerName + "Id", String.class, DefaultUrlMappingEvaluator.this.constraintRegistry));
                }
            }
            if (this.previousConstraints.size() > 0) {
                mappingInfo.getConstraints().addAll(this.previousConstraints);
                this.previousConstraints.clear();
            }
            this.mappingInfoDeque.push(mappingInfo);
            return mappingInfo;
        }

        protected MetaMappingInfo getMetaMappingInfo() {
            return this.mappingInfoDeque.peek();
        }

        class ParentResource {
            String controllerName;
            String uri;
            boolean isSingle;
            boolean isGroup;

            ParentResource(String controllerName, String uri, boolean single) {
                this.controllerName = controllerName;
                this.uri = uri;
                this.isSingle = single;
                this.isGroup = false;
            }

            ParentResource(String controllerName, String uri, boolean single, boolean group) {
                this.controllerName = controllerName;
                this.uri = uri;
                this.isSingle = single;
                this.isGroup = group;
            }
        }
    }

    class MappingCapturingClosure
    extends Closure {
        private static final long serialVersionUID = 2108155626252742722L;
        private Closure<?> mappings;

        public Closure<?> getMappings() {
            return this.mappings;
        }

        public MappingCapturingClosure(Object o) {
            super(o);
        }

        public Object call(Object ... args) {
            if (args.length > 0 && args[0] instanceof Closure) {
                this.mappings = (Closure)args[0];
            }
            return null;
        }
    }
}

