/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import grails.util.GrailsMetaClassUtils;
import grails.util.GrailsStringUtils;
import grails.web.servlet.mvc.GrailsParameterMap;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.web.mapping.DefaultLinkGenerator;
import org.grails.web.servlet.mvc.GrailsWebRequest;

public class CachingLinkGenerator
extends DefaultLinkGenerator {
    private static final int DEFAULT_MAX_WEIGHTED_CAPACITY = 5000;
    public static final String LINK_PREFIX = "link";
    public static final String RESOURCE_PREFIX = "resource";
    public static final String USED_ATTRIBUTES_SUFFIX = "-used-attributes";
    public static final String EMPTY_MAP_STRING = "[:]";
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";
    private static final String COMMA_SEPARATOR = ", ";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String THIS_MAP = "(this Map)";
    private Map<String, Object> linkCache;

    public CachingLinkGenerator(String serverBaseURL, String contextPath) {
        super(serverBaseURL, contextPath);
        this.linkCache = this.createDefaultCache();
    }

    public CachingLinkGenerator(String serverBaseURL) {
        super(serverBaseURL);
        this.linkCache = this.createDefaultCache();
    }

    public CachingLinkGenerator(String serverBaseURL, Map<String, Object> linkCache) {
        super(serverBaseURL);
        this.linkCache = linkCache;
    }

    public CachingLinkGenerator(String serverBaseURL, String contextPath, Map<String, Object> linkCache) {
        super(serverBaseURL, contextPath);
        this.linkCache = linkCache;
    }

    @Override
    public String link(Map attrs, String encoding) {
        if (!this.isCacheable(attrs)) {
            return super.link(attrs, encoding);
        }
        String key = this.makeKey(LINK_PREFIX, attrs);
        Object resourceLink = this.linkCache.get(key);
        if (resourceLink == null) {
            resourceLink = super.link(attrs, encoding);
            this.linkCache.put(key, resourceLink);
        }
        return resourceLink.toString();
    }

    private boolean isCacheable(Map attrs) {
        if (attrs.get("params") instanceof GrailsParameterMap) {
            return false;
        }
        Object urlAttr = attrs.get("url");
        if (urlAttr instanceof Map) {
            return this.isCacheable((Map)urlAttr);
        }
        return attrs.get("controller") != null || attrs.get("action") != null || urlAttr != null || attrs.get("uri") != null;
    }

    private void appendMapKey(StringBuilder buffer, Map map) {
        String namespace;
        if (map == null || map.isEmpty()) {
            buffer.append(EMPTY_MAP_STRING);
        }
        String requestControllerName = this.getRequestStateLookupStrategy().getControllerName();
        if (map.get("action") != null && map.get("controller") == null) {
            Object action = map.remove("action");
            map.put("controller", requestControllerName);
            map.put("action", action);
        }
        if (map.get("namespace") == null && map.get("controller") == requestControllerName && GrailsStringUtils.isNotEmpty((String)(namespace = this.getRequestStateLookupStrategy().getControllerNamespace()))) {
            map.put("namespace", namespace);
        }
        buffer.append(OPENING_BRACKET);
        boolean first = true;
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = o;
            Object value = entry.getValue();
            if (value == null) continue;
            first = this.appendCommaIfNotFirst(buffer, first);
            Object key = entry.getKey();
            if (RESOURCE_PREFIX.equals(key)) {
                value = this.getCacheKeyValueForResource(value);
            }
            this.appendKeyValue(buffer, map, key, value);
        }
        buffer.append(CLOSING_BRACKET);
    }

    protected String getCacheKeyValueForResource(Object o) {
        StringBuilder builder = new StringBuilder(o.getClass().getName());
        builder.append("->");
        Object idValue = GrailsMetaClassUtils.invokeMethodIfExists((Object)o, (String)"ident", (Object[])new Object[0]);
        if (idValue != null) {
            builder.append(idValue.toString());
        } else {
            builder.append(o);
        }
        return builder.toString();
    }

    private boolean appendCommaIfNotFirst(StringBuilder buffer, boolean first) {
        if (first) {
            first = false;
        } else {
            buffer.append(COMMA_SEPARATOR);
        }
        return first;
    }

    private void appendKeyValue(StringBuilder buffer, Map map, Object key, Object value) {
        buffer.append(key).append(KEY_VALUE_SEPARATOR);
        if (value == map) {
            buffer.append(THIS_MAP);
        } else {
            buffer.append(DefaultGroovyMethods.toString((Object)value));
        }
    }

    @Override
    public String resource(Map attrs) {
        String key = this.makeKey(RESOURCE_PREFIX, attrs);
        Object resourceLink = this.linkCache.get(key);
        if (resourceLink == null) {
            resourceLink = super.resource(attrs);
            this.linkCache.put(key, resourceLink);
        }
        return resourceLink.toString();
    }

    protected String makeKey(String prefix, Map attrs) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (this.getConfiguredServerBaseURL() == null && this.isAbsolute(attrs)) {
            if (attrs.get("base") != null) {
                sb.append(attrs.get("base"));
            } else {
                GrailsWebRequest webRequest = GrailsWebRequest.lookup();
                if (webRequest != null) {
                    sb.append(webRequest.getBaseUrl());
                }
            }
        }
        this.appendMapKey(sb, attrs);
        return sb.toString();
    }

    private ConcurrentLinkedHashMap<String, Object> createDefaultCache() {
        return new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(5000L).build();
    }

    public void clearCache() {
        this.linkCache.clear();
    }
}

