/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.validation.ConstrainedProperty;
import grails.web.mapping.UrlMapping;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;

public abstract class AbstractUrlMapping
implements UrlMapping {
    protected final ConstrainedProperty[] constraints;
    protected Object controllerName;
    protected Object actionName;
    protected Object namespace;
    protected Object pluginName;
    protected Object viewName;
    protected Object forwardURI;
    protected Object redirectInfo;
    protected ServletContext servletContext;
    protected Map parameterValues = Collections.EMPTY_MAP;
    protected boolean parseRequest;
    protected String mappingName;
    protected String httpMethod = "*";
    protected String version = "*";

    public AbstractUrlMapping(Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, ConstrainedProperty[] constraints, ServletContext servletContext) {
        this.controllerName = controllerName;
        this.actionName = actionName;
        this.namespace = namespace;
        this.pluginName = pluginName;
        this.constraints = constraints;
        this.viewName = viewName;
        this.servletContext = servletContext;
        this.redirectInfo = redirectInfo;
    }

    protected AbstractUrlMapping(Object viewName, ConstrainedProperty[] constraints, ServletContext servletContext) {
        this.viewName = viewName;
        this.constraints = constraints;
        this.servletContext = servletContext;
    }

    protected AbstractUrlMapping(URI uri, ConstrainedProperty[] constraints, ServletContext servletContext) {
        this.forwardURI = uri;
        this.constraints = constraints;
        this.servletContext = servletContext;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ConstrainedProperty[] getConstraints() {
        return this.constraints;
    }

    @Override
    public Object getControllerName() {
        return this.controllerName;
    }

    @Override
    public Object getActionName() {
        return this.actionName;
    }

    @Override
    public Object getPluginName() {
        return this.pluginName;
    }

    @Override
    public Object getNamespace() {
        return this.namespace;
    }

    @Override
    public Object getViewName() {
        return this.viewName;
    }

    @Override
    public void setParameterValues(Map parameterValues) {
        this.parameterValues = Collections.unmodifiableMap(parameterValues);
    }

    @Override
    public void setParseRequest(boolean shouldParse) {
        this.parseRequest = shouldParse;
    }

    @Override
    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public void setMappingName(String name) {
        this.mappingName = name;
    }

    @Override
    public boolean hasRuntimeVariable(String name) {
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.length; ++i) {
                ConstrainedProperty cp = this.constraints[i];
                if (!cp.getPropertyName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getRedirectInfo() {
        return this.redirectInfo;
    }
}

