/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsMetaClassUtils;
import org.codehaus.groovy.grails.io.support.GrailsIOUtils;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerAware;
import org.codehaus.groovy.grails.plugins.support.aware.ClassLoaderAware;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.ConstrainedPropertyBuilder;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingParser;
import org.codehaus.groovy.grails.web.mapping.MetaMappingInfo;
import org.codehaus.groovy.grails.web.mapping.RegexUrlMapping;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeMappingData;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeUrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.codehaus.groovy.grails.web.mapping.UrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.UrlMappingParser;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.metaclass.ControllerDynamicMethods;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DefaultUrlMappingEvaluator
implements UrlMappingEvaluator,
ClassLoaderAware,
PluginManagerAware {
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_INDEX = "index";
    public static final String ACTION_SHOW = "show";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_PATCH = "patch";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_SAVE = "save";
    public static final List<String> DEFAULT_RESOURCES_INCLUDES = Arrays.asList("index", "create", "save", "show", "edit", "update", "patch", "delete");
    public static final List<String> DEFAULT_RESOURCE_INCLUDES = Arrays.asList("create", "save", "show", "edit", "update", "patch", "delete");
    private static final Log LOG = LogFactory.getLog(UrlMappingBuilder.class);
    private GroovyClassLoader classLoader = new GroovyClassLoader();
    private UrlMappingParser urlParser = new DefaultUrlMappingParser();
    private ServletContext servletContext;
    private static final String EXCEPTION = "exception";
    private static final String PARSE_REQUEST = "parseRequest";
    private static final String RESOURCE = "resource";
    private static final String RESOURCES = "resources";
    private GrailsPluginManager pluginManager;
    private WebApplicationContext applicationContext;

    @Deprecated
    public DefaultUrlMappingEvaluator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public DefaultUrlMappingEvaluator(WebApplicationContext applicationContext) {
        if (applicationContext != null) {
            this.servletContext = applicationContext.getServletContext();
        }
        this.applicationContext = applicationContext;
    }

    public List evaluateMappings(Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            List<UrlMapping> list = this.evaluateMappings(this.classLoader.parseClass(IOGroovyMethods.getText((InputStream)inputStream, (String)"UTF-8")));
            return list;
        }
        catch (IOException e) {
            throw new UrlMappingException("Unable to read mapping file [" + resource.getFilename() + "]: " + e.getMessage(), e);
        }
        finally {
            GrailsIOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    public List<UrlMapping> evaluateMappings(Class theClass) {
        GroovyObject obj = (GroovyObject)BeanUtils.instantiateClass((Class)theClass);
        if (obj instanceof Script) {
            Script script = (Script)obj;
            Binding b = new Binding();
            MappingCapturingClosure closure = new MappingCapturingClosure(script);
            b.setVariable("mappings", (Object)closure);
            script.setBinding(b);
            script.run();
            Closure<?> mappings = closure.getMappings();
            Binding binding = script.getBinding();
            return this.evaluateMappings((GroovyObject)script, mappings, binding);
        }
        throw new UrlMappingException("Unable to configure URL mappings for class [" + theClass + "]. A URL mapping must be an instance of groovy.lang.Script.");
    }

    private List<UrlMapping> evaluateMappings(GroovyObject go, Closure<?> mappings, Binding binding) {
        UrlMappingBuilder builder = new UrlMappingBuilder(binding, this.servletContext);
        mappings.setDelegate((Object)builder);
        mappings.call();
        builder.urlDefiningMode = false;
        this.configureUrlMappingDynamicObjects(go);
        return builder.getUrlMappings();
    }

    @Override
    public List<UrlMapping> evaluateMappings(Closure closure) {
        UrlMappingBuilder builder = new UrlMappingBuilder(null, this.servletContext);
        closure.setDelegate((Object)builder);
        closure.setResolveStrategy(1);
        if (closure.getParameterTypes().length == 0) {
            closure.call();
        } else {
            closure.call((Object)this.applicationContext);
        }
        builder.urlDefiningMode = false;
        this.configureUrlMappingDynamicObjects(closure);
        return builder.getUrlMappings();
    }

    private void configureUrlMappingDynamicObjects(Object object) {
        if (this.pluginManager != null) {
            ControllerDynamicMethods.registerCommonWebProperties((MetaClass)GrailsMetaClassUtils.getExpandoMetaClass(object.getClass()), null);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        Assert.isInstanceOf(GroovyClassLoader.class, (Object)classLoader, (String)"Property [classLoader] must be an instance of GroovyClassLoader");
        this.classLoader = (GroovyClassLoader)classLoader;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    class UrlMappingBuilder
    extends GroovyObjectSupport {
        private static final String CAPTURING_WILD_CARD = "(*)";
        private static final String SLASH = "/";
        private static final String CONSTRAINTS = "constraints";
        private boolean urlDefiningMode = true;
        private List<ConstrainedProperty> previousConstraints = new ArrayList<ConstrainedProperty>();
        private List<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
        private Map<String, Object> parameterValues = new HashMap<String, Object>();
        private Binding binding;
        private ServletContext sc;
        private Object exception;
        private Object parseRequest;
        private Deque<ParentResource> parentResources = new ArrayDeque<ParentResource>();
        private Deque<MetaMappingInfo> mappingInfoDeque = new ArrayDeque<MetaMappingInfo>();

        public UrlMappingBuilder(Binding binding, ServletContext servletContext) {
            this.binding = binding;
            this.sc = servletContext;
        }

        public List<UrlMapping> getUrlMappings() {
            return this.urlMappings;
        }

        public ServletContext getServletContext() {
            return this.sc;
        }

        public ApplicationContext getApplicationContext() {
            return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.sc);
        }

        public GrailsApplication getGrailsApplication() {
            return (GrailsApplication)this.getApplicationContext().getBean("grailsApplication", GrailsApplication.class);
        }

        public Object getProperty(String name) {
            if (this.urlDefiningMode) {
                ConstrainedProperty newConstrained = new ConstrainedProperty(UrlMapping.class, name, String.class);
                this.previousConstraints.add(newConstrained);
                return CAPTURING_WILD_CARD;
            }
            return super.getProperty(name);
        }

        public Object getException() {
            return this.exception;
        }

        public void setException(Object exception) {
            this.exception = exception;
        }

        public Object getUri() {
            return this.getMetaMappingInfo().getUri();
        }

        public void setUri(Object uri) {
            this.getMetaMappingInfo().setUri(uri);
        }

        public void setAction(Object action) {
            this.getMetaMappingInfo().setAction(action);
        }

        public Object getAction() {
            return this.getMetaMappingInfo().getAction();
        }

        public void setController(Object controller) {
            this.getMetaMappingInfo().setController(controller);
        }

        public Object getController() {
            return this.getMetaMappingInfo().getController();
        }

        public void setRedirectInfo(Object redirectInfo) {
            this.getMetaMappingInfo().setRedirectInfo(redirectInfo);
        }

        public Object getRedirectInfo() {
            return this.getMetaMappingInfo().getRedirectInfo();
        }

        public void setPlugin(Object plugin) {
            this.getMetaMappingInfo().setPlugin(plugin);
        }

        public Object getPlugin() {
            return this.getMetaMappingInfo().getPlugin();
        }

        public void setNamespace(Object namespace) {
            this.getMetaMappingInfo().setNamespace(namespace);
        }

        public Object getNamespace() {
            return this.getMetaMappingInfo().getNamespace();
        }

        public Object getView() {
            return this.getMetaMappingInfo().getView();
        }

        public void setView(String viewName) {
            this.getMetaMappingInfo().setView(viewName);
        }

        public void name(Map<String, UrlMapping> m) {
            for (Map.Entry<String, UrlMapping> entry : m.entrySet()) {
                entry.getValue().setMappingName(entry.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void group(String uri, Closure mappings) {
            try {
                this.parentResources.push(new ParentResource(null, uri, true));
                mappings.call();
            }
            finally {
                this.parentResources.pop();
            }
        }

        public Object invokeMethod(String methodName, Object arg) {
            if (this.binding == null) {
                return this.invokeMethodClosure(methodName, arg);
            }
            return this.invokeMethodScript(methodName, arg);
        }

        private Object invokeMethodScript(String methodName, Object arg) {
            return this._invoke(methodName, arg, null);
        }

        private Object invokeMethodClosure(String methodName, Object arg) {
            return this._invoke(methodName, arg, (Object)this);
        }

        void propertyMissing(String name, Object value) {
            this.parameterValues.put(name, value);
        }

        Object propertyMissing(String name) {
            return this.parameterValues.get(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object _invoke(String methodName, Object arg, Object delegate) {
            try {
                MetaMappingInfo mappingInfo = this.pushNewMetaMappingInfo();
                List<ConstrainedProperty> currentConstraints = mappingInfo.getConstraints();
                Object[] args = (Object[])arg;
                String mappedURI = this.establishFullURI(methodName, currentConstraints);
                boolean isResponseCode = this.isResponseCode(mappedURI);
                if (mappedURI.startsWith(SLASH) || isResponseCode) {
                    this.parameterValues = new HashMap<String, Object>();
                    Map variables = this.binding != null ? this.binding.getVariables() : null;
                    try {
                        Map namedArguments;
                        Object[] objectArray;
                        if (this.parentResources.isEmpty()) {
                            this.urlDefiningMode = false;
                        }
                        if (args != null && args.length > 0) {
                            objectArray = args;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = Collections.EMPTY_MAP;
                        }
                        args = objectArray;
                        if (args[0] instanceof Closure) {
                            Object bindingVariables;
                            Object parse;
                            UrlMapping urlMapping;
                            UrlMappingData urlData = this.createUrlMappingData(mappedURI, isResponseCode);
                            Closure callable = (Closure)args[0];
                            if (delegate != null) {
                                callable.setDelegate(delegate);
                            }
                            callable.call();
                            if (this.binding != null) {
                                mappingInfo.setController(variables.get("controller"));
                                mappingInfo.setAction(variables.get("action"));
                                mappingInfo.setView(variables.get("view"));
                                mappingInfo.setUri(variables.get("uri"));
                                mappingInfo.setPlugin(variables.get("plugin"));
                                mappingInfo.setNamespace(variables.get("namespace"));
                                if (variables.containsKey("method")) {
                                    mappingInfo.setHttpMethod(variables.get("method").toString());
                                }
                            }
                            ConstrainedProperty[] constraints = currentConstraints.toArray(new ConstrainedProperty[currentConstraints.size()]);
                            if (mappingInfo.getUri() != null) {
                                try {
                                    urlMapping = new RegexUrlMapping(urlData, new URI(mappingInfo.getUri().toString()), constraints, this.sc);
                                }
                                catch (URISyntaxException e) {
                                    throw new UrlMappingException("Cannot map to invalid URI: " + e.getMessage(), e);
                                }
                            } else {
                                urlMapping = this.createURLMapping(urlData, isResponseCode, mappingInfo.getRedirectInfo(), mappingInfo.getController(), mappingInfo.getAction(), mappingInfo.getNamespace(), mappingInfo.getPlugin(), mappingInfo.getView(), mappingInfo.getHttpMethod(), null, constraints);
                            }
                            if (this.binding != null && (parse = this.getParseRequest(Collections.EMPTY_MAP, (Map)(bindingVariables = variables))) instanceof Boolean) {
                                urlMapping.setParseRequest((Boolean)parse);
                            }
                            this.configureUrlMapping(urlMapping);
                            bindingVariables = urlMapping;
                            return bindingVariables;
                        }
                        if (args[0] instanceof Map) {
                            namedArguments = (Map)args[0];
                            String uri = mappedURI;
                            String version = null;
                            if (namedArguments.containsKey("version")) {
                                version = namedArguments.get("version").toString();
                            }
                            if (namedArguments.containsKey("namespace")) {
                                mappingInfo.setNamespace(namedArguments.get("namespace").toString());
                            }
                            if (namedArguments.containsKey("plugin")) {
                                mappingInfo.setPlugin(namedArguments.get("plugin").toString());
                            }
                            UrlMappingData urlData = this.createUrlMappingData(uri, isResponseCode);
                            if (namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCE)) {
                                Object controller = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCE);
                                String controllerName = controller.toString();
                                mappingInfo.setController(controllerName);
                                this.parentResources.push(new ParentResource(controllerName, uri, true));
                                try {
                                    this.invokeLastArgumentIfClosure(args);
                                }
                                finally {
                                    this.parentResources.pop();
                                }
                                if (controller != null) {
                                    this.createSingleResourceRestfulMappings(controllerName, mappingInfo.getPlugin(), mappingInfo.getNamespace(), version, urlData, currentConstraints, this.calculateIncludes(namedArguments, DEFAULT_RESOURCE_INCLUDES));
                                }
                            } else {
                                if (!namedArguments.containsKey(DefaultUrlMappingEvaluator.RESOURCES)) {
                                    this.invokeLastArgumentIfClosure(args);
                                    UrlMapping urlMapping = this.getURLMappingForNamedArgs(namedArguments, urlData, mappedURI, isResponseCode, currentConstraints);
                                    this.configureUrlMapping(urlMapping);
                                    UrlMapping urlMapping2 = urlMapping;
                                    return urlMapping2;
                                }
                                Object controller = namedArguments.get(DefaultUrlMappingEvaluator.RESOURCES);
                                String controllerName = controller.toString();
                                mappingInfo.setController(controllerName);
                                this.parentResources.push(new ParentResource(controllerName, uri, false));
                                try {
                                    this.invokeLastArgumentIfClosure(args);
                                }
                                finally {
                                    this.parentResources.pop();
                                }
                                if (controller != null) {
                                    this.createResourceRestfulMappings(controllerName, mappingInfo.getPlugin(), mappingInfo.getNamespace(), version, urlData, currentConstraints, this.calculateIncludes(namedArguments, DEFAULT_RESOURCES_INCLUDES));
                                }
                            }
                        }
                        namedArguments = null;
                        return namedArguments;
                    }
                    finally {
                        if (this.binding != null) {
                            variables.clear();
                        }
                        if (this.parentResources.isEmpty()) {
                            this.urlDefiningMode = true;
                        }
                    }
                }
                if (!this.urlDefiningMode && CONSTRAINTS.equals(mappedURI)) {
                    ConstrainedPropertyBuilder builder = new ConstrainedPropertyBuilder((Object)this);
                    if (args.length > 0 && args[0] instanceof Closure) {
                        Closure callable = (Closure)args[0];
                        callable.setDelegate((Object)builder);
                        for (ConstrainedProperty constrainedProperty : currentConstraints) {
                            builder.getConstrainedProperties().put(constrainedProperty.getPropertyName(), constrainedProperty);
                        }
                        callable.call();
                    }
                    Map map = builder.getConstrainedProperties();
                    return map;
                }
                Object object = super.invokeMethod(mappedURI, arg);
                return object;
            }
            finally {
                this.mappingInfoDeque.pop();
            }
        }

        private List<String> calculateIncludes(Map namedArguments, List<String> defaultResourcesIncludes) {
            Object includesObject;
            ArrayList<String> includes = new ArrayList<String>(defaultResourcesIncludes);
            Object excludesObject = namedArguments.get("excludes");
            if (excludesObject != null) {
                if (excludesObject instanceof List) {
                    List excludeList = (List)excludesObject;
                    for (Object exc : excludeList) {
                        if (exc == null) continue;
                        String excStr = exc.toString().toLowerCase();
                        includes.remove(excStr);
                    }
                } else {
                    includes.remove(excludesObject.toString());
                }
            }
            if ((includesObject = namedArguments.get("includes")) != null) {
                if (includesObject instanceof List) {
                    List includeList = (List)includesObject;
                    includes.clear();
                    for (Object inc : includeList) {
                        if (inc == null) continue;
                        String incStr = inc.toString().toLowerCase();
                        includes.add(incStr);
                    }
                } else {
                    includes.clear();
                    includes.add(includesObject.toString());
                }
            }
            return includes;
        }

        private String establishFullURI(String uri, List<ConstrainedProperty> constrainedList) {
            if (this.parentResources.isEmpty()) {
                return uri;
            }
            StringBuilder uriBuilder = new StringBuilder();
            ParentResource parentResource = this.parentResources.peek();
            if (parentResource.isSingle) {
                uriBuilder.append(parentResource.uri);
            } else if (parentResource.controllerName != null) {
                uriBuilder.append(parentResource.uri).append(SLASH).append(CAPTURING_WILD_CARD);
                constrainedList.add(new ConstrainedProperty(UrlMapping.class, parentResource.controllerName + "Id", String.class));
            }
            uriBuilder.append(uri);
            return uriBuilder.toString();
        }

        private void invokeLastArgumentIfClosure(Object[] args) {
            if (args.length > 1 && args[1] instanceof Closure) {
                ((Closure)args[1]).call();
            }
        }

        protected void createResourceRestfulMappings(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList, List<String> includes) {
            ConstrainedProperty[] constraintArray = constrainedList.toArray(new ConstrainedProperty[constrainedList.size()]);
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_INDEX)) {
                UrlMapping listUrlMapping = this.createIndexActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(listUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_CREATE)) {
                UrlMapping createUrlMapping = this.createCreateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(createUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SAVE)) {
                UrlMapping saveUrlMapping = this.createSaveActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(saveUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SHOW)) {
                UrlMapping showUrlMapping = this.createShowActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(showUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_EDIT)) {
                UrlMapping editUrlMapping = this.createEditActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(editUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_UPDATE)) {
                UrlMapping updateUrlMapping = this.createUpdateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(updateUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_PATCH)) {
                UrlMapping patchUrlMapping = this.createPatchActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(patchUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_DELETE)) {
                UrlMapping deleteUrlMapping = this.createDeleteActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(deleteUrlMapping);
            }
        }

        protected UrlMapping createDeleteActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData deleteUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> deleteUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(deleteUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_DELETE, namespace, pluginName, null, HttpMethod.DELETE.toString(), version, deleteUrlMappingConstraints.toArray(new ConstrainedProperty[deleteUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createUpdateActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData updateUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> updateUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(updateUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_UPDATE, namespace, pluginName, null, HttpMethod.PUT.toString(), version, updateUrlMappingConstraints.toArray(new ConstrainedProperty[updateUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createPatchActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData patchUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> patchUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(patchUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_PATCH, namespace, pluginName, null, HttpMethod.PATCH.toString(), version, patchUrlMappingConstraints.toArray(new ConstrainedProperty[patchUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createEditActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData editUrlMappingData = urlData.createRelative("/(*)/edit");
            ArrayList<ConstrainedProperty> editUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constrainedList);
            editUrlMappingConstraints.add(new ConstrainedProperty(UrlMapping.class, "id", String.class));
            return new RegexUrlMapping(editUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_EDIT, namespace, pluginName, null, HttpMethod.GET.toString(), version, editUrlMappingConstraints.toArray(new ConstrainedProperty[editUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createShowActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData showUrlMappingData = this.createRelativeUrlDataWithIdAndFormat(urlData);
            List<ConstrainedProperty> showUrlMappingConstraints = this.createConstraintsWithIdAndFormat(constrainedList);
            return new RegexUrlMapping(showUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SHOW, namespace, pluginName, null, HttpMethod.GET.toString(), version, showUrlMappingConstraints.toArray(new ConstrainedProperty[showUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        private List<ConstrainedProperty> createConstraintsWithIdAndFormat(List<ConstrainedProperty> constrainedList) {
            ArrayList<ConstrainedProperty> showUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constrainedList);
            showUrlMappingConstraints.add(new ConstrainedProperty(UrlMapping.class, "id", String.class));
            ConstrainedProperty cp = new ConstrainedProperty(UrlMapping.class, "format", String.class);
            cp.setNullable(true);
            showUrlMappingConstraints.add(cp);
            return showUrlMappingConstraints;
        }

        private UrlMappingData createRelativeUrlDataWithIdAndFormat(UrlMappingData urlData) {
            return urlData.createRelative("/(*)(.(*))?");
        }

        private UrlMappingData createFormatOnlyUrlMappingData(UrlMappingData urlData) {
            return urlData.createRelative("(.(*))?");
        }

        protected UrlMapping createSaveActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData saveActionUrlMappingData = urlData.createRelative("(.(*))?");
            List<ConstrainedProperty> saveUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(saveActionUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SAVE, namespace, pluginName, null, HttpMethod.POST.toString(), version, saveUrlMappingConstraints.toArray(new ConstrainedProperty[saveUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createCreateActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, ConstrainedProperty[] constraintArray) {
            UrlMappingData createMappingData = urlData.createRelative("/create");
            return new RegexUrlMapping(createMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_CREATE, namespace, pluginName, null, HttpMethod.GET.toString(), version, constraintArray, DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createIndexActionResourcesRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData indexActionUrlMappingData = urlData.createRelative("(.(*))?");
            List<ConstrainedProperty> indexUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(indexActionUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_INDEX, namespace, pluginName, null, HttpMethod.GET.toString(), version, indexUrlMappingConstraints.toArray(new ConstrainedProperty[indexUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        private List<ConstrainedProperty> createFormatOnlyConstraints(List<ConstrainedProperty> constrainedList) {
            ArrayList<ConstrainedProperty> indexUrlMappingConstraints = new ArrayList<ConstrainedProperty>(constrainedList);
            ConstrainedProperty cp = new ConstrainedProperty(UrlMapping.class, "format", String.class);
            cp.setNullable(true);
            indexUrlMappingConstraints.add(cp);
            return indexUrlMappingConstraints;
        }

        protected void createSingleResourceRestfulMappings(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList, List<String> includes) {
            ConstrainedProperty[] constraintArray = constrainedList.toArray(new ConstrainedProperty[constrainedList.size()]);
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_CREATE)) {
                UrlMapping createUrlMapping = this.createCreateActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(createUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SAVE)) {
                UrlMapping saveUrlMapping = this.createSaveActionResourcesRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(saveUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_SHOW)) {
                UrlMapping showUrlMapping = this.createShowActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(showUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_EDIT)) {
                UrlMapping editUrlMapping = this.createEditActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constraintArray);
                this.configureUrlMapping(editUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_UPDATE)) {
                UrlMapping updateUrlMapping = this.createUpdateActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(updateUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_PATCH)) {
                UrlMapping patchUrlMapping = this.createPatchActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(patchUrlMapping);
            }
            if (includes.contains(DefaultUrlMappingEvaluator.ACTION_DELETE)) {
                UrlMapping deleteUrlMapping = this.createDeleteActionResourceRestfulMapping(controllerName, pluginName, namespace, version, urlData, constrainedList);
                this.configureUrlMapping(deleteUrlMapping);
            }
        }

        protected UrlMapping createDeleteActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData deleteUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> deleteUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(deleteUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_DELETE, namespace, pluginName, null, HttpMethod.DELETE.toString(), version, deleteUrlMappingConstraints.toArray(new ConstrainedProperty[deleteUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createUpdateActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData updateUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> updateUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(updateUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_UPDATE, namespace, pluginName, null, HttpMethod.PUT.toString(), version, updateUrlMappingConstraints.toArray(new ConstrainedProperty[updateUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createPatchActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData patchUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> patchUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(patchUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_PATCH, namespace, pluginName, null, HttpMethod.PATCH.toString(), version, patchUrlMappingConstraints.toArray(new ConstrainedProperty[patchUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createEditActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, ConstrainedProperty[] constraintArray) {
            UrlMappingData editMappingData = urlData.createRelative("/edit");
            return new RegexUrlMapping(editMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_EDIT, namespace, pluginName, null, HttpMethod.GET.toString(), version, constraintArray, DefaultUrlMappingEvaluator.this.servletContext);
        }

        protected UrlMapping createShowActionResourceRestfulMapping(String controllerName, Object pluginName, Object namespace, String version, UrlMappingData urlData, List<ConstrainedProperty> constrainedList) {
            UrlMappingData showUrlMappingData = this.createFormatOnlyUrlMappingData(urlData);
            List<ConstrainedProperty> showUrlMappingConstraints = this.createFormatOnlyConstraints(constrainedList);
            return new RegexUrlMapping(showUrlMappingData, controllerName, DefaultUrlMappingEvaluator.ACTION_SHOW, namespace, pluginName, null, HttpMethod.GET.toString(), version, showUrlMappingConstraints.toArray(new ConstrainedProperty[showUrlMappingConstraints.size()]), DefaultUrlMappingEvaluator.this.servletContext);
        }

        private void configureUrlMapping(UrlMapping urlMapping) {
            if (this.binding != null) {
                Map vars = this.binding.getVariables();
                for (String key : vars.keySet()) {
                    if (!this.isNotCoreMappingKey(key)) continue;
                    this.parameterValues.put(key, vars.get(key));
                }
                this.binding.getVariables().clear();
            }
            if (urlMapping.getControllerName() != null) {
                this.parameterValues.put("controller", urlMapping.getControllerName());
            }
            if (urlMapping.getActionName() != null) {
                this.parameterValues.put("action", urlMapping.getActionName());
            }
            urlMapping.setParameterValues(new LinkedHashMap<String, Object>(this.parameterValues));
            this.urlMappings.add(urlMapping);
        }

        private boolean isNotCoreMappingKey(Object key) {
            return !"action".equals(key) && !"controller".equals(key) && !"view".equals(key);
        }

        private UrlMappingData createUrlMappingData(String methodName, boolean responseCode) {
            if (!responseCode) {
                return DefaultUrlMappingEvaluator.this.urlParser.parse(methodName);
            }
            return new ResponseCodeMappingData(methodName);
        }

        private boolean isResponseCode(String s) {
            int count = s.length();
            for (int i = 0; i < count; ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private UrlMapping getURLMappingForNamedArgs(Map namedArguments, UrlMappingData urlData, String mapping, boolean isResponseCode, List<ConstrainedProperty> constrainedList) {
            Object parseRequest;
            UrlMapping urlMapping;
            Map bindingVariables = this.binding != null ? this.binding.getVariables() : null;
            Object controllerName = this.getControllerName(namedArguments, bindingVariables);
            Object actionName = this.getActionName(namedArguments, bindingVariables);
            Object pluginName = this.getPluginName(namedArguments, bindingVariables);
            Object httpMethod = this.getHttpMethod(namedArguments, bindingVariables);
            Object version = this.getVersion(namedArguments, bindingVariables);
            Object namespace = this.getNamespace(namedArguments, bindingVariables);
            Object redirectInfo = this.getRedirectInfo(namedArguments, bindingVariables);
            Object viewName = this.getViewName(namedArguments, bindingVariables);
            if (actionName != null && viewName != null) {
                viewName = null;
                LOG.warn((Object)("Both [action] and [view] specified in URL mapping [" + mapping + "]. The action takes precendence!"));
            }
            Object uri = this.getURI(namedArguments, bindingVariables);
            ConstrainedProperty[] constraints = constrainedList.toArray(new ConstrainedProperty[constrainedList.size()]);
            if (uri != null) {
                try {
                    urlMapping = new RegexUrlMapping(urlData, new URI(uri.toString()), constraints, this.sc);
                }
                catch (URISyntaxException e) {
                    throw new UrlMappingException("Cannot map to invalid URI: " + e.getMessage(), e);
                }
            } else {
                urlMapping = this.createURLMapping(urlData, isResponseCode, redirectInfo, controllerName, actionName, namespace, pluginName, viewName, httpMethod != null ? httpMethod.toString() : null, version != null ? version.toString() : null, constraints);
            }
            Object exceptionArg = this.getException(namedArguments, bindingVariables);
            if (isResponseCode && exceptionArg != null) {
                if (exceptionArg instanceof Class) {
                    Class exClass = (Class)exceptionArg;
                    if (Throwable.class.isAssignableFrom(exClass)) {
                        ((ResponseCodeUrlMapping)urlMapping).setExceptionType(exClass);
                    } else {
                        LOG.error((Object)("URL mapping argument [exception] with value [" + exceptionArg + "] must be a subclass of java.lang.Throwable"));
                    }
                } else {
                    LOG.error((Object)("URL mapping argument [exception] with value [" + exceptionArg + "] must be a valid class"));
                }
            }
            if ((parseRequest = this.getParseRequest(namedArguments, bindingVariables)) instanceof Boolean) {
                urlMapping.setParseRequest((Boolean)parseRequest);
            }
            return urlMapping;
        }

        private Object getVariableFromNamedArgsOrBinding(Map namedArguments, Map bindingVariables, String variableName, Object defaultValue) {
            Object returnValue = namedArguments.get(variableName);
            if (returnValue == null) {
                returnValue = this.binding != null ? bindingVariables.get(variableName) : defaultValue;
            }
            return returnValue;
        }

        private Object getActionName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "action", this.getMetaMappingInfo().getAction());
        }

        private Object getParseRequest(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.PARSE_REQUEST, this.parseRequest);
        }

        private Object getControllerName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "controller", this.getMetaMappingInfo().getController());
        }

        private Object getPluginName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "plugin", this.getMetaMappingInfo().getPlugin());
        }

        private Object getHttpMethod(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "method", this.getMetaMappingInfo().getHttpMethod());
        }

        private Object getRedirectInfo(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "redirect", this.getMetaMappingInfo().getRedirectInfo());
        }

        private Object getVersion(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "version", this.getMetaMappingInfo().getView());
        }

        private Object getNamespace(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "namespace", this.getMetaMappingInfo().getNamespace());
        }

        private Object getViewName(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "view", this.getMetaMappingInfo().getView());
        }

        private Object getURI(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, "uri", this.getMetaMappingInfo().getUri());
        }

        private Object getException(Map namedArguments, Map bindingVariables) {
            return this.getVariableFromNamedArgsOrBinding(namedArguments, bindingVariables, DefaultUrlMappingEvaluator.EXCEPTION, this.exception);
        }

        private UrlMapping createURLMapping(UrlMappingData urlData, boolean isResponseCode, Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints) {
            if (!isResponseCode) {
                return new RegexUrlMapping(redirectInfo, urlData, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints, this.sc);
            }
            return new ResponseCodeUrlMapping(urlData, controllerName, actionName, namespace, pluginName, viewName, null, this.sc);
        }

        protected MetaMappingInfo pushNewMetaMappingInfo() {
            List<ConstrainedProperty> parentMappingConstraints;
            MetaMappingInfo mappingInfo = new MetaMappingInfo();
            MetaMappingInfo parentMappingInfo = this.mappingInfoDeque.peek();
            if (parentMappingInfo != null && (parentMappingConstraints = parentMappingInfo.getConstraints()) != null) {
                mappingInfo.getConstraints().addAll(parentMappingConstraints);
            }
            if (this.previousConstraints.size() > 0) {
                mappingInfo.getConstraints().addAll(this.previousConstraints);
                this.previousConstraints.clear();
            }
            this.mappingInfoDeque.push(mappingInfo);
            return mappingInfo;
        }

        protected MetaMappingInfo getMetaMappingInfo() {
            return this.mappingInfoDeque.peek();
        }

        class ParentResource {
            String controllerName;
            String uri;
            boolean isSingle;

            ParentResource(String controllerName, String uri, boolean single) {
                this.controllerName = controllerName;
                this.uri = uri;
                this.isSingle = single;
            }
        }
    }

    class MappingCapturingClosure
    extends Closure {
        private static final long serialVersionUID = 2108155626252742722L;
        private Closure<?> mappings;

        public Closure<?> getMappings() {
            return this.mappings;
        }

        public MappingCapturingClosure(Object o) {
            super(o);
        }

        public Object call(Object ... args) {
            if (args.length > 0 && args[0] instanceof Closure) {
                this.mappings = (Closure)args[0];
            }
            return null;
        }
    }
}

