/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.mvc;

import grails.web.mvc.FlashScope;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.mvc.OutputAwareHttpServletResponse;
import org.grails.web.servlet.mvc.ParameterCreationListener;
import org.grails.web.util.WebUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class GrailsWebRequestFilter
extends OncePerRequestFilter
implements ApplicationContextAware {
    Collection<ParameterCreationListener> paramListenerBeans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        LocaleContextHolder.setLocale((Locale)request.getLocale());
        response = new OutputAwareHttpServletResponse(response);
        boolean isIncludeOrForward = WebUtils.isForwardOrInclude((HttpServletRequest)request);
        GrailsWebRequest previous = isIncludeOrForward ? GrailsWebRequest.lookup((HttpServletRequest)request) : null;
        GrailsWebRequest webRequest = new GrailsWebRequest(request, response, this.getServletContext());
        this.configureParameterCreationListeners(webRequest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound Grails request context to thread: " + request));
        }
        try {
            WebUtils.storeGrailsWebRequest((GrailsWebRequest)webRequest);
            if (!isIncludeOrForward) {
                FlashScope fs = webRequest.getAttributes().getFlashScope((ServletRequest)request);
                fs.next();
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            webRequest.requestCompleted();
            if (isIncludeOrForward) {
                if (previous != null) {
                    WebUtils.storeGrailsWebRequest((GrailsWebRequest)previous);
                }
            } else {
                WebUtils.clearGrailsWebRequest();
                LocaleContextHolder.setLocale(null);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared Grails thread-bound request context: " + request));
            }
        }
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    private void configureParameterCreationListeners(GrailsWebRequest webRequest) {
        if (this.paramListenerBeans != null) {
            for (ParameterCreationListener creationListenerBean : this.paramListenerBeans) {
                webRequest.addParameterListener(creationListenerBean);
            }
        } else {
            this.logger.warn((Object)"paramListenerBeans isn't initialized.");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.paramListenerBeans = applicationContext.getBeansOfType(ParameterCreationListener.class).values();
    }
}

