/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.util.Proxy;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.core.io.support.GrailsFactoriesLoader;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.ActionResultTransformer;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.TokenResponseHandler;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.NoViewNameDefinedException;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.UnknownControllerException;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractGrailsControllerHelper
implements ApplicationContextAware,
ServletContextAware,
GrailsApplicationAware {
    protected GrailsApplication application;
    protected ApplicationContext applicationContext;
    protected ServletContext servletContext;
    protected GrailsApplicationAttributes grailsAttributes;
    private static final Log LOG = LogFactory.getLog(AbstractGrailsControllerHelper.class);
    private static final String PROPERTY_CHAIN_MODEL = "chainModel";
    private static final String FORWARD_IN_PROGRESS = "org.codehaus.groovy.grails.FORWARD_IN_PROGRESS";
    private static final String FORWARD_CALLED = "org.codehaus.groovy.grails.FORWARD_CALLED";
    private Collection<ActionResultTransformer> actionResultTransformers = Collections.emptyList();
    protected boolean developmentMode = Environment.isDevelopmentMode();
    protected Map<Class<?>, Boolean> allowedMethodsSupport = new HashMap();
    protected final boolean developerMode = Environment.isDevelopmentMode();

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public GrailsControllerClass getControllerClassByName(String name) {
        return (GrailsControllerClass)this.application.getArtefact("Controller", name);
    }

    public GrailsControllerClass getControllerClassByURI(String uri) {
        return (GrailsControllerClass)this.application.getArtefactForFeature("Controller", (Object)uri);
    }

    public GroovyObject getControllerInstance(GrailsControllerClass controllerClass) {
        return (GroovyObject)this.applicationContext.getBean(controllerClass.getFullName());
    }

    private void removeProxiesFromModelObjects(Map<Object, Object> model) {
        for (Map.Entry<Object, Object> entry : model.entrySet()) {
            if (!(entry.getValue() instanceof Proxy)) continue;
            entry.setValue(((Proxy)entry.getValue()).getAdaptee());
        }
    }

    public ModelAndView handleURI(String uri, GrailsWebRequest request) {
        return this.handleURI(uri, request, Collections.EMPTY_MAP);
    }

    public ModelAndView handleURI(String originalUri, GrailsWebRequest grailsWebRequest, Map params) {
        GroovyObject controller;
        boolean allowedMethodsHandledAtCompileTime;
        Assert.notNull((Object)originalUri, (String)("Controller URI [" + originalUri + "] cannot be null!"));
        HttpServletRequest request = grailsWebRequest.getCurrentRequest();
        HttpServletResponse response = grailsWebRequest.getCurrentResponse();
        String uri = originalUri;
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        GrailsControllerClass controllerClass = null;
        Object attribute = grailsWebRequest.getAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS", 0);
        if (attribute instanceof GrailsControllerClass) {
            controllerClass = (GrailsControllerClass)attribute;
            Boolean canUse = (Boolean)grailsWebRequest.getAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", 0);
            if (canUse == null) {
                controllerClass = null;
            } else {
                grailsWebRequest.removeAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", 0);
            }
        }
        if (controllerClass == null) {
            controllerClass = this.getControllerClassByURI(uri);
        }
        if (controllerClass == null) {
            throw new UnknownControllerException("No controller found for URI [" + uri + "]!");
        }
        String actionName = controllerClass.getMethodActionName(uri);
        if (controllerClass.isFlowAction(actionName)) {
            return null;
        }
        grailsWebRequest.setActionName(actionName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing request for controller action [" + actionName + "]"));
        }
        if (!(allowedMethodsHandledAtCompileTime = this.hasCompileTimeSupportForAllowedMethods(controller = this.getControllerInstance(controllerClass))) && !controllerClass.isHttpMethodAllowedForAction(controller, request.getMethod(), actionName)) {
            try {
                response.sendError(405);
                return null;
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error sending 405 error", (Throwable)e);
            }
        }
        request.setAttribute("org.codehaus.groovy.grails.CONTROLLER", (Object)controller);
        request.setAttribute("org.codehaus.groovy.grails.GRAILS_APPLICATION_ATTRIBUTES", (Object)this.grailsAttributes);
        String viewName = controllerClass.getViewByURI(uri);
        boolean executeAction = this.invokeBeforeInterceptor(controller, actionName, controllerClass);
        if (!executeAction) {
            return null;
        }
        ModelAndView mv = this.executeAction(controller, actionName, viewName, grailsWebRequest, params);
        boolean returnModelAndView = this.invokeAfterInterceptor(controllerClass, controller, actionName, mv) && !response.isCommitted();
        return returnModelAndView ? mv : null;
    }

    protected boolean hasCompileTimeSupportForAllowedMethods(GroovyObject controller) {
        Class<?> controllerClass = controller.getClass();
        Boolean allowedMethodsHandledAtCompileTime = this.allowedMethodsSupport.get(controllerClass);
        if (allowedMethodsHandledAtCompileTime == null) {
            allowedMethodsHandledAtCompileTime = GrailsClassUtils.hasBeenEnhancedForFeature(controllerClass, (String)"allowedMethods");
            if (!this.developerMode) {
                this.allowedMethodsSupport.put(controllerClass, allowedMethodsHandledAtCompileTime);
            }
        }
        return allowedMethodsHandledAtCompileTime;
    }

    protected abstract Object retrieveAction(GroovyObject var1, String var2, HttpServletResponse var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelAndView executeAction(GroovyObject controller, String actionName, String viewName, GrailsWebRequest webRequest, Map params) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        HttpServletResponse response = webRequest.getCurrentResponse();
        HttpServletRequest request = webRequest.getCurrentRequest();
        try {
            Object action = this.retrieveAction(controller, actionName, response);
            Object returnValue = null;
            try {
                returnValue = this.handleAction(controller, action, request, response, params);
                for (ActionResultTransformer actionResultTransformer : this.actionResultTransformers) {
                    returnValue = actionResultTransformer.transformActionResult(webRequest, viewName, returnValue);
                }
            }
            catch (Throwable t) {
                String pluginName = GrailsPluginUtils.getPluginName(controller.getClass());
                pluginName = pluginName != null ? "in plugin [" + pluginName + "]" : "";
                throw new ControllerExecutionException("Executing action [" + actionName + "] of controller [" + controller.getClass().getName() + "] " + pluginName + " caused exception: " + t.getMessage(), t);
            }
            Map chainModel = this.initChainModel(request);
            if (response.isCommitted() || request.getAttribute("org.codehaus.groovy.grails.REDIRECT_ISSUED") != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Response has been redirected, returning null model and view");
                }
                ModelAndView pluginName = null;
                return pluginName;
            }
            TokenResponseHandler handler = (TokenResponseHandler)request.getAttribute("org.codehaus.groovy.grails.TOKEN_RESPONSE_HANDLER");
            if (handler != null && !handler.wasInvoked() && handler.wasInvalidToken()) {
                String uri = (String)request.getAttribute("SYNCHRONIZER_URI");
                if (uri == null) {
                    uri = WebUtils.getForwardURI((HttpServletRequest)request);
                }
                try {
                    FlashScope flashScope = webRequest.getFlashScope();
                    flashScope.put((Object)"invalidToken", (Object)request.getParameter("SYNCHRONIZER_TOKEN"));
                    response.sendRedirect(uri);
                    ModelAndView modelAndView = null;
                    return modelAndView;
                }
                catch (IOException e) {
                    throw new ControllerExecutionException("I/O error sending redirect to URI: " + uri, (Throwable)e);
                }
            }
            if (request.getAttribute(FORWARD_CALLED) == null && request.getAttribute("org.codehaus.groovy.grails.ASYNC_STARTED") == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Action [" + actionName + "] executed with result [" + returnValue + "] and view name [" + viewName + "]"));
                }
                ModelAndView mv = this.handleActionResponse(controller, returnValue, webRequest, chainModel, actionName, viewName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Action [" + actionName + "] handled, created Spring model and view [" + mv + "]"));
                }
                ModelAndView modelAndView = mv;
                return modelAndView;
            }
            ModelAndView modelAndView = null;
            return modelAndView;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (AccessControlException accessControlException) {}
        }
    }

    private boolean invokeBeforeInterceptor(GroovyObject controller, String actionName, GrailsControllerClass controllerClass) {
        if (!controllerClass.isInterceptedBefore(controller, actionName)) {
            return true;
        }
        Closure beforeInterceptor = controllerClass.getBeforeInterceptor(controller);
        if (beforeInterceptor == null) {
            return true;
        }
        Object interceptorResult = beforeInterceptor.call();
        return interceptorResult instanceof Boolean ? (Boolean)interceptorResult : true;
    }

    private boolean invokeAfterInterceptor(GrailsControllerClass controllerClass, GroovyObject controller, String actionName, ModelAndView mv) {
        if (!controllerClass.isInterceptedAfter(controller, actionName)) {
            return true;
        }
        Object interceptorResult = null;
        Closure afterInterceptor = controllerClass.getAfterInterceptor(controller);
        HashMap model = new HashMap();
        if (mv != null) {
            model = mv.getModel() == null ? new HashMap() : mv.getModel();
        }
        switch (afterInterceptor.getMaximumNumberOfParameters()) {
            case 1: {
                interceptorResult = afterInterceptor.call(new Object[]{model});
                break;
            }
            case 2: {
                interceptorResult = afterInterceptor.call(new Object[]{model, mv});
                break;
            }
            default: {
                throw new ControllerExecutionException("AfterInterceptor closure must accept one or two parameters");
            }
        }
        return interceptorResult instanceof Boolean ? (Boolean)interceptorResult : true;
    }

    public GrailsApplicationAttributes getGrailsAttributes() {
        return this.grailsAttributes;
    }

    public Object handleAction(GroovyObject controller, Object action, HttpServletRequest request, HttpServletResponse response) {
        return this.handleAction(controller, action, request, response, Collections.EMPTY_MAP);
    }

    protected abstract Object invoke(GroovyObject var1, Object var2);

    public Object handleAction(GroovyObject controller, Object action, HttpServletRequest request, HttpServletResponse response, Map params) {
        GrailsParameterMap paramsMap = (GrailsParameterMap)controller.getProperty("params");
        if (params != null && !params.isEmpty()) {
            paramsMap.putAll(params);
        }
        Object returnValue = action == null ? null : this.invoke(controller, action);
        request.setAttribute("org.codehaus.groovy.grails.ERRORS", controller.getProperty("errors"));
        return returnValue;
    }

    public ModelAndView handleActionResponse(GroovyObject controller, Object returnValue, GrailsWebRequest webRequest, Map chainModel, String closurePropertyName, String viewName) {
        boolean viewNameBlank = !StringUtils.hasLength((String)viewName);
        ModelAndView explicitModelAndView = (ModelAndView)controller.getProperty("modelAndView");
        if (!webRequest.isRenderView()) {
            return null;
        }
        if (explicitModelAndView != null) {
            return explicitModelAndView;
        }
        if (returnValue == null) {
            if (viewNameBlank) {
                return null;
            }
            return new ModelAndView(viewName, chainModel);
        }
        if (returnValue instanceof Map) {
            LinkedHashMap<Object, Object> finalModel = new LinkedHashMap<Object, Object>();
            if (!chainModel.isEmpty()) {
                finalModel.putAll(chainModel);
            }
            Map returnModel = (Map)returnValue;
            finalModel.putAll(returnModel);
            this.removeProxiesFromModelObjects(finalModel);
            return new ModelAndView(viewName, finalModel);
        }
        if (returnValue instanceof ModelAndView) {
            ModelAndView modelAndView = (ModelAndView)returnValue;
            Map modelMap = modelAndView.getModel();
            this.removeProxiesFromModelObjects(modelMap);
            if (!chainModel.isEmpty()) {
                modelAndView.addAllObjects(chainModel);
            }
            if (modelAndView.getView() == null && modelAndView.getViewName() == null) {
                if (viewNameBlank) {
                    throw new NoViewNameDefinedException("ModelAndView instance returned by and no view name defined by nor for closure on property [" + closurePropertyName + "] in controller [" + controller.getClass() + "]!");
                }
                modelAndView.setViewName(viewName);
            }
            return modelAndView;
        }
        return new ModelAndView(viewName, chainModel);
    }

    private Map initChainModel(HttpServletRequest request) {
        FlashScope fs = this.grailsAttributes.getFlashScope((ServletRequest)request);
        if (fs.containsKey((Object)PROPERTY_CHAIN_MODEL)) {
            Map chainModel = (Map)fs.get((Object)PROPERTY_CHAIN_MODEL);
            if (chainModel == null) {
                chainModel = Collections.EMPTY_MAP;
            }
            return chainModel;
        }
        return Collections.EMPTY_MAP;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.actionResultTransformers = applicationContext.getBeansOfType(ActionResultTransformer.class).values();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.grailsAttributes = (GrailsApplicationAttributes)GrailsFactoriesLoader.loadFactoriesWithArguments(GrailsApplicationAttributes.class, (ClassLoader)this.getClass().getClassLoader(), (Object[])new Object[]{servletContext}).get(0);
    }

    public void setGrailsApplication(GrailsApplication application) {
        this.application = application;
    }
}

