/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.json;

import groovy.lang.Writable;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.grails.web.json.JSONException;
import org.grails.web.json.JSONObject;

public class JSONWriter {
    protected boolean comma = false;
    protected Mode mode;
    private Stack<Mode> stack = new Stack();
    protected Writer writer;
    static Writable nullWritable = new NullWritable();

    public JSONWriter(Writer w) {
        this.mode = Mode.INIT;
        this.writer = w;
    }

    protected JSONWriter append(String s) {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        return this.append(new WritableString(s));
    }

    protected JSONWriter append(Writable writableValue) {
        if (this.mode == Mode.OBJECT || this.mode == Mode.ARRAY) {
            try {
                if (this.comma && this.mode == Mode.ARRAY) {
                    this.comma();
                }
                writableValue.writeTo(this.writer);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.mode == Mode.OBJECT) {
                this.mode = Mode.KEY;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence: expected mode to be OBJECT or ARRAY when writing '" + writableValue + "' but was " + this.mode);
    }

    protected void comma() {
        try {
            this.writer.write(44);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public JSONWriter array() {
        if (this.mode == Mode.INIT || this.mode == Mode.OBJECT || this.mode == Mode.ARRAY) {
            this.push(Mode.ARRAY);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array: expected mode of INIT, OBJECT or ARRAY but was " + this.mode);
    }

    protected JSONWriter end(Mode m, char c) {
        if (this.mode != m) {
            throw new JSONException(m == Mode.OBJECT ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() {
        return this.end(Mode.ARRAY, ']');
    }

    public JSONWriter endObject() {
        return this.end(Mode.KEY, '}');
    }

    public JSONWriter key(String s) {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == Mode.KEY) {
            try {
                if (this.comma) {
                    this.comma();
                }
                JSONObject.writeQuoted(this.writer, s);
                this.writer.write(58);
                this.comma = false;
                this.mode = Mode.OBJECT;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw new JSONException("Misplaced key: expected mode of KEY but was " + this.mode);
    }

    public JSONWriter object() {
        if (this.mode == Mode.INIT) {
            this.mode = Mode.OBJECT;
        }
        if (this.mode == Mode.OBJECT || this.mode == Mode.ARRAY) {
            this.append("{");
            this.push(Mode.KEY);
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object: expected mode of INIT, OBJECT or ARRAY but was " + this.mode);
    }

    protected void pop(Mode c) {
        if (this.stack.size() == 0 || this.stack.pop() != c) {
            throw new JSONException("Nesting error.");
        }
        this.mode = this.stack.size() > 0 ? this.stack.peek() : Mode.DONE;
    }

    protected void push(Mode c) {
        this.stack.push(c);
        this.mode = c;
    }

    public JSONWriter value(boolean b) {
        return this.append(b ? "true" : "false");
    }

    public JSONWriter value(double d) {
        return this.value((Number)d);
    }

    public JSONWriter value(long l) {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(Number number) {
        return number != null ? this.append(number.toString()) : this.valueNull();
    }

    public JSONWriter valueNull() {
        return this.append(nullWritable);
    }

    public JSONWriter value(Object o) {
        return o != null ? this.append(new QuotedWritable(o)) : this.valueNull();
    }

    protected static enum Mode {
        INIT,
        OBJECT,
        ARRAY,
        KEY,
        DONE;

    }

    private static class WritableString
    implements Writable {
        private String string;

        WritableString(String string) {
            this.string = string;
        }

        public Writer writeTo(Writer out) throws IOException {
            out.write(this.string);
            return out;
        }

        public String toString() {
            return this.string;
        }
    }

    private static class QuotedWritable
    implements Writable {
        Object o;

        QuotedWritable(Object o) {
            this.o = o;
        }

        public Writer writeTo(Writer out) throws IOException {
            JSONObject.writeValue(out, this.o);
            return out;
        }

        public String toString() {
            return String.valueOf(this.o);
        }
    }

    private static class NullWritable
    implements Writable {
        private NullWritable() {
        }

        public Writer writeTo(Writer out) throws IOException {
            out.write("null");
            return out;
        }
    }
}

