/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import grails.validation.DeferredBindingActions;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.core.io.support.GrailsFactoriesLoader;
import org.codehaus.groovy.grails.support.encoding.CodecLookupHelper;
import org.codehaus.groovy.grails.support.encoding.DefaultEncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistryLookup;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistryLookupHolder;
import org.codehaus.groovy.grails.web.beans.PropertyEditorRegistryUtils;
import org.codehaus.groovy.grails.web.pages.FilteringCodecsByContentTypeSettings;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsHttpSession;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.ParameterCreationListener;
import org.codehaus.groovy.grails.web.servlet.mvc.ParameterInitializationCallback;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UrlPathHelper;

public class GrailsWebRequest
extends DispatcherServletWebRequest
implements ParameterInitializationCallback {
    private static final Class<? extends GrailsApplicationAttributes> grailsApplicationAttributesClass = (Class)GrailsFactoriesLoader.loadFactoryClasses(GrailsApplicationAttributes.class, (ClassLoader)GrailsWebRequest.class.getClassLoader()).get(0);
    private static final Constructor<? extends GrailsApplicationAttributes> grailsApplicationAttributesConstructor = ClassUtils.getConstructorIfAvailable(grailsApplicationAttributesClass, (Class[])new Class[]{ServletContext.class});
    private GrailsApplicationAttributes attributes;
    private GrailsParameterMap params;
    private GrailsParameterMap originalParams;
    private GrailsHttpSession session;
    private boolean renderView = true;
    private boolean skipFilteringCodec = false;
    private Encoder filteringEncoder;
    public static final String ID_PARAMETER = "id";
    private final List<ParameterCreationListener> parameterCreationListeners = new ArrayList<ParameterCreationListener>();
    private final UrlPathHelper urlHelper = new UrlPathHelper();
    private ApplicationContext applicationContext;
    private String baseUrl;
    private HttpServletResponse wrappedResponse;
    private EncodingStateRegistry encodingStateRegistry;

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, GrailsApplicationAttributes attributes) {
        super(request, response);
        this.attributes = attributes;
        this.inheritEncodingStateRegistry();
    }

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(request, response);
        try {
            this.attributes = grailsApplicationAttributesConstructor.newInstance(servletContext);
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        this.inheritEncodingStateRegistry();
    }

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ApplicationContext applicationContext) {
        this(request, response, servletContext);
        this.applicationContext = applicationContext;
    }

    private void inheritEncodingStateRegistry() {
        GrailsWebRequest parentRequest = GrailsWebRequest.lookup(this.getRequest());
        if (parentRequest != null) {
            this.encodingStateRegistry = parentRequest.getEncodingStateRegistry();
        }
    }

    public Map getParameterMap() {
        if (this.params == null) {
            this.resetParams();
        }
        return this.params;
    }

    public void requestCompleted() {
        super.requestCompleted();
        DeferredBindingActions.clear();
    }

    public Writer getOut() {
        Writer out = this.attributes.getOut(this.getCurrentRequest());
        if (out == null) {
            try {
                return this.getCurrentResponse().getWriter();
            }
            catch (IOException e) {
                throw new ControllerExecutionException("Error retrieving response writer: " + e.getMessage(), e);
            }
        }
        return out;
    }

    public boolean isActive() {
        return super.isRequestActive();
    }

    public void setOut(Writer out) {
        this.attributes.setOut(this.getCurrentRequest(), out);
    }

    public ServletContext getServletContext() {
        return this.attributes.getServletContext();
    }

    public String getContextPath() {
        HttpServletRequest request = this.getCurrentRequest();
        String appUri = (String)request.getAttribute("org.codehaus.groovy.grails.APP_URI_ATTRIBUTE");
        if (appUri == null) {
            appUri = this.urlHelper.getContextPath(request);
        }
        return appUri;
    }

    public FlashScope getFlashScope() {
        return this.attributes.getFlashScope((ServletRequest)this.getRequest());
    }

    public HttpServletRequest getCurrentRequest() {
        return this.getRequest();
    }

    public HttpServletResponse getCurrentResponse() {
        if (this.wrappedResponse != null) {
            return this.wrappedResponse;
        }
        return this.getResponse();
    }

    public HttpServletResponse getWrappedResponse() {
        return this.wrappedResponse;
    }

    public void setWrappedResponse(HttpServletResponse wrappedResponse) {
        this.wrappedResponse = wrappedResponse;
    }

    public GrailsParameterMap getParams() {
        if (this.params == null) {
            this.resetParams();
        }
        return this.params;
    }

    public void resetParams() {
        if (this.originalParams == null) {
            this.originalParams = new GrailsParameterMap(this.getCurrentRequest());
        }
        this.params = (GrailsParameterMap)this.originalParams.clone();
    }

    public void addParametersFrom(Map previousParams) {
        if (previousParams instanceof GrailsParameterMap) {
            this.getParams().addParametersFrom((GrailsParameterMap)previousParams);
        } else {
            for (Object key : previousParams.keySet()) {
                String name = String.valueOf(key);
                this.getParams().put(name, previousParams.get(key));
            }
        }
    }

    public void informParameterCreationListeners() {
        for (ParameterCreationListener parameterCreationListener : this.parameterCreationListeners) {
            parameterCreationListener.paramsCreated(this.getParams());
        }
    }

    public GrailsHttpSession getSession() {
        if (this.session == null) {
            this.session = new GrailsHttpSession(this.getCurrentRequest());
        }
        return this.session;
    }

    public GrailsApplicationAttributes getAttributes() {
        return this.attributes;
    }

    public void setActionName(String actionName) {
        this.getCurrentRequest().setAttribute("org.codehaus.groovy.grails.ACTION_NAME_ATTRIBUTE", (Object)actionName);
    }

    public void setControllerName(String controllerName) {
        this.getCurrentRequest().setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controllerName);
    }

    public void setControllerNamespace(String controllerNamespace) {
        this.getCurrentRequest().setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAMESPACE_ATTRIBUTE", (Object)controllerNamespace);
    }

    public String getActionName() {
        return (String)this.getCurrentRequest().getAttribute("org.codehaus.groovy.grails.ACTION_NAME_ATTRIBUTE");
    }

    public String getControllerName() {
        return (String)this.getCurrentRequest().getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE");
    }

    public Object getControllerClass() {
        return this.getCurrentRequest().getAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS");
    }

    public String getControllerNamespace() {
        return (String)this.getCurrentRequest().getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAMESPACE_ATTRIBUTE");
    }

    public void setRenderView(boolean renderView) {
        this.renderView = renderView;
    }

    public boolean isRenderView() {
        return this.renderView;
    }

    public String getId() {
        Object id = this.getParams().get(ID_PARAMETER);
        return id == null ? null : id.toString();
    }

    public boolean isFlowRequest() {
        GrailsApplication application = this.getAttributes().getGrailsApplication();
        Object controllerClassObject = this.getControllerClass();
        GrailsControllerClass controllerClass = null;
        if (controllerClassObject instanceof GrailsControllerClass) {
            controllerClass = (GrailsControllerClass)controllerClassObject;
        }
        if (controllerClass == null) {
            return false;
        }
        String actionName = this.getActionName();
        if (actionName == null) {
            actionName = controllerClass.getDefaultAction();
        }
        if (actionName == null) {
            return false;
        }
        return controllerClass.isFlowAction(actionName);
    }

    @Override
    public void addParameterListener(ParameterCreationListener creationListener) {
        this.parameterCreationListeners.add(creationListener);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext == null ? this.getAttributes().getApplicationContext() : this.applicationContext;
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        HttpServletRequest servletRequest = this.getCurrentRequest();
        PropertyEditorRegistry registry = (PropertyEditorRegistry)servletRequest.getAttribute("org.codehaus.groovy.grails.PROPERTY_REGISTRY");
        if (registry == null) {
            registry = new PropertyEditorRegistrySupport();
            PropertyEditorRegistryUtils.registerCustomEditors(this, registry, RequestContextUtils.getLocale((HttpServletRequest)servletRequest));
            servletRequest.setAttribute("org.codehaus.groovy.grails.PROPERTY_REGISTRY", (Object)registry);
        }
        return registry;
    }

    public static GrailsWebRequest lookup(HttpServletRequest request) {
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        return webRequest == null ? GrailsWebRequest.lookup() : webRequest;
    }

    public static GrailsWebRequest lookup() {
        GrailsWebRequest webRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof GrailsWebRequest) {
            webRequest = (GrailsWebRequest)requestAttributes;
        }
        return webRequest;
    }

    public static GrailsApplication lookupApplication() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof GrailsWebRequest) {
            return ((GrailsWebRequest)requestAttributes).getAttributes().getGrailsApplication();
        }
        return null;
    }

    public void setId(Object id) {
        this.getParams().put(ID_PARAMETER, id);
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            String contextPath;
            HttpServletRequest request = this.getCurrentRequest();
            String scheme = request.getScheme();
            StringBuilder sb = new StringBuilder();
            sb.append(scheme).append("://").append(request.getServerName());
            int port = request.getServerPort();
            if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
                sb.append(":").append(port);
            }
            if ((contextPath = request.getContextPath()) != null) {
                sb.append(contextPath);
            }
            this.baseUrl = sb.toString();
        }
        return this.baseUrl;
    }

    public EncodingStateRegistry getEncodingStateRegistry() {
        if (this.encodingStateRegistry == null) {
            this.encodingStateRegistry = new DefaultEncodingStateRegistry();
        }
        return this.encodingStateRegistry;
    }

    public boolean isSkipFilteringCodec() {
        return this.skipFilteringCodec;
    }

    public void setSkipFilteringCodec(boolean skipCodec) {
        this.skipFilteringCodec = skipCodec;
    }

    public String getFilteringCodec() {
        return this.filteringEncoder != null ? this.filteringEncoder.getCodecIdentifier().getCodecName() : null;
    }

    public void setFilteringCodec(String codecName) {
        this.filteringEncoder = codecName != null ? CodecLookupHelper.lookupEncoder((GrailsApplication)this.attributes.getGrailsApplication(), (String)codecName) : null;
    }

    public Encoder lookupFilteringEncoder() {
        if (this.filteringEncoder == null && this.applicationContext != null && this.applicationContext.containsBean("filteringCodecsByContentTypeSettings")) {
            this.filteringEncoder = ((FilteringCodecsByContentTypeSettings)this.applicationContext.getBean("filteringCodecsByContentTypeSettings", FilteringCodecsByContentTypeSettings.class)).getEncoderForContentType(this.getResponse().getContentType());
        }
        return this.filteringEncoder;
    }

    public Encoder getFilteringEncoder() {
        return this.filteringEncoder;
    }

    public void setFilteringEncoder(Encoder filteringEncoder) {
        this.filteringEncoder = filteringEncoder;
    }

    static {
        EncodingStateRegistryLookupHolder.setEncodingStateRegistryLookup((EncodingStateRegistryLookup)new DefaultEncodingStateRegistryLookup());
    }

    private static final class DefaultEncodingStateRegistryLookup
    implements EncodingStateRegistryLookup {
        private DefaultEncodingStateRegistryLookup() {
        }

        public EncodingStateRegistry lookup() {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            return webRequest == null ? null : webRequest.getEncodingStateRegistry();
        }
    }
}

