/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import groovy.lang.Range;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.validation.AbstractConstraint;
import org.springframework.validation.Errors;

public class RangeConstraint
extends AbstractConstraint {
    Range range;

    public Range getRange() {
        return this.range;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (Comparable.class.isAssignableFrom(type) || GrailsClassUtils.isAssignableOrConvertibleFrom(Number.class, (Class)type));
    }

    @Override
    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Range)) {
            throw new IllegalArgumentException("Parameter for constraint [range] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [groovy.lang.Range]");
        }
        this.range = (Range)constraintParameter;
        super.setParameter(constraintParameter);
    }

    @Override
    public String getName() {
        return "range";
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (this.range.contains(propertyValue)) {
            return;
        }
        Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.range.getFrom(), this.range.getTo()};
        Comparable from = this.range.getFrom();
        Comparable to = this.range.getTo();
        if (from instanceof Number && propertyValue instanceof Number) {
            from = Long.valueOf(((Number)((Object)from)).longValue());
            to = Long.valueOf(((Number)((Object)to)).longValue());
            propertyValue = ((Number)propertyValue).longValue();
        }
        if (from.compareTo(propertyValue) > 0) {
            this.rejectValue(target, errors, "default.invalid.range.message", "range.toosmall", args);
        } else if (to.compareTo(propertyValue) < 0) {
            this.rejectValue(target, errors, "default.invalid.range.message", "range.toobig", args);
        }
    }
}

