/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection.test;

import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.test.mixin.TestFor;
import grails.test.mixin.domain.DomainClassUnitTestMixin;
import grails.test.mixin.support.MixinMethod;
import grails.test.mixin.support.TestMixinRegistrar;
import grails.test.mixin.support.TestMixinRegistry;
import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.compiler.injection.test.TestMixinTransformation;
import org.grails.compiler.logging.LoggingTransformer;
import org.grails.core.io.DefaultResourceLocator;
import org.grails.core.io.ResourceLocator;
import org.grails.core.io.support.GrailsFactoriesLoader;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TestForTransformation
extends TestMixinTransformation
implements TestMixinRegistry {
    private static final ClassNode MY_TYPE = new ClassNode(TestFor.class);
    private static final Token ASSIGN = Token.newSymbol((String)"=", (int)-1, (int)-1);
    protected static final Map<String, Class> artefactTypeToTestMap = new HashMap<String, Class>();
    public static final String DOMAIN_TYPE = "Domain";
    public static final ClassNode BEFORE_CLASS_NODE;
    public static final AnnotationNode BEFORE_ANNOTATION;
    public static final ClassNode AFTER_CLASS_NODE;
    public static final AnnotationNode AFTER_ANNOTATION;
    public static final AnnotationNode TEST_ANNOTATION;
    private static final String GROOVY_TEST_CASE_CLASS_NAME = "groovy.util.GroovyTestCase";
    public static final String VOID_TYPE = "void";
    private ResourceLocator resourceLocator;
    private Map<ClassNode, List<Class>> wovenMixins = new HashMap<ClassNode, List<Class>>();

    public ResourceLocator getResourceLocator() {
        if (this.resourceLocator == null) {
            this.resourceLocator = new DefaultResourceLocator();
            String basedir = BuildSettings.BASE_DIR.getAbsolutePath();
            this.resourceLocator.setSearchLocation(basedir);
        }
        return this.resourceLocator;
    }

    @Override
    public void visit(ASTNode[] astNodes, SourceUnit source) {
        boolean isJunit;
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!MY_TYPE.equals((Object)node.getClassNode()) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode classNode = (ClassNode)parent;
        if (classNode.isInterface() || Modifier.isAbstract(classNode.getModifiers())) {
            return;
        }
        boolean junit3Test = TestForTransformation.isJunit3Test(classNode);
        boolean spockTest = TestForTransformation.isSpockTest(classNode);
        boolean bl = isJunit = !junit3Test && !spockTest;
        if (!(junit3Test || spockTest || isJunit)) {
            return;
        }
        this.handleTestForAnnotation(classNode, source, node, junit3Test);
        this.addEnableEMCStatement(classNode);
    }

    protected void handleTestForAnnotation(ClassNode classNode, SourceUnit source, AnnotationNode testForAnnotationNode, boolean junit3Test) {
        block16: {
            Expression value = testForAnnotationNode.getMember("value");
            if (value instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)value;
                this.testFor(classNode, ce);
                return;
            }
            if (junit3Test) {
                return;
            }
            List annotations = classNode.getAnnotations(MY_TYPE);
            if (annotations.size() > 0) {
                return;
            }
            annotations = classNode.getAnnotations(TestMixinTransformation.MY_TYPE);
            if (annotations.size() > 0) {
                return;
            }
            String fileName = source.getName();
            String className = GrailsResourceUtils.getClassName((Resource)new FileSystemResource(fileName));
            if (className == null) {
                return;
            }
            String targetClassName = null;
            if (className.endsWith("Tests")) {
                targetClassName = className.substring(0, className.indexOf("Tests"));
            } else if (className.endsWith("Test")) {
                targetClassName = className.substring(0, className.indexOf("Test"));
            } else if (className.endsWith("Spec")) {
                targetClassName = className.substring(0, className.indexOf("Spec"));
            }
            if (targetClassName == null) {
                return;
            }
            org.springframework.core.io.Resource targetResource = this.getResourceLocator().findResourceForClassName(targetClassName);
            if (targetResource == null) {
                return;
            }
            try {
                if (GrailsResourceUtils.isDomainClass((URL)targetResource.getURL())) {
                    this.testFor(classNode, new ClassExpression(new ClassNode(targetClassName, 0, ClassHelper.OBJECT_TYPE)));
                    break block16;
                }
                for (String artefactType : artefactTypeToTestMap.keySet()) {
                    if (!targetClassName.endsWith(artefactType)) continue;
                    this.testFor(classNode, new ClassExpression(new ClassNode(targetClassName, 0, ClassHelper.OBJECT_TYPE)));
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void testFor(ClassNode classNode, ClassExpression ce) {
        MethodNode methodToAdd;
        boolean isSpockTest;
        boolean isJunit4;
        this.autoAnnotateSetupTeardown(classNode);
        boolean isJunit3Test = TestForTransformation.isJunit3Test(classNode);
        FieldNode log = classNode.getField("log");
        if (log == null || log.getDeclaringClass().getName().equals(GROOVY_TEST_CASE_CLASS_NAME)) {
            LoggingTransformer.addLogField((ClassNode)classNode, (String)classNode.getName());
        }
        boolean bl = isJunit4 = !(isSpockTest = TestForTransformation.isSpockTest(classNode)) && !isJunit3Test;
        if (isJunit4) {
            Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
            boolean hasTestMethods = false;
            for (String methodName : declaredMethodsMap.keySet()) {
                ClassNode returnType;
                MethodNode methodNode = (MethodNode)declaredMethodsMap.get(methodName);
                ClassNode testAnnotationClassNode = TEST_ANNOTATION.getClassNode();
                List existingTestAnnotations = methodNode.getAnnotations(testAnnotationClassNode);
                if (!this.isCandidateMethod(methodNode) || !methodNode.getName().startsWith("test") && existingTestAnnotations.size() <= 0) continue;
                if (existingTestAnnotations.size() == 0 && (returnType = methodNode.getReturnType()).getName().equals(VOID_TYPE)) {
                    methodNode.addAnnotation(TEST_ANNOTATION);
                }
                hasTestMethods = true;
            }
            if (!hasTestMethods) {
                isJunit4 = false;
            }
        }
        if ((isJunit4 || isJunit3Test || isSpockTest) && (methodToAdd = this.weaveMock(classNode, ce, true)) != null && isJunit3Test) {
            TestForTransformation.addMethodCallsToMethod(classNode, "setUp", Arrays.asList(methodToAdd));
        }
    }

    protected MethodNode weaveMock(ClassNode classNode, ClassExpression value, boolean isClassUnderTest) {
        ClassNode testTarget = value.getType();
        String className = testTarget.getName();
        MethodNode testForMethod = null;
        for (String artefactType : artefactTypeToTestMap.keySet()) {
            if (!className.endsWith(artefactType)) continue;
            Class mixinClass = artefactTypeToTestMap.get(artefactType);
            if (!this.isAlreadyWoven(classNode, mixinClass)) {
                this.weaveMixinClass(classNode, mixinClass);
                if (isClassUnderTest) {
                    testForMethod = this.addClassUnderTestMethod(classNode, value, artefactType);
                } else {
                    this.addMockCollaboratorToSetup(classNode, value, artefactType);
                }
                return testForMethod;
            }
            this.addMockCollaboratorToSetup(classNode, value, artefactType);
            return null;
        }
        this.weaveMixinClass(classNode, DomainClassUnitTestMixin.class);
        if (isClassUnderTest) {
            testForMethod = this.addClassUnderTestMethod(classNode, value, DOMAIN_TYPE);
        } else {
            this.addMockCollaboratorToSetup(classNode, value, DOMAIN_TYPE);
        }
        return testForMethod;
    }

    protected Class getMixinClassForArtefactType(ClassNode classNode) {
        String className = classNode.getName();
        for (String artefactType : artefactTypeToTestMap.keySet()) {
            Class mixinClass;
            if (!className.endsWith(artefactType) || (mixinClass = artefactTypeToTestMap.get(artefactType)) == null) continue;
            return mixinClass;
        }
        return null;
    }

    private void addMockCollaboratorToSetup(ClassNode classNode, ClassExpression targetClassExpression, String artefactType) {
        BlockStatement methodBody = this.getOrCreateTestSetupMethod(classNode);
        this.addMockCollaborator(artefactType, targetClassExpression, methodBody);
    }

    protected BlockStatement getOrCreateTestSetupMethod(ClassNode classNode) {
        BlockStatement methodBody = TestForTransformation.isJunit3Test(classNode) ? this.getJunit3Setup(classNode) : this.getExistingOrCreateJUnit4Setup(classNode);
        return methodBody;
    }

    protected BlockStatement getExistingOrCreateJUnit4Setup(ClassNode classNode) {
        Statement code = this.getExistingJUnit4BeforeMethod(classNode);
        if (code instanceof BlockStatement) {
            return (BlockStatement)code;
        }
        return this.getJunit4Setup(classNode);
    }

    protected Statement getExistingJUnit4BeforeMethod(ClassNode classNode) {
        Statement code = null;
        Map declaredMethodsMap = classNode.getDeclaredMethodsMap();
        for (MethodNode methodNode : declaredMethodsMap.values()) {
            if (!this.isDeclaredBeforeMethod(methodNode)) continue;
            code = this.getMethodBody(methodNode);
        }
        return code;
    }

    private Statement getMethodBody(MethodNode methodNode) {
        Statement code = methodNode.getCode();
        if (!(code instanceof BlockStatement)) {
            BlockStatement body = new BlockStatement();
            body.addStatement(code);
            code = body;
        }
        return code;
    }

    private boolean isDeclaredBeforeMethod(MethodNode methodNode) {
        return this.isPublicInstanceMethod(methodNode) && TestForTransformation.hasAnnotation(methodNode, Before.class) && !TestForTransformation.hasAnnotation(methodNode, MixinMethod.class);
    }

    private boolean isPublicInstanceMethod(MethodNode methodNode) {
        return !methodNode.isSynthetic() && !methodNode.isStatic() && methodNode.isPublic();
    }

    private BlockStatement getJunit4Setup(ClassNode classNode) {
        MethodNode setupMethod = classNode.getDeclaredMethod("setUp", GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (setupMethod == null) {
            setupMethod = new MethodNode("setUp", 1, ClassHelper.VOID_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)new BlockStatement());
            setupMethod.addAnnotation(MIXIN_METHOD_ANNOTATION);
            classNode.addMethod(setupMethod);
        }
        if (setupMethod.getAnnotations(BEFORE_CLASS_NODE).size() == 0) {
            setupMethod.addAnnotation(BEFORE_ANNOTATION);
        }
        return TestForTransformation.getOrCreateMethodBody(classNode, setupMethod, "setUp");
    }

    private BlockStatement getJunit3Setup(ClassNode classNode) {
        boolean hasExistingSetupMethod = classNode.hasDeclaredMethod("setUp", Parameter.EMPTY_ARRAY);
        BlockStatement setUpMethodBody = TestForTransformation.getOrCreateNoArgsMethodBody(classNode, "setUp");
        if (!hasExistingSetupMethod) {
            setUpMethodBody.getStatements().add(new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("super"), "setUp", (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
        }
        return setUpMethodBody;
    }

    private boolean isAlreadyWoven(ClassNode classNode, Class mixinClass) {
        List<Class> mixinClasses = this.wovenMixins.get(classNode);
        if (mixinClasses == null) {
            mixinClasses = new ArrayList<Class>();
            mixinClasses.add(mixinClass);
            this.wovenMixins.put(classNode, mixinClasses);
        } else {
            if (mixinClasses.contains(mixinClass)) {
                return true;
            }
            mixinClasses.add(mixinClass);
        }
        return false;
    }

    protected void weaveMixinClass(ClassNode classNode, Class mixinClass) {
        ListExpression listExpression = new ListExpression();
        listExpression.addExpression((Expression)new ClassExpression(new ClassNode(mixinClass)));
        this.weaveMixinsIntoClass(classNode, listExpression);
    }

    protected MethodNode addClassUnderTestMethod(ClassNode classNode, ClassExpression targetClass, String type) {
        MethodNode getter;
        String methodName = "setup" + type + "UnderTest";
        String fieldName = GrailsNameUtils.getPropertyName((String)type);
        String getterName = GrailsNameUtils.getGetterName((String)fieldName);
        fieldName = '$' + fieldName;
        if (classNode.getField(fieldName) == null) {
            classNode.addField(fieldName, 2, targetClass.getType(), null);
        }
        MethodNode methodNode = classNode.getDeclaredMethod(methodName, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        VariableExpression fieldExpression = new VariableExpression(fieldName, targetClass.getType());
        if (methodNode == null) {
            BlockStatement setupMethodBody = new BlockStatement();
            this.addMockCollaborator(type, targetClass, setupMethodBody);
            methodNode = new MethodNode(methodName, 1, ClassHelper.VOID_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)setupMethodBody);
            methodNode.addAnnotation(BEFORE_ANNOTATION);
            methodNode.addAnnotation(MIXIN_METHOD_ANNOTATION);
            classNode.addMethod(methodNode);
            GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)methodNode);
        }
        if ((getter = classNode.getDeclaredMethod(getterName, GrailsArtefactClassInjector.ZERO_PARAMETERS)) == null) {
            BlockStatement getterBody = new BlockStatement();
            getter = new MethodNode(getterName, 1, targetClass.getType().getPlainNodeReference(), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)getterBody);
            BinaryExpression testTargetAssignment = new BinaryExpression((Expression)fieldExpression, ASSIGN, (Expression)new ConstructorCallExpression(targetClass.getType(), (Expression)GrailsArtefactClassInjector.ZERO_ARGS));
            IfStatement autowiringIfStatement = this.getAutowiringIfStatement(targetClass, fieldExpression, testTargetAssignment);
            getterBody.addStatement((Statement)autowiringIfStatement);
            getterBody.addStatement((Statement)new ReturnStatement((Expression)fieldExpression));
            classNode.addMethod(getter);
            GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)getter);
        }
        return methodNode;
    }

    private IfStatement getAutowiringIfStatement(ClassExpression targetClass, VariableExpression fieldExpression, BinaryExpression testTargetAssignment) {
        VariableExpression appCtxVar = new VariableExpression("applicationContext", ClassHelper.make(ApplicationContext.class));
        BooleanExpression applicationContextCheck = new BooleanExpression((Expression)new BinaryExpression((Expression)new BinaryExpression((Expression)fieldExpression, GrailsASTUtils.EQUALS_OPERATOR, (Expression)GrailsASTUtils.NULL_EXPRESSION), Token.newSymbol((String)"&&", (int)0, (int)0), (Expression)new BinaryExpression((Expression)appCtxVar, GrailsASTUtils.NOT_EQUALS_OPERATOR, (Expression)GrailsASTUtils.NULL_EXPRESSION)));
        BlockStatement performAutowireBlock = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)fieldExpression);
        arguments.addExpression((Expression)new ConstantExpression((Object)1));
        arguments.addExpression((Expression)new ConstantExpression((Object)false));
        BlockStatement assignFromApplicationContext = new BlockStatement();
        ArgumentListExpression argWithClassName = new ArgumentListExpression();
        MethodCallExpression getClassNameMethodCall = new MethodCallExpression((Expression)targetClass, "getName", (Expression)new ArgumentListExpression());
        argWithClassName.addExpression((Expression)getClassNameMethodCall);
        assignFromApplicationContext.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)fieldExpression, ASSIGN, (Expression)new MethodCallExpression((Expression)appCtxVar, "getBean", (Expression)argWithClassName))));
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement((Statement)new ExpressionStatement((Expression)testTargetAssignment));
        performAutowireBlock.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new MethodCallExpression((Expression)appCtxVar, "containsBean", (Expression)argWithClassName)), (Statement)assignFromApplicationContext, (Statement)elseBlock));
        performAutowireBlock.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new PropertyExpression((Expression)appCtxVar, "autowireCapableBeanFactory"), "autowireBeanProperties", (Expression)arguments)));
        return new IfStatement(applicationContextCheck, (Statement)performAutowireBlock, (Statement)new BlockStatement());
    }

    protected void addMockCollaborator(String mockType, ClassExpression targetClass, BlockStatement methodBody) {
        ArgumentListExpression args = new ArgumentListExpression();
        args.addExpression((Expression)targetClass);
        methodBody.getStatements().add(0, new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), "mock" + mockType, (Expression)args)));
    }

    protected void addMockCollaborators(ClassNode classNode, String mockType, List<ClassExpression> targetClasses) {
        this.addMockCollaborators(mockType, targetClasses, this.getOrCreateTestSetupMethod(classNode));
    }

    protected void addMockCollaborators(String mockType, List<ClassExpression> targetClasses, BlockStatement methodBody) {
        ArgumentListExpression args = new ArgumentListExpression();
        for (ClassExpression ce : targetClasses) {
            args.addExpression((Expression)ce);
        }
        methodBody.getStatements().add(0, new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), "mock" + mockType + 's', (Expression)args)));
    }

    @Override
    public void registerMixin(String artefactType, Class mixin) {
        artefactTypeToTestMap.put(artefactType, mixin);
    }

    static {
        List registrars = GrailsFactoriesLoader.loadFactories(TestMixinRegistrar.class);
        TestMixinRegistry thisRegistry = new TestMixinRegistry(){

            @Override
            public void registerMixin(String artefactType, Class mixin) {
                artefactTypeToTestMap.put(artefactType, mixin);
            }
        };
        for (TestMixinRegistrar registrar : registrars) {
            registrar.registerTestMixins(thisRegistry);
        }
        BEFORE_CLASS_NODE = new ClassNode(Before.class);
        BEFORE_ANNOTATION = new AnnotationNode(BEFORE_CLASS_NODE);
        AFTER_CLASS_NODE = new ClassNode(After.class);
        AFTER_ANNOTATION = new AnnotationNode(AFTER_CLASS_NODE);
        TEST_ANNOTATION = new AnnotationNode(new ClassNode(Test.class));
    }
}

