/*
 * Decompiled with CFR 0.152.
 */
package grails.test.mixin.support;

import groovy.lang.GroovyObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.plugins.web.GroovyPagesGrailsPlugin;
import org.codehaus.groovy.grails.web.pages.GroovyPage;
import org.codehaus.groovy.grails.web.pages.TagLibraryLookup;
import org.codehaus.groovy.grails.web.taglib.NamespacedTagDispatcher;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyTagLibraryLookup
extends TagLibraryLookup {
    private Map<String, String> resolveTagLibraries = new HashMap<String, String>();
    private Map<String, List<Class>> tagClassesByNamespace = new HashMap<String, List<Class>>();
    private Map<Class, GrailsTagLibClass> tagClassToTagLibMap = new HashMap<Class, GrailsTagLibClass>();

    protected void registerTagLibraries() {
        List providedArtefacts = (List)new GroovyPagesGrailsPlugin().getProvidedArtefacts();
        this.tagClassesByNamespace.put("g", new ArrayList());
        this.namespaceDispatchers.put("g", new NamespacedTagDispatcher("g", GroovyPage.class, this.grailsApplication, (TagLibraryLookup)this));
        for (Class providedArtefact : providedArtefacts) {
            if (!this.grailsApplication.isArtefactOfType("TagLib", providedArtefact)) continue;
            Object value = GrailsClassUtils.getStaticPropertyValue((Class)providedArtefact, (String)"namespace");
            if (value != null) {
                String namespace = value.toString();
                List<Class> classes = this.tagClassesByNamespace.get(namespace);
                if (classes == null) {
                    classes = new ArrayList<Class>();
                    this.tagClassesByNamespace.put(namespace, classes);
                }
                classes.add(providedArtefact);
                this.namespaceDispatchers.put(namespace, new NamespacedTagDispatcher(namespace, GroovyPage.class, this.grailsApplication, (TagLibraryLookup)this));
                continue;
            }
            this.tagClassesByNamespace.get("g").add(providedArtefact);
        }
    }

    public GroovyObject lookupTagLibrary(String namespace, String tagName) {
        String tagKey = this.tagNameKey(namespace, tagName);
        if (this.resolveTagLibraries.containsKey(tagKey)) {
            return (GroovyObject)this.applicationContext.getBean(this.resolveTagLibraries.get(tagKey), GroovyObject.class);
        }
        List<Class> tagLibraryClasses = this.tagClassesByNamespace.get(namespace);
        if (tagLibraryClasses != null) {
            for (Class tagLibraryClass : tagLibraryClasses) {
                GrailsTagLibClass tagLib = this.tagClassToTagLibMap.get(tagLibraryClass);
                if (tagLib == null) {
                    tagLib = (GrailsTagLibClass)this.grailsApplication.addArtefact("TagLib", tagLibraryClass);
                    this.tagClassToTagLibMap.put(tagLibraryClass, tagLib);
                }
                String tagLibraryClassName = tagLibraryClass.getName();
                if (tagLib == null || !tagLib.hasTag(tagName) || this.applicationContext.containsBean(tagLibraryClassName)) continue;
                this.registerTagLib(tagLib);
                if (!tagLib.hasTag(tagName)) continue;
                GenericBeanDefinition bd = new GenericBeanDefinition();
                bd.setBeanClass(tagLibraryClass);
                bd.setAutowireCandidate(true);
                bd.setAutowireMode(1);
                ((GenericApplicationContext)this.applicationContext).getDefaultListableBeanFactory().registerBeanDefinition(tagLibraryClassName, (BeanDefinition)bd);
                this.resolveTagLibraries.put(tagKey, tagLib.getFullName());
                return (GroovyObject)this.applicationContext.getBean(tagLibraryClassName);
            }
        }
        return null;
    }

    protected String tagNameKey(String namespace, String tagName) {
        return namespace + ':' + tagName;
    }

    protected void putTagLib(Map<String, Object> tags, String name, GrailsTagLibClass taglib) {
        tags.put(name, taglib.getFullName());
    }

    public void registerTagLib(GrailsTagLibClass taglib) {
        super.registerTagLib(taglib);
        String ns = taglib.getNamespace();
        for (String tagName : taglib.getTagNames()) {
            String key = this.tagNameKey(ns, tagName);
            this.resolveTagLibraries.put(key, taglib.getFullName());
        }
    }
}

