/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.hal;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import grails.rest.Link;
import grails.rest.render.RenderContext;
import grails.rest.render.util.AbstractLinkingRenderer;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.beans.PropertyDescriptor;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.xml.bind.DatatypeConverter;
import org.codehaus.groovy.grails.web.binding.bindingsource.DataBindingSourceRegistry;
import org.codehaus.groovy.grails.web.binding.bindingsource.HalJsonDataBindingSourceCreator;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.databinding.bindingsource.DataBindingSourceCreator;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;

public class HalJsonRenderer<T>
extends AbstractLinkingRenderer<T> {
    public static final MimeType MIME_TYPE;
    public static final String LINKS_ATTRIBUTE = "_links";
    public static final String EMBEDDED_ATTRIBUTE = "_embedded";
    private static final MimeType[] DEFAULT_MIME_TYPES;
    private Gson gson;
    @Autowired(required=false)
    private DataBindingSourceRegistry dataBindingSourceRegistry;
    private Converter<Date, String> dateToStringConverter;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public HalJsonRenderer(Class<T> targetType) {
        super(targetType, DEFAULT_MIME_TYPES);
        UTCDateConverter uTCDateConverter;
        Gson gson;
        this.gson = gson = new Gson();
        this.dateToStringConverter = uTCDateConverter = new UTCDateConverter();
    }

    public HalJsonRenderer(Class<T> targetType, MimeType ... mimeTypes) {
        super(targetType, mimeTypes);
        UTCDateConverter uTCDateConverter;
        Gson gson;
        this.gson = gson = new Gson();
        this.dateToStringConverter = uTCDateConverter = new UTCDateConverter();
    }

    @Autowired(required=false)
    public void setGson(Gson gson) {
        Gson gson2;
        this.gson = gson2 = gson;
    }

    @Autowired(required=false)
    public void setDateToStringConverter(Converter<Date, String> converter) {
        Converter<Date, String> converter2 = converter;
        this.dateToStringConverter = converter2;
    }

    @PostConstruct
    public void initialize() {
        if (this.dataBindingSourceRegistry != null) {
            Reference thisType = new Reference(this.getTargetType());
            Reference thisMimeTypes = new Reference((Object)this.getMimeTypes());
            HalJsonDataBindingSourceCreator halDataBindingSourceCreator = new HalJsonDataBindingSourceCreator(this, thisType, thisMimeTypes){
                public /* synthetic */ Reference thisMimeTypes;
                public /* synthetic */ Reference thisType;
                public /* synthetic */ HalJsonRenderer this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                {
                    Reference reference;
                    Reference reference2;
                    HalJsonRenderer halJsonRenderer;
                    this.this$0 = halJsonRenderer = p0;
                    this.thisMimeTypes = reference2 = p2;
                    this.thisType = reference = p1;
                }

                public Class getTargetType() {
                    return ShortTypeHandling.castToClass((Object)this.thisType.get());
                }

                public MimeType[] getMimeTypes() {
                    return (MimeType[])ScriptBytecodeAdapter.castToType((Object)this.thisMimeTypes.get(), MimeType[].class);
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$4(name, args);
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$4(name, val);
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$4(name);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            };
            Gson gson = this.gson;
            halDataBindingSourceCreator.setGson(gson);
            this.dataBindingSourceRegistry.addDataBindingSourceCreator((DataBindingSourceCreator)halDataBindingSourceCreator);
        }
    }

    @Override
    public void renderInternal(T object, RenderContext context) {
        MimeType mimeType = context.getAcceptMimeType();
        MimeType mimeType2 = DefaultTypeTransformation.booleanUnbox((Object)mimeType) ? mimeType : (MimeType)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.getMimeTypes(), (int)0), MimeType.class);
        Writer responseWriter = context.getWriter();
        JsonWriter writer = new JsonWriter(responseWriter);
        try {
            if (this.getPrettyPrint()) {
                writer.setIndent("  ");
            }
            Class<?> clazz = object.getClass();
            if (this.isDomainResource(clazz)) {
                this.writeDomainWithEmbeddedAndLinks(context, clazz, object, writer, context.getLocale(), mimeType2, (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class), new Stack());
            } else if (object instanceof Collection) {
                this.beginLinks(writer);
                this.writeLinkForCurrentPath(context, mimeType2, writer);
                writer.endObject();
                writer.name(EMBEDDED_ATTRIBUTE);
                this.renderEmbeddedAttributes(writer, object, context, mimeType2);
                writer.endObject();
            } else {
                this.writeSimpleObjectAndLink(object, context, writer, mimeType2);
            }
        }
        finally {
            writer.flush();
        }
    }

    protected Object renderEmbeddedAttributes(JsonWriter writer, Object object, RenderContext context, MimeType mimeType) {
        writer.beginArray();
        Set writtenObjects = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        Object o2 = null;
        for (Object o2 : (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class)) {
            if (!DefaultTypeTransformation.booleanUnbox(o2)) continue;
            if (this.isDomainResource(o2.getClass())) {
                this.writeDomainWithEmbeddedAndLinks(context, o2.getClass(), o2, writer, context.getLocale(), mimeType, writtenObjects, new Stack());
                continue;
            }
            this.writeSimpleObjectAndLink(o2, context, writer, mimeType);
        }
        return writer.endArray();
    }

    protected Object writeSimpleObjectAndLink(Object o, RenderContext context, JsonWriter writer, MimeType mimeType) {
        this.beginLinks(writer);
        this.writeLinkForCurrentPath(context, mimeType, writer);
        this.writeExtraLinks(o, context.getLocale(), writer);
        writer.endObject();
        this.writeSimpleObject(o, context, writer);
        return null;
    }

    protected void writeSimpleObject(Object object, RenderContext context, JsonWriter writer) {
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)object);
        PropertyDescriptor[] propertyDescriptors = bean.getPropertyDescriptors();
        PropertyDescriptor pd2 = null;
        PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
        if (propertyDescriptors != null) {
            for (PropertyDescriptor pd2 : propertyDescriptorArray) {
                String propertyName = pd2.getName();
                if (AbstractLinkingRenderer.DEFAULT_EXCLUDES.contains(propertyName) || !this.shouldIncludeProperty(context, object, propertyName) || !(DefaultTypeTransformation.booleanUnbox((Object)pd2.getReadMethod()) && DefaultTypeTransformation.booleanUnbox((Object)pd2.getWriteMethod()))) continue;
                Object value = bean.getPropertyValue(propertyName);
                if (value instanceof Number) {
                    writer.name(propertyName).value((Number)ScriptBytecodeAdapter.castToType((Object)value, Number.class));
                    continue;
                }
                if (value instanceof CharSequence || value instanceof Enum) {
                    writer.name(propertyName).value(DefaultGroovyMethods.toString((Object)value));
                    continue;
                }
                if (MappingFactory.isSimpleType((String)pd2.getPropertyType().getName())) {
                    writer.name(propertyName).value(this.gson.toJson(value));
                    continue;
                }
                writer.name(propertyName).beginObject();
                this.writeSimpleObject(value, context, writer);
            }
        }
        writer.endObject();
    }

    protected void writeLinkForCurrentPath(RenderContext context, MimeType mimeType, JsonWriter writer) {
        String href = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uri", context.getResourcePath(), "method", HttpMethod.GET.toString(), "absolute", this.getAbsoluteLinks()}));
        String resourceRef = href;
        Locale locale = context.getLocale();
        Link link = new Link(AbstractLinkingRenderer.RELATIONSHIP_SELF, href);
        String string = this.getResourceTitle(resourceRef, locale);
        link.setTitle(string);
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)mimeType) ? mimeType.getName() : null;
        link.setContentType(ShortTypeHandling.castToString((Object)string2));
        this.writeLink(link, locale, writer);
    }

    protected void beginLinks(JsonWriter writer) {
        writer.beginObject().name(LINKS_ATTRIBUTE).beginObject();
    }

    protected void writeDomainWithEmbeddedAndLinks(RenderContext context, Class clazz, Object object, JsonWriter writer, Locale locale, MimeType contentType, Set writtenObjects, Stack referenceStack) {
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(clazz.getName());
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getJavaClass());
        if (referenceStack.contains(object)) {
            this.writeLinks(context, metaClass, object, entity, locale, contentType, writer, false);
            writer.endObject();
            return;
        }
        referenceStack.push(object);
        Map<Association, Object> associationMap = this.writeLinks(context, metaClass, object, entity, locale, contentType, writer, true);
        this.writeDomain(context, metaClass, entity, object, writer);
        if (DefaultTypeTransformation.booleanUnbox(associationMap)) {
            writer.name(EMBEDDED_ATTRIBUTE);
            writer.beginObject();
            Map.Entry entry = null;
            Iterator<Map.Entry<Association, Object>> iterator = associationMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Association property = (Association)ScriptBytecodeAdapter.castToType(entry.getKey(), Association.class);
                boolean isSingleEnded = property instanceof ToOne;
                if (isSingleEnded) {
                    Object value = entry.getValue();
                    if (!(value != null)) continue;
                    writer.name(property.getName());
                    PersistentEntity associatedEntity = property.getAssociatedEntity();
                    if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, value);
                    this.writeDomainWithEmbeddedAndLinks(context, associatedEntity.getJavaClass(), value, writer, locale, null, writtenObjects, referenceStack);
                    continue;
                }
                writer.name(property.getName());
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                writer.beginArray();
                Object obj = null;
                Iterator iterator2 = DefaultGroovyMethods.iterator(entry.getValue());
                while (iterator2.hasNext()) {
                    obj = iterator2.next();
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, obj);
                    this.writeDomainWithEmbeddedAndLinks(context, associatedEntity.getJavaClass(), obj, writer, locale, null, writtenObjects, referenceStack);
                }
                writer.endArray();
            }
            writer.endObject();
        }
        referenceStack.pop();
        writer.endObject();
    }

    protected Map<Association, Object> writeLinks(RenderContext context, MetaClass metaClass, Object object, PersistentEntity entity, Locale locale, MimeType contentType, JsonWriter writer, boolean associationLinks) {
        writer.beginObject();
        writer.name(LINKS_ATTRIBUTE);
        writer.beginObject();
        String entityHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resource", object, "method", HttpMethod.GET.toString(), "absolute", this.getAbsoluteLinks()}));
        String title = this.getLinkTitle(entity, locale);
        Link link = new Link(AbstractLinkingRenderer.RELATIONSHIP_SELF, entityHref);
        String string = DefaultTypeTransformation.booleanUnbox((Object)contentType) ? contentType.getName() : null;
        link.setContentType(ShortTypeHandling.castToString((Object)string));
        String string2 = title;
        link.setTitle(string2);
        Locale locale2 = locale;
        link.setHreflang(locale2);
        this.writeLink(link, locale, writer);
        Map<Association, Object> associationMap = associationLinks ? this.writeAssociationLinks(context, object, locale, writer, entity, metaClass) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        writer.endObject();
        return associationMap;
    }

    @Override
    protected void writeLink(Link link, Locale locale, Object writerObject) {
        Locale locale2;
        JsonWriter writer = (JsonWriter)ScriptBytecodeAdapter.castToType((Object)writerObject, JsonWriter.class);
        writer.name(link.getRel()).beginObject().name(AbstractLinkingRenderer.HREF_ATTRIBUTE).value(link.getHref()).name(AbstractLinkingRenderer.HREFLANG_ATTRIBUTE).value((DefaultTypeTransformation.booleanUnbox((Object)(locale2 = link.getHreflang())) ? locale2 : locale).getLanguage());
        String title = link.getTitle();
        if (DefaultTypeTransformation.booleanUnbox((Object)title)) {
            writer.name(AbstractLinkingRenderer.TITLE_ATTRIBUTE).value(title);
        }
        String type = link.getContentType();
        if (DefaultTypeTransformation.booleanUnbox((Object)type)) {
            writer.name(AbstractLinkingRenderer.TYPE_ATTRIBUTE).value(type);
        }
        if (link.isTemplated()) {
            writer.name(AbstractLinkingRenderer.TEMPLATED_ATTRIBUTE).value(true);
        }
        if (link.isDeprecated()) {
            writer.name(AbstractLinkingRenderer.DEPRECATED_ATTRIBUTE).value(true);
        }
        writer.endObject();
    }

    @Override
    protected void writeDomainProperty(Object value, String propertyName, Object writer) {
        JsonWriter jsonWriter = (JsonWriter)ScriptBytecodeAdapter.castToType((Object)writer, JsonWriter.class);
        if (value instanceof Number) {
            jsonWriter.name(propertyName).value((Number)ScriptBytecodeAdapter.castToType((Object)value, Number.class));
        } else if (value instanceof CharSequence || value instanceof Enum) {
            jsonWriter.name(propertyName).value(DefaultGroovyMethods.toString((Object)value));
        } else if (value instanceof Date) {
            String asStringDate = ShortTypeHandling.castToString((Object)this.dateToStringConverter.convert((Object)((Date)ScriptBytecodeAdapter.castToType((Object)value, Date.class))));
            jsonWriter.name(propertyName).value(asStringDate);
        } else {
            jsonWriter.name(propertyName);
            this.gson.toJson(value, value.getClass(), jsonWriter);
        }
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(HalJsonRenderer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, HalJsonRenderer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(HalJsonRenderer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ void access$0(HalJsonRenderer $that, RenderContext context, MetaClass metaClass, PersistentEntity entity, Object object, Object writer) {
        $that.writeDomain(context, metaClass, entity, object, writer);
    }

    public static /* synthetic */ String access$1(HalJsonRenderer $that, PersistentEntity entity, Locale locale) {
        return $that.getLinkTitle(entity, locale);
    }

    public static /* synthetic */ void access$2(HalJsonRenderer $that, Object object, Locale locale, Object writer) {
        $that.writeExtraLinks(object, locale, writer);
    }

    public static /* synthetic */ Map<Association, Object> access$3(HalJsonRenderer $that, RenderContext context, Object object, Locale locale, Object writer, PersistentEntity entity, MetaClass metaClass) {
        return $that.writeAssociationLinks(context, object, locale, writer, entity, metaClass);
    }

    public static /* synthetic */ boolean access$4(HalJsonRenderer $that, Class clazz) {
        return $that.isDomainResource(clazz);
    }

    public static /* synthetic */ String access$5(HalJsonRenderer $that, String uri, Locale locale) {
        return $that.getResourceTitle(uri, locale);
    }

    protected Map<Association, Object> writeLinks(RenderContext context, MetaClass metaClass, Object object, PersistentEntity entity, Locale locale, MimeType contentType, JsonWriter writer) {
        return this.writeLinks(context, metaClass, object, entity, locale, contentType, writer, true);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HalJsonRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        MimeType mimeType;
        MIME_TYPE = mimeType = MimeType.HAL_JSON;
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE};
        DEFAULT_MIME_TYPES = mimeTypeArray;
    }

    public DataBindingSourceRegistry getDataBindingSourceRegistry() {
        return this.dataBindingSourceRegistry;
    }

    public void setDataBindingSourceRegistry(DataBindingSourceRegistry dataBindingSourceRegistry) {
        this.dataBindingSourceRegistry = dataBindingSourceRegistry;
    }

    public Converter<Date, String> getDateToStringConverter() {
        return this.dateToStringConverter;
    }

    static class UTCDateConverter
    implements Converter<Date, String>,
    GroovyObject {
        private static final TimeZone UtcTZ;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public UTCDateConverter() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public String convert(Date source) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(source);
            cal.setTimeZone(UtcTZ);
            return DatatypeConverter.printDateTime((Calendar)cal);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(UTCDateConverter.class, HalJsonRenderer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, HalJsonRenderer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(UTCDateConverter.class, HalJsonRenderer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != UTCDateConverter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        static {
            TimeZone timeZone;
            UtcTZ = timeZone = TimeZone.getTimeZone("UTC");
        }
    }
}

