/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.hal;

import grails.converters.XML;
import grails.rest.Link;
import grails.rest.render.RenderContext;
import grails.rest.render.util.AbstractLinkingRenderer;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.xml.PrettyPrintXMLStreamWriter;
import org.codehaus.groovy.grails.web.xml.StreamingMarkupWriter;
import org.codehaus.groovy.grails.web.xml.XMLStreamWriter;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.http.HttpMethod;

public class HalXmlRenderer<T>
extends AbstractLinkingRenderer<T> {
    public static final MimeType MIME_TYPE;
    public static final String RESOURCE_TAG = "resource";
    public static final String LINK_TAG = "link";
    public static final String RELATIONSHIP_ATTRIBUTE = "rel";
    private static final MimeType[] DEFAULT_MIME_TYPES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public HalXmlRenderer(Class<T> targetType) {
        super(targetType, DEFAULT_MIME_TYPES);
    }

    public HalXmlRenderer(Class<T> targetType, MimeType mimeType) {
        super(targetType, mimeType);
    }

    public HalXmlRenderer(Class<T> targetType, MimeType ... mimeTypes) {
        super(targetType, mimeTypes);
    }

    @Override
    public void renderInternal(T object, RenderContext context) {
        StreamingMarkupWriter streamingWriter = new StreamingMarkupWriter(context.getWriter(), this.getEncoding());
        PrettyPrintXMLStreamWriter w = this.getPrettyPrint() ? new PrettyPrintXMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter) : new XMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter);
        XML xml = new XML((XMLStreamWriter)w);
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(object.getClass().getName());
        boolean isDomain = entity != null;
        Set writtenObjects = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        w.startDocument(this.getEncoding(), "1.0");
        if (isDomain) {
            this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, writtenObjects);
        } else if (object instanceof Collection) {
            XMLStreamWriter writer = xml.getWriter();
            this.startResourceTagForCurrentPath(context, writer);
            Object o2 = null;
            for (Object o2 : (Collection)ScriptBytecodeAdapter.castToType(object, Collection.class)) {
                PersistentEntity currentEntity = this.getMappingContext().getPersistentEntity(o2.getClass().getName());
                if (!DefaultTypeTransformation.booleanUnbox((Object)currentEntity)) continue;
                this.writeDomainWithEmbeddedAndLinks(currentEntity, o2, context, xml, writtenObjects);
            }
            writer.end();
        } else {
            XMLStreamWriter writer = xml.getWriter();
            this.startResourceTagForCurrentPath(context, writer);
            this.writeExtraLinks(object, context.getLocale(), xml);
            BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess(object);
            PropertyDescriptor[] propertyDescriptors = bean.getPropertyDescriptors();
            PropertyDescriptor pd2 = null;
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
            if (propertyDescriptors != null) {
                for (PropertyDescriptor pd2 : propertyDescriptorArray) {
                    String propertyName = pd2.getName();
                    if (AbstractLinkingRenderer.DEFAULT_EXCLUDES.contains(propertyName) || !this.shouldIncludeProperty(context, object, propertyName) || !(DefaultTypeTransformation.booleanUnbox((Object)pd2.getReadMethod()) && DefaultTypeTransformation.booleanUnbox((Object)pd2.getWriteMethod()))) continue;
                    writer.startNode(propertyName);
                    xml.convertAnother(bean.getPropertyValue(propertyName));
                    writer.end();
                }
            }
            writer.end();
        }
    }

    protected void startResourceTagForCurrentPath(RenderContext context, XMLStreamWriter writer) {
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uri", context.getResourcePath(), "method", HttpMethod.GET, "absolute", this.getAbsoluteLinks()}));
        String title = this.getResourceTitle(context.getResourcePath(), locale);
        this.startResourceTag(writer, resourceHref, locale, title);
    }

    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects) {
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{RESOURCE_TAG, object, "method", HttpMethod.GET, "absolute", this.getAbsoluteLinks()}));
        String title = this.getLinkTitle(entity, locale);
        XMLStreamWriter writer = xml.getWriter();
        this.startResourceTag(writer, resourceHref, locale, title);
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getJavaClass());
        Map<Association, Object> associationMap = this.writeAssociationLinks(context, object, locale, xml, entity, metaClass);
        this.writeDomain(context, metaClass, entity, object, xml);
        if (DefaultTypeTransformation.booleanUnbox(associationMap)) {
            Map.Entry entry = null;
            Iterator<Map.Entry<Association, Object>> iterator = associationMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Association property = (Association)ScriptBytecodeAdapter.castToType(entry.getKey(), Association.class);
                boolean isSingleEnded = property instanceof ToOne;
                if (isSingleEnded) {
                    Object value = entry.getValue();
                    if (writtenObjects.contains(value) || !(value != null)) continue;
                    PersistentEntity associatedEntity = property.getAssociatedEntity();
                    if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, value);
                    this.writeDomainWithEmbeddedAndLinks(associatedEntity, value, context, xml, writtenObjects);
                    continue;
                }
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                Object obj = null;
                Iterator iterator2 = DefaultGroovyMethods.iterator(entry.getValue());
                while (iterator2.hasNext()) {
                    obj = iterator2.next();
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, obj);
                    this.writeDomainWithEmbeddedAndLinks(associatedEntity, obj, context, xml, writtenObjects);
                }
            }
        }
        writer.end();
    }

    protected void startResourceTag(XMLStreamWriter writer, String resourceHref, Locale locale, String title) {
        writer.startNode(RESOURCE_TAG).attribute(AbstractLinkingRenderer.HREF_ATTRIBUTE, resourceHref).attribute(AbstractLinkingRenderer.HREFLANG_ATTRIBUTE, locale.getLanguage());
        if (DefaultTypeTransformation.booleanUnbox((Object)title)) {
            writer.attribute(AbstractLinkingRenderer.TITLE_ATTRIBUTE, title);
        }
    }

    @Override
    public void writeLink(Link link, Locale locale, Object writerObject) {
        Locale locale2;
        XMLStreamWriter writer = ((XML)ScriptBytecodeAdapter.castToType((Object)writerObject, XML.class)).getWriter();
        writer.startNode(LINK_TAG).attribute(RELATIONSHIP_ATTRIBUTE, link.getRel()).attribute(AbstractLinkingRenderer.HREF_ATTRIBUTE, link.getHref()).attribute(AbstractLinkingRenderer.HREFLANG_ATTRIBUTE, (DefaultTypeTransformation.booleanUnbox((Object)(locale2 = link.getHreflang())) ? locale2 : locale).getLanguage());
        String title = link.getTitle();
        if (DefaultTypeTransformation.booleanUnbox((Object)title)) {
            writer.attribute(AbstractLinkingRenderer.TITLE_ATTRIBUTE, title);
        }
        String contentType = link.getContentType();
        if (DefaultTypeTransformation.booleanUnbox((Object)contentType)) {
            writer.attribute(AbstractLinkingRenderer.TYPE_ATTRIBUTE, contentType);
        }
        if (link.isTemplated()) {
            writer.attribute(AbstractLinkingRenderer.TEMPLATED_ATTRIBUTE, "true");
        }
        if (link.isDeprecated()) {
            writer.attribute(AbstractLinkingRenderer.DEPRECATED_ATTRIBUTE, "true");
        }
        writer.end();
    }

    @Override
    protected void writeDomainProperty(Object value, String propertyName, Object writerObject) {
        XML xml = (XML)ScriptBytecodeAdapter.castToType((Object)writerObject, XML.class);
        XMLStreamWriter writer = xml.getWriter();
        writer.startNode(propertyName);
        xml.convertAnother(value);
        writer.end();
    }

    public static /* synthetic */ String access$0(HalXmlRenderer $that, String uri, Locale locale) {
        return $that.getResourceTitle(uri, locale);
    }

    public static /* synthetic */ void access$1(HalXmlRenderer $that, RenderContext context, MetaClass metaClass, PersistentEntity entity, Object object, Object writer) {
        $that.writeDomain(context, metaClass, entity, object, writer);
    }

    public static /* synthetic */ Map<Association, Object> access$2(HalXmlRenderer $that, RenderContext context, Object object, Locale locale, Object writer, PersistentEntity entity, MetaClass metaClass) {
        return $that.writeAssociationLinks(context, object, locale, writer, entity, metaClass);
    }

    public static /* synthetic */ void access$3(HalXmlRenderer $that, Object object, Locale locale, Object writer) {
        $that.writeExtraLinks(object, locale, writer);
    }

    public static /* synthetic */ String access$4(HalXmlRenderer $that, PersistentEntity entity, Locale locale) {
        return $that.getLinkTitle(entity, locale);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HalXmlRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        MimeType mimeType;
        MIME_TYPE = mimeType = MimeType.HAL_XML;
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE};
        DEFAULT_MIME_TYPES = mimeTypeArray;
    }
}

