/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.databinding;

import grails.core.GrailsApplication;
import grails.databinding.TypedStructuredBindingEditor;
import grails.databinding.converters.FormattedValueConverter;
import grails.databinding.converters.ValueConverter;
import grails.web.databinding.GrailsWebDataBinder;
import io.micronaut.core.util.ArrayUtils;
import org.grails.databinding.bindingsource.DataBindingSourceCreator;
import org.grails.plugins.databinding.DataBindingConfigurationProperties;
import org.grails.web.databinding.bindingsource.DataBindingSourceRegistry;
import org.grails.web.databinding.bindingsource.DefaultDataBindingSourceRegistry;
import org.grails.web.databinding.bindingsource.HalJsonDataBindingSourceCreator;
import org.grails.web.databinding.bindingsource.HalXmlDataBindingSourceCreator;
import org.grails.web.databinding.bindingsource.JsonApiDataBindingSourceCreator;
import org.grails.web.databinding.bindingsource.JsonDataBindingSourceCreator;
import org.grails.web.databinding.bindingsource.XmlDataBindingSourceCreator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataBindingConfiguration {
    private final DataBindingConfigurationProperties configurationProperties;

    public DataBindingConfiguration(DataBindingConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    @Bean(value={"grailsWebDataBinder"})
    protected GrailsWebDataBinder grailsWebDataBinder(GrailsApplication grailsApplication, ValueConverter[] valueConverters, FormattedValueConverter[] formattedValueConverters, TypedStructuredBindingEditor[] structuredBindingEditors) {
        GrailsWebDataBinder dataBinder = new GrailsWebDataBinder(grailsApplication);
        dataBinder.setConvertEmptyStringsToNull(this.configurationProperties.isConvertEmptyStringsToNull());
        dataBinder.setTrimStrings(this.configurationProperties.isTrimStrings());
        dataBinder.setAutoGrowCollectionLimit(this.configurationProperties.getAutoGrowCollectionLimit());
        dataBinder.setStructuredBindingEditors(structuredBindingEditors);
        ApplicationContext mainContext = grailsApplication.getMainContext();
        Object[] mainContextConverters = mainContext.getBeansOfType(ValueConverter.class).values().toArray(new ValueConverter[0]);
        dataBinder.setValueConverters((ValueConverter[])ArrayUtils.concat((Object[])valueConverters, (Object[])mainContextConverters));
        dataBinder.setFormattedValueConverters(formattedValueConverters);
        return dataBinder;
    }

    @Bean(value={"xmlDataBindingSourceCreator"})
    protected XmlDataBindingSourceCreator xmlDataBindingSourceCreator() {
        return new XmlDataBindingSourceCreator();
    }

    @Bean(value={"jsonDataBindingSourceCreator"})
    protected JsonDataBindingSourceCreator jsonDataBindingSourceCreator() {
        return new JsonDataBindingSourceCreator();
    }

    @Bean(value={"halJsonDataBindingSourceCreator"})
    protected HalJsonDataBindingSourceCreator halJsonDataBindingSourceCreator() {
        return new HalJsonDataBindingSourceCreator();
    }

    @Bean(value={"halXmlDataBindingSourceCreator"})
    protected HalXmlDataBindingSourceCreator halXmlDataBindingSourceCreator() {
        return new HalXmlDataBindingSourceCreator();
    }

    @Bean(value={"jsonApiDataBindingSourceCreator"})
    protected JsonApiDataBindingSourceCreator jsonApiDataBindingSourceCreator() {
        return new JsonApiDataBindingSourceCreator();
    }

    @Bean(value={"dataBindingSourceRegistry"})
    protected DataBindingSourceRegistry dataBindingSourceRegistry(DataBindingSourceCreator ... creators) {
        DefaultDataBindingSourceRegistry registry = new DefaultDataBindingSourceRegistry();
        registry.setDataBindingSourceCreators(creators);
        registry.initialize();
        return registry;
    }
}

