/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.support.IncludeExcludeSupport;
import org.codehaus.groovy.grails.support.proxy.EntityProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.springframework.beans.BeanWrapperImpl;

public class DomainClassMarshaller
extends IncludeExcludePropertyMarshaller<XML> {
    protected final boolean includeVersion;
    protected ProxyHandler proxyHandler;
    protected GrailsApplication application;

    public DomainClassMarshaller(GrailsApplication application) {
        this(false, application);
    }

    public DomainClassMarshaller(boolean includeVersion, GrailsApplication application) {
        this.includeVersion = includeVersion;
        this.application = application;
    }

    public DomainClassMarshaller(boolean includeVersion, ProxyHandler proxyHandler, GrailsApplication application) {
        this(includeVersion, application);
        this.proxyHandler = proxyHandler;
    }

    @Override
    public boolean supports(Object object) {
        String name = ConverterUtil.trimProxySuffix(object.getClass().getName());
        return this.application.isArtefactOfType("Domain", name);
    }

    @Override
    public void marshalObject(Object value, XML xml) throws ConverterException {
        GrailsDomainClassProperty[] properties;
        Object idValue;
        Class<?> clazz = value.getClass();
        List<String> excludes = xml.getExcludes(clazz);
        List<String> includes = xml.getIncludes(clazz);
        IncludeExcludeSupport includeExcludeSupport = new IncludeExcludeSupport();
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", ConverterUtil.trimProxySuffix(clazz.getName()));
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        GrailsDomainClassProperty id = domainClass.getIdentifier();
        if (this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, id.getName()) && (idValue = beanWrapper.getPropertyValue(id.getName())) != null) {
            xml.attribute("id", String.valueOf(idValue));
        }
        if (this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, "version") && this.includeVersion) {
            Object versionValue = beanWrapper.getPropertyValue(domainClass.getVersion().getName());
            xml.attribute("version", String.valueOf(versionValue));
        }
        for (GrailsDomainClassProperty property : properties = domainClass.getPersistentProperties()) {
            Object referenceObject;
            String propertyName = property.getName();
            if (!this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, property.getName())) continue;
            xml.startNode(propertyName);
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(propertyName);
                xml.convertAnother(val);
            } else if (this.isRenderDomainClassRelations()) {
                referenceObject = beanWrapper.getPropertyValue(propertyName);
                if (referenceObject != null && this.shouldInitializeProxy(referenceObject)) {
                    if ((referenceObject = this.proxyHandler.unwrapIfProxy(referenceObject)) instanceof SortedMap) {
                        referenceObject = new TreeMap((SortedMap)referenceObject);
                    } else if (referenceObject instanceof SortedSet) {
                        referenceObject = new TreeSet((SortedSet)referenceObject);
                    } else if (referenceObject instanceof Set) {
                        referenceObject = new HashSet((Set)referenceObject);
                    } else if (referenceObject instanceof Map) {
                        referenceObject = new HashMap((Map)referenceObject);
                    } else if (referenceObject instanceof Collection) {
                        referenceObject = new ArrayList((Collection)referenceObject);
                    }
                    xml.convertAnother(referenceObject);
                }
            } else {
                referenceObject = beanWrapper.getPropertyValue(propertyName);
                if (referenceObject != null) {
                    GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
                    if (referencedDomainClass == null || property.isEmbedded() || GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                        xml.convertAnother(referenceObject);
                    } else if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                        this.asShortObject(referenceObject, xml, referencedDomainClass.getIdentifier(), referencedDomainClass);
                    } else {
                        GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
                        String refPropertyName = referencedDomainClass.getPropertyName();
                        if (referenceObject instanceof Collection) {
                            Collection o = (Collection)referenceObject;
                            for (Object e : o) {
                                xml.startNode(xml.getElementName(e));
                                this.asShortObject(e, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        } else if (referenceObject instanceof Map) {
                            Map map = (Map)referenceObject;
                            for (Map.Entry entry : map.entrySet()) {
                                String key = String.valueOf(entry.getKey());
                                Object o = entry.getValue();
                                xml.startNode("entry").attribute("key", key);
                                this.asShortObject(o, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        }
                    }
                }
            }
            xml.end();
        }
    }

    private boolean shouldInclude(IncludeExcludeSupport<String> includeExcludeSupport, List<String> includes, List<String> excludes, Object object, String name) {
        return includeExcludeSupport.shouldInclude(includes, excludes, (Object)name) && this.shouldInclude(object, name);
    }

    private boolean shouldInitializeProxy(Object object) {
        return this.proxyHandler.isInitialized(object) || this.shouldInitializeProxies();
    }

    protected boolean shouldInitializeProxies() {
        return true;
    }

    protected void asShortObject(Object refObj, XML xml, GrailsDomainClassProperty idProperty, GrailsDomainClass referencedDomainClass) throws ConverterException {
        Object idValue;
        if (this.proxyHandler instanceof EntityProxyHandler) {
            idValue = ((EntityProxyHandler)this.proxyHandler).getProxyIdentifier(refObj);
            if (idValue == null) {
                ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(refObj.getClass());
                idValue = propertyFetcher.getPropertyValue(refObj, idProperty.getName());
            }
        } else {
            ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(refObj.getClass());
            idValue = propertyFetcher.getPropertyValue(refObj, idProperty.getName());
        }
        xml.attribute("id", String.valueOf(idValue));
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

