/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import grails.converters.JSON;
import grails.converters.XML;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.cfg.GrailsConfig;
import org.codehaus.groovy.grails.support.proxy.DefaultProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ChainedConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.ConvertersConfigurationHolder;
import org.codehaus.groovy.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.ObjectMarshallerRegisterer;
import org.codehaus.groovy.grails.web.converters.marshaller.ProxyUnwrappingMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.ByteArrayMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.DateMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.DeepDomainClassMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.DomainClassMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.GroovyBeanMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.JavascriptDateMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.MapMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.json.ToStringBeanMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.ArrayMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.Base64ByteArrayMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.CollectionMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.EnumMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.xml.GenericJavaBeanMarshaller;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersConfigurationInitializer
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    public final Log LOG = LogFactory.getLog(ConvertersConfigurationInitializer.class);

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void initialize(GrailsApplication application) {
        this.LOG.debug((Object)"Initializing Converters Default Configurations...");
        this.initJSONConfiguration(application);
        this.initXMLConfiguration(application);
        this.initDeepJSONConfiguration(application);
        this.initDeepXMLConfiguration(application);
    }

    private void initJSONConfiguration(GrailsApplication application) {
        this.LOG.debug((Object)"Initializing default JSON Converters Configuration...");
        ArrayList marshallers = new ArrayList();
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.ArrayMarshaller());
        marshallers.add(new ByteArrayMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.CollectionMarshaller());
        marshallers.add(new MapMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.EnumMarshaller());
        marshallers.add(new ProxyUnwrappingMarshaller());
        GrailsConfig grailsConfig = new GrailsConfig(application);
        if ("javascript".equals(grailsConfig.get("grails.converters.json.date", (Object)"default", Arrays.asList("javascript", "default")))) {
            this.LOG.debug((Object)"Using Javascript JSON Date Marshaller.");
            marshallers.add(new JavascriptDateMarshaller());
        } else {
            this.LOG.debug((Object)"Using default JSON Date Marshaller");
            marshallers.add(new DateMarshaller());
        }
        marshallers.add(new ToStringBeanMarshaller());
        boolean includeDomainVersion = this.includeDomainVersionProperty(grailsConfig, "json");
        ProxyHandler proxyHandler = this.getProxyHandler();
        if (((Boolean)grailsConfig.get("grails.converters.json.default.deep", (Object)false)).booleanValue()) {
            this.LOG.debug((Object)"Using DeepDomainClassMarshaller as default.");
            marshallers.add(new DeepDomainClassMarshaller(includeDomainVersion, proxyHandler, application));
        } else {
            marshallers.add(new DomainClassMarshaller(includeDomainVersion, proxyHandler, application));
        }
        marshallers.add(new GroovyBeanMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.json.GenericJavaBeanMarshaller());
        DefaultConverterConfiguration cfg = new DefaultConverterConfiguration(marshallers, proxyHandler);
        cfg.setEncoding((String)grailsConfig.get("grails.converters.encoding", (Object)"UTF-8"));
        String defaultCirRefBehaviour = (String)grailsConfig.get("grails.converters.default.circular.reference.behaviour", (Object)"DEFAULT");
        cfg.setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour.valueOf((String)grailsConfig.get("grails.converters.json.circular.reference.behaviour", (Object)defaultCirRefBehaviour, Converter.CircularReferenceBehaviour.allowedValues())));
        Boolean defaultPrettyPrint = (Boolean)grailsConfig.get("grails.converters.default.pretty.print", (Object)false);
        Boolean prettyPrint = (Boolean)grailsConfig.get("grails.converters.json.pretty.print", (Object)defaultPrettyPrint);
        cfg.setPrettyPrint(prettyPrint);
        cfg.setCacheObjectMarshallerByClass((Boolean)grailsConfig.get("grails.converters.json.cacheObjectMarshallerSelectionByClass", (Object)true));
        this.registerObjectMarshallersFromApplicationContext(cfg, JSON.class);
        ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, new ChainedConverterConfiguration(cfg, proxyHandler));
    }

    private void initDeepJSONConfiguration(GrailsApplication application) {
        GrailsConfig grailsConfig = new GrailsConfig(application);
        DefaultConverterConfiguration<JSON> deepConfig = new DefaultConverterConfiguration<JSON>(ConvertersConfigurationHolder.getConverterConfiguration(JSON.class), this.getProxyHandler());
        deepConfig.registerObjectMarshaller(new DeepDomainClassMarshaller(this.includeDomainVersionProperty(grailsConfig, "json"), this.getProxyHandler(), application));
        ConvertersConfigurationHolder.setNamedConverterConfiguration(JSON.class, "deep", deepConfig);
    }

    private void initXMLConfiguration(GrailsApplication application) {
        this.LOG.debug((Object)"Initializing default XML Converters Configuration...");
        ArrayList marshallers = new ArrayList();
        marshallers.add(new Base64ByteArrayMarshaller());
        marshallers.add(new ArrayMarshaller());
        marshallers.add(new CollectionMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.MapMarshaller());
        marshallers.add(new EnumMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DateMarshaller());
        marshallers.add(new ProxyUnwrappingMarshaller());
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.ToStringBeanMarshaller());
        ProxyHandler proxyHandler = this.getProxyHandler();
        GrailsConfig grailsConfig = new GrailsConfig(application);
        boolean includeDomainVersion = this.includeDomainVersionProperty(grailsConfig, "xml");
        if (((Boolean)grailsConfig.get("grails.converters.xml.default.deep", (Object)false)).booleanValue()) {
            marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DeepDomainClassMarshaller(includeDomainVersion, proxyHandler, application));
        } else {
            marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DomainClassMarshaller(includeDomainVersion, proxyHandler, application));
        }
        marshallers.add(new org.codehaus.groovy.grails.web.converters.marshaller.xml.GroovyBeanMarshaller());
        marshallers.add(new GenericJavaBeanMarshaller());
        DefaultConverterConfiguration cfg = new DefaultConverterConfiguration(marshallers, proxyHandler);
        cfg.setEncoding((String)grailsConfig.get("grails.converters.encoding", (Object)"UTF-8"));
        String defaultCirRefBehaviour = (String)grailsConfig.get("grails.converters.default.circular.reference.behaviour", (Object)"DEFAULT");
        cfg.setCircularReferenceBehaviour(Converter.CircularReferenceBehaviour.valueOf((String)grailsConfig.get("grails.converters.xml.circular.reference.behaviour", (Object)defaultCirRefBehaviour, Converter.CircularReferenceBehaviour.allowedValues())));
        Boolean defaultPrettyPrint = (Boolean)grailsConfig.get("grails.converters.default.pretty.print", (Object)false);
        Boolean prettyPrint = (Boolean)grailsConfig.get("grails.converters.xml.pretty.print", (Object)defaultPrettyPrint);
        cfg.setPrettyPrint(prettyPrint);
        cfg.setCacheObjectMarshallerByClass((Boolean)grailsConfig.get("grails.converters.xml.cacheObjectMarshallerSelectionByClass", (Object)true));
        this.registerObjectMarshallersFromApplicationContext(cfg, XML.class);
        ConvertersConfigurationHolder.setDefaultConfiguration(XML.class, new ChainedConverterConfiguration(cfg, proxyHandler));
    }

    private ProxyHandler getProxyHandler() {
        Object proxyHandler = this.applicationContext != null ? (ProxyHandler)this.applicationContext.getBean(ProxyHandler.class) : new DefaultProxyHandler();
        return proxyHandler;
    }

    private void initDeepXMLConfiguration(GrailsApplication application) {
        GrailsConfig grailsConfig = new GrailsConfig(application);
        DefaultConverterConfiguration<XML> deepConfig = new DefaultConverterConfiguration<XML>(ConvertersConfigurationHolder.getConverterConfiguration(XML.class), this.getProxyHandler());
        deepConfig.registerObjectMarshaller(new org.codehaus.groovy.grails.web.converters.marshaller.xml.DeepDomainClassMarshaller(this.includeDomainVersionProperty(grailsConfig, "xml"), this.getProxyHandler(), application));
        ConvertersConfigurationHolder.setNamedConverterConfiguration(XML.class, "deep", deepConfig);
    }

    private boolean includeDomainVersionProperty(GrailsConfig grailsConfig, String converterType) {
        return (Boolean)grailsConfig.get(String.format("grails.converters.%s.domain.include.version", converterType), grailsConfig.get("grails.converters.domain.include.version", (Object)false));
    }

    private <C extends Converter> void registerObjectMarshallersFromApplicationContext(DefaultConverterConfiguration<C> cfg, Class<C> converterClass) {
        if (this.applicationContext == null) {
            return;
        }
        for (ObjectMarshallerRegisterer o : this.applicationContext.getBeansOfType(ObjectMarshallerRegisterer.class).values()) {
            ObjectMarshallerRegisterer omr = o;
            if (omr.getConverterClass() != converterClass) continue;
            cfg.registerObjectMarshaller(omr.getMarshaller(), omr.getPriority());
        }
    }
}

