/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersConfigurationHolder {
    public static final String CONVERTERS_DEFAULT_ENCODING = "UTF-8";
    private static ConvertersConfigurationHolder INSTANCE;
    private final Map<Class<? extends Converter>, ConverterConfiguration> defaultConfiguration = new HashMap<Class<? extends Converter>, ConverterConfiguration>();
    private final Map<Class<? extends Converter>, Map<String, ConverterConfiguration>> namedConfigurations = new HashMap<Class<? extends Converter>, Map<String, ConverterConfiguration>>();
    private final Map<Class<? extends Converter>, ThreadLocal<ConverterConfiguration>> threadLocalConfiguration = new HashMap<Class<? extends Converter>, ThreadLocal<ConverterConfiguration>>();

    private ConvertersConfigurationHolder() {
    }

    public static void clear() {
        ConvertersConfigurationHolder configurationHolder = ConvertersConfigurationHolder.getInstance();
        configurationHolder.defaultConfiguration.clear();
        configurationHolder.namedConfigurations.clear();
        configurationHolder.threadLocalConfiguration.clear();
    }

    public static <C extends Converter> void setDefaultConfiguration(Class<C> c, ConverterConfiguration<C> cfg) {
        ConvertersConfigurationHolder.getInstance().defaultConfiguration.put(c, cfg);
    }

    public static <C extends Converter> void setDefaultConfiguration(Class<C> c, List<ObjectMarshaller<C>> om) {
        ConvertersConfigurationHolder.getInstance().defaultConfiguration.put(c, new DefaultConverterConfiguration<C>(om));
    }

    private static ConvertersConfigurationHolder getInstance() throws ConverterException {
        return INSTANCE;
    }

    public static <C extends Converter> ConverterConfiguration<C> getConverterConfiguration(Class<C> converterClass) throws ConverterException {
        DefaultConverterConfiguration cfg = ConvertersConfigurationHolder.getThreadLocalConverterConfiguration(converterClass);
        if (cfg == null) {
            cfg = ConvertersConfigurationHolder.getInstance().defaultConfiguration.get(converterClass);
        }
        if (cfg == null) {
            cfg = new DefaultConverterConfiguration();
        }
        return cfg;
    }

    public static <C extends Converter> ConverterConfiguration<C> getNamedConverterConfiguration(String name, Class<C> converterClass) throws ConverterException {
        Map<String, ConverterConfiguration> map = ConvertersConfigurationHolder.getNamedConfigMapForConverter(converterClass, false);
        return map != null ? map.get(name) : null;
    }

    public static <C extends Converter> ConverterConfiguration<C> getThreadLocalConverterConfiguration(Class<C> converterClass) throws ConverterException {
        return ConvertersConfigurationHolder.getThreadLocalForConverter(converterClass, true).get();
    }

    public static <C extends Converter> void setTheadLocalConverterConfiguration(Class<C> converterClass, ConverterConfiguration<C> cfg) throws ConverterException {
        ConvertersConfigurationHolder.getThreadLocalForConverter(converterClass, true).set(cfg);
    }

    private static <C extends Converter> ThreadLocal<ConverterConfiguration> getThreadLocalForConverter(Class<C> converter, boolean create) {
        ThreadLocal<ConverterConfiguration<Object>> threadlocal = ConvertersConfigurationHolder.getInstance().threadLocalConfiguration.get(converter);
        if (threadlocal == null && create) {
            threadlocal = new ThreadLocal();
            ConvertersConfigurationHolder.getInstance().threadLocalConfiguration.put(converter, threadlocal);
        }
        return threadlocal;
    }

    public static <C extends Converter> void setNamedConverterConfiguration(Class<C> converterClass, String name, ConverterConfiguration<C> cfg) throws ConverterException {
        ConvertersConfigurationHolder.getNamedConfigMapForConverter(converterClass, true).put(name, cfg);
    }

    private static <C extends Converter> Map<String, ConverterConfiguration> getNamedConfigMapForConverter(Class<C> clazz, boolean create) {
        Map<String, ConverterConfiguration> namedConfigs = ConvertersConfigurationHolder.getInstance().namedConfigurations.get(clazz);
        if (namedConfigs == null && create) {
            namedConfigs = new HashMap<String, ConverterConfiguration>();
            ConvertersConfigurationHolder.getInstance().namedConfigurations.put(clazz, namedConfigs);
        }
        return namedConfigs;
    }

    public static <C extends Converter> void setNamedConverterConfiguration(Class<C> converterClass, String name, List<ObjectMarshaller<C>> om) throws ConverterException {
        ConvertersConfigurationHolder.getNamedConfigMapForConverter(converterClass, true).put(name, new DefaultConverterConfiguration<C>(om));
    }

    static {
        ShutdownOperations.addOperation((Runnable)new Runnable(){

            public void run() {
                ConvertersConfigurationHolder.clear();
            }
        });
        INSTANCE = new ConvertersConfigurationHolder();
    }
}

