/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.metaclass;

import grails.async.Promise;
import grails.converters.JSON;
import grails.util.GrailsWebUtil;
import grails.web.JSONBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.StreamingMarkupBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.GrailsStringUtils;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.io.support.GrailsIOUtils;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.io.support.IOUtils;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.support.ResourceAwareTemplateEngine;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.json.JSONElement;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.mime.MimeUtility;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.servlet.mvc.ActionResultTransformer;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.ModelAndView;

public class RenderDynamicMethod
extends AbstractDynamicMethodInvocation {
    public static final String METHOD_SIGNATURE = "render";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^render$");
    public static final String ARGUMENT_TEXT = "text";
    public static final String ARGUMENT_STATUS = "status";
    public static final String ARGUMENT_LAYOUT = "layout";
    public static final String ARGUMENT_CONTENT_TYPE = "contentType";
    public static final String ARGUMENT_ENCODING = "encoding";
    public static final String ARGUMENT_VIEW = "view";
    public static final String ARGUMENT_MODEL = "model";
    public static final String ARGUMENT_TEMPLATE = "template";
    public static final String ARGUMENT_CONTEXTPATH = "contextPath";
    public static final String ARGUMENT_BEAN = "bean";
    public static final String ARGUMENT_COLLECTION = "collection";
    public static final String ARGUMENT_BUILDER = "builder";
    public static final String ARGUMENT_VAR = "var";
    private static final String DEFAULT_ARGUMENT = "it";
    private static final String BUILDER_TYPE_JSON = "json";
    private static final String TEXT_HTML = "text/html";
    private static final String APPLICATION_XML = "application/xml";
    public static final String DISPOSITION_HEADER_PREFIX = "attachment;filename=";
    private String gspEncoding = "utf-8";
    private static final String DEFAULT_ENCODING = "utf-8";
    private Object ARGUMENT_PLUGIN = "plugin";
    private static final String ARGUMENT_FILE = "file";
    private static final String ARGUMENT_FILE_NAME = "fileName";
    private MimeUtility mimeUtility;
    private Collection<ActionResultTransformer> actionResultTransformers;

    public RenderDynamicMethod() {
        super(METHOD_PATTERN);
    }

    public void setGspEncoding(String gspEncoding) {
        this.gspEncoding = gspEncoding;
    }

    public Object invoke(Object target, String methodName, Object[] arguments) {
        if (arguments.length == 0) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = webRequest.getCurrentResponse();
        boolean renderView = true;
        GroovyObject controller = (GroovyObject)target;
        String explicitSiteMeshLayout = null;
        Object renderArgument = arguments[0];
        if (renderArgument instanceof Converter) {
            renderView = this.renderConverter((Converter)renderArgument, response);
        } else if (renderArgument instanceof Writable) {
            this.applyContentType(response, null, renderArgument);
            Writable writable = (Writable)renderArgument;
            renderView = this.renderWritable(writable, response);
        } else if (renderArgument instanceof CharSequence) {
            this.applyContentType(response, null, renderArgument);
            CharSequence text = (CharSequence)renderArgument;
            renderView = this.renderText(text, response);
        } else {
            Object renderObject = arguments[arguments.length - 1];
            if (renderArgument instanceof Closure) {
                this.setContentType(response, TEXT_HTML, DEFAULT_ENCODING, true);
                Closure closure = (Closure)renderObject;
                renderView = this.renderMarkup(closure, response);
            } else if (renderArgument instanceof Map) {
                Object statusObj;
                Map argMap = (Map)renderArgument;
                if (argMap.containsKey(ARGUMENT_LAYOUT)) {
                    explicitSiteMeshLayout = String.valueOf(argMap.get(ARGUMENT_LAYOUT));
                }
                boolean statusSet = false;
                if (argMap.containsKey(ARGUMENT_STATUS) && (statusObj = argMap.get(ARGUMENT_STATUS)) != null) {
                    try {
                        int statusCode = statusObj instanceof Number ? ((Number)statusObj).intValue() : Integer.parseInt(statusObj.toString());
                        response.setStatus(statusCode);
                        statusSet = true;
                    }
                    catch (NumberFormatException e) {
                        throw new ControllerExecutionException("Argument [status] of method [render] must be a valid integer.");
                    }
                }
                if (renderObject instanceof Writable) {
                    Writable writable = (Writable)renderObject;
                    this.applyContentType(response, argMap, renderObject);
                    renderView = this.renderWritable(writable, response);
                } else if (renderObject instanceof Closure) {
                    Closure callable = (Closure)renderObject;
                    this.applyContentType(response, argMap, renderObject);
                    renderView = BUILDER_TYPE_JSON.equals(argMap.get(ARGUMENT_BUILDER)) || this.isJSONResponse(response) ? this.renderJSON(callable, response) : this.renderMarkup(callable, response);
                } else if (renderObject instanceof CharSequence) {
                    this.applyContentType(response, argMap, renderObject);
                    CharSequence text = (CharSequence)renderObject;
                    renderView = this.renderText(text, response);
                } else if (argMap.containsKey(ARGUMENT_TEXT)) {
                    Object textArg = argMap.get(ARGUMENT_TEXT);
                    this.applyContentType(response, argMap, textArg);
                    if (textArg instanceof Writable) {
                        Writable writable = (Writable)textArg;
                        renderView = this.renderWritable(writable, response);
                    } else {
                        CharSequence text = textArg instanceof CharSequence ? (CharSequence)textArg : textArg.toString();
                        renderView = this.renderText(text, response);
                    }
                } else if (argMap.containsKey(ARGUMENT_VIEW)) {
                    this.renderView(webRequest, argMap, target, controller);
                } else if (argMap.containsKey(ARGUMENT_TEMPLATE)) {
                    this.applyContentType(response, argMap, null, false);
                    renderView = this.renderTemplate(target, controller, webRequest, argMap);
                } else if (argMap.containsKey(ARGUMENT_FILE)) {
                    String fileName;
                    renderView = false;
                    Object o = argMap.get(ARGUMENT_FILE);
                    Object fnO = argMap.get(ARGUMENT_FILE_NAME);
                    String string = fnO != null ? fnO.toString() : (fileName = o instanceof File ? ((File)o).getName() : null);
                    if (o != null) {
                        boolean hasContentType = this.applyContentType(response, argMap, null, false);
                        if (fileName != null) {
                            if (!hasContentType) {
                                hasContentType = this.detectContentTypeFromFileName(webRequest, response, argMap, fileName);
                            }
                            if (fnO != null) {
                                response.setHeader("Content-Disposition", DISPOSITION_HEADER_PREFIX + fileName);
                            }
                        }
                        if (!hasContentType) {
                            throw new ControllerExecutionException("Argument [file] of render method specified without valid [contentType] argument");
                        }
                        InputStream input = null;
                        try {
                            if (o instanceof File) {
                                File f = (File)o;
                                input = GrailsIOUtils.openStream((File)f);
                            } else {
                                input = o instanceof InputStream ? (InputStream)o : (o instanceof byte[] ? new ByteArrayInputStream((byte[])o) : GrailsIOUtils.openStream((File)new File(o.toString())));
                            }
                            IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
                        }
                        catch (IOException e) {
                            throw new ControllerExecutionException("I/O error copying file to response: " + e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                } else if (statusSet) {
                    renderView = false;
                } else {
                    Object object = renderArgument;
                    if (object instanceof JSONElement) {
                        renderView = this.renderJSON((JSONElement)object, response);
                    } else {
                        try {
                            renderView = this.renderObject(object, response.getWriter());
                        }
                        catch (IOException e) {}
                    }
                }
            } else {
                throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
            }
        }
        this.applySiteMeshLayout(webRequest.getCurrentRequest(), renderView, explicitSiteMeshLayout);
        webRequest.setRenderView(renderView);
        return null;
    }

    private void applySiteMeshLayout(HttpServletRequest request, boolean renderView, String explicitSiteMeshLayout) {
        String siteMeshLayout;
        if (explicitSiteMeshLayout == null && request.getAttribute("org.grails.layout.name") != null) {
            return;
        }
        String string = explicitSiteMeshLayout != null ? explicitSiteMeshLayout : (siteMeshLayout = renderView ? null : "_none_");
        if (siteMeshLayout != null) {
            request.setAttribute("org.grails.layout.name", (Object)siteMeshLayout);
        }
    }

    private boolean renderConverter(Converter<?> converter, HttpServletResponse response) {
        converter.render(response);
        return false;
    }

    private String resolveContentTypeBySourceType(Object renderArgument, String defaultEncoding) {
        return renderArgument instanceof GPathResult ? APPLICATION_XML : defaultEncoding;
    }

    private boolean applyContentType(HttpServletResponse response, Map argMap, Object renderArgument) {
        return this.applyContentType(response, argMap, renderArgument, true);
    }

    private boolean applyContentType(HttpServletResponse response, Map argMap, Object renderArgument, boolean useDefault) {
        boolean contentTypeIsDefault = true;
        String contentType = this.resolveContentTypeBySourceType(renderArgument, useDefault ? TEXT_HTML : null);
        String encoding = DEFAULT_ENCODING;
        if (argMap != null) {
            if (argMap.containsKey(ARGUMENT_CONTENT_TYPE)) {
                contentType = argMap.get(ARGUMENT_CONTENT_TYPE).toString();
                contentTypeIsDefault = false;
            }
            if (argMap.containsKey(ARGUMENT_ENCODING)) {
                encoding = argMap.get(ARGUMENT_ENCODING).toString();
                contentTypeIsDefault = false;
            }
        }
        if (contentType != null) {
            this.setContentType(response, contentType, encoding, contentTypeIsDefault);
            return true;
        }
        return false;
    }

    private boolean renderJSON(JSONElement object, HttpServletResponse response) {
        response.setContentType(GrailsWebUtil.getContentType((String)"application/json", (String)DEFAULT_ENCODING));
        return this.renderWritable((Writable)object, response);
    }

    private boolean detectContentTypeFromFileName(GrailsWebRequest webRequest, HttpServletResponse response, Map argMap, String fileName) {
        MimeType mimeType;
        MimeUtility mimeUtility = this.lookupMimeUtility(webRequest);
        if (mimeUtility != null && (mimeType = mimeUtility.getMimeTypeForExtension(GrailsStringUtils.getFilenameExtension((String)fileName))) != null) {
            String contentType = mimeType.getName();
            Object encodingObj = argMap.get(ARGUMENT_ENCODING);
            String encoding = encodingObj != null ? encodingObj.toString() : DEFAULT_ENCODING;
            this.setContentType(response, contentType, encoding);
            return true;
        }
        return false;
    }

    private MimeUtility lookupMimeUtility(GrailsWebRequest webRequest) {
        ApplicationContext applicationContext;
        if (this.mimeUtility == null && (applicationContext = webRequest.getApplicationContext()) != null) {
            this.mimeUtility = (MimeUtility)applicationContext.getBean("grailsMimeUtility", MimeUtility.class);
        }
        return this.mimeUtility;
    }

    private GSPResponseWriter createResponseWriter(GrailsWebRequest webRequest) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)webRequest.getCurrentResponse());
        webRequest.setOut((Writer)out);
        return out;
    }

    private boolean renderTemplate(Object target, GroovyObject controller, GrailsWebRequest webRequest, Map argMap) {
        boolean renderView;
        GSPResponseWriter out = this.createResponseWriter(webRequest);
        boolean hasModel = argMap.containsKey(ARGUMENT_MODEL);
        Object modelObject = null;
        if (hasModel) {
            modelObject = argMap.get(ARGUMENT_MODEL);
        }
        String templateName = argMap.get(ARGUMENT_TEMPLATE).toString();
        String contextPath = this.getContextPath(webRequest, argMap);
        String var = null;
        if (argMap.containsKey(ARGUMENT_VAR)) {
            var = String.valueOf(argMap.get(ARGUMENT_VAR));
        }
        String templateUri = webRequest.getAttributes().getTemplateURI(controller, templateName);
        ResourceAwareTemplateEngine engine = webRequest.getAttributes().getPagesTemplateEngine();
        try {
            Template t = engine.createTemplateForUri(new String[]{GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, templateUri}), GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, "/grails-app/views/", templateUri})});
            if (t == null) {
                throw new ControllerExecutionException("Unable to load template for uri [" + templateUri + "]. Template not found.");
            }
            if (t instanceof GroovyPageTemplate) {
                ((GroovyPageTemplate)t).setAllowSettingContentType(true);
            }
            HashMap binding = new HashMap();
            if (argMap.containsKey(ARGUMENT_BEAN)) {
                Object bean = argMap.get(ARGUMENT_BEAN);
                if (hasModel && modelObject instanceof Map) {
                    this.setTemplateModel(webRequest, binding, modelObject);
                }
                this.renderTemplateForBean(t, binding, bean, var, (Writer)out);
            } else if (argMap.containsKey(ARGUMENT_COLLECTION)) {
                Object colObject = argMap.get(ARGUMENT_COLLECTION);
                if (hasModel && modelObject instanceof Map) {
                    this.setTemplateModel(webRequest, binding, modelObject);
                }
                this.renderTemplateForCollection(t, binding, colObject, var, (Writer)out);
            } else if (hasModel) {
                if (modelObject instanceof Map) {
                    this.setTemplateModel(webRequest, binding, modelObject);
                }
                this.renderTemplateForModel(t, modelObject, target, (Writer)out);
            } else {
                Writable w = t.make();
                w.writeTo((Writer)out);
            }
            out.flush();
            renderView = false;
        }
        catch (GroovyRuntimeException gre) {
            throw new ControllerExecutionException("Error rendering template [" + templateName + "]: " + gre.getMessage(), (Throwable)gre);
        }
        catch (IOException ioex) {
            throw new ControllerExecutionException("I/O error executing render method for arguments [" + argMap + "]: " + ioex.getMessage(), (Throwable)ioex);
        }
        return renderView;
    }

    protected Collection<ActionResultTransformer> getActionResultTransformers(GrailsWebRequest webRequest) {
        if (this.actionResultTransformers == null) {
            ApplicationContext applicationContext = webRequest.getApplicationContext();
            if (applicationContext != null) {
                this.actionResultTransformers = applicationContext.getBeansOfType(ActionResultTransformer.class).values();
            }
            if (this.actionResultTransformers == null) {
                this.actionResultTransformers = Collections.emptyList();
            }
        }
        return this.actionResultTransformers;
    }

    private void setTemplateModel(GrailsWebRequest webRequest, Map binding, Map modelObject) {
        Map modelMap = modelObject;
        webRequest.setAttribute("org.codehaus.groovy.grails.TEMPLATE_MODEL", (Object)modelMap, 0);
        binding.putAll(modelMap);
    }

    private String getContextPath(GrailsWebRequest webRequest, Map argMap) {
        ApplicationContext applicationContext;
        GrailsPluginManager pluginManager;
        GrailsPlugin plugin;
        Object cp = argMap.get(ARGUMENT_CONTEXTPATH);
        String contextPath = cp != null ? cp.toString() : "";
        Object pluginName = argMap.get(this.ARGUMENT_PLUGIN);
        if (pluginName != null && (plugin = (pluginManager = (GrailsPluginManager)(applicationContext = webRequest.getApplicationContext()).getBean("pluginManager")).getGrailsPlugin(pluginName.toString())) != null && !plugin.isBasePlugin()) {
            contextPath = plugin.getPluginPath();
        }
        return contextPath;
    }

    private void setContentType(HttpServletResponse response, String contentType, String encoding) {
        this.setContentType(response, contentType, encoding, false);
    }

    private void setContentType(HttpServletResponse response, String contentType, String encoding, boolean contentTypeIsDefault) {
        if (!contentTypeIsDefault || response.getContentType() == null) {
            response.setContentType(GrailsWebUtil.getContentType((String)contentType, (String)encoding));
        }
    }

    private boolean renderObject(Object object, Writer out) {
        boolean renderView;
        try {
            out.write(DefaultGroovyMethods.inspect((Object)object));
            renderView = false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error obtaining response writer: " + e.getMessage(), (Throwable)e);
        }
        return renderView;
    }

    private void renderTemplateForModel(Template template, Object modelObject, Object target, Writer out) throws IOException {
        if (modelObject instanceof Map) {
            template.make((Map)modelObject).writeTo(out);
        } else {
            template.make().writeTo(out);
        }
    }

    private void renderTemplateForCollection(Template template, Map binding, Object colObject, String var, Writer out) throws IOException {
        if (colObject instanceof Collection) {
            Collection c = (Collection)colObject;
            for (Object o : c) {
                if (GrailsStringUtils.isBlank((String)var)) {
                    binding.put(DEFAULT_ARGUMENT, o);
                } else {
                    binding.put(var, o);
                }
                template.make(binding).writeTo(out);
            }
        } else {
            if (GrailsStringUtils.isBlank((String)var)) {
                binding.put(DEFAULT_ARGUMENT, colObject);
            } else {
                binding.put(var, colObject);
            }
            template.make(binding).writeTo(out);
        }
    }

    private void renderTemplateForBean(Template template, Map binding, Object bean, String varName, Writer out) throws IOException {
        if (GrailsStringUtils.isBlank((String)varName)) {
            binding.put(DEFAULT_ARGUMENT, bean);
        } else {
            binding.put(varName, bean);
        }
        template.make(binding).writeTo(out);
    }

    private void renderView(GrailsWebRequest webRequest, Map argMap, Object target, GroovyObject controller) {
        Object modelObject;
        String viewName = argMap.get(ARGUMENT_VIEW).toString();
        String viewUri = webRequest.getAttributes().getNoSuffixViewURI((GroovyObject)target, viewName);
        String contextPath = this.getContextPath(webRequest, argMap);
        if (contextPath != null) {
            viewUri = contextPath + viewUri;
        }
        if ((modelObject = argMap.get(ARGUMENT_MODEL)) != null) {
            modelObject = argMap.get(ARGUMENT_MODEL);
            boolean isPromise = modelObject instanceof Promise;
            Collection<ActionResultTransformer> resultTransformers = this.getActionResultTransformers(webRequest);
            for (ActionResultTransformer resultTransformer : resultTransformers) {
                modelObject = resultTransformer.transformActionResult(webRequest, viewUri, modelObject);
            }
            if (isPromise) {
                return;
            }
        }
        this.applyContentType(webRequest.getCurrentResponse(), argMap, null);
        HashMap model = modelObject instanceof Map ? (HashMap)modelObject : new HashMap();
        controller.setProperty("modelAndView", (Object)new ModelAndView(viewUri, model));
    }

    private boolean renderJSON(Closure callable, HttpServletResponse response) {
        boolean renderView = true;
        JSONBuilder builder = new JSONBuilder();
        JSON json = builder.build(callable);
        json.render(response);
        renderView = false;
        return renderView;
    }

    private boolean renderMarkup(Closure closure, HttpServletResponse response) {
        StreamingMarkupBuilder b = new StreamingMarkupBuilder();
        b.setEncoding((Object)response.getCharacterEncoding());
        Writable markup = b.bind((Object)closure);
        return this.renderWritable(markup, response);
    }

    private boolean renderText(CharSequence text, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            return this.renderText(text, writer);
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean renderWritable(Writable writable, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            writable.writeTo((Writer)writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean renderText(CharSequence text, Writer writer) {
        try {
            if (writer instanceof PrintWriter) {
                ((PrintWriter)writer).print(text);
            } else {
                writer.write(text.toString());
            }
            writer.flush();
            return false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isJSONResponse(HttpServletResponse response) {
        String contentType = response.getContentType();
        return contentType != null && (contentType.indexOf("application/json") > -1 || contentType.indexOf("text/json") > -1);
    }
}

