/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.web;

import grails.artefact.Artefact;
import grails.validation.DefaultASTValidateableHelper;
import grails.web.Action;
import grails.web.RequestParameter;
import grails.web.controllers.ControllerMethod;
import groovy.lang.Closure;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AnnotatedClassInjector;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.web.ControllerTransformer;
import org.codehaus.groovy.grails.validation.Validateable;
import org.codehaus.groovy.grails.web.binding.DefaultASTDatabindingHelper;
import org.codehaus.groovy.grails.web.controllers.DefaultControllerExceptionHandlerMetaData;
import org.codehaus.groovy.grails.web.util.TypeConvertingMap;
import org.codehaus.groovy.syntax.Token;
import org.grails.databinding.bindingsource.DataBindingSourceCreationException;
import org.springframework.validation.Errors;
import org.springframework.validation.MapBindingResult;

@AstTransformer
public class ControllerActionTransformer
implements GrailsArtefactClassInjector,
AnnotatedClassInjector {
    private static final ClassNode OBJECT_CLASS = new ClassNode(Object.class);
    public static final AnnotationNode ACTION_ANNOTATION_NODE = new AnnotationNode(new ClassNode(Action.class));
    private static final String ACTION_MEMBER_TARGET = "commandObjects";
    public static final String EXCEPTION_HANDLER_META_DATA_FIELD_NAME = "$exceptionHandlerMetaData";
    private static final TupleExpression EMPTY_TUPLE = new TupleExpression();
    private static final Map<ClassNode, String> TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME = grails.util.CollectionUtils.newMap((Object[])new Object[]{ClassHelper.Integer_TYPE, "int", ClassHelper.Float_TYPE, "float", ClassHelper.Long_TYPE, "long", ClassHelper.Double_TYPE, "double", ClassHelper.Short_TYPE, "short", ClassHelper.Boolean_TYPE, "boolean", ClassHelper.Byte_TYPE, "byte", ClassHelper.Character_TYPE, "char"});
    private static List<ClassNode> PRIMITIVE_CLASS_NODES = grails.util.CollectionUtils.newList((Object[])new ClassNode[]{ClassHelper.boolean_TYPE, ClassHelper.char_TYPE, ClassHelper.int_TYPE, ClassHelper.short_TYPE, ClassHelper.long_TYPE, ClassHelper.double_TYPE, ClassHelper.float_TYPE, ClassHelper.byte_TYPE});
    public static final String VOID_TYPE = "void";
    private Boolean converterEnabled = Boolean.parseBoolean(System.getProperty("grails.compile.artefacts.closures.convert"));

    public String[] getArtefactTypes() {
        return new String[]{"Controller"};
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (!classNode.getAnnotations(new ClassNode(Artefact.class)).isEmpty()) {
            return;
        }
        this.performInjectionOnAnnotatedClass(source, context, classNode);
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        String className = classNode.getName();
        if (className.endsWith("Controller")) {
            this.processMethods(classNode, source, context);
            this.processClosures(classNode, source, context);
        }
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, null, classNode);
    }

    private boolean isExceptionHandlingMethod(MethodNode methodNode) {
        boolean isExceptionHandler = false;
        Parameter[] parameters = methodNode.getParameters();
        if (parameters.length == 1) {
            ClassNode parameterTypeClassNode = parameters[0].getType();
            isExceptionHandler = parameterTypeClassNode.isDerivedFrom(new ClassNode(Exception.class));
        }
        return isExceptionHandler;
    }

    private void processMethods(ClassNode classNode, SourceUnit source, GeneratorContext context) {
        ArrayList<MethodNode> deferredNewMethods = new ArrayList<MethodNode>();
        for (MethodNode method : classNode.getMethods()) {
            MethodNode wrapperMethod;
            int numberOfNonExceptionHandlerMethodsWithThisName;
            if (!this.methodShouldBeConfiguredAsControllerAction(method)) continue;
            List declaredMethodsWithThisName = classNode.getDeclaredMethods(method.getName());
            if (declaredMethodsWithThisName != null && (numberOfNonExceptionHandlerMethodsWithThisName = CollectionUtils.countMatches((Collection)declaredMethodsWithThisName, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return !ControllerActionTransformer.this.isExceptionHandlingMethod((MethodNode)object);
                }
            })) > 1) {
                String message = "Controller actions may not be overloaded.  The [" + method.getName() + "] action has been overloaded in [" + classNode.getName() + "].";
                GrailsASTUtils.error((SourceUnit)source, (ASTNode)method, (String)message);
            }
            if ((wrapperMethod = this.convertToMethodAction(classNode, method, source, context)) == null) continue;
            deferredNewMethods.add(wrapperMethod);
        }
        Collection<MethodNode> exceptionHandlerMethods = this.getExceptionHandlerMethods(classNode, source);
        FieldNode exceptionHandlerMetaDataField = classNode.getField(EXCEPTION_HANDLER_META_DATA_FIELD_NAME);
        if (exceptionHandlerMetaDataField == null || !exceptionHandlerMetaDataField.getDeclaringClass().equals((Object)classNode)) {
            ListExpression listOfExceptionHandlerMetaData = new ListExpression();
            for (MethodNode exceptionHandlerMethod : exceptionHandlerMethods) {
                Class exceptionHandlerExceptionType = exceptionHandlerMethod.getParameters()[0].getType().getPlainNodeReference().getTypeClass();
                String exceptionHandlerMethodName = exceptionHandlerMethod.getName();
                ArgumentListExpression defaultControllerExceptionHandlerMetaDataCtorArgs = new ArgumentListExpression();
                defaultControllerExceptionHandlerMetaDataCtorArgs.addExpression((Expression)new ConstantExpression((Object)exceptionHandlerMethodName));
                defaultControllerExceptionHandlerMetaDataCtorArgs.addExpression((Expression)new ClassExpression(new ClassNode(exceptionHandlerExceptionType)));
                listOfExceptionHandlerMetaData.addExpression((Expression)new ConstructorCallExpression(new ClassNode(DefaultControllerExceptionHandlerMetaData.class), (Expression)defaultControllerExceptionHandlerMetaDataCtorArgs));
            }
            classNode.addField(EXCEPTION_HANDLER_META_DATA_FIELD_NAME, 26, new ClassNode(List.class), (Expression)listOfExceptionHandlerMetaData);
        }
        for (MethodNode newMethod : deferredNewMethods) {
            classNode.addMethod(newMethod);
        }
    }

    protected boolean methodShouldBeConfiguredAsControllerAction(MethodNode method) {
        return !method.isStatic() && method.isPublic() && !method.isAbstract() && method.getAnnotations(ACTION_ANNOTATION_NODE.getClassNode()).isEmpty() && method.getAnnotations(new ClassNode(ControllerMethod.class)).isEmpty() && method.getLineNumber() >= 0 && !method.getName().startsWith("$") && !method.getReturnType().getName().equals(VOID_TYPE) && !this.isExceptionHandlingMethod(method);
    }

    protected Collection<MethodNode> getExceptionHandlerMethods(ClassNode classNode, SourceUnit sourceUnit) {
        HashMap<ClassNode, MethodNode> exceptionTypeToHandlerMethodMap = new HashMap<ClassNode, MethodNode>();
        List methods = classNode.getMethods();
        for (MethodNode methodNode : methods) {
            if (!this.isExceptionHandlingMethod(methodNode)) continue;
            Parameter exceptionParameter = methodNode.getParameters()[0];
            ClassNode exceptionType = exceptionParameter.getType();
            if (!exceptionTypeToHandlerMethodMap.containsKey(exceptionType)) {
                exceptionTypeToHandlerMethodMap.put(exceptionType, methodNode);
                continue;
            }
            MethodNode otherHandlerMethod = (MethodNode)exceptionTypeToHandlerMethodMap.get(exceptionType);
            String message = "A controller may not define more than 1 exception handler for a particular exception type.  [%s] defines the [%s] and [%s] exception handlers which each accept a [%s] which is not allowed.";
            String formattedMessage = String.format("A controller may not define more than 1 exception handler for a particular exception type.  [%s] defines the [%s] and [%s] exception handlers which each accept a [%s] which is not allowed.", classNode.getName(), otherHandlerMethod.getName(), methodNode.getName(), exceptionType.getName());
            GrailsASTUtils.error((SourceUnit)sourceUnit, (ASTNode)methodNode, (String)formattedMessage);
        }
        ClassNode superClass = classNode.getSuperClass();
        if (!superClass.equals((Object)OBJECT_CLASS)) {
            Collection<MethodNode> superClassMethods = this.getExceptionHandlerMethods(superClass, sourceUnit);
            for (MethodNode superClassMethod : superClassMethods) {
                Parameter exceptionParameter = superClassMethod.getParameters()[0];
                ClassNode exceptionType = exceptionParameter.getType();
                if (exceptionTypeToHandlerMethodMap.containsKey(exceptionType)) continue;
                exceptionTypeToHandlerMethodMap.put(exceptionType, superClassMethod);
            }
        }
        return exceptionTypeToHandlerMethodMap.values();
    }

    private MethodNode convertToMethodAction(ClassNode classNode, MethodNode methodNode, SourceUnit source, GeneratorContext context) {
        Parameter[] parameters;
        ClassNode returnType = methodNode.getReturnType();
        for (Parameter param : parameters = methodNode.getParameters()) {
            if (!param.hasInitialExpression()) continue;
            String paramName = param.getName();
            String methodName = methodNode.getName();
            String initialValue = param.getInitialExpression().getText();
            String methodDeclaration = methodNode.getText();
            String message = "Parameter [%s] to method [%s] has default value [%s].  Default parameter values are not allowed in controller action methods. ([%s])";
            String formattedMessage = String.format(message, paramName, methodName, initialValue, methodDeclaration);
            GrailsASTUtils.error((SourceUnit)source, (ASTNode)methodNode, (String)formattedMessage);
        }
        MethodNode method = null;
        if (methodNode.getParameters().length > 0) {
            method = new MethodNode(methodNode.getName(), 1, returnType, ZERO_PARAMETERS, EMPTY_CLASS_ARRAY, this.addOriginalMethodCall(methodNode, this.initializeActionParameters(classNode, (ASTNode)methodNode, methodNode.getName(), parameters, source, context)));
            GrailsASTUtils.copyAnnotations((AnnotatedNode)methodNode, (AnnotatedNode)method);
            this.annotateActionMethodAndWrapWithExceptionHandling(classNode, parameters, method);
        } else {
            this.annotateActionMethodAndWrapWithExceptionHandling(classNode, parameters, methodNode);
        }
        return method;
    }

    private Statement addOriginalMethodCall(MethodNode methodNode, BlockStatement blockStatement) {
        if (blockStatement == null) {
            return null;
        }
        ArgumentListExpression arguments = new ArgumentListExpression();
        for (Parameter p : methodNode.getParameters()) {
            arguments.addExpression((Expression)new VariableExpression(p.getName(), p.getType()));
        }
        MethodCallExpression callExpression = new MethodCallExpression((Expression)new VariableExpression("this"), methodNode.getName(), (Expression)arguments);
        callExpression.setMethodTarget(methodNode);
        blockStatement.addStatement((Statement)new ReturnStatement((Expression)callExpression));
        return blockStatement;
    }

    private boolean isCommandObjectAction(Parameter[] params) {
        return params != null && params.length > 0 && params[0].getType() != new ClassNode(Object[].class) && params[0].getType() != new ClassNode(Object.class);
    }

    private void processClosures(ClassNode classNode, SourceUnit source, GeneratorContext context) {
        ArrayList propertyNodes = new ArrayList(classNode.getProperties());
        for (PropertyNode property : propertyNodes) {
            Expression initialExpression = property.getInitialExpression();
            if (property.isStatic() || initialExpression == null || !initialExpression.getClass().equals(ClosureExpression.class)) continue;
            ClosureExpression closureAction = (ClosureExpression)initialExpression;
            if (this.converterEnabled.booleanValue()) {
                this.transformClosureToMethod(classNode, closureAction, property, source, context);
                continue;
            }
            this.addMethodToInvokeClosure(classNode, property, source, context);
        }
    }

    protected void addMethodToInvokeClosure(ClassNode controllerClassNode, PropertyNode closureProperty, SourceUnit source, GeneratorContext context) {
        MethodNode method = controllerClassNode.getMethod(closureProperty.getName(), ZERO_PARAMETERS);
        if (method == null || !method.getDeclaringClass().equals((Object)controllerClassNode)) {
            ClosureExpression closureExpression = (ClosureExpression)closureProperty.getInitialExpression();
            Parameter[] parameters = closureExpression.getParameters();
            BlockStatement newMethodCode = this.initializeActionParameters(controllerClassNode, (ASTNode)closureProperty, closureProperty.getName(), parameters, source, context);
            ArgumentListExpression closureInvocationArguments = new ArgumentListExpression();
            if (parameters != null) {
                for (Parameter p : parameters) {
                    closureInvocationArguments.addExpression((Expression)new VariableExpression(p.getName()));
                }
            }
            MethodCallExpression methodCallExpression = new MethodCallExpression((Expression)closureExpression, "call", (Expression)closureInvocationArguments);
            newMethodCode.addStatement((Statement)new ExpressionStatement((Expression)GrailsASTUtils.applyMethodTarget((MethodCallExpression)methodCallExpression, Closure.class, (Class[])new Class[]{Object.class})));
            MethodNode methodNode = new MethodNode(closureProperty.getName(), 1, new ClassNode(Object.class), ZERO_PARAMETERS, EMPTY_CLASS_ARRAY, (Statement)newMethodCode);
            this.annotateActionMethodAndWrapWithExceptionHandling(controllerClassNode, parameters, methodNode);
            controllerClassNode.addMethod(methodNode);
        }
    }

    protected void annotateActionMethodAndWrapWithExceptionHandling(ClassNode controllerClassNode, Parameter[] parameters, MethodNode methodNode) {
        if (this.isCommandObjectAction(parameters)) {
            ListExpression initArray = new ListExpression();
            for (Parameter parameter : parameters) {
                initArray.addExpression((Expression)new ClassExpression(parameter.getType()));
            }
            AnnotationNode paramActionAnn = new AnnotationNode(new ClassNode(Action.class));
            paramActionAnn.setMember(ACTION_MEMBER_TARGET, (Expression)initArray);
            methodNode.addAnnotation(paramActionAnn);
        } else {
            methodNode.addAnnotation(ACTION_ANNOTATION_NODE);
        }
        this.wrapMethodBodyWithExceptionHandling(controllerClassNode, methodNode);
    }

    protected void wrapMethodBodyWithExceptionHandling(ClassNode controllerClassNode, MethodNode methodNode) {
        BlockStatement catchBlockCode = new BlockStatement();
        String caughtExceptionArgumentName = "$caughtException";
        VariableExpression caughtExceptionVariableExpression = new VariableExpression("$caughtException");
        PropertyExpression caughtExceptionTypeExpression = new PropertyExpression((Expression)caughtExceptionVariableExpression, "class");
        VariableExpression thisExpression = new VariableExpression("this");
        MethodCallExpression getExceptionHandlerMethodCall = new MethodCallExpression((Expression)thisExpression, "getExceptionHandlerMethodFor", (Expression)caughtExceptionTypeExpression);
        GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)getExceptionHandlerMethodCall, (ClassNode)controllerClassNode);
        ClassNode reflectMethodClassNode = new ClassNode(Method.class);
        String exceptionHandlerMethodVariableName = "$method";
        VariableExpression exceptionHandlerMethodExpression = new VariableExpression("$method", new ClassNode(Method.class));
        DeclarationExpression declareExceptionHandlerMethod = new DeclarationExpression(new VariableExpression("$method", reflectMethodClassNode), Token.newSymbol((int)100, (int)0, (int)0), (Expression)getExceptionHandlerMethodCall);
        ArgumentListExpression invokeArguments = new ArgumentListExpression();
        invokeArguments.addExpression((Expression)thisExpression);
        invokeArguments.addExpression((Expression)caughtExceptionVariableExpression);
        MethodCallExpression invokeExceptionHandlerMethodExpression = new MethodCallExpression((Expression)new VariableExpression("$method"), "invoke", (Expression)invokeArguments);
        GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)invokeExceptionHandlerMethodExpression, (ClassNode)reflectMethodClassNode);
        ReturnStatement returnStatement = new ReturnStatement((Expression)invokeExceptionHandlerMethodExpression);
        ThrowStatement throwCaughtExceptionStatement = new ThrowStatement((Expression)caughtExceptionVariableExpression);
        IfStatement ifExceptionHandlerMethodExistsStatement = new IfStatement(new BooleanExpression((Expression)exceptionHandlerMethodExpression), (Statement)returnStatement, (Statement)throwCaughtExceptionStatement);
        catchBlockCode.addStatement((Statement)new ExpressionStatement((Expression)declareExceptionHandlerMethod));
        catchBlockCode.addStatement((Statement)ifExceptionHandlerMethodExistsStatement);
        CatchStatement catchStatement = new CatchStatement(new Parameter(new ClassNode(Exception.class), "$caughtException"), (Statement)catchBlockCode);
        Statement methodBody = methodNode.getCode();
        TryCatchStatement tryCatchStatement = new TryCatchStatement(methodBody, (Statement)new EmptyStatement());
        tryCatchStatement.addCatch(catchStatement);
        methodNode.setCode((Statement)tryCatchStatement);
    }

    protected void transformClosureToMethod(ClassNode classNode, ClosureExpression closureAction, PropertyNode property, SourceUnit source, GeneratorContext context) {
        MethodNode actionMethod = new MethodNode(property.getName(), 1, property.getType(), closureAction.getParameters(), EMPTY_CLASS_ARRAY, closureAction.getCode());
        MethodNode convertedMethod = this.convertToMethodAction(classNode, actionMethod, source, context);
        if (convertedMethod != null) {
            classNode.addMethod(convertedMethod);
        }
        classNode.getProperties().remove(property);
        classNode.getFields().remove(property.getField());
        classNode.addMethod(actionMethod);
    }

    protected BlockStatement initializeActionParameters(ClassNode classNode, ASTNode actionNode, String actionName, Parameter[] actionParameters, SourceUnit source, GeneratorContext context) {
        BlockStatement wrapper = new BlockStatement();
        ArgumentListExpression mapBindingResultConstructorArgs = new ArgumentListExpression();
        mapBindingResultConstructorArgs.addExpression((Expression)new ConstructorCallExpression(new ClassNode(HashMap.class), (Expression)EMPTY_TUPLE));
        mapBindingResultConstructorArgs.addExpression((Expression)new ConstantExpression((Object)"controller"));
        ConstructorCallExpression mapBindingResultConstructorCallExpression = new ConstructorCallExpression(new ClassNode(MapBindingResult.class), (Expression)mapBindingResultConstructorArgs);
        MethodCallExpression errorsAssignmentExpression = GrailsASTUtils.buildSetPropertyExpression((Expression)new VariableExpression("this", classNode), (String)"errors", (ClassNode)classNode, (Expression)mapBindingResultConstructorCallExpression);
        wrapper.addStatement((Statement)new ExpressionStatement((Expression)errorsAssignmentExpression));
        if (actionParameters != null) {
            for (Parameter param : actionParameters) {
                this.initializeMethodParameter(classNode, wrapper, actionNode, actionName, param, source, context);
            }
        }
        return wrapper;
    }

    protected void initializeMethodParameter(ClassNode classNode, BlockStatement wrapper, ASTNode actionNode, String actionName, Parameter param, SourceUnit source, GeneratorContext context) {
        String paramName;
        ClassNode paramTypeClassNode = param.getType();
        String requestParameterName = paramName = param.getName();
        List requestParameters = param.getAnnotations(new ClassNode(RequestParameter.class));
        if (requestParameters.size() == 1) {
            requestParameterName = ((AnnotationNode)requestParameters.get(0)).getMember("value").getText();
        }
        if (PRIMITIVE_CLASS_NODES.contains(paramTypeClassNode) || TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.containsKey(paramTypeClassNode)) {
            this.initializePrimitiveOrTypeWrapperParameter(classNode, wrapper, param, requestParameterName);
        } else if (paramTypeClassNode.equals((Object)new ClassNode(String.class))) {
            this.initializeStringParameter(classNode, wrapper, param, requestParameterName);
        } else if (!paramTypeClassNode.equals((Object)OBJECT_CLASS)) {
            this.initializeAndValidateCommandObjectParameter(wrapper, classNode, paramTypeClassNode, actionNode, actionName, paramName, source, context);
        }
    }

    protected void initializeAndValidateCommandObjectParameter(BlockStatement wrapper, ClassNode controllerNode, ClassNode commandObjectNode, ASTNode actionNode, String actionName, String paramName, SourceUnit source, GeneratorContext context) {
        DeclarationExpression declareCoExpression = new DeclarationExpression(new VariableExpression(paramName, commandObjectNode), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new EmptyExpression());
        wrapper.addStatement((Statement)new ExpressionStatement((Expression)declareCoExpression));
        if (commandObjectNode.isInterface() || Modifier.isAbstract(commandObjectNode.getModifiers())) {
            String warningMessage = "The [" + actionName + "] action in [" + controllerNode.getName() + "] accepts a parameter of type [" + commandObjectNode.getName() + "].  Interface types and abstract class types are not supported as command objects.  This parameter will be ignored.";
            GrailsASTUtils.warning((SourceUnit)source, (ASTNode)actionNode, (String)warningMessage);
        } else {
            ModuleNode commandObjectModule;
            this.initializeCommandObjectParameter(wrapper, commandObjectNode, paramName, source);
            boolean argumentIsValidateable = GrailsASTUtils.hasAnyAnnotations((ClassNode)commandObjectNode, (Class[])new Class[]{grails.validation.Validateable.class, Validateable.class, grails.persistence.Entity.class, Entity.class});
            if (!argumentIsValidateable && (commandObjectModule = commandObjectNode.getModule()) != null) {
                if (commandObjectModule == controllerNode.getModule() || this.doesModulePathIncludeSubstring(commandObjectModule, "grails-app" + File.separator + "controllers" + File.separator)) {
                    DefaultASTValidateableHelper h = new DefaultASTValidateableHelper();
                    h.injectValidateableCode(commandObjectNode);
                    argumentIsValidateable = true;
                } else if (this.doesModulePathIncludeSubstring(commandObjectModule, "grails-app" + File.separator + "domain" + File.separator)) {
                    argumentIsValidateable = true;
                }
            }
            if (argumentIsValidateable) {
                MethodCallExpression validateMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(paramName), "validate", (Expression)EMPTY_TUPLE);
                MethodNode validateMethod = commandObjectNode.getMethod("validate", new Parameter[0]);
                if (validateMethod != null) {
                    validateMethodCallExpression.setMethodTarget(validateMethod);
                }
                IfStatement ifCommandObjectIsNotNullThenValidate = new IfStatement(new BooleanExpression((Expression)new VariableExpression(paramName)), (Statement)new ExpressionStatement((Expression)validateMethodCallExpression), (Statement)new ExpressionStatement((Expression)new EmptyExpression()));
                wrapper.addStatement((Statement)ifCommandObjectIsNotNullThenValidate);
            } else {
                MethodCallExpression respondsToValidateMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(paramName), "respondsTo", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)"validate")));
                MethodCallExpression validateMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(paramName), "validate", (Expression)new ArgumentListExpression());
                IfStatement ifRespondsToValidateThenValidateStatement = new IfStatement(new BooleanExpression((Expression)respondsToValidateMethodCallExpression), (Statement)new ExpressionStatement((Expression)validateMethodCallExpression), (Statement)new ExpressionStatement((Expression)new EmptyExpression()));
                IfStatement ifCommandObjectIsNotNullThenValidate = new IfStatement(new BooleanExpression((Expression)new VariableExpression(paramName)), (Statement)ifRespondsToValidateThenValidateStatement, (Statement)new ExpressionStatement((Expression)new EmptyExpression()));
                wrapper.addStatement((Statement)ifCommandObjectIsNotNullThenValidate);
                String warningMessage = "The [" + actionName + "] action accepts a parameter of type [" + commandObjectNode.getName() + "] which has not been marked with @Validateable.  Data binding will still be applied " + "to this command object but the instance will not be validateable.";
                GrailsASTUtils.warning((SourceUnit)source, (ASTNode)actionNode, (String)warningMessage);
            }
            if (GrailsASTUtils.isInnerClassNode((ClassNode)commandObjectNode)) {
                String warningMessage = "The [" + actionName + "] action accepts a parameter of type [" + commandObjectNode.getName() + "] which is an inner class. Command object classes should not be inner classes.";
                GrailsASTUtils.warning((SourceUnit)source, (ASTNode)actionNode, (String)warningMessage);
            } else {
                new DefaultASTDatabindingHelper().injectDatabindingCode(source, context, commandObjectNode);
            }
        }
    }

    protected void initializeCommandObjectParameter(BlockStatement wrapper, ClassNode commandObjectNode, String paramName, SourceUnit source) {
        BlockStatement tryBlock = new BlockStatement();
        MethodCallExpression initializeCommandObjectMethodCall = new MethodCallExpression((Expression)new VariableExpression("this"), "initializeCommandObject", (Expression)new ClassExpression(commandObjectNode));
        GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)initializeCommandObjectMethodCall, (ClassNode)commandObjectNode);
        BinaryExpression assignCommandObjectToParameter = new BinaryExpression((Expression)new VariableExpression(paramName), Token.newSymbol((int)100, (int)0, (int)0), (Expression)initializeCommandObjectMethodCall);
        tryBlock.addStatement((Statement)new ExpressionStatement((Expression)assignCommandObjectToParameter));
        BlockStatement catchBlock = new BlockStatement();
        VariableExpression responseVariableExpression = new VariableExpression("response");
        MethodCallExpression setStatusMethodCallExpression = new MethodCallExpression((Expression)responseVariableExpression, "setStatus", (Expression)new ConstantExpression((Object)400));
        GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)setStatusMethodCallExpression, HttpServletResponse.class);
        catchBlock.addStatement((Statement)new ExpressionStatement((Expression)setStatusMethodCallExpression));
        ReturnStatement returnStatement = new ReturnStatement(new ExpressionStatement((Expression)new ConstantExpression(null)));
        catchBlock.addStatement((Statement)returnStatement);
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)tryBlock, (Statement)new EmptyStatement());
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(DataBindingSourceCreationException.class), "$dataBindingSourceInitializationException"), (Statement)catchBlock));
        wrapper.addStatement((Statement)tryCatchStatement);
    }

    private boolean doesModulePathIncludeSubstring(ModuleNode moduleNode, String substring) {
        if (moduleNode == null) {
            return false;
        }
        boolean substringFoundInDescription = false;
        String commandObjectModuleDescription = moduleNode.getDescription();
        if (commandObjectModuleDescription != null) {
            substringFoundInDescription = commandObjectModuleDescription.contains(substring);
        }
        return substringFoundInDescription;
    }

    protected void initializeStringParameter(ClassNode classNode, BlockStatement wrapper, Parameter param, String requestParameterName) {
        ClassNode paramTypeClassNode = param.getType();
        String methodParamName = param.getName();
        MethodCallExpression getParamsExpression = GrailsASTUtils.buildGetPropertyExpression((Expression)new VariableExpression("this"), (String)"params", (ClassNode)classNode);
        ArgumentListExpression paramsContainsKeyMethodArguments = new ArgumentListExpression((Expression)new ConstantExpression((Object)requestParameterName));
        BooleanExpression containsKeyExpression = new BooleanExpression((Expression)GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)new MethodCallExpression((Expression)getParamsExpression, "containsKey", (Expression)paramsContainsKeyMethodArguments), Map.class));
        ExpressionStatement initializeParameterStatement = new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression(methodParamName, paramTypeClassNode), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new TernaryExpression(containsKeyExpression, (Expression)GrailsASTUtils.buildGetMapExpression((Expression)getParamsExpression, (String)requestParameterName), (Expression)new ConstantExpression(null))));
        wrapper.addStatement((Statement)initializeParameterStatement);
    }

    protected void initializePrimitiveOrTypeWrapperParameter(ClassNode classNode, BlockStatement wrapper, Parameter param, String requestParameterName) {
        ClassNode paramTypeClassNode = param.getType();
        String methodParamName = param.getName();
        ConstantExpression defaultValueExpression = paramTypeClassNode.equals((Object)ClassHelper.Boolean_TYPE) ? new ConstantExpression((Object)false) : (PRIMITIVE_CLASS_NODES.contains(paramTypeClassNode) ? new ConstantExpression((Object)0) : new ConstantExpression(null));
        ConstantExpression paramConstantExpression = new ConstantExpression((Object)requestParameterName);
        ArgumentListExpression paramsTypeConversionMethodArguments = new ArgumentListExpression((Expression)paramConstantExpression, (Expression)new ConstantExpression(null));
        String conversionMethodName = TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.containsKey(paramTypeClassNode) ? TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.get(paramTypeClassNode) : paramTypeClassNode.getName();
        MethodCallExpression getParamsExpression = GrailsASTUtils.buildGetPropertyExpression((Expression)new VariableExpression("this"), (String)"params", (ClassNode)classNode);
        MethodCallExpression retrieveConvertedValueExpression = new MethodCallExpression((Expression)getParamsExpression, conversionMethodName, (Expression)paramsTypeConversionMethodArguments);
        Class<Integer> defaultValueClass = null;
        if ("char".equals(conversionMethodName)) {
            defaultValueClass = Integer.class;
        }
        GrailsASTUtils.applyMethodTarget((MethodCallExpression)retrieveConvertedValueExpression, TypeConvertingMap.class, (Class[])new Class[]{null, defaultValueClass});
        ArgumentListExpression paramsContainsKeyMethodArguments = new ArgumentListExpression((Expression)paramConstantExpression);
        BooleanExpression containsKeyExpression = new BooleanExpression((Expression)GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)new MethodCallExpression((Expression)getParamsExpression, "containsKey", (Expression)paramsContainsKeyMethodArguments), Map.class));
        Token equalsToken = Token.newSymbol((int)100, (int)0, (int)0);
        VariableExpression convertedValueExpression = new VariableExpression("___converted_" + methodParamName, new ClassNode(Object.class));
        DeclarationExpression declareConvertedValueExpression = new DeclarationExpression(convertedValueExpression, equalsToken, (Expression)new EmptyExpression());
        ExpressionStatement declareVariableStatement = new ExpressionStatement((Expression)declareConvertedValueExpression);
        wrapper.addStatement((Statement)declareVariableStatement);
        VariableExpression methodParamExpression = new VariableExpression(methodParamName, paramTypeClassNode);
        DeclarationExpression declareParameterVariableStatement = new DeclarationExpression(methodParamExpression, equalsToken, (Expression)new EmptyExpression());
        declareVariableStatement = new ExpressionStatement((Expression)declareParameterVariableStatement);
        wrapper.addStatement((Statement)declareVariableStatement);
        BinaryExpression assignmentExpression = new BinaryExpression((Expression)convertedValueExpression, equalsToken, (Expression)new TernaryExpression(containsKeyExpression, (Expression)retrieveConvertedValueExpression, (Expression)defaultValueExpression));
        wrapper.addStatement((Statement)new ExpressionStatement((Expression)assignmentExpression));
        Expression rejectValueMethodCallExpression = this.getRejectValueExpression(classNode, methodParamName);
        BlockStatement ifConvertedValueIsNullBlockStatement = new BlockStatement();
        ifConvertedValueIsNullBlockStatement.addStatement((Statement)new ExpressionStatement(rejectValueMethodCallExpression));
        ifConvertedValueIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)methodParamExpression, equalsToken, (Expression)defaultValueExpression)));
        BooleanExpression isConvertedValueNullExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)convertedValueExpression, Token.newSymbol((int)123, (int)0, (int)0), (Expression)new ConstantExpression(null)));
        ExpressionStatement assignConvertedValueToParamStatement = new ExpressionStatement((Expression)new BinaryExpression((Expression)methodParamExpression, equalsToken, (Expression)convertedValueExpression));
        IfStatement ifStatement = new IfStatement(isConvertedValueNullExpression, (Statement)ifConvertedValueIsNullBlockStatement, (Statement)assignConvertedValueToParamStatement);
        wrapper.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)containsKeyExpression), (Statement)ifStatement, (Statement)new ExpressionStatement((Expression)new EmptyExpression())));
    }

    protected Expression getRejectValueExpression(ClassNode classNode, String methodParamName) {
        ArgumentListExpression rejectValueArgs = new ArgumentListExpression();
        rejectValueArgs.addExpression((Expression)new ConstantExpression((Object)methodParamName));
        rejectValueArgs.addExpression((Expression)new ConstantExpression((Object)("params." + methodParamName + ".conversion.error")));
        MethodCallExpression getErrorsExpression = GrailsASTUtils.buildGetPropertyExpression((Expression)new VariableExpression("this", classNode), (String)"errors", (ClassNode)classNode);
        MethodCallExpression rejectValueMethodCallExpression = GrailsASTUtils.applyDefaultMethodTarget((MethodCallExpression)new MethodCallExpression((Expression)getErrorsExpression, "rejectValue", (Expression)rejectValueArgs), Errors.class);
        return rejectValueMethodCallExpression;
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public boolean shouldInject(URL url) {
        return url != null && ControllerTransformer.CONTROLLER_PATTERN.matcher(url.getFile()).find();
    }
}

